/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.ClassifierAssistant;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ClassConstructorAssistant
extends TransformationAssistant {
    @Inject
    private TypeAssistant typeAssistant;
    @Inject
    private ClassifierAssistant classifierAssistant;

    public void amendConstructor(N4ClassDeclaration classDecl, SymbolTableEntry classSTE, SymbolTableEntryOriginal superClassSTE, LinkedHashSet<N4FieldDeclaration> fieldsRequiringExplicitDefinition) {
        N4MethodDeclaration __N4MethodDecl;
        N4MethodDeclaration explicitCtorDecl = classDecl.getOwnedCtor();
        N4MethodDeclaration _elvis = null;
        _elvis = explicitCtorDecl != null ? explicitCtorDecl : (__N4MethodDecl = TranspilerBuilderBlocks._N4MethodDecl((String)"constructor", (Statement[])new Statement[0]));
        N4MethodDeclaration ctorDecl = _elvis;
        this.amendFormalParametersOfConstructor(classDecl, ctorDecl, explicitCtorDecl);
        boolean isNonTrivial = this.amendBodyOfConstructor(classDecl, classSTE, superClassSTE, ctorDecl, explicitCtorDecl, fieldsRequiringExplicitDefinition);
        if (ctorDecl.eContainer() == null && isNonTrivial) {
            classDecl.getOwnedMembersRaw().add(0, (Object)ctorDecl);
        }
    }

    private void amendFormalParametersOfConstructor(N4ClassDeclaration classDecl, N4MethodDeclaration ctorDecl, N4MethodDeclaration explicitCtorDecl) {
        TMethod templateCtor;
        boolean hasExplicitCtor;
        boolean bl = hasExplicitCtor = explicitCtorDecl != null;
        if (!hasExplicitCtor && (templateCtor = this.getNearestConstructorInHierarchy(classDecl)) != null) {
            EList _fpars = ctorDecl.getFpars();
            Functions.Function1 _function = it -> {
                FormalParameter _xblockexpression = null;
                TypeRef typeRefIM = (TypeRef)this.copyAlienElement((EObject)it.getTypeRef());
                _xblockexpression = TranspilerBuilderBlocks._Fpar((String)it.getName(), (boolean)it.isVariadic(), (TypeRef)typeRefIM, (boolean)AnnotationDefinition.SPEC.hasAnnotation((TAnnotableElement)it));
                return _xblockexpression;
            };
            List _map = ListExtensions.map((List)templateCtor.getFpars(), (Functions.Function1)_function);
            Iterables.addAll((Collection)_fpars, (Iterable)_map);
        }
    }

    private boolean amendBodyOfConstructor(N4ClassDeclaration classDecl, SymbolTableEntry classSTE, SymbolTableEntryOriginal superClassSTE, N4MethodDeclaration ctorDecl, N4MethodDeclaration explicitCtorDecl, LinkedHashSet<N4FieldDeclaration> fieldsRequiringExplicitDefinition) {
        TObjectPrototype _errorType;
        boolean hasExplicitCtor = explicitCtorDecl != null;
        Block body = ctorDecl.getBody();
        Functions.Function1 _function = it -> AnnotationDefinition.SPEC.hasAnnotation((AnnotableElement)it);
        FormalParameter specFpar = (FormalParameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)ctorDecl.getFpars(), (Functions.Function1)_function));
        IdentifiableElement _originalTarget = null;
        if (superClassSTE != null) {
            _originalTarget = superClassSTE.getOriginalTarget();
        }
        boolean isDirectSubclassOfError = _originalTarget == (_errorType = RuleEnvironmentExtensions.errorType((RuleEnvironment)this.getState().G));
        int _xifexpression = 0;
        Block _body = null;
        if (explicitCtorDecl != null) {
            _body = explicitCtorDecl.getBody();
        }
        boolean _tripleNotEquals = _body != null;
        _xifexpression = _tripleNotEquals ? this.getSuperCallIndex(explicitCtorDecl) : -1;
        int superCallIndex = _xifexpression;
        boolean hasExplicitSuperCall = superCallIndex >= 0;
        Statement _xifexpression_1 = null;
        if (hasExplicitSuperCall) {
            _xifexpression_1 = (Statement)explicitCtorDecl.getBody().getStatements().get(superCallIndex);
        }
        Statement explicitSuperCall = _xifexpression_1;
        ExpressionStatement defaultSuperCall = null;
        int _xifexpression_2 = 0;
        _xifexpression_2 = hasExplicitSuperCall ? superCallIndex + 1 : 0;
        int idx = _xifexpression_2;
        if (!hasExplicitSuperCall && superClassSTE != null) {
            EList _xifexpression_3 = null;
            _xifexpression_3 = hasExplicitCtor ? Collections.unmodifiableList(CollectionLiterals.newArrayList()) : ctorDecl.getFpars();
            EList fparsOfSuperCtor = _xifexpression_3;
            defaultSuperCall = this.createDefaultSuperCall(classDecl, (SymbolTableEntry)superClassSTE, (FormalParameter[])Conversions.unwrapArray((Object)fparsOfSuperCtor, FormalParameter.class));
            idx = ClassConstructorAssistant.insertAt(body.getStatements(), idx, defaultSuperCall);
        }
        if (isDirectSubclassOfError) {
            idx = ClassConstructorAssistant.insertAt(body.getStatements(), idx, (Collection)Conversions.doWrapArray((Object)this.createSubclassingErrorOddities(classDecl, (FormalParameter[])Conversions.unwrapArray((Object)ctorDecl.getFpars(), FormalParameter.class), explicitSuperCall)));
        }
        SymbolTableEntry specObjSTE = null;
        if (specFpar != null) {
            SymbolTableEntry specFparSTE = this.findSymbolTableEntryForElement((NamedElement)specFpar, true);
            VariableDeclaration specObjVarDecl = TranspilerBuilderBlocks._VariableDeclaration((String)"$specObj", (Expression)TranspilerBuilderBlocks._OR((Expression[])new Expression[]{TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specFparSTE), TranspilerBuilderBlocks._ObjLit()}));
            idx = ClassConstructorAssistant.insertAt(body.getStatements(), idx, TranspilerBuilderBlocks._VariableStatement((VariableStatementKeyword)VariableStatementKeyword.CONST, (VariableDeclaration[])new VariableDeclaration[]{specObjVarDecl}));
            specObjSTE = this.findSymbolTableEntryForElement((NamedElement)specObjVarDecl, true);
        }
        idx = ClassConstructorAssistant.insertAt(body.getStatements(), idx, this.classifierAssistant.createExplicitFieldDefinitions(classSTE, false, fieldsRequiringExplicitDefinition));
        idx = ClassConstructorAssistant.insertAt(body.getStatements(), idx, (Collection)Conversions.doWrapArray((Object)this.createInstanceFieldInitCode(classDecl, specFpar, specObjSTE, fieldsRequiringExplicitDefinition)));
        idx = ClassConstructorAssistant.insertAt(body.getStatements(), idx, (Collection)Conversions.doWrapArray((Object)this.createDelegationToFieldInitOfImplementedInterfaces(classDecl, specObjSTE)));
        EList ctorDeclStmnts = ctorDecl.getBody().getStatements();
        boolean bodyContainsOnlyDefaultSuperCall = defaultSuperCall != null && ctorDeclStmnts.size() == 1 && IterableExtensions.head((Iterable)ctorDeclStmnts) == defaultSuperCall;
        boolean isNonTrivialCtor = !ctorDeclStmnts.isEmpty() && !bodyContainsOnlyDefaultSuperCall;
        return isNonTrivialCtor;
    }

    private Statement[] createInstanceFieldInitCode(N4ClassDeclaration classDecl, FormalParameter specFpar, SymbolTableEntry specObjSTE, Set<N4FieldDeclaration> fieldsWithExplicitDefinition) {
        Functions.Function1 _function = it -> !it.isStatic() && !this.isConsumedFromInterface((N4MemberDeclaration)it);
        List allFields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedFields(), (Functions.Function1)_function));
        if (specFpar != null) {
            ArrayList result = CollectionLiterals.newArrayList();
            EList structFields = specFpar.getDeclaredTypeRef().getStructuralMembers();
            ArrayList currFields = CollectionLiterals.newArrayList();
            boolean currFieldsAreSpecced = false;
            for (N4FieldDeclaration field : allFields) {
                boolean isSpecced;
                boolean bl = isSpecced = this.isPublic((N4MemberDeclaration)field) || IterableExtensions.exists((Iterable)structFields, it -> {
                    String _name = it.getName();
                    String _name_1 = field.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                });
                if (Boolean.valueOf(isSpecced) == Boolean.valueOf(currFieldsAreSpecced)) {
                    currFields.add(field);
                    continue;
                }
                Statement[] _createFieldInitCodeForSeveralFields = this.createFieldInitCodeForSeveralFields(currFields, currFieldsAreSpecced, specObjSTE);
                Iterables.addAll((Collection)result, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createFieldInitCodeForSeveralFields)));
                currFields.clear();
                currFields.add(field);
                currFieldsAreSpecced = isSpecced;
            }
            Statement[] _createFieldInitCodeForSeveralFields = this.createFieldInitCodeForSeveralFields(currFields, currFieldsAreSpecced, specObjSTE);
            Iterables.addAll((Collection)result, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createFieldInitCodeForSeveralFields)));
            Functions.Function1 _function_1 = it -> !it.isStatic() && it.getDeclaredModifiers().contains((Object)N4Modifier.PUBLIC);
            List speccedSetters = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedSetters(), (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = it -> this.createFieldInitCodeForSingleSpeccedSetter((N4SetterDeclaration)it, specObjSTE);
            List _map = ListExtensions.map((List)speccedSetters, (Functions.Function1)_function_2);
            Iterables.addAll((Collection)result, (Iterable)_map);
            return (Statement[])Conversions.unwrapArray((Object)result, Statement.class);
        }
        Functions.Function1 _function_3 = it -> it.getExpression() != null || !fieldsWithExplicitDefinition.contains(it);
        Functions.Function1 _function_4 = it -> this.createFieldInitCodeForSingleField((N4FieldDeclaration)it);
        return (Statement[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)allFields, (Functions.Function1)_function_3), (Functions.Function1)_function_4), Statement.class);
    }

    private Statement[] createFieldInitCodeForSeveralFields(Collection<N4FieldDeclaration> fieldDecls, boolean fieldsAreSpecced, SymbolTableEntry specObjSTE) {
        boolean _tripleEquals;
        boolean _isEmpty = fieldDecls.isEmpty();
        if (_isEmpty) {
            return new Statement[0];
        }
        if (!fieldsAreSpecced) {
            Functions.Function1 _function = it -> this.createFieldInitCodeForSingleField((N4FieldDeclaration)it);
            return (Statement[])Conversions.unwrapArray((Object)IterableExtensions.map(fieldDecls, (Functions.Function1)_function), Statement.class);
        }
        int _size = fieldDecls.size();
        boolean bl = _tripleEquals = _size == 1;
        if (_tripleEquals) {
            Statement _createFieldInitCodeForSingleSpeccedField = this.createFieldInitCodeForSingleSpeccedField((N4FieldDeclaration)IterableExtensions.head(fieldDecls), specObjSTE);
            return new Statement[]{_createFieldInitCodeForSingleSpeccedField};
        }
        Statement _createFieldInitCodeForSeveralSpeccedFields = this.createFieldInitCodeForSeveralSpeccedFields(fieldDecls, specObjSTE);
        return new Statement[]{_createFieldInitCodeForSeveralSpeccedFields};
    }

    private Statement createFieldInitCodeForSingleField(N4FieldDeclaration fieldDecl) {
        SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement((NamedElement)fieldDecl, true);
        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE});
        Object _xifexpression = null;
        Expression _expression = fieldDecl.getExpression();
        boolean _tripleNotEquals = _expression != null;
        _xifexpression = _tripleNotEquals ? fieldDecl.getExpression() : this.undefinedRef();
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)__PropertyAccessExpr, (Expression)_xifexpression));
    }

    private Statement createFieldInitCodeForSeveralSpeccedFields(Iterable<N4FieldDeclaration> fieldDecls, SymbolTableEntry specObjSTE) {
        Functions.Function1 _function = fieldDecl -> {
            SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement((NamedElement)fieldDecl, true);
            ParameterizedPropertyAccessExpression_IM thisFieldName = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE});
            String _name = fieldDecl.getName();
            Object _xifexpression = null;
            boolean _hasNonTrivialInitExpression = this.hasNonTrivialInitExpression((N4FieldDeclaration)fieldDecl);
            _xifexpression = _hasNonTrivialInitExpression ? TranspilerBuilderBlocks._AssignmentExpr((Expression)thisFieldName, (Expression)fieldDecl.getExpression()) : thisFieldName;
            return Pair.of((Object)_name, (Object)_xifexpression);
        };
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._ObjLit((Pair[])((Pair[])Conversions.unwrapArray((Object)IterableExtensions.map(fieldDecls, (Functions.Function1)_function), Pair.class))), (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specObjSTE))));
    }

    private Statement createFieldInitCodeForSingleSpeccedField(N4FieldDeclaration fieldDecl, SymbolTableEntry specObjSTE) {
        SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement((NamedElement)fieldDecl, true);
        boolean _hasNonTrivialInitExpression = this.hasNonTrivialInitExpression(fieldDecl);
        if (_hasNonTrivialInitExpression) {
            EqualityExpression __EqualityExpr = TranspilerBuilderBlocks._EqualityExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)specObjSTE, (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}), (EqualityOperator)EqualityOperator.SAME, (Expression)this.undefinedRef());
            Object _xifexpression = null;
            Expression _expression = fieldDecl.getExpression();
            boolean _tripleNotEquals = _expression != null;
            _xifexpression = _tripleNotEquals ? (Expression)this.copy((EObject)fieldDecl.getExpression()) : this.undefinedRef();
            return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}), (Expression)TranspilerBuilderBlocks._ConditionalExpr((Expression)__EqualityExpr, (Expression)_xifexpression, (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)specObjSTE, (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}))));
        }
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}), (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)specObjSTE, (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE})));
    }

    private Statement createFieldInitCodeForSingleSpeccedSetter(N4SetterDeclaration setterDecl, SymbolTableEntry specObjSTE) {
        SymbolTableEntry setterSTE = this.findSymbolTableEntryForElement((NamedElement)setterDecl, true);
        return TranspilerBuilderBlocks._IfStmnt((Expression)TranspilerBuilderBlocks._RelationalExpr((Expression)TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)setterSTE), (RelationalOperator)RelationalOperator.IN, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specObjSTE)), (Statement)TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{setterSTE}), (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)specObjSTE, (SymbolTableEntry[])new SymbolTableEntry[]{setterSTE}))));
    }

    private ExpressionStatement createDefaultSuperCall(N4ClassDeclaration classDecl, SymbolTableEntry superClassSTE, FormalParameter[] fpars) {
        boolean variadicCase = !((List)Conversions.doWrapArray((Object)fpars)).isEmpty() && ((FormalParameter)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)fpars)))).isVariadic();
        Functions.Function1 _function = it -> this.findSymbolTableEntryForElement((NamedElement)it, true);
        Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._Argument((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)it));
        List argsIter = ListExtensions.map((List)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)fpars)), (Functions.Function1)_function), (Functions.Function1)_function_1);
        ArrayList args = new ArrayList(argsIter);
        if (variadicCase) {
            Argument _last = (Argument)IterableExtensions.last(args);
            _last.setSpread(true);
        }
        ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
        Procedures.Procedure1 _function_2 = it -> {
            it.setTarget((Expression)TranspilerBuilderBlocks._SuperLiteral());
            EList _arguments = it.getArguments();
            Iterables.addAll((Collection)_arguments, (Iterable)args);
        };
        ParameterizedCallExpression _doubleArrow = (ParameterizedCallExpression)ObjectExtensions.operator_doubleArrow((Object)__CallExpr, (Procedures.Procedure1)_function_2);
        return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
    }

    private Statement[] createSubclassingErrorOddities(N4ClassDeclaration classDecl, FormalParameter[] fpars, Statement explicitSuperCall) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("this.name = this.constructor.n4type.name;");
        _builder.newLine();
        _builder.append("if (Error.captureStackTrace) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("Error.captureStackTrace(this, this.name);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._Snippet((String)_builder.toString()));
        return new Statement[]{__ExprStmnt};
    }

    private Statement[] createDelegationToFieldInitOfImplementedInterfaces(N4ClassDeclaration classDecl, SymbolTableEntry specObjSTE) {
        Functions.Function1 _function = it -> {
            IdentifiableElement _originalTarget = it.getOriginalTarget();
            boolean _builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation = N4JSLanguageUtils.builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation((TInterface)((TInterface)_originalTarget));
            return !_builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation;
        };
        Iterable implementedIfcSTEs = IterableExtensions.filter((Iterable)this.typeAssistant.getSuperInterfacesSTEs((N4ClassifierDeclaration)classDecl), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)implementedIfcSTEs);
        if (_isEmpty) {
            return new Statement[0];
        }
        LinkedHashSet ownedInstanceDataFieldsSupressMixin = CollectionLiterals.newLinkedHashSet();
        Functions.Function1 _function_1 = it -> {
            boolean _isConsumedFromInterface = this.isConsumedFromInterface((N4MemberDeclaration)it);
            return !_isConsumedFromInterface;
        };
        Functions.Function1 _function_2 = it -> it.getName();
        Iterables.addAll((Collection)ownedInstanceDataFieldsSupressMixin, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedGetters(), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> {
            boolean _isConsumedFromInterface = this.isConsumedFromInterface((N4MemberDeclaration)it);
            return !_isConsumedFromInterface;
        };
        Functions.Function1 _function_4 = it -> it.getName();
        Iterables.addAll((Collection)ownedInstanceDataFieldsSupressMixin, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedSetters(), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        SymbolTableEntry classSTE = this.findSymbolTableEntryForElement((NamedElement)classDecl, false);
        SymbolTableEntryInternal $initFieldsFromInterfacesSTE = this.steFor_$initFieldsFromInterfaces();
        IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)$initFieldsFromInterfacesSTE);
        ThisLiteral __ThisLiteral = TranspilerBuilderBlocks._ThisLiteral();
        IdentifierRef_IM __IdentRef_1 = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)classSTE);
        IdentifierRef_IM _xifexpression = null;
        _xifexpression = specObjSTE != null ? TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specObjSTE) : this.undefinedRef();
        Functions.Function1 _function_5 = it -> TranspilerBuilderBlocks._PropertyNameValuePair((String)it, (Expression)TranspilerBuilderBlocks._TRUE());
        ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)__IdentRef, (Expression[])new Expression[]{__ThisLiteral, __IdentRef_1, _xifexpression, TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)ownedInstanceDataFieldsSupressMixin, (Functions.Function1)_function_5), PropertyAssignment.class)))}));
        return new Statement[]{__ExprStmnt};
    }

    private int getSuperCallIndex(N4MethodDeclaration ownedCtor) {
        EList stmnts;
        Block _body = null;
        if (ownedCtor != null) {
            _body = ownedCtor.getBody();
        }
        EList _statements = null;
        if (_body != null) {
            _statements = _body.getStatements();
        }
        if ((stmnts = _statements) != null && !stmnts.isEmpty()) {
            int _size = ownedCtor.getBody().getStatements().size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            for (Integer i : _doubleDotLessThan) {
                Expression _target;
                Expression expr;
                Statement stmnt = (Statement)stmnts.get(i.intValue());
                if (!(stmnt instanceof ExpressionStatement) || !((expr = ((ExpressionStatement)stmnt).getExpression()) instanceof ParameterizedCallExpression) || !((_target = ((ParameterizedCallExpression)expr).getTarget()) instanceof SuperLiteral)) continue;
                return i;
            }
        }
        return -1;
    }

    private TMethod getNearestConstructorInHierarchy(N4ClassDeclaration classDecl) {
        TClass tClass = this.getState().info.getOriginalDefinedType(classDecl);
        return this.getNearestConstructorInHierarchy((TClassifier)tClass);
    }

    private TMethod getNearestConstructorInHierarchy(TClassifier clazz) {
        TMethod _xifexpression = null;
        if (clazz instanceof TClass) {
            _xifexpression = ((TClass)clazz).getOwnedCtor();
        } else {
            TMethod _xifexpression_1 = null;
            if (clazz instanceof TObjectPrototype) {
                _xifexpression_1 = ((TObjectPrototype)clazz).getOwnedCtor();
            }
            _xifexpression = _xifexpression_1;
        }
        TMethod ownedCtor = _xifexpression;
        if (ownedCtor != null) {
            return ownedCtor;
        }
        Type _xifexpression_2 = null;
        if (clazz instanceof TClass) {
            ParameterizedTypeRef _superClassRef = ((TClass)clazz).getSuperClassRef();
            Type _declaredType = null;
            if (_superClassRef != null) {
                _declaredType = _superClassRef.getDeclaredType();
            }
            _xifexpression_2 = _declaredType;
        } else {
            Type _xifexpression_3 = null;
            if (clazz instanceof TObjectPrototype) {
                ParameterizedTypeRef _superType = ((TObjectPrototype)clazz).getSuperType();
                Type _declaredType_1 = null;
                if (_superType != null) {
                    _declaredType_1 = _superType.getDeclaredType();
                }
                _xifexpression_3 = _declaredType_1;
            }
            _xifexpression_2 = _xifexpression_3;
        }
        Type superType = _xifexpression_2;
        if (superType instanceof TClassifier) {
            return this.getNearestConstructorInHierarchy((TClassifier)superType);
        }
        return null;
    }

    private boolean isConsumedFromInterface(N4MemberDeclaration memberDecl) {
        return this.getState().info.isConsumedFromInterface(memberDecl);
    }

    private boolean isPublic(N4MemberDeclaration memberDecl) {
        MemberAccessModifier accessModifier = ModifierUtils.convertToMemberAccessModifier((Collection)memberDecl.getDeclaredModifiers(), (List)memberDecl.getAnnotations());
        return accessModifier == MemberAccessModifier.PUBLIC;
    }

    private static <T> int insertAt(List<T> list, int index, T element) {
        list.add(index, element);
        return index + 1;
    }

    private static <T> int insertAt(List<T> list, int index, Collection<? extends T> elements) {
        list.addAll(index, elements);
        int _size = elements.size();
        return index + _size;
    }
}

