/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.RuntimeDependency;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.SCCUtils;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class RuntimeDependencyProcessor {
    @Inject
    private JavaScriptVariantHelper variantHelper;

    Boolean recordRuntimeReferencesInCache(EObject node, ASTMetaInfoCache cache) {
        boolean _hasRuntimeRepresentation;
        boolean _xifexpression = false;
        if (node instanceof IdentifierRef) {
            boolean _xblockexpression = false;
            IdentifiableElement target = ((IdentifierRef)node).getTargetElement();
            boolean _xifexpression_1 = false;
            boolean _hasRuntimeRepresentation2 = N4JSLanguageUtils.hasRuntimeRepresentation(target, this.variantHelper);
            if (_hasRuntimeRepresentation2) {
                boolean _xblockexpression_1 = false;
                cache.elementsReferencedAtRuntime.add(target);
                IdentifiableElement targetRaw = ((IdentifierRef)node).getId();
                boolean _xifexpression_2 = false;
                if (targetRaw != target && targetRaw instanceof ModuleNamespaceVirtualType) {
                    _xifexpression_2 = cache.elementsReferencedAtRuntime.add(targetRaw);
                }
                _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else if (node instanceof N4ClassifierDeclaration && (_hasRuntimeRepresentation = N4JSLanguageUtils.hasRuntimeRepresentation((N4TypeDeclaration)node, this.variantHelper))) {
            Iterable targetTypeRefs = ((N4ClassifierDeclaration)node).getSuperClassifierRefs();
            for (ParameterizedTypeRef targetTypeRef : targetTypeRefs) {
                boolean _isTopLevelCode;
                TModule targetModule;
                boolean _isDifferentModuleInSameProject;
                boolean _not;
                Type targetDeclType;
                boolean _hasRuntimeRepresentation_1;
                Type _declaredType = null;
                if (targetTypeRef != null) {
                    _declaredType = targetTypeRef.getDeclaredType();
                }
                if (!(_hasRuntimeRepresentation_1 = N4JSLanguageUtils.hasRuntimeRepresentation((IdentifiableElement)(targetDeclType = _declaredType), this.variantHelper))) continue;
                cache.elementsReferencedAtRuntime.add((IdentifiableElement)targetDeclType);
                ModuleNamespaceVirtualType namespace = targetTypeRef.getAstNamespace();
                if (namespace != null) {
                    cache.elementsReferencedAtRuntime.add((IdentifiableElement)namespace);
                }
                TModule _xifexpression_1 = null;
                boolean _eIsProxy = targetDeclType.eIsProxy();
                boolean bl = _not = !_eIsProxy;
                if (_not) {
                    _xifexpression_1 = (TModule)EcoreUtil2.getContainerOfType((EObject)targetDeclType, TModule.class);
                }
                if (!(_isDifferentModuleInSameProject = RuntimeDependencyProcessor.isDifferentModuleInSameProject(targetModule = _xifexpression_1, cache)) || !(_isTopLevelCode = N4JSASTUtils.isTopLevelCode((EObject)node))) continue;
                cache.modulesReferencedAtLoadtimeForInheritance.add(targetModule);
            }
        }
        return _xifexpression;
    }

    void storeDirectRuntimeDependenciesInTModule(Script script, ASTMetaInfoCache cache) {
        try (Measurement m = N4JSDataCollectors.dcRuntimeDepsCollect.getMeasurement();){
            this.doStoreDirectRuntimeDependenciesInTModule(script, cache);
        }
    }

    private void doStoreDirectRuntimeDependenciesInTModule(Script script, ASTMetaInfoCache cache) {
        TModule module = script.getModule();
        List importDecls = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class));
        for (ImportDeclaration importDecl : importDecls) {
            EList _importSpecifiers = importDecl.getImportSpecifiers();
            for (ImportSpecifier importSpec : _importSpecifiers) {
                if (importSpec == null) continue;
                TExportableElement _switchResult = null;
                boolean _matched = false;
                if (importSpec instanceof NamedImportSpecifier) {
                    _matched = true;
                    _switchResult = ((NamedImportSpecifier)importSpec).getImportedElement();
                }
                if (!_matched && importSpec instanceof NamespaceImportSpecifier) {
                    _matched = true;
                    _switchResult = ((NamespaceImportSpecifier)importSpec).getDefinedType();
                }
                if (!_matched) {
                    String _name = importSpec.eClass().getName();
                    String _plus = "unknown subclass of ImportSpecifier: " + _name;
                    throw new IllegalStateException(_plus);
                }
                TExportableElement element = _switchResult;
                boolean retained = cache.elementsReferencedAtRuntime.contains(element);
                Procedures.Procedure0 _function = () -> importSpec.setRetainedAtRuntime(retained);
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{importSpec});
            }
        }
        LinkedHashSet modulesReferencedAtRuntime = CollectionLiterals.newLinkedHashSet();
        for (ImportDeclaration importDecl_1 : importDecls) {
            TModule targetModule;
            boolean _isDifferentModuleInSameProject;
            boolean _isRetainedAtRuntime = importDecl_1.isRetainedAtRuntime();
            if (!_isRetainedAtRuntime || !(_isDifferentModuleInSameProject = RuntimeDependencyProcessor.isDifferentModuleInSameProject(targetModule = importDecl_1.getModule(), cache))) continue;
            modulesReferencedAtRuntime.add(targetModule);
        }
        int _size = modulesReferencedAtRuntime.size();
        ArrayList<RuntimeDependency> dependenciesRuntime = new ArrayList<RuntimeDependency>(_size);
        for (TModule currModule : modulesReferencedAtRuntime) {
            RuntimeDependency currDep = TypesFactory.eINSTANCE.createRuntimeDependency();
            currDep.setTarget(currModule);
            currDep.setLoadtimeForInheritance(cache.modulesReferencedAtLoadtimeForInheritance.contains(currModule));
            dependenciesRuntime.add(currDep);
        }
        Procedures.Procedure0 _function_1 = () -> {
            module.getDependenciesRuntime().clear();
            EList _dependenciesRuntime = module.getDependenciesRuntime();
            Iterables.addAll((Collection)_dependenciesRuntime, (Iterable)dependenciesRuntime);
        };
        EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function_1, (Object[])new Object[]{module});
    }

    void computeAndStoreRuntimeCyclesInTModule(TModule module) {
        try (Measurement m = N4JSDataCollectors.dcRuntimeDepsFindCycles.getMeasurement();){
            this.doComputeAndStoreRuntimeCyclesInTModule(module);
        }
    }

    private void doComputeAndStoreRuntimeCyclesInTModule(TModule module) {
        List<TModule> cyclicModulesRuntime = RuntimeDependencyProcessor.getAllRuntimeCyclicModules(module, false);
        List<TModule> cyclicModulesLoadtimeForInheritance = RuntimeDependencyProcessor.getAllRuntimeCyclicModules(module, true);
        LinkedHashSet<TModule> runtimeCyclicLoadtimeDependents = new LinkedHashSet<TModule>();
        for (TModule cyclicModule : cyclicModulesRuntime) {
            boolean _hasDirectLoadtimeDependencyTo = this.hasDirectLoadtimeDependencyTo(cyclicModule, module);
            if (!_hasDirectLoadtimeDependencyTo) continue;
            runtimeCyclicLoadtimeDependents.add(cyclicModule);
        }
        Procedures.Procedure0 _function = () -> {
            module.getCyclicModulesRuntime().clear();
            module.getCyclicModulesLoadtimeForInheritance().clear();
            module.getRuntimeCyclicLoadtimeDependents().clear();
            EList _cyclicModulesRuntime = module.getCyclicModulesRuntime();
            Iterables.addAll((Collection)_cyclicModulesRuntime, (Iterable)cyclicModulesRuntime);
            EList _cyclicModulesLoadtimeForInheritance = module.getCyclicModulesLoadtimeForInheritance();
            Iterables.addAll((Collection)_cyclicModulesLoadtimeForInheritance, (Iterable)cyclicModulesLoadtimeForInheritance);
            EList _runtimeCyclicLoadtimeDependents = module.getRuntimeCyclicLoadtimeDependents();
            Iterables.addAll((Collection)_runtimeCyclicLoadtimeDependents, (Iterable)runtimeCyclicLoadtimeDependents);
        };
        EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{module});
    }

    private static List<TModule> getAllRuntimeCyclicModules(TModule module, boolean onlyLoadtime) {
        Function<TModule, Iterable> _function = m -> {
            Functions.Function1 _function_1 = it -> !onlyLoadtime || it.isLoadtimeForInheritance();
            Functions.Function1 _function_2 = it -> it.getTarget();
            return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)m.getDependenciesRuntime(), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        };
        List<List<TModule>> sccs = SCCUtils.findSCCs(Iterators.singletonIterator((Object)module), _function);
        Functions.Function1 _function_1 = it -> it.remove(module);
        List cyclicModules = (List)IterableExtensions.head((Iterable)IterableExtensions.filter(sccs, (Functions.Function1)_function_1));
        return cyclicModules;
    }

    private boolean hasDirectLoadtimeDependencyTo(TModule from, TModule to) {
        Functions.Function1 _function = it -> it.isLoadtimeForInheritance() && it.getTarget() == to;
        return IterableExtensions.exists((Iterable)from.getDependenciesRuntime(), (Functions.Function1)_function);
    }

    private static boolean isDifferentModuleInSameProject(TModule module, ASTMetaInfoCache cache) {
        return module != null && !module.eIsProxy() && module.eResource() != cache.getResource() && Objects.equal((Object)module.getProjectName(), (Object)cache.getProjectName());
    }
}

