/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.time.Duration;
import org.eclipse.xtext.util.CancelIndicator;

public class BufferedCancelIndicator
implements CancelIndicator {
    private final CancelIndicator delegate;
    private final Ticker clock;
    private final long bufferNanos;
    private long canceledSince;

    public BufferedCancelIndicator(CancelIndicator delegate, Duration buffer) {
        this(delegate, buffer, Ticker.systemTicker());
    }

    public BufferedCancelIndicator(CancelIndicator delegate, Duration buffer, Ticker clock) {
        this.bufferNanos = buffer.toNanos();
        this.delegate = (CancelIndicator)Preconditions.checkNotNull((Object)delegate);
        this.clock = (Ticker)Preconditions.checkNotNull((Object)clock);
    }

    public boolean isCanceled() {
        if (this.canceledSince == 0L && this.delegate.isCanceled()) {
            this.canceledSince = this.clock.read();
            return false;
        }
        return this.canceledSince != 0L && this.clock.read() > this.canceledSince + this.bufferNanos;
    }
}

