/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.resources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.n4js.utils.resources.DelegatingWorkspace;
import org.eclipse.n4js.utils.resources.ExternalFile;
import org.eclipse.n4js.utils.resources.IExternalResource;

public class ExternalFolder
extends Folder
implements IExternalResource {
    private final File file;
    private final IProject project;
    private final IContainer parent;

    public ExternalFolder(IProject project, IContainer parent, File file) {
        super((IPath)new Path(file.getAbsolutePath()), null);
        this.file = file;
        this.project = project;
        this.parent = parent;
    }

    @Override
    public File getExternalResource() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public IProject getProject() {
        return this.project;
    }

    public IContainer getParent() {
        return this.parent;
    }

    public boolean exists() {
        return this.file.exists() && this.file.isDirectory();
    }

    public boolean exists(int flags, boolean checkType) {
        return this.exists();
    }

    public boolean isAccessible() {
        return this.exists();
    }

    public boolean isReadOnly() {
        return !this.file.canWrite();
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        if (depth == 0) {
            visitor.visit((IResource)this);
        } else if (visitor.visit((IResource)this)) {
            IResource[] iResourceArray = this.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                member.accept(visitor, 1 == depth ? 0 : 2, memberFlags);
                ++n2;
            }
        }
    }

    public URI getLocationURI() {
        return this.file.toURI();
    }

    public IPath getLocation() {
        return new Path(this.file.toPath().toString());
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        try {
            FileDeleter.delete(this.file.toPath());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.n4js.utils", "Error while deleting resource: " + this.file, (Throwable)e));
        }
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.delete(force, monitor);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.delete(true, monitor);
    }

    public void deleteResource(boolean convertToPhantom, MultiStatus status) throws CoreException {
        this.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public IMarker findMarker(long id) {
        return null;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        return new IMarker[0];
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
    }

    public IPath getProjectRelativePath() {
        java.nio.file.Path projectPath = ((IExternalResource)this.getProject()).getExternalResource().toPath();
        java.nio.file.Path currentPath = this.getExternalResource().toPath();
        java.nio.file.Path relativePath = projectPath.relativize(currentPath);
        return new Path(relativePath.toString());
    }

    public IWorkspace getWorkspace() {
        return new DelegatingWorkspace();
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        if (this.exists()) {
            this.file.setLastModified(System.currentTimeMillis());
        }
    }

    public IResource[] members() throws CoreException {
        return this.members(0);
    }

    public IResource[] members(boolean phantom) throws CoreException {
        return this.members(0);
    }

    public IResource[] members(int memberFlags) throws CoreException {
        File[] subFiles = this.file.listFiles();
        IResource[] members = new IResource[subFiles.length];
        int i = 0;
        while (i < subFiles.length) {
            File subFile = subFiles[i];
            members[i] = subFile.isFile() ? new ExternalFile(this.getProject(), (IContainer)this, subFile) : new ExternalFolder(this.getProject(), (IContainer)this, subFile);
            ++i;
        }
        return members;
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
    }

    public IFolder getFolder(String name) {
        return this.getResource(name, IFolder.class);
    }

    public IFile getFile(String name) {
        return this.getResource(name, IFile.class);
    }

    private <T extends IResource> T getResource(String name, Class<T> resourceClass) {
        File fileCandidate = this.getFullPath().append(name).toFile();
        AtomicReference actualRef = new AtomicReference();
        if (fileCandidate.exists()) {
            this.acceptUnsafe(resource -> {
                if (resource instanceof IExternalResource && resourceClass.isAssignableFrom(resource.getClass()) && fileCandidate.equals(((IExternalResource)resource).getExternalResource())) {
                    actualRef.set((IResource)resourceClass.cast(resource));
                    return false;
                }
                return true;
            });
        }
        return (T)((IResource)actualRef.get());
    }

    private void acceptUnsafe(IResourceVisitor visitor) {
        try {
            this.accept(visitor);
        }
        catch (CoreException e) {
            throw new RuntimeException("Error while visiting resource." + this, e);
        }
    }

    public String toString() {
        return "E" + super.toString();
    }
}

