/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CoalesceExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionWithTarget;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryIMOnly;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.PromisifyHelper;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ExpressionTransformation
extends Transformation {
    private static final String CHAINING_COALESCING_TEMP_VAR_NAME = "$opt";
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private PromisifyHelper promisifyHelper;
    private TGetter n4Object_n4type;
    private TGetter n4NamedElement_name;
    private TGetter n4Element_origin;
    private TGetter n4Type_fqn;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
        TMember _findOwnedMember = RuleEnvironmentExtensions.n4ObjectType((RuleEnvironment)this.getState().G).findOwnedMember("n4type", false, true);
        this.n4Object_n4type = (TGetter)_findOwnedMember;
        TMember _findOwnedMember_1 = RuleEnvironmentExtensions.n4NamedElementType((RuleEnvironment)this.getState().G).findOwnedMember("name", false, false);
        this.n4NamedElement_name = (TGetter)_findOwnedMember_1;
        TMember _findOwnedMember_2 = RuleEnvironmentExtensions.n4ElementType((RuleEnvironment)this.getState().G).findOwnedMember("origin", false, false);
        this.n4Element_origin = (TGetter)_findOwnedMember_2;
        TMember _findOwnedMember_3 = RuleEnvironmentExtensions.n4TypeType((RuleEnvironment)this.getState().G).findOwnedMember("fqn", false, false);
        this.n4Type_fqn = (TGetter)_findOwnedMember_3;
        if (this.n4Object_n4type == null || this.n4NamedElement_name == null || this.n4Element_origin == null || this.n4Type_fqn == null) {
            throw new IllegalStateException("could not find required members of built-in types");
        }
    }

    public void transform() {
        Consumer<Expression> _function = it -> this.transformExpression((Expression)it);
        ListExtensions.reverse((List)this.collectNodes((EObject)this.getState().im, Expression.class, true)).forEach(_function);
    }

    private void _transformExpression(Expression expr) {
    }

    private void _transformExpression(CastExpression castExpr) {
        this.replace((Expression)castExpr, castExpr.getExpression());
    }

    private void _transformExpression(CoalesceExpression coalExpr) {
        this.transformCoalesceExpression(coalExpr);
    }

    private void _transformExpression(ExpressionWithTarget exprWithTarget) {
        boolean _transformTrivialUsageOfReflection;
        if (exprWithTarget instanceof ParameterizedPropertyAccessExpression_IM && (_transformTrivialUsageOfReflection = this.transformTrivialUsageOfReflection((ParameterizedPropertyAccessExpression_IM)exprWithTarget))) {
            return;
        }
        this.transformOptionalChaining(exprWithTarget);
    }

    private void _transformExpression(AwaitExpression awaitExpr) {
        AwaitExpression awaitExprOrig = (AwaitExpression)this.getState().tracer.getOriginalASTNodeOfSameType((EObject)awaitExpr, false);
        boolean _isAutoPromisify = this.promisifyHelper.isAutoPromisify(awaitExprOrig);
        if (_isAutoPromisify) {
            Expression _expression = awaitExpr.getExpression();
            ParameterizedCallExpression callExpr = (ParameterizedCallExpression)_expression;
            ParameterizedCallExpression replacement = this.promisify(callExpr);
            this.replace((Expression)callExpr, (Expression)replacement);
        }
    }

    private void _transformExpression(PromisifyExpression promiExpr) {
        Expression _expression = promiExpr.getExpression();
        ParameterizedCallExpression callExpr = (ParameterizedCallExpression)_expression;
        ParameterizedCallExpression replacement = this.promisify(callExpr);
        this.replace((Expression)promiExpr, (Expression)replacement);
    }

    private ParameterizedCallExpression promisify(ParameterizedCallExpression callExpr) {
        IdentifiableElement originalTarget;
        SymbolTableEntry targetSTE;
        Expression target = callExpr.getTarget();
        SymbolTableEntry _switchResult = null;
        boolean _matched = false;
        if (target instanceof ParameterizedPropertyAccessExpression_IM) {
            _matched = true;
            _switchResult = ((ParameterizedPropertyAccessExpression_IM)target).getProperty_IM();
        }
        if (!_matched && target instanceof IdentifierRef_IM) {
            _matched = true;
            _switchResult = ((IdentifierRef_IM)target).getId_IM();
        }
        if ((targetSTE = _switchResult) instanceof SymbolTableEntryOriginal && (originalTarget = ((SymbolTableEntryOriginal)targetSTE).getOriginalTarget()) instanceof TFunction) {
            ParameterizedTypeRef _createTypeRef = TypeUtils.createTypeRef((Type)((Type)originalTarget), (TypeArgument[])new TypeArgument[0]);
            FunctionTypeRef originalTargetTypeRef = (FunctionTypeRef)_createTypeRef;
            TypeRef returnTypeRef = this.promisifyHelper.extractPromisifiedReturnType(this.getState().G, (FunctionTypeExprOrRef)originalTargetTypeRef);
            boolean _isUndefined = TypeUtils.isUndefined((TypeArgument)((TypeArgument)IterableExtensions.head((Iterable)IterableExtensions.drop((Iterable)returnTypeRef.getTypeArgs(), (int)1))));
            boolean hasErrorValue = !_isUndefined;
            boolean hasMoreThan1SuccessValue = RuleEnvironmentExtensions.isIterableN((RuleEnvironment)this.getState().G, (EObject)((EObject)IterableExtensions.head((Iterable)returnTypeRef.getTypeArgs())));
            if (target instanceof ParameterizedPropertyAccessExpression_IM && ((SymbolTableEntryOriginal)targetSTE).getOriginalTarget() instanceof TMethod) {
                Functions.Function1 _function = it -> TranspilerBuilderBlocks._ArrayElement((boolean)it.isSpread(), (Expression)it.getExpression());
                return TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_$n4promisifyMethod()), (Expression[])new Expression[]{((ParameterizedPropertyAccessExpression_IM)target).getTarget(), TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)targetSTE), TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)ListExtensions.map((List)callExpr.getArguments(), (Functions.Function1)_function), ArrayElement.class))), TranspilerBuilderBlocks._BooleanLiteral((boolean)hasMoreThan1SuccessValue), TranspilerBuilderBlocks._BooleanLiteral((!hasErrorValue ? 1 : 0) != 0)});
            }
            Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._ArrayElement((boolean)it.isSpread(), (Expression)it.getExpression());
            return TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_$n4promisifyFunction()), (Expression[])new Expression[]{callExpr.getTarget(), TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)ListExtensions.map((List)callExpr.getArguments(), (Functions.Function1)_function_1), ArrayElement.class))), TranspilerBuilderBlocks._BooleanLiteral((boolean)hasMoreThan1SuccessValue), TranspilerBuilderBlocks._BooleanLiteral((!hasErrorValue ? 1 : 0) != 0)});
        }
        return callExpr;
    }

    private boolean transformTrivialUsageOfReflection(ParameterizedPropertyAccessExpression_IM propAccessExpr) {
        IdentifiableElement id;
        Expression targetOfTarget;
        IdentifiableElement propertyOfTarget;
        Expression target;
        IdentifiableElement property = propAccessExpr.getOriginalTargetOfRewiredTarget();
        if ((property == this.n4NamedElement_name || property == this.n4Element_origin || property == this.n4Type_fqn) && (target = propAccessExpr.getTarget()) instanceof ParameterizedPropertyAccessExpression_IM && (propertyOfTarget = ((ParameterizedPropertyAccessExpression_IM)target).getOriginalTargetOfRewiredTarget()) == this.n4Object_n4type && (targetOfTarget = ((ParameterizedPropertyAccessExpression_IM)target).getTarget()) instanceof IdentifierRef_IM && (id = ((IdentifierRef_IM)targetOfTarget).getOriginalTargetOfRewiredTarget()) instanceof TClass) {
            String _switchResult = null;
            boolean _matched = false;
            if (Objects.equal((Object)property, (Object)this.n4NamedElement_name)) {
                _matched = true;
                _switchResult = ((TClass)id).getName();
            }
            if (!_matched && Objects.equal((Object)property, (Object)this.n4Element_origin)) {
                _matched = true;
                _switchResult = this.resourceNameComputer.generateProjectDescriptor(((TClass)id).eResource().getURI());
            }
            if (!_matched && Objects.equal((Object)property, (Object)this.n4Type_fqn)) {
                boolean _not;
                _matched = true;
                String _xifexpression = null;
                boolean _isFromResourceWithN4Scheme = N4Scheme.isFromResourceWithN4Scheme((EObject)id);
                boolean bl = _not = !_isFromResourceWithN4Scheme;
                if (_not) {
                    _xifexpression = this.resourceNameComputer.getFullyQualifiedTypeName((Type)id);
                }
                _switchResult = _xifexpression;
            }
            if (!_matched) {
                throw new IllegalStateException();
            }
            String value = _switchResult;
            if (value != null) {
                this.replace((Expression)propAccessExpr, (Expression)TranspilerBuilderBlocks._StringLiteral((String)value));
                return true;
            }
        }
        return false;
    }

    private void transformCoalesceExpression(CoalesceExpression coalExpr) {
        SymbolTableEntryIMOnly tempVarSTE = this.addOrGetTemporaryVariable(CHAINING_COALESCING_TEMP_VAR_NAME, (EObject)coalExpr);
        ConditionalExpression replacement = TranspilerBuilderBlocks._ConditionalExpr((Expression)TranspilerBuilderBlocks._EqualityExpr((Expression)TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)tempVarSTE), (Expression)coalExpr.getExpression())), (EqualityOperator)EqualityOperator.NEQ, (Expression)TranspilerBuilderBlocks._NULL()), (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)tempVarSTE), (Expression)coalExpr.getDefaultExpression());
        EObject _eContainer = coalExpr.eContainer();
        if (_eContainer instanceof Expression) {
            this.replace((Expression)coalExpr, (Expression)TranspilerBuilderBlocks._Parenthesis((Expression)replacement));
        } else {
            this.replace((Expression)coalExpr, (Expression)replacement);
        }
    }

    private boolean transformOptionalChaining(ExpressionWithTarget exprWithTarget) {
        boolean _not;
        boolean _isOptionalChaining = exprWithTarget.isOptionalChaining();
        boolean bl = _not = !_isOptionalChaining;
        if (_not) {
            return false;
        }
        exprWithTarget.setOptionalChaining(false);
        Expression target = exprWithTarget.getTarget();
        SymbolTableEntryIMOnly tempVarSTE = this.addOrGetTemporaryVariable(CHAINING_COALESCING_TEMP_VAR_NAME, (EObject)exprWithTarget);
        this.replace(target, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)tempVarSTE));
        Expression toBeReplaced = this.getLongShortCircuitingDesitnation(exprWithTarget);
        EqualityExpression __EqualityExpr = TranspilerBuilderBlocks._EqualityExpr((Expression)TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)tempVarSTE), (Expression)target)), (EqualityOperator)EqualityOperator.EQ, (Expression)TranspilerBuilderBlocks._NULL());
        Object _xifexpression = null;
        _xifexpression = toBeReplaced instanceof UnaryExpression ? TranspilerBuilderBlocks._TRUE() : TranspilerBuilderBlocks._Void0();
        ConditionalExpression replacement = TranspilerBuilderBlocks._ConditionalExpr((Expression)__EqualityExpr, (Expression)_xifexpression, null);
        EObject _eContainer = toBeReplaced.eContainer();
        if (_eContainer instanceof Expression) {
            this.replace(toBeReplaced, (Expression)TranspilerBuilderBlocks._Parenthesis((Expression)replacement));
        } else {
            this.replace(toBeReplaced, (Expression)replacement);
        }
        replacement.setFalseExpression(toBeReplaced);
        if (exprWithTarget instanceof ParameterizedCallExpression && target instanceof ParameterizedPropertyAccessExpression) {
            this.preserveCallContext((ParameterizedCallExpression)exprWithTarget, (ParameterizedPropertyAccessExpression)target);
        }
        return true;
    }

    private Expression getLongShortCircuitingDesitnation(ExpressionWithTarget expr) {
        ExpressionWithTarget dest = expr;
        EObject destParent = dest.eContainer();
        while (destParent instanceof ExpressionWithTarget) {
            dest = (Expression)destParent;
            destParent = dest.eContainer();
        }
        if (destParent instanceof UnaryExpression && ((UnaryExpression)destParent).getOp() == UnaryOperator.DELETE && ((UnaryExpression)destParent).getExpression() == dest) {
            dest = (Expression)destParent;
        }
        return dest;
    }

    private void preserveCallContext(ParameterizedCallExpression exprWithTarget, ParameterizedPropertyAccessExpression target) {
        IdentifierRef_IM callContextExpr = null;
        Expression receiver = target.getTarget();
        if (receiver instanceof IdentifierRef_IM && !this.isIdentifierRefToChainingTempVar(receiver)) {
            callContextExpr = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)((IdentifierRef_IM)receiver).getId_IM());
        } else {
            SymbolTableEntryIMOnly tempVarReceiverSTE = this.addOrGetTemporaryVariable("$optR", (EObject)exprWithTarget);
            AssignmentExpression receiverAssignment = TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)tempVarReceiverSTE), null);
            this.replace(receiver, (Expression)TranspilerBuilderBlocks._Parenthesis((Expression)receiverAssignment));
            receiverAssignment.setRhs(receiver);
            callContextExpr = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)tempVarReceiverSTE);
        }
        exprWithTarget.setTarget((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)exprWithTarget.getTarget(), (SymbolTableEntry[])new SymbolTableEntry[]{this.steFor_Function_call()}));
        exprWithTarget.getArguments().add(0, (Object)TranspilerBuilderBlocks._Argument((Expression)callContextExpr));
    }

    private boolean isIdentifierRefToChainingTempVar(Expression expr) {
        if (expr instanceof IdentifierRef_IM) {
            String name;
            SymbolTableEntry _id_IM = ((IdentifierRef_IM)expr).getId_IM();
            String _name = null;
            if (_id_IM != null) {
                _name = _id_IM.getName();
            }
            return (name = _name) != null && name.startsWith(CHAINING_COALESCING_TEMP_VAR_NAME);
        }
        return false;
    }

    private void transformExpression(Expression awaitExpr) {
        if (awaitExpr instanceof AwaitExpression) {
            this._transformExpression((AwaitExpression)awaitExpr);
            return;
        }
        if (awaitExpr instanceof CastExpression) {
            this._transformExpression((CastExpression)awaitExpr);
            return;
        }
        if (awaitExpr instanceof CoalesceExpression) {
            this._transformExpression((CoalesceExpression)awaitExpr);
            return;
        }
        if (awaitExpr instanceof ExpressionWithTarget) {
            this._transformExpression((ExpressionWithTarget)awaitExpr);
            return;
        }
        if (awaitExpr instanceof PromisifyExpression) {
            this._transformExpression((PromisifyExpression)awaitExpr);
            return;
        }
        if (awaitExpr != null) {
            this._transformExpression(awaitExpr);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(awaitExpr).toString());
    }
}

