/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.MultiCleartriggerCache;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectModel.locations.PlatformResourceURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.ui.internal.ProjectDescriptionLoadListener;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

@Singleton
public class EclipseBasedN4JSWorkspace
extends InternalN4JSWorkspace<PlatformResourceURI> {
    private final IWorkspaceRoot workspace;
    private final ProjectDescriptionLoader projectDescriptionLoader;
    private final MultiCleartriggerCache cache;
    private ProjectDescriptionLoadListener listener;

    @Inject
    public EclipseBasedN4JSWorkspace(IWorkspaceRoot workspace, ProjectDescriptionLoader projectDescriptionLoader, MultiCleartriggerCache cache) {
        this.workspace = workspace;
        this.projectDescriptionLoader = projectDescriptionLoader;
        this.cache = cache;
    }

    public IWorkspaceRoot getWorkspace() {
        return this.workspace;
    }

    public PlatformResourceURI fromURI(URI uri) {
        if (!uri.isPlatformResource()) {
            return null;
        }
        return new PlatformResourceURI(uri);
    }

    public PlatformResourceURI findProjectWith(PlatformResourceURI nestedLocation) {
        return new PlatformResourceURI(URI.createPlatformResourceURI((String)nestedLocation.toURI().segment(1), (boolean)true));
    }

    public ProjectDescription getProjectDescription(PlatformResourceURI location) {
        ProjectDescriptionLoaderAndNotifier supplier = new ProjectDescriptionLoaderAndNotifier(location);
        ProjectDescription existing = (ProjectDescription)this.cache.get((Supplier)((Object)supplier), "PROJECT_DESCRIPTIONS", location.toURI());
        return existing;
    }

    public PlatformResourceURI getProjectLocation(N4JSProjectName name) {
        IProject project = this.workspace.getProject(name.toEclipseProjectName().getRawName());
        if (project.exists()) {
            return new PlatformResourceURI((IResource)project);
        }
        return null;
    }

    public Collection<PlatformResourceURI> getAllProjectLocations() {
        ArrayList<PlatformResourceURI> prjLocations = new ArrayList<PlatformResourceURI>();
        IProject[] iProjectArray = this.workspace.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            prjLocations.add(new PlatformResourceURI((IResource)prj));
            ++n2;
        }
        return prjLocations;
    }

    public PlatformResourceURI getLocation(ProjectReference projectReference) {
        String expectedEclipseProjectName;
        IProject existingProject;
        String expectedProjectName = projectReference.getProjectName();
        if (expectedProjectName != null && expectedProjectName.length() > 0 && (existingProject = this.workspace.getProject(expectedEclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)expectedProjectName))).isAccessible()) {
            return new PlatformResourceURI((IResource)existingProject);
        }
        return null;
    }

    public Iterator<? extends PlatformResourceURI> getFolderIterator(PlatformResourceURI folderLocation) {
        return folderLocation.getAllChildren();
    }

    public PlatformResourceURI findArtifactInFolder(PlatformResourceURI folderLocation, String folderRelativePath) {
        PlatformResourceURI result = (PlatformResourceURI)folderLocation.appendPath(folderRelativePath);
        if (result.exists()) {
            return result;
        }
        return null;
    }

    public void invalidateProject(PlatformResourceURI location) {
        throw new IllegalStateException("Not supported for EclipseBasedN4JSWorkspace");
    }

    void setProjectDescriptionLoadListener(ProjectDescriptionLoadListener listener) {
        this.listener = listener;
    }

    private class ProjectDescriptionLoaderAndNotifier
    implements MultiCleartriggerCache.CleartriggerSupplier<ProjectDescription> {
        final PlatformResourceURI location;

        public ProjectDescriptionLoaderAndNotifier(PlatformResourceURI location) {
            this.location = location;
        }

        public ProjectDescription get() {
            ProjectDescription pd = EclipseBasedN4JSWorkspace.this.projectDescriptionLoader.loadProjectDescriptionAtLocation((SafeURI)this.location);
            return pd;
        }

        public void postSupply() {
            if (EclipseBasedN4JSWorkspace.this.listener != null) {
                EclipseBasedN4JSWorkspace.this.listener.onDescriptionLoaded(this.location.toURI());
            }
        }
    }
}

