/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.DefaultImportSpecifier;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.IUsageAwareEObjectDescription;
import org.eclipse.n4js.scoping.utils.UnresolvableObjectDescription;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ErrorAwareLinkingService
extends DefaultLinkingService {
    private static final EReference PARAMETERIZED_TYPE_REF__DECLARED_TYPE = TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType();
    private static final EReference NAMED_IMPORT_SPECIFIER__IMPORTED_ELEMENT = N4JSPackage.eINSTANCE.getNamedImportSpecifier_ImportedElement();
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IN4JSCore n4jsCore;

    protected IScope getScope(EObject context, EReference reference) {
        IScopeProvider scopeProvider = N4LanguageUtils.getServiceForContext((EObject)context, IScopeProvider.class).orElse(super.getScopeProvider());
        if (this.getScopeProvider() == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        try {
            this.registerImportedNamesAdapter(scopeProvider, context);
            IScope iScope = scopeProvider.getScope(context, reference);
            return iScope;
        }
        finally {
            this.unRegisterImportedNamesAdapter(scopeProvider);
        }
    }

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        EClass requiredType = ref.getEReferenceType();
        if (requiredType == null) {
            return Collections.emptyList();
        }
        String crossRefString = this.getCrossRefNodeAsString(context, ref, node);
        if (crossRefString != null && !crossRefString.equals("")) {
            IEObjectDescriptionWithError errorDescr;
            IScope scope = this.getScope(context, ref);
            QualifiedName qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
            IEObjectDescription eObjectDescription = scope.getSingleElement(qualifiedLinkName);
            Resource resource = context.eResource();
            if (resource != null && (errorDescr = IEObjectDescriptionWithError.getDescriptionWithError((IEObjectDescription)eObjectDescription)) != null && !this.n4jsCore.isNoValidate(resource.getURI())) {
                this.addError(context, node, errorDescr);
            } else if (eObjectDescription instanceof UnresolvableObjectDescription) {
                return Collections.singletonList((EObject)context.eGet((EStructuralFeature)ref, false));
            }
            if (eObjectDescription != null) {
                EObject candidate = eObjectDescription.getEObjectOrProxy();
                if (!candidate.eIsProxy() && candidate.eResource() == null) {
                    throw new AssertionError((Object)"Found an instance without resource and without URI");
                }
                if (eObjectDescription instanceof IUsageAwareEObjectDescription) {
                    ((IUsageAwareEObjectDescription)eObjectDescription).markAsUsed();
                }
                return Collections.singletonList(candidate);
            }
        }
        return Collections.emptyList();
    }

    public String getCrossRefNodeAsString(EObject context, EReference ref, INode node) {
        if (ref == NAMED_IMPORT_SPECIFIER__IMPORTED_ELEMENT && context instanceof DefaultImportSpecifier) {
            return "default";
        }
        String result = this.getCrossRefNodeAsString(node);
        if (ref == PARAMETERIZED_TYPE_REF__DECLARED_TYPE && context instanceof ParameterizedTypeRef) {
            result = result != null ? result.replace('.', '/') : null;
        }
        return result;
    }

    protected void addError(EObject context, INode node, IEObjectDescriptionWithError error) {
        XtextLinkingDiagnostic diagnostic;
        N4JSResource resource = (N4JSResource)context.eResource();
        if (resource.isValidationDisabled()) {
            return;
        }
        Severity severity = error.getSeverity();
        EList list = severity == Severity.WARNING ? resource.getWarnings() : resource.getErrors();
        String[] userData = null;
        if (error.getUserDataKeys() != null) {
            ArrayList<String> userDataList = new ArrayList<String>(error.getUserDataKeys().length * 2);
            String[] stringArray = error.getUserDataKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String userDataKey = stringArray[n2];
                String userDataValue = error.getUserData(userDataKey);
                if (userDataValue != null) {
                    userDataList.add(userDataKey);
                    userDataList.add(userDataValue);
                }
                ++n2;
            }
            userData = userDataList.toArray(new String[userDataList.size()]);
        }
        if (!list.contains(diagnostic = new XtextLinkingDiagnostic(node, error.getMessage(), error.getIssueCode(), userData))) {
            list.add(diagnostic);
        }
    }
}

