/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.XIWorkspaceConfigFactory;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSBrokenProjectException;
import org.eclipse.n4js.internal.lsp.N4JSWorkspaceConfig;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.ProjectDiscoveryHelper;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.xtext.workspace.XIWorkspaceConfig;

@Singleton
public class FileBasedWorkspaceInitializer
implements XIWorkspaceConfigFactory {
    private static Logger LOG = Logger.getLogger(XLanguageServerImpl.class);
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private FileBasedWorkspace workspace;
    private ProjectDiscoveryHelper projectDiscoveryHelper;
    private URI knownWorkspaceBaseURI = null;

    @Inject
    public void setProjectDiscoveryHelper(ProjectDiscoveryHelper projectDiscoveryHelper) {
        this.projectDiscoveryHelper = projectDiscoveryHelper;
    }

    @Override
    public XIWorkspaceConfig createWorkspaceConfig(URI workspaceBaseURI) {
        try {
            if (workspaceBaseURI.equals(this.knownWorkspaceBaseURI)) {
                N4JSWorkspaceConfig n4JSWorkspaceConfig = new N4JSWorkspaceConfig(workspaceBaseURI, this.n4jsCore);
                return n4JSWorkspaceConfig;
            }
            this.workspace.clear();
            File workspaceRoot = URIUtils.toFile((URI)workspaceBaseURI);
            LinkedHashSet allProjectLocations = this.projectDiscoveryHelper.collectAllProjectDirs(new Path[]{workspaceRoot.toPath()});
            ArrayList<FileURI> allProjectURIs = new ArrayList<FileURI>();
            for (Path path : allProjectLocations) {
                allProjectURIs.add(new FileURI(path.toFile()));
            }
            this.registerProjectsToFileBasedWorkspace(allProjectURIs);
            N4JSWorkspaceConfig n4JSWorkspaceConfig = new N4JSWorkspaceConfig(workspaceBaseURI, this.n4jsCore);
            return n4JSWorkspaceConfig;
        }
        finally {
            this.knownWorkspaceBaseURI = workspaceBaseURI;
        }
    }

    private void registerProjectsToFileBasedWorkspace(Iterable<FileURI> projectURIs) {
        HashMap<String, FileURI> registeredProjects = new HashMap<String, FileURI>();
        this.workspace.getAllProjectLocationsIterator().forEachRemaining(uri -> {
            String projectName = this.workspace.getProjectDescription(uri).getProjectName();
            registeredProjects.put(projectName, (FileURI)uri);
        });
        for (FileURI projectURI : projectURIs) {
            ProjectDescription projectDescription = this.projectDescriptionLoader.loadProjectDescriptionAtLocation((SafeURI)projectURI);
            if (projectDescription == null) {
                throw new RuntimeException("Cannot load project description for project at " + projectURI + ". Make sure the project contains a valid package.json file.");
            }
            String projectName = projectDescription.getProjectName();
            if (this.skipRegistering(projectName, projectURI, registeredProjects)) {
                LOG.debug((Object)("Skipping already registered project '" + projectURI + "'"));
                continue;
            }
            try {
                LOG.debug((Object)("Registering project '" + projectURI + "'"));
                this.workspace.registerProject(projectURI, projectDescription);
                registeredProjects.put(projectName, projectURI);
            }
            catch (N4JSBrokenProjectException e) {
                throw new RuntimeException("Unable to register project '" + projectURI + "'", e);
            }
        }
    }

    private boolean skipRegistering(String projectName, FileURI projectLocation, Map<String, FileURI> registeredProjects) {
        if (!registeredProjects.containsKey(projectName)) {
            return false;
        }
        FileURI registeredProjectLocation = registeredProjects.get(projectName);
        if (projectLocation.equals((Object)registeredProjectLocation)) {
            return true;
        }
        if (registeredProjectLocation == null) {
            throw new RuntimeException("Duplicate project id [" + projectName + "]. Already registered project at " + registeredProjects.get(projectName) + ", trying to register project at " + projectLocation + ".");
        }
        return true;
    }
}

