/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ide.validation.N4JSIssue;
import org.eclipse.n4js.ide.xtext.server.HashedFileContent;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ProjectStatePersister {
    private static final int VERSION_2 = 2;
    private static final int CURRENT_VERSION = 2;
    public static final String FILENAME = ".n4js.projectstate";
    private final ExecutorService writer = Executors.newSingleThreadExecutor();

    public void close() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.writer, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> pendingWrites() {
        if (this.writer.isTerminated()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {}, this.writer).exceptionally(any -> null);
    }

    public void writeProjectState(IProjectConfig project, XIndexState state, Collection<? extends HashedFileContent> files, Multimap<URI, Issue> validationIssues) {
        XIndexState indexCopy = new XIndexState(state.getResourceDescriptions().copy(), state.getFileMappings().copy());
        this.asyncWriteProjectState(project, indexCopy, (Collection<? extends HashedFileContent>)ImmutableList.copyOf(files), (Multimap<URI, Issue>)ImmutableListMultimap.copyOf(validationIssues));
    }

    private void asyncWriteProjectState(IProjectConfig project, XIndexState state, Collection<? extends HashedFileContent> files, Multimap<URI, Issue> validationIssues) {
        this.writer.submit(() -> {
            block11: {
                File file = this.getDataFile(project);
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (OutputStream nativeOut = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();){
                        this.writeProjectState(nativeOut, N4JSLanguageUtils.getLanguageVersion(), state, files, validationIssues);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (!file.isFile()) break block11;
                    file.delete();
                }
            }
        });
    }

    public void writeProjectState(OutputStream stream, String languageVersion, XIndexState state, Collection<? extends HashedFileContent> files, Multimap<URI, Issue> validationIssues) throws IOException {
        stream.write(2);
        Throwable throwable = null;
        Object var7_8 = null;
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream, 8192)));){
            output.writeUTF(languageVersion);
            this.writeResourceDescriptions(state, output);
            this.writeFileMappings(state, output);
            this.writeFingerprints(files, output);
            this.writeValidationIssues(validationIssues, output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeResourceDescriptions(XIndexState state, DataOutput output) throws IOException {
        ResourceDescriptionsData resourceDescriptionData = state.getResourceDescriptions();
        output.writeInt(resourceDescriptionData.getAllURIs().size());
        for (IResourceDescription description : resourceDescriptionData.getAllResourceDescriptions()) {
            if (description instanceof SerializableResourceDescription) {
                this.writeResourceDescription((SerializableResourceDescription)description, output);
                continue;
            }
            throw new IOException("Unexpected type: " + description.getClass().getName());
        }
    }

    private void writeResourceDescription(SerializableResourceDescription description, DataOutput output) throws IOException {
        output.writeUTF(description.getURI().toString());
        this.writeEObjectDescriptions(description, output);
        this.writeReferenceDescriptions(description, output);
        this.writeImportedNames(description, output);
    }

    private void writeImportedNames(SerializableResourceDescription resourceDescription, DataOutput output) throws IOException {
        List importedNames = IterableExtensions.toList((Iterable)resourceDescription.getImportedNames());
        output.writeInt(importedNames.size());
        for (QualifiedName importedName : importedNames) {
            this.writeQualifiedName(importedName, output);
        }
    }

    private void writeReferenceDescriptions(SerializableResourceDescription resourceDescription, DataOutput output) throws IOException {
        List references = resourceDescription.getReferences();
        output.writeInt(references.size());
        for (SerializableReferenceDescription reference : references) {
            output.writeUTF(reference.getSourceEObjectUri().toString());
            output.writeUTF(reference.getTargetEObjectUri().toString());
            output.writeUTF(reference.getContainerEObjectURI().toString());
            output.writeUTF(EcoreUtil.getURI((EObject)reference.getEReference()).toString());
            output.writeInt(reference.getIndexInList());
        }
    }

    private void writeEObjectDescriptions(SerializableResourceDescription resourceDescription, DataOutput output) throws IOException {
        List objects = resourceDescription.getDescriptions();
        output.writeInt(objects.size());
        for (SerializableEObjectDescription object : objects) {
            output.writeUTF(object.getEObjectURI().toString());
            output.writeUTF(EcoreUtil.getURI((EObject)object.getEClass()).toString());
            QualifiedName qn = object.getQualifiedName();
            this.writeQualifiedName(qn, output);
            HashMap userData = object.getUserData();
            if (userData != null) {
                output.writeInt(userData.size());
                for (Map.Entry entry : userData.entrySet()) {
                    output.writeUTF((String)entry.getKey());
                    this.writeUserDataValue((String)entry.getValue(), output);
                }
                continue;
            }
            output.writeInt(0);
        }
    }

    private void writeUserDataValue(String value, DataOutput output) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    private void writeQualifiedName(QualifiedName qualifiedName, DataOutput output) throws IOException {
        output.writeInt(qualifiedName.getSegmentCount());
        int i = 0;
        int max = qualifiedName.getSegmentCount();
        while (i < max) {
            output.writeUTF(qualifiedName.getSegment(i));
            ++i;
        }
    }

    private void writeFileMappings(XIndexState state, DataOutputStream output) throws IOException {
        state.getFileMappings().writeExternal(output);
    }

    private void writeFingerprints(Collection<? extends HashedFileContent> files, DataOutput output) throws IOException {
        output.writeInt(files.size());
        for (HashedFileContent hashedFileContent : files) {
            hashedFileContent.write(output);
        }
    }

    private void writeValidationIssues(Multimap<URI, Issue> validationIssues, DataOutput output) throws IOException {
        int numberSources = validationIssues.size();
        output.writeInt(numberSources);
        for (URI source : validationIssues.keys()) {
            Collection issues = validationIssues.get((Object)source);
            output.writeUTF(source.toString());
            ArrayList<N4JSIssue> n4Issues = new ArrayList<N4JSIssue>();
            for (Issue issue : issues) {
                if (issue instanceof N4JSIssue) {
                    n4Issues.add((N4JSIssue)issue);
                    continue;
                }
                n4Issues.add(new N4JSIssue(issue));
            }
            int numberIssues = n4Issues.size();
            output.writeInt(numberIssues);
            for (N4JSIssue issue : n4Issues) {
                issue.writeExternal(output);
            }
        }
    }

    public PersistedState readProjectState(IProjectConfig project) {
        block13: {
            File file = this.getDataFile(project);
            try {
                if (file.isFile()) {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream nativeIn = Files.asByteSource((File)file).openBufferedStream();){
                        PersistedState result = this.readProjectState(nativeIn, N4JSLanguageUtils.getLanguageVersion());
                        if (result == null && file.isFile()) {
                            file.delete();
                        }
                        return result;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                if (!file.isFile()) break block13;
                file.delete();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistedState readProjectState(InputStream stream, String expectedLanguageVersion) throws IOException, ClassNotFoundException {
        int version = stream.read();
        if (version != 2) {
            return null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(new GZIPInputStream(stream, 8192)));){
            String languageVersion = input.readUTF();
            if (!expectedLanguageVersion.equals(languageVersion)) {
                return null;
            }
            ResourceDescriptionsData resourceDescriptionsData = this.readResourceDescriptions(input);
            XSource2GeneratedMapping fileMappings = this.readFileMappings(input);
            Map<URI, HashedFileContent> fingerprints = this.readFingerprints(input);
            Multimap<URI, Issue> validationIssues = this.readValidationIssues(input);
            XIndexState indexState = new XIndexState(resourceDescriptionsData, fileMappings);
            return new PersistedState(indexState, fingerprints, validationIssues);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private ResourceDescriptionsData readResourceDescriptions(DataInput input) throws IOException {
        ArrayList<SerializableResourceDescription> descriptions = new ArrayList<SerializableResourceDescription>();
        int size = input.readInt();
        while (size > 0) {
            --size;
            descriptions.add(this.readResourceDescription(input));
        }
        return new ResourceDescriptionsData(descriptions);
    }

    private ENamedElement readEcoreElement(DataInput input) throws IOException {
        URI uri = URI.createURI((String)input.readUTF());
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri.trimFragment().toString());
        if (ePackage != null) {
            Resource resource = ePackage.eResource();
            return (ENamedElement)resource.getEObject(uri.fragment());
        }
        return null;
    }

    private SerializableResourceDescription readResourceDescription(DataInput input) throws IOException {
        SerializableResourceDescription result = new SerializableResourceDescription();
        result.setURI(URI.createURI((String)input.readUTF()));
        result.setDescriptions(this.readEObjectDescriptions(input));
        result.setReferences(this.readReferenceDescriptions(input));
        result.setImportedNames(this.readImportedNames(input));
        return result;
    }

    private List<QualifiedName> readImportedNames(DataInput input) throws IOException {
        int size = input.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<QualifiedName> result = new ArrayList<QualifiedName>(size);
        while (size > 0) {
            --size;
            result.add(this.readQualifiedName(input));
        }
        return result;
    }

    private List<SerializableReferenceDescription> readReferenceDescriptions(DataInput input) throws IOException {
        int size = input.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<SerializableReferenceDescription> result = new ArrayList<SerializableReferenceDescription>(size);
        while (size > 0) {
            --size;
            SerializableReferenceDescription reference = new SerializableReferenceDescription();
            reference.setSourceEObjectUri(URI.createURI((String)input.readUTF()));
            reference.setTargetEObjectUri(URI.createURI((String)input.readUTF()));
            reference.setContainerEObjectURI(URI.createURI((String)input.readUTF()));
            reference.setEReference((EReference)this.readEcoreElement(input));
            reference.setIndexInList(input.readInt() - 1);
            result.add(reference);
        }
        return result;
    }

    private List<SerializableEObjectDescription> readEObjectDescriptions(DataInput input) throws IOException {
        int size = input.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<SerializableEObjectDescription> result = new ArrayList<SerializableEObjectDescription>(size);
        while (size > 0) {
            --size;
            SerializableEObjectDescription object = new SerializableEObjectDescription();
            object.setEObjectURI(URI.createURI((String)input.readUTF()));
            object.setEClass((EClass)this.readEcoreElement(input));
            object.setQualifiedName(this.readQualifiedName(input));
            int userDataSize = input.readInt();
            HashMap<String, String> userData = new HashMap<String, String>();
            while (userDataSize > 0) {
                --userDataSize;
                String key = input.readUTF();
                userData.put(key, this.readUserDataValue(input));
            }
            object.setUserData(userData);
            result.add(object);
        }
        return result;
    }

    private String readUserDataValue(DataInput input) throws IOException {
        byte[] value = new byte[input.readInt()];
        input.readFully(value);
        return new String(value, StandardCharsets.UTF_8);
    }

    private QualifiedName readQualifiedName(DataInput input) throws IOException {
        int size = input.readInt();
        QualifiedName.Builder builder = new QualifiedName.Builder(size);
        while (size > 0) {
            --size;
            builder.add(input.readUTF());
        }
        return builder.build();
    }

    private XSource2GeneratedMapping readFileMappings(DataInput input) throws IOException {
        XSource2GeneratedMapping fileMappings = new XSource2GeneratedMapping();
        fileMappings.readExternal(input);
        return fileMappings;
    }

    private Map<URI, HashedFileContent> readFingerprints(DataInput input) throws IOException {
        int size = input.readInt();
        HashMap<URI, HashedFileContent> fingerprints = new HashMap<URI, HashedFileContent>(size);
        while (size > 0) {
            --size;
            HashedFileContent hashFileContent = new HashedFileContent(input);
            fingerprints.put(hashFileContent.getUri(), hashFileContent);
        }
        return fingerprints;
    }

    private Multimap<URI, Issue> readValidationIssues(DataInput input) throws IOException {
        int numberOfSources = input.readInt();
        LinkedHashMultimap validationIssues = LinkedHashMultimap.create();
        while (numberOfSources > 0) {
            --numberOfSources;
            URI source = URI.createURI((String)input.readUTF());
            int numberOfIssues = input.readInt();
            while (numberOfIssues > 0) {
                --numberOfIssues;
                N4JSIssue issue = new N4JSIssue();
                issue.readExternal(input);
                validationIssues.put((Object)source, (Object)issue);
            }
        }
        return validationIssues;
    }

    private File getDataFile(IProjectConfig project) {
        URI fileName = this.getFileName(project);
        File file = URIUtils.toFile((URI)fileName);
        return file;
    }

    public URI getFileName(IProjectConfig project) {
        URI rootPath = project.getPath();
        return ((FileURI)new FileURI(rootPath).appendSegment(FILENAME)).toURI();
    }

    public static class PersistedState {
        public final XIndexState indexState;
        public final Map<URI, HashedFileContent> fileHashs;
        public final Multimap<URI, Issue> validationIssues;

        PersistedState(XIndexState indexState, Map<URI, HashedFileContent> fileHashs, Multimap<URI, Issue> validationIssues) {
            this.indexState = indexState;
            this.fileHashs = fileHashs;
            this.validationIssues = validationIssues;
        }
    }
}

