/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.projectDescription.ModuleFilter;
import org.eclipse.n4js.projectDescription.ModuleFilterType;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.utils.io.FileUtils;

public class N4JSProject
implements IN4JSProject {
    private final N4JSModel<? extends SafeURI<?>> model;
    private final SafeURI<?> location;
    private final boolean external;
    private Boolean exists;

    protected N4JSProject(SafeURI<?> location, boolean external, N4JSModel<? extends SafeURI<?>> model) {
        this.location = location;
        this.model = model;
        this.external = this.isInNodeModulesFolderOrDefault(location, external);
    }

    private boolean isInNodeModulesFolderOrDefault(SafeURI<?> location, boolean defaultResult) {
        if (!defaultResult && location instanceof FileURI) {
            URI parent = ((SafeURI)location.getParent()).toURI();
            String lastSegment = parent.lastSegment();
            if (parent.lastSegment() != null && parent.lastSegment().isBlank()) {
                parent = parent.trimSegments(1);
                lastSegment = parent.lastSegment();
            }
            if (lastSegment != null && lastSegment.startsWith("@")) {
                parent = parent.trimSegments(1);
                lastSegment = parent.lastSegment();
            }
            if ("node_modules".equals(lastSegment)) {
                return true;
            }
        }
        return defaultResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof N4JSProject) {
            N4JSProject otherP = (N4JSProject)obj;
            if (this.external != otherP.external) {
                return false;
            }
            return this.location.equals(otherP.location);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.external ? 1231 : 1237);
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    @Override
    public IN4JSSourceContainer findSourceContainerWith(URI member) {
        return (IN4JSSourceContainer)this.model.findN4JSSourceContainerInProject(this, member).orNull();
    }

    protected N4JSModel<? extends SafeURI<?>> getModel() {
        return this.model;
    }

    @Override
    public boolean exists() {
        if (this.exists != null) {
            return this.exists;
        }
        this.exists = this.checkExists();
        return this.exists;
    }

    @Override
    public SafeURI<?> getProjectDescriptionLocation() {
        return this.getProjectDescriptionFile();
    }

    protected boolean checkExists() {
        return this.getProjectDescriptionFile() != null;
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getDependencies() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getDependencies(this, false);
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getSortedDependencies() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.model.getSortedDependencies(this));
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getDependenciesAndImplementedApis() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getDependenciesAndImplementedApis(this, false);
    }

    @Override
    public Optional<N4JSProjectName> getImplementationId() {
        if (!this.exists()) {
            return Optional.absent();
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)pd.getImplementationId()).transform(N4JSProjectName::new);
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getImplementedProjects() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getImplementedProjects(this);
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getAllDirectDependencies() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.getDependencies();
    }

    public ImmutableList<String> getAllDependenciesAndImplementedApiNames() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return ImmutableList.of();
        }
        ArrayList<String> allDependencyNames = new ArrayList<String>();
        for (ProjectDependency prjDep : pd.getProjectDependencies()) {
            allDependencyNames.add(prjDep.getProjectName());
        }
        for (ProjectReference prjRef : pd.getImplementedProjects()) {
            allDependencyNames.add(prjRef.getProjectName());
        }
        return ImmutableList.copyOf(allDependencyNames);
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getProvidedRuntimeLibraries() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getProvidedRuntimeLibraries(this);
    }

    @Override
    public N4JSProjectName getProjectName() {
        return this.location.getProjectName();
    }

    @Override
    public String getVendorID() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return null;
        }
        return pd.getVendorId();
    }

    @Override
    public SafeURI<?> getLocation() {
        return this.location;
    }

    @Override
    public ImmutableList<? extends IN4JSSourceContainer> getSourceContainers() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getN4JSSourceContainers(this);
    }

    @Override
    public VersionNumber getVersion() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return null;
        }
        return pd.getProjectVersion();
    }

    @Override
    public String getOutputPath() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return null;
        }
        return FileUtils.normalizeToDotWhenEmpty((String)pd.getOutputPath());
    }

    public boolean isWorkspacesProject() {
        List<String> workspaces = this.getWorkspaces();
        return workspaces != null && !workspaces.isEmpty();
    }

    public List<String> getWorkspaces() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return null;
        }
        return pd.getWorkspaces();
    }

    @Override
    public ModuleFilter getModuleValidationFilter() {
        return this.getModuleFilterByType(ModuleFilterType.NO_VALIDATE);
    }

    private ModuleFilter getModuleFilterByType(ModuleFilterType type) {
        for (ModuleFilter moduleFilter : this.getModuleFilters()) {
            if (moduleFilter.getModuleFilterType() != type) continue;
            return moduleFilter;
        }
        return null;
    }

    private List<ModuleFilter> getModuleFilters() {
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return Collections.emptyList();
        }
        return pd.getModuleFilters();
    }

    @Override
    public ProjectType getProjectType() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return null;
        }
        return pd.getProjectType();
    }

    @Override
    public String getMainModule() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return null;
        }
        return pd.getMainModule();
    }

    @Override
    public Optional<N4JSProjectName> getExtendedRuntimeEnvironmentId() {
        return this.model.getExtendedRuntimeEnvironmentName(this).transform(N4JSProjectName::new);
    }

    public Optional<IN4JSProject> getExtendedRuntimeEnvironment() {
        return Optional.fromNullable((Object)((IN4JSProject)this.model.getExtendedRuntimeEnvironment(this).orNull()));
    }

    public Collection<IN4JSProject> getTestedProjects() {
        if (!this.exists()) {
            return Collections.emptyList();
        }
        return this.model.getTestedProjects(this);
    }

    public String toString() {
        String str = this.getProjectName().getRawName();
        str = String.valueOf(str) + " (" + (this.exists() ? this.getProjectType() : "doesn't exist") + ")";
        return str;
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }

    private SafeURI<?> getProjectDescriptionFile() {
        if (this.location.isDirectory()) {
            Object packageJson = this.location.appendSegment("package.json");
            if (((SafeURI)packageJson).isFile()) {
                return packageJson;
            }
            Object packageJsonXpect = this.location.appendSegment("package.json.xt");
            if (((SafeURI)packageJsonXpect).isFile()) {
                return packageJsonXpect;
            }
        }
        return null;
    }

    public void invalidate() {
        this.model.invalidateProject(this.getLocation());
    }

    @Override
    public boolean hasN4JSNature() {
        if (!this.exists()) {
            return false;
        }
        ProjectDescription pd = this.model.getProjectDescription(this);
        if (pd == null) {
            return false;
        }
        return pd.isHasN4JSNature();
    }

    @Override
    public N4JSProjectName getDefinesPackageName() {
        String raw = this.getModel().getDefinesPackage(this);
        if (raw == null) {
            return null;
        }
        return new N4JSProjectName(raw);
    }
}

