/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.postprocessing.TypeProcessor;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.BoundJudgment;
import org.eclipse.n4js.typesystem.ExpectedTypeJudgment;
import org.eclipse.n4js.typesystem.SubstTypeVariablesJudgment;
import org.eclipse.n4js.typesystem.SubtypeJudgment;
import org.eclipse.n4js.typesystem.TypeJudgment;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class N4JSTypeSystem {
    @Inject
    private TypeJudgment typeJudgment;
    @Inject
    private ExpectedTypeJudgment expectedTypeJudgment;
    @Inject
    private SubtypeJudgment subtypeJudgment;
    @Inject
    private BoundJudgment boundJudgment;
    @Inject
    private SubstTypeVariablesJudgment substTypeVariablesJudgment;
    @Inject
    private TypeProcessor typeProcessor;
    @Inject
    private TypeSystemHelper tsh;

    public TypeRef type(RuleEnvironment G, TypableElement element) {
        return this.typeProcessor.getType(G, element);
    }

    public TypeRef use_type_judgment_from_PostProcessors(RuleEnvironment G, TypableElement element) {
        return this.typeJudgment.apply(G, element);
    }

    public TypeRef expectedType(RuleEnvironment G, EObject container, Expression expression) {
        return this.expectedTypeJudgment.apply(G, container, expression);
    }

    public Result subtype(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.subtypeJudgment.apply(G, left, right);
    }

    public boolean subtypeSucceeded(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.subtype(G, left, right).isSuccess();
    }

    public Result supertype(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        if (this.subtype(G, right, left).isSuccess()) {
            return Result.success();
        }
        return Result.failure(String.valueOf(left.getTypeRefAsString()) + " is not a super type of " + right.getTypeRefAsString(), false, null);
    }

    public Result equaltype(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        if (this.subtype(G, left, right).isSuccess() && this.subtype(G, right, left).isSuccess()) {
            return Result.success();
        }
        return Result.failure(String.valueOf(left.getTypeRefAsString()) + " is not equal to " + right.getTypeRefAsString(), false, null);
    }

    public boolean equaltypeSucceeded(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        return this.equaltype(G, left, right).isSuccess();
    }

    public TypeRef upperBound(RuleEnvironment G, TypeArgument typeArgument) {
        return this.boundJudgment.applyUpperBound(G, typeArgument, false, false);
    }

    public TypeRef upperBoundWithReopen(RuleEnvironment G, TypeArgument typeArgument) {
        return this.boundJudgment.applyUpperBound(G, typeArgument, true, false);
    }

    public TypeRef upperBoundWithReopenAndResolve(RuleEnvironment G, TypeArgument typeArgument) {
        return this.boundJudgment.applyUpperBound(G, typeArgument, true, true);
    }

    public TypeRef lowerBound(RuleEnvironment G, TypeArgument typeArgument) {
        return this.boundJudgment.applyLowerBound(G, typeArgument, false, false);
    }

    public TypeRef lowerBoundWithReopen(RuleEnvironment G, TypeArgument typeArgument) {
        return this.boundJudgment.applyLowerBound(G, typeArgument, true, false);
    }

    public TypeRef lowerBoundWithReopenAndResolve(RuleEnvironment G, TypeArgument typeArgument) {
        return this.boundJudgment.applyLowerBound(G, typeArgument, true, true);
    }

    public Wildcard substTypeVariables(RuleEnvironment G, Wildcard wildcard) {
        return (Wildcard)this.substTypeVariables(G, (TypeArgument)wildcard);
    }

    public TypeRef substTypeVariables(RuleEnvironment G, TypeRef typeRef) {
        return (TypeRef)this.substTypeVariables(G, (TypeArgument)typeRef);
    }

    public TypeArgument substTypeVariables(RuleEnvironment G, TypeArgument typeArgument) {
        return this.substTypeVariablesJudgment.apply(G, typeArgument, false, false);
    }

    public TypeRef substTypeVariablesWithFullCapture(RuleEnvironment G, TypeRef typeRef) {
        return (TypeRef)this.substTypeVariablesWithFullCapture(G, (TypeArgument)typeRef);
    }

    public TypeArgument substTypeVariablesWithFullCapture(RuleEnvironment G, TypeArgument typeArgument) {
        return this.substTypeVariablesJudgment.apply(G, typeArgument, true, true);
    }

    public TypeRef substTypeVariablesWithPartialCapture(RuleEnvironment G, TypeRef typeRef) {
        return (TypeRef)this.substTypeVariablesWithPartialCapture(G, (TypeArgument)typeRef);
    }

    public TypeArgument substTypeVariablesWithPartialCapture(RuleEnvironment G, TypeArgument typeArgument) {
        return this.substTypeVariablesJudgment.apply(G, typeArgument, false, true);
    }

    public TypeRef tau(TypableElement element) {
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)element);
        return this.type(G, element);
    }

    public TypeRef tau(TypableElement element, TypeRef context) {
        RuleEnvironment G = this.createRuleEnvironmentForContext(context, element != null ? element.eResource() : null);
        return this.tau(element, G);
    }

    public TypeRef tau(TypableElement element, EObject astNodeForContext) {
        TypeDefiningElement tde = (TypeDefiningElement)EcoreUtil2.getContainerOfType((EObject)astNodeForContext, TypeDefiningElement.class);
        ParameterizedTypeRef context = null;
        if (tde != null) {
            context = TypeUtils.createTypeRef((Type)tde.getDefinedType(), (TypeArgument[])new TypeArgument[0]);
        }
        return this.tau(element, (TypeRef)context);
    }

    public TypeRef tau(TypableElement element, RuleEnvironment G) {
        TypeRef value = this.type(G, element);
        if (value != null) {
            TypeRef substValue = this.substTypeVariables(G, value);
            return substValue;
        }
        return null;
    }

    public RuleEnvironment createRuleEnvironmentForContext(TypeRef context, Resource resource) {
        return this.createRuleEnvironmentForContext(context, context, resource);
    }

    public RuleEnvironment createRuleEnvironmentForContext(TypeRef contextTypeVariableBindings, TypeRef contextThisBinding, Resource resource) {
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(resource);
        if (contextTypeVariableBindings != null) {
            this.tsh.addSubstitutions(G, contextTypeVariableBindings);
        }
        if (contextThisBinding instanceof ParameterizedTypeRef && contextThisBinding.getDeclaredType() instanceof TClassifier) {
            RuleEnvironmentExtensions.addThisType(G, contextThisBinding);
        }
        return G;
    }

    public TypeRef createSimplifiedUnion(List<TypeRef> typeRefs, Resource resource) {
        if (typeRefs.size() > 1 && resource != null) {
            return this.tsh.createUnionType(RuleEnvironmentExtensions.newRuleEnvironment(resource), typeRefs.toArray(new TypeRef[typeRefs.size()]));
        }
        if (typeRefs.size() == 1) {
            return (TypeRef)TypeUtils.copyIfContained((EObject)typeRefs.get(0));
        }
        return null;
    }

    public TypeRef createSimplifiedIntersection(List<TypeRef> typeRefs, Resource resource) {
        if (typeRefs.size() > 1 && resource != null) {
            return this.tsh.createIntersectionType(RuleEnvironmentExtensions.newRuleEnvironment(resource), typeRefs.toArray(new TypeRef[typeRefs.size()]));
        }
        if (typeRefs.size() == 1) {
            return (TypeRef)TypeUtils.copyIfContained((EObject)typeRefs.get(0));
        }
        return null;
    }
}

