/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Singleton;
import java.io.OutputStream;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.io.OutputRedirection;
import org.eclipse.n4js.utils.io.OutputStreamPrinterThread;
import org.eclipse.n4js.utils.io.OutputStreamProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

@Singleton
public class ConsoleOutputStreamProvider
implements OutputStreamProvider {
    private static final String CONSOLE_VIEW_ID = "org.eclipse.ui.console.ConsoleView";
    private static final OutputStreamProvider.Default DEFAULT = new OutputStreamProvider.Default();
    private final Supplier<MessageConsole> consoleSupplier = Suppliers.memoize(() -> new MessageConsole("npm Console", null));

    public OutputStream getOutputStream(OutputStreamPrinterThread.OutputStreamType type, OutputRedirection redirect) {
        boolean silent;
        if (!PlatformUI.isWorkbenchRunning()) {
            return DEFAULT.getOutputStream(type, redirect);
        }
        MessageConsole console = (MessageConsole)this.consoleSupplier.get();
        boolean bl = silent = redirect == OutputRedirection.SUPPRESS;
        if (!silent) {
            console.activate();
        }
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        MessageConsoleStream stream = console.newMessageStream();
        UIUtils.getDisplay().asyncExec(() -> {
            stream.setColor(this.toColor(type));
            this.showConsoleView(silent);
        });
        return stream;
    }

    private void showConsoleView(boolean silent) {
        IWorkbenchWindow window;
        IViewPart view;
        if (PlatformUI.isWorkbenchRunning() && !silent && (view = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage().findView(CONSOLE_VIEW_ID)) != null) {
            view.setFocus();
        }
    }

    private Color toColor(OutputStreamPrinterThread.OutputStreamType type) {
        switch (type) {
            case STD_OUT: {
                return UIUtils.getDisplay().getSystemColor(24);
            }
            case STD_ERR: {
                return UIUtils.getDisplay().getSystemColor(3);
            }
        }
        throw new IllegalArgumentException("Unexpected output stream type.");
    }
}

