/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclarationContainer;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;

public abstract class DestructureUtils {
    public static boolean isObjectOrArrayLiteral(EObject expr) {
        return expr instanceof ObjectLiteral || expr instanceof ArrayLiteral;
    }

    public static boolean isTopOfDestructuringAssignment(EObject eobj) {
        if (eobj instanceof AssignmentExpression) {
            AssignmentExpression ae = (AssignmentExpression)eobj;
            return DestructureUtils.isObjectOrArrayLiteral(ae.getLhs());
        }
        return false;
    }

    public static boolean isTopOfDestructuringVariableBinding(EObject eobj) {
        if (eobj instanceof VariableBinding) {
            VariableBinding vb = (VariableBinding)eobj;
            return vb.getPattern() != null;
        }
        return false;
    }

    public static boolean isTopOfDestructuringForStatement(EObject eobj) {
        if (eobj instanceof ForStatement) {
            ForStatement fs = (ForStatement)eobj;
            boolean isDestructuringForStatement = false;
            isDestructuringForStatement = fs.isForIn() || fs.isForOf();
            return isDestructuringForStatement &= DestructureUtils.containsDestructuringPattern(fs) || DestructureUtils.isObjectOrArrayLiteral(fs.getInitExpr());
        }
        return false;
    }

    public static boolean isTopOfDestructuring(EObject eobj) {
        boolean isParentOfDestructuring = false;
        isParentOfDestructuring |= DestructureUtils.isTopOfDestructuringAssignment(eobj);
        isParentOfDestructuring |= DestructureUtils.isTopOfDestructuringVariableBinding(eobj);
        return isParentOfDestructuring |= DestructureUtils.isTopOfDestructuringForStatement(eobj);
    }

    public static EObject getTop(EObject eobj) {
        if (DestructureUtils.isTopOfDestructuring(eobj)) {
            return eobj;
        }
        EObject root = DestructureUtils.getRoot(eobj);
        if (root == null) {
            return null;
        }
        EObject parent = root.eContainer();
        EObject parent2 = parent.eContainer();
        if (parent2 instanceof ForStatement) {
            return parent2;
        }
        if (parent instanceof VariableBinding) {
            return parent;
        }
        if (parent instanceof AssignmentExpression) {
            return parent;
        }
        if (parent instanceof ForStatement) {
            return parent;
        }
        return null;
    }

    public static EObject getRepresentingElement(EObject eobj) {
        EObject currEO = eobj;
        int i = 0;
        while (currEO != null) {
            if (DestructureUtils.isRepresentingElement(currEO = currEO.eContainer())) break;
            if (i++ <= 2) continue;
            currEO = null;
            break;
        }
        if (currEO != null) {
            EObject parent = currEO.eContainer();
            if (currEO instanceof BindingElement && parent instanceof BindingProperty) {
                currEO = parent;
            }
        }
        return currEO;
    }

    public static DestructNode getCorrespondingDestructNode(EObject eobj) {
        EObject representing = DestructureUtils.getRepresentingElement(eobj);
        if (representing == null) {
            return null;
        }
        EObject top = DestructureUtils.getTop(eobj);
        if (top == null) {
            return null;
        }
        DestructNode dNode = DestructNode.unify(top);
        if (dNode == null) {
            return null;
        }
        dNode = dNode.findNodeForElement(representing);
        return dNode;
    }

    public static boolean containsDestructuringPattern(VariableDeclarationContainer vdeclContainer) {
        for (VariableDeclarationOrBinding vdeclOrBinding : vdeclContainer.getVarDeclsOrBindings()) {
            if (!(vdeclOrBinding instanceof VariableBinding)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArrayOrObjectLiteralUsedAsDestructuringPattern(EObject obj) {
        if (!DestructureUtils.isObjectOrArrayLiteral(obj)) {
            return false;
        }
        EObject root = DestructureUtils.getRoot(obj);
        EObject parent = root.eContainer();
        if (parent instanceof AssignmentExpression) {
            return ((AssignmentExpression)parent).getLhs() == root;
        }
        if (parent instanceof ForStatement) {
            return !((ForStatement)parent).isForPlain() && ((ForStatement)parent).getInitExpr() == root;
        }
        return false;
    }

    public static boolean isArrayOrObjectLiteralBeingDestructured(EObject obj) {
        if (!(obj instanceof ArrayLiteral) && !(obj instanceof ObjectLiteral)) {
            return false;
        }
        EObject root = DestructureUtils.getRoot(obj);
        EObject parent = root.eContainer();
        if (parent instanceof VariableBinding) {
            return ((VariableBinding)parent).getExpression() == root;
        }
        if (parent instanceof AssignmentExpression && DestructureUtils.isTopOfDestructuringAssignment(parent)) {
            return ((AssignmentExpression)parent).getRhs() == root;
        }
        if (parent instanceof ForStatement && DestructureUtils.isTopOfDestructuringForStatement(parent)) {
            return !((ForStatement)parent).isForPlain() && ((ForStatement)parent).getExpression() == root && obj != root;
        }
        return false;
    }

    public static boolean isRoot(EObject nodeWithinDestructuringPattern) {
        return !DestructureUtils.isParentPartOfSameDestructuringPattern(nodeWithinDestructuringPattern);
    }

    public static EObject getRoot(EObject nodeWithinDestructuringPattern) {
        EObject curr = nodeWithinDestructuringPattern;
        while (DestructureUtils.isParentPartOfSameDestructuringPattern(curr)) {
            curr = curr.eContainer();
        }
        if (curr instanceof ObjectLiteral || curr instanceof ArrayLiteral || curr instanceof BindingPattern) {
            return curr;
        }
        return null;
    }

    public static boolean isInDestructuringPattern(EObject obj) {
        return DestructureUtils.isParentPartOfSameDestructuringPattern(obj);
    }

    public static boolean isRepresentingElement(EObject eobj) {
        boolean isRepresentingElement = false;
        isRepresentingElement |= eobj instanceof ArrayElement;
        isRepresentingElement |= eobj instanceof VariableBinding;
        isRepresentingElement |= eobj instanceof BindingElement;
        isRepresentingElement |= eobj instanceof BindingPattern;
        isRepresentingElement |= eobj instanceof BindingProperty;
        return isRepresentingElement |= eobj instanceof PropertyAssignment;
    }

    public static boolean isPatternElement(EObject eobj) {
        boolean isDestrElem = false;
        isDestrElem = isDestrElem || eobj instanceof ArrayElement;
        isDestrElem = isDestrElem || eobj instanceof ArrayLiteral;
        isDestrElem = isDestrElem || eobj instanceof ObjectLiteral;
        isDestrElem = isDestrElem || eobj instanceof BindingElement;
        isDestrElem = isDestrElem || eobj instanceof BindingPattern;
        isDestrElem = isDestrElem || eobj instanceof BindingProperty;
        isDestrElem = isDestrElem || eobj instanceof PropertyAssignment;
        return isDestrElem;
    }

    private static boolean isParentPartOfSameDestructuringPattern(EObject obj) {
        AssignmentExpression ae;
        EObject parent;
        EObject eObject = parent = obj != null ? obj.eContainer() : null;
        if (DestructureUtils.isPatternElement(parent)) {
            return true;
        }
        if (parent instanceof AssignmentExpression && obj == (ae = (AssignmentExpression)parent).getLhs()) {
            EObject parentParent = parent.eContainer();
            return parentParent instanceof ArrayElement || parentParent instanceof PropertyAssignment;
        }
        return false;
    }
}

