/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.internal.FileBasedExternalPackageManager;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.MultiCleartriggerCache;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.internal.N4JSProjectSourceContainer;
import org.eclipse.n4js.internal.TypeDefinitionsAwareDependenciesSupplier;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class N4JSModel<Loc extends SafeURI<Loc>> {
    private final InternalN4JSWorkspace<Loc> workspace;
    @Inject
    protected ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    protected FileBasedExternalPackageManager packageManager;
    @Inject
    private MultiCleartriggerCache cache;

    @Inject
    public N4JSModel(InternalN4JSWorkspace<Loc> workspace) {
        this.workspace = workspace;
    }

    public N4JSProject getN4JSProject(URI location) {
        Preconditions.checkArgument((boolean)location.isFile(), (Object)("Expecting file URI. Was: " + location));
        boolean external = this.isExternal(location);
        if (external) {
            return this.getN4JSProject(this.externalLibraryWorkspace.fromURI(location), external);
        }
        return this.getN4JSProject((SafeURI<?>)this.workspace.fromURI(location), external);
    }

    public SafeURI<?> toProjectLocation(URI location) {
        boolean external = this.isExternal(location);
        if (external) {
            return this.externalLibraryWorkspace.fromURI(location);
        }
        return this.workspace.fromURI(location);
    }

    public N4JSProject getN4JSProject(SafeURI<?> location) {
        return this.getN4JSProject(location, this.isExternal(location.toURI()));
    }

    protected boolean isExternal(URI location) {
        if (this.externalLibraryWorkspace != null && location.isFile()) {
            return this.externalLibraryWorkspace.getProject(new FileURI(location)) != null;
        }
        return false;
    }

    protected N4JSProject getN4JSProject(SafeURI<?> location, boolean external) {
        return new N4JSProject(location, external, this);
    }

    public Set<? extends IN4JSProject> getAllProjects() {
        LinkedHashSet<N4JSProject> prjConfs = new LinkedHashSet<N4JSProject>();
        for (SafeURI prjLoc : this.workspace.getAllProjectLocations()) {
            prjConfs.add(this.getN4JSProject(prjLoc, false));
        }
        return prjConfs;
    }

    public IN4JSProject findProject(N4JSProjectName name) {
        Loc loc = this.workspace.getProjectLocation(name);
        if (loc != null) {
            return this.getN4JSProject((SafeURI<?>)loc, false);
        }
        return null;
    }

    public IN4JSProject findProjectWith(URI nestedLocation) {
        Loc location = this.fromURI(this.workspace, nestedLocation);
        if (location != null) {
            return this.getN4JSProject((SafeURI<?>)location, false);
        }
        FileURI externalLocation = this.fromURI(this.externalLibraryWorkspace, nestedLocation);
        if (externalLocation != null) {
            return this.getN4JSProject(externalLocation, true);
        }
        return null;
    }

    protected <PL extends SafeURI<PL>> PL fromURI(InternalN4JSWorkspace<PL> ws, URI uri) {
        PL safeURI = ws.fromURI(uri);
        if (safeURI == null) {
            return null;
        }
        return ws.findProjectWith(safeURI);
    }

    public Optional<? extends IN4JSSourceContainer> findN4JSSourceContainer(URI nestedLocation) {
        Optional<IN4JSSourceContainer> foundN4JSSourceContainer = Optional.absent();
        IN4JSProject project = this.findProjectWith(nestedLocation);
        foundN4JSSourceContainer = this.findN4JSSourceContainerInProject(project, nestedLocation);
        return foundN4JSSourceContainer;
    }

    protected Optional<? extends IN4JSSourceContainer> findN4JSSourceContainerInProject(IN4JSProject project, URI nestedLocation) {
        IN4JSSourceContainer matchingContainer = null;
        int matchingSegmentCount = -1;
        if (project != null) {
            for (IN4JSSourceContainer n4jsSourceContainer : project.getSourceContainers()) {
                int segmentCount;
                if (!this.isLocationInNestedInContainer(nestedLocation, n4jsSourceContainer) || (segmentCount = n4jsSourceContainer.getLocation().toURI().segmentCount()) <= matchingSegmentCount) continue;
                matchingContainer = n4jsSourceContainer;
                matchingSegmentCount = segmentCount;
            }
        }
        return Optional.fromNullable(matchingContainer);
    }

    private boolean isLocationInNestedInContainer(URI nestedLocation, IN4JSSourceContainer container) {
        URI containerLocation = container.getLocation().toURI();
        if (containerLocation == null || nestedLocation == null) {
            return false;
        }
        int maxSegments = containerLocation.segmentCount();
        if (nestedLocation.segmentCount() >= maxSegments) {
            int i = 0;
            while (i < maxSegments) {
                if (!nestedLocation.segment(i).equals(containerLocation.segment(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected InternalN4JSWorkspace<Loc> getInternalWorkspace() {
        return this.workspace;
    }

    public ProjectDescription getProjectDescription(SafeURI<?> location) {
        ProjectDescription result;
        if (location instanceof FileURI && (result = this.externalLibraryWorkspace.getProjectDescription((FileURI)location)) != null) {
            return result;
        }
        SafeURI<?> casted = location;
        return this.workspace.getProjectDescription(casted);
    }

    public ProjectDescription getProjectDescription(IN4JSProject project) {
        SafeURI<?> location = project.getLocation();
        if (!(location instanceof FileURI)) {
            throw new IllegalArgumentException("Unexpected location of external project " + project.getProjectName() + " at " + location);
        }
        if (project.isExternal()) {
            ProjectDescription potentialResult;
            Loc specificLocation = this.workspace.fromURI(location.toURI());
            if (specificLocation != null && (potentialResult = this.workspace.getProjectDescription(specificLocation)) != null) {
                return potentialResult;
            }
            return this.externalLibraryWorkspace.getProjectDescription((FileURI)location);
        }
        SafeURI<?> casted = location;
        return this.workspace.getProjectDescription(casted);
    }

    public ImmutableList<? extends IN4JSSourceContainer> getN4JSSourceContainers(N4JSProject project) {
        ImmutableList.Builder result = ImmutableList.builder();
        ProjectDescription description = this.getProjectDescription(project);
        if (description != null) {
            ArrayList sourceFragments = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)description.getSourceContainers()));
            sourceFragments.sort((f1, fDIRECT_RESOURCE_IN_PROJECT_SEGMENTCOUNT) -> ProjectDescriptionUtils.compareBySourceContainerType(f1, fDIRECT_RESOURCE_IN_PROJECT_SEGMENTCOUNT));
            for (SourceContainerDescription sourceFragment : sourceFragments) {
                List<String> paths = ProjectDescriptionUtils.getPathsNormalized(sourceFragment);
                for (String path : paths) {
                    String relativeLocation = ".".equals(path) ? "" : path;
                    IN4JSSourceContainer sourceContainer = this.createProjectN4JSSourceContainer(project, sourceFragment.getSourceContainerType(), relativeLocation);
                    result.add((Object)sourceContainer);
                }
            }
        }
        return result.build();
    }

    protected IN4JSSourceContainer createProjectN4JSSourceContainer(N4JSProject project, SourceContainerType type, String relativeLocation) {
        return new N4JSProjectSourceContainer(project, type, relativeLocation);
    }

    public void invalidateProject(SafeURI<?> location) {
        this.workspace.invalidateProject(location);
    }

    public ImmutableList<? extends IN4JSProject> getDependencies(N4JSProject project, boolean includeAbsentProjects) {
        return this.getDependencies(project, false, includeAbsentProjects);
    }

    public ImmutableList<? extends IN4JSProject> getDependenciesAndImplementedApis(N4JSProject project, boolean includeAbsentProjects) {
        return this.getDependencies(project, true, includeAbsentProjects);
    }

    private ImmutableList<? extends IN4JSProject> getDependencies(N4JSProject project, boolean includeApis, boolean includeAbsentProjects) {
        ImmutableList.Builder result = ImmutableList.builder();
        ProjectDescription description = this.getProjectDescription(project);
        if (description != null) {
            result.addAll(this.resolveProjectReferences(project, (Iterable<ProjectReference>)description.getProjectDependencies(), includeAbsentProjects));
            if (includeApis) {
                result.addAll(this.resolveProjectReferences(project, (Iterable<ProjectReference>)description.getImplementedProjects(), includeAbsentProjects));
            }
        }
        return result.build();
    }

    public Optional<IN4JSProject> getExtendedRuntimeEnvironment(N4JSProject project) {
        ProjectDescription description = this.getProjectDescription(project);
        if (description == null) {
            return Optional.absent();
        }
        ProjectReference ref = description.getExtendedRuntimeEnvironment();
        return this.resolveProjectReference(project, ref, false);
    }

    public ImmutableList<? extends IN4JSProject> getImplementedProjects(N4JSProject project) {
        ImmutableList.Builder result = ImmutableList.builder();
        ProjectDescription description = this.getProjectDescription(project);
        if (description != null) {
            result.addAll(this.resolveProjectReferences(project, (Iterable<ProjectReference>)description.getImplementedProjects(), false));
        }
        return result.build();
    }

    public ImmutableList<? extends IN4JSProject> getProvidedRuntimeLibraries(N4JSProject project) {
        ImmutableList.Builder providedRuntimes = ImmutableList.builder();
        EList<ProjectReference> runtimeLibraries = this.getAllProvidedRuntimeLibraries(project);
        for (ProjectReference runtimeLibrary : runtimeLibraries) {
            Loc location = this.workspace.getLocation(runtimeLibrary);
            if (location != null) {
                providedRuntimes.add((Object)this.getN4JSProject((SafeURI<?>)location, false));
                continue;
            }
            Object external = this.externalLibraryWorkspace.getLocation(runtimeLibrary);
            if (external == null) continue;
            providedRuntimes.add((Object)this.getN4JSProject((SafeURI<?>)external, true));
        }
        return providedRuntimes.build();
    }

    private EList<ProjectReference> getAllProvidedRuntimeLibraries(N4JSProject project) {
        ProjectDescription description = this.getProjectDescription(project);
        if (description == null) {
            return ECollections.emptyEList();
        }
        EList runtimeLibraries = description.getProvidedRuntimeLibraries();
        if (runtimeLibraries == null) {
            return ECollections.emptyEList();
        }
        return runtimeLibraries;
    }

    public SafeURI<?> findArtifact(IN4JSSourceContainer sourceContainer, QualifiedName name, Optional<String> fileExtension) {
        String ext = ((String)fileExtension.or((Object)"")).trim();
        String extWithDot = !ext.isEmpty() && !ext.startsWith(".") ? "." + ext : ext;
        String pathStr = String.valueOf(name.toString("/")) + extWithDot;
        Object artifactLocation = this.findArtifactInFolder(this.workspace, sourceContainer.getLocation().toURI(), pathStr);
        if (artifactLocation == null) {
            artifactLocation = this.findArtifactInFolder(this.externalLibraryWorkspace, sourceContainer.getLocation().toURI(), pathStr);
        }
        return artifactLocation;
    }

    private <PL extends SafeURI<PL>> PL findArtifactInFolder(InternalN4JSWorkspace<PL> ws, URI location, String pathStr) {
        PL safeURI = ws.fromURI(location);
        if (safeURI == null) {
            return null;
        }
        return ws.findArtifactInFolder(safeURI, pathStr);
    }

    public Optional<String> getExtendedRuntimeEnvironmentName(N4JSProject project) {
        ProjectDescription description = this.getProjectDescription(project);
        if (description == null) {
            return Optional.absent();
        }
        ProjectReference reRef = description.getExtendedRuntimeEnvironment();
        if (reRef == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)reRef.getProjectName());
    }

    public Collection<IN4JSProject> getTestedProjects(N4JSProject project) {
        if (project == null || !project.exists()) {
            return Collections.emptyList();
        }
        if (!ProjectType.TEST.equals((Object)project.getProjectType())) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        ProjectDescription description = this.getProjectDescription(project);
        if (description != null) {
            for (ProjectReference testedProject : description.getTestedProjects()) {
                Loc hostLocation = this.workspace.getLocation(testedProject);
                N4JSProject tested = null;
                if (hostLocation != null) {
                    tested = this.getN4JSProject((SafeURI<?>)hostLocation, false);
                } else {
                    hostLocation = this.externalLibraryWorkspace.getLocation(testedProject);
                    if (hostLocation != null) {
                        tested = this.getN4JSProject((SafeURI<?>)hostLocation, true);
                    }
                }
                if (tested == null || !tested.exists()) continue;
                builder.add((Object)tested);
            }
        }
        return builder.build();
    }

    public Optional<IN4JSProject> resolveProjectReference(IN4JSProject project, ProjectReference reference, boolean includeAbsentProjects) {
        if (project == null || reference == null) {
            return Optional.absent();
        }
        Loc dependencyLocation = this.workspace.getLocation(reference);
        if (dependencyLocation != null) {
            return Optional.fromNullable((Object)this.getN4JSProject((SafeURI<?>)dependencyLocation));
        }
        dependencyLocation = this.externalLibraryWorkspace.getLocation(reference);
        if (dependencyLocation != null) {
            return Optional.fromNullable((Object)this.getN4JSProject((SafeURI<?>)dependencyLocation));
        }
        if (includeAbsentProjects) {
            return Optional.fromNullable((Object)this.newAbsentProject(reference.getProjectName()));
        }
        return Optional.absent();
    }

    protected IN4JSProject newAbsentProject(String projectName) {
        URI absent = URI.createFileURI((String)projectName);
        return this.getN4JSProject((SafeURI<?>)this.workspace.fromURI(absent), false);
    }

    public Collection<IN4JSProject> resolveProjectReferences(IN4JSProject project, Iterable<? extends ProjectReference> references, boolean includeAbsentProjects) {
        if (project == null || references == null || Iterables.isEmpty(references)) {
            return Collections.emptyList();
        }
        LinkedList<IN4JSProject> resolvedReferences = new LinkedList<IN4JSProject>();
        for (ProjectReference projectReference : references) {
            IN4JSProject projectReference2 = (IN4JSProject)this.resolveProjectReference(project, projectReference, includeAbsentProjects).orNull();
            if (projectReference2 == null) continue;
            resolvedReferences.add(projectReference2);
        }
        return resolvedReferences;
    }

    public String getDefinesPackage(IN4JSProject project) {
        if (project == null) {
            return null;
        }
        ProjectDescription projectDescription = this.getProjectDescription(project);
        if (projectDescription != null) {
            return projectDescription.getDefinesPackage();
        }
        return null;
    }

    public Iterable<IN4JSProject> getSortedDependencies(IN4JSProject project) {
        SortedDependenciesProvider sdProvider = new SortedDependenciesProvider(project);
        Iterable<IN4JSProject> existing = this.cache.get(sdProvider, "SORTED_DEPENDENCIES", project.getLocation().toURI());
        return existing;
    }

    private class SortedDependenciesProvider
    implements MultiCleartriggerCache.CleartriggerSupplier<Iterable<IN4JSProject>> {
        final IN4JSProject project;
        private Iterable<IN4JSProject> sortedDeps;

        SortedDependenciesProvider(IN4JSProject project) {
            this.project = project;
        }

        @Override
        public Iterable<IN4JSProject> get() {
            this.computeIfNull();
            return this.sortedDeps;
        }

        private void computeIfNull() {
            if (this.sortedDeps != null) {
                return;
            }
            this.sortedDeps = TypeDefinitionsAwareDependenciesSupplier.get(this.project);
        }

        @Override
        public Collection<URI> getCleartriggers() {
            this.computeIfNull();
            HashSet<URI> triggerURIs = new HashSet<URI>();
            for (IN4JSProject dep : this.sortedDeps) {
                if (dep.getDefinesPackageName() == null) continue;
                URI uri = dep.getLocation().toURI();
                triggerURIs.add(uri);
            }
            return triggerURIs;
        }
    }
}

