/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.scoping.members.MemberScopingHelper;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class DestructureHelper {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private MemberScopingHelper memberScopingHelper;

    public TypeRef getTypeOfVariableDeclarationInDestructuringPattern(RuleEnvironment G, VariableDeclaration vdecl) {
        boolean _tripleNotEquals;
        TypeRef _declaredTypeRef = vdecl.getDeclaredTypeRef();
        boolean bl = _tripleNotEquals = _declaredTypeRef != null;
        if (_tripleNotEquals) {
            return null;
        }
        EObject root = DestructureUtils.getRoot((EObject)vdecl.eContainer());
        if (root == null) {
            return null;
        }
        EObject rootParent = root.eContainer();
        if (rootParent instanceof VariableBinding) {
            EObject rootParent2 = ((VariableBinding)rootParent).eContainer();
            boolean isLocatedUnderForInOf = rootParent2 instanceof ForStatement && DestructureUtils.isTopOfDestructuringForStatement((EObject)rootParent2);
            DestructNode _xifexpression = null;
            _xifexpression = isLocatedUnderForInOf ? DestructNode.unify((ForStatement)((ForStatement)rootParent2)) : DestructNode.unify((VariableBinding)((VariableBinding)rootParent));
            DestructNode rootNode = _xifexpression;
            if (rootNode != null) {
                HashMap valueTypePerNode = CollectionLiterals.newHashMap();
                this.buildValueTypesMap(G, rootNode, valueTypePerNode, (EObject)((VariableBinding)rootParent).getPattern());
                Predicate<DestructNode> _function = it -> {
                    VariableDeclaration _variableDeclaration = it.getVariableDeclaration();
                    return _variableDeclaration == vdecl;
                };
                DestructNode node = rootNode.stream().filter(_function).findFirst().orElse(null);
                return (TypeRef)valueTypePerNode.get(node);
            }
        }
        return null;
    }

    public void buildValueTypesMap(RuleEnvironment G, DestructNode rootNode, Map<DestructNode, TypeRef> addHere, EObject contextObj) {
        boolean _tripleEquals;
        Expression _defaultExpr = null;
        if (rootNode != null) {
            _defaultExpr = rootNode.getDefaultExpr();
        }
        boolean bl = _tripleEquals = _defaultExpr == null;
        if (_tripleEquals) {
            return;
        }
        TypeRef valueTypeRef = this.ts.type(G, (TypableElement)rootNode.getDefaultExpr());
        valueTypeRef = this.ts.upperBoundWithReopenAndResolve(G, (TypeArgument)valueTypeRef);
        EObject _eContainer = rootNode.getDefaultExpr().eContainer();
        if (_eContainer instanceof ForStatement) {
            valueTypeRef = this.tsh.extractIterableElementTypeUB(G, valueTypeRef);
        }
        if (valueTypeRef != null) {
            addHere.put(rootNode, valueTypeRef);
            DestructNode[] nestedNodes = rootNode.getNestedNodes();
            if (nestedNodes != null && !((List)Conversions.doWrapArray((Object)nestedNodes)).isEmpty()) {
                this.buildValueTypesMap(G, nestedNodes, valueTypeRef, addHere, contextObj);
            }
        }
    }

    private void buildValueTypesMap(RuleEnvironment G, DestructNode[] nodes, TypeRef valueTypeRef, Map<DestructNode, TypeRef> addHere, EObject contextObj) {
        block4: {
            block3: {
                boolean _not;
                boolean _arePositional = DestructNode.arePositional((DestructNode[])nodes);
                if (!_arePositional) break block3;
                List elementTypeRefs = IterableExtensions.toList(this.tsh.extractIterableElementTypesUBs(G, valueTypeRef));
                boolean _isEmpty = elementTypeRefs.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (!_not) break block4;
                int _size = elementTypeRefs.size();
                int maxIdx = _size - 1;
                int idx = 0;
                while (idx < ((List)Conversions.doWrapArray((Object)nodes)).size()) {
                    DestructNode currNode = nodes[idx];
                    TypeRef currValueTypeRef = (TypeRef)elementTypeRefs.get(Math.min(idx, maxIdx));
                    this.addTypeAndContinueWithChildren(G, currNode, currValueTypeRef, addHere, contextObj);
                    ++idx;
                }
                break block4;
            }
            IScope memberScope = this.createMemberScopeForPropertyAccess(valueTypeRef, contextObj, false);
            DestructNode[] destructNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                DestructNode currNode = destructNodeArray[n2];
                TypeRef currValueTypeRef = this.getPropertyTypeForNode(G, valueTypeRef, memberScope, currNode.getPropName(), null);
                if (currValueTypeRef != null) {
                    this.addTypeAndContinueWithChildren(G, currNode, currValueTypeRef, addHere, contextObj);
                }
                ++n2;
            }
        }
    }

    public IScope createMemberScopeForPropertyAccess(TypeRef receiverTypeRef, EObject contextObj, boolean checkVisibility) {
        TypingStrategy _typingStrategy = receiverTypeRef.getTypingStrategy();
        boolean structFieldInitMode = _typingStrategy == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
        return this.memberScopingHelper.createMemberScopeAllowingNonContainedMembers(receiverTypeRef, contextObj, checkVisibility, false, structFieldInitMode);
    }

    public TypeRef getPropertyTypeForNode(RuleEnvironment G, TypeRef parentValueTypeRef, IScope parentMemberScope, String propName, StringBuffer errorMessage) {
        EObject m;
        if (parentValueTypeRef == null || parentMemberScope == null) {
            return null;
        }
        IEObjectDescription mDesc = parentMemberScope.getSingleElement(QualifiedName.create((String)propName));
        if (mDesc instanceof AbstractDescriptionWithError && errorMessage != null) {
            errorMessage.append(((AbstractDescriptionWithError)mDesc).getMessage());
        }
        EObject _eObjectOrProxy = null;
        if (mDesc != null) {
            _eObjectOrProxy = mDesc.getEObjectOrProxy();
        }
        if ((m = _eObjectOrProxy) != null && !m.eIsProxy()) {
            TypeRef result;
            TypeRef _switchResult = null;
            boolean _matched = false;
            if (m instanceof TField) {
                _matched = true;
                _switchResult = ((TField)m).getTypeRef();
            }
            if (!_matched && m instanceof TGetter) {
                _matched = true;
                _switchResult = ((TGetter)m).getDeclaredTypeRef();
            }
            if ((result = _switchResult) != null) {
                RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
                this.tsh.addSubstitutions(G2, parentValueTypeRef);
                TypeRef resultSubst = this.ts.substTypeVariables(G2, result);
                TypeRef _xifexpression = null;
                if (resultSubst != null) {
                    _xifexpression = this.ts.upperBound(G2, (TypeArgument)resultSubst);
                }
                TypeRef resultSubstUB = _xifexpression;
                return resultSubstUB;
            }
        }
        return null;
    }

    private void addTypeAndContinueWithChildren(RuleEnvironment G, DestructNode currNode, TypeRef valueTypeRef, Map<DestructNode, TypeRef> addHere, EObject contextObj) {
        Object _xifexpression = null;
        boolean _isRest = currNode.isRest();
        _xifexpression = _isRest ? RuleEnvironmentExtensions.arrayTypeRef(G, new TypeArgument[]{valueTypeRef}) : valueTypeRef;
        TypeRef actualValueTypeRef = _xifexpression;
        TypeRef currTypeRef = this.mergeWithTypeOfDefaultExpression(G, actualValueTypeRef, currNode);
        if (currTypeRef != null) {
            addHere.put(currNode, currTypeRef);
            if (currNode.getNestedNodes() != null && !((List)Conversions.doWrapArray((Object)currNode.getNestedNodes())).isEmpty()) {
                this.buildValueTypesMap(G, currNode.getNestedNodes(), currTypeRef, addHere, contextObj);
            }
        }
    }

    private TypeRef mergeWithTypeOfDefaultExpression(RuleEnvironment G, TypeRef valueTypeRef, DestructNode node) {
        boolean _tripleNotEquals;
        TypeRef _xifexpression = null;
        Expression _defaultExpr = node.getDefaultExpr();
        boolean bl = _tripleNotEquals = _defaultExpr != null;
        if (_tripleNotEquals) {
            _xifexpression = this.ts.type(G, (TypableElement)node.getDefaultExpr());
        }
        TypeRef exprTypeRefRaw = _xifexpression;
        boolean _xifexpression_1 = false;
        if (exprTypeRefRaw != null) {
            _xifexpression_1 = this.ts.subtypeSucceeded(G, (TypeArgument)exprTypeRefRaw, (TypeArgument)RuleEnvironmentExtensions.undefinedTypeRef(G)) || this.ts.subtypeSucceeded(G, (TypeArgument)exprTypeRefRaw, (TypeArgument)RuleEnvironmentExtensions.nullTypeRef(G));
        }
        boolean isNullOrUndef = _xifexpression_1;
        TypeRef _xifexpression_2 = null;
        if (exprTypeRefRaw != null && !isNullOrUndef) {
            _xifexpression_2 = this.ts.upperBound(G, (TypeArgument)exprTypeRefRaw);
        }
        TypeRef exprTypeRef = _xifexpression_2;
        if (valueTypeRef != null && exprTypeRef != null) {
            TypeRef _xifexpression_3 = null;
            boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)valueTypeRef, (TypeArgument)exprTypeRef);
            if (_subtypeSucceeded) {
                _xifexpression_3 = exprTypeRef;
            } else {
                TypeRef _xifexpression_4 = null;
                boolean _subtypeSucceeded_1 = this.ts.subtypeSucceeded(G, (TypeArgument)exprTypeRef, (TypeArgument)valueTypeRef);
                _xifexpression_4 = _subtypeSucceeded_1 ? valueTypeRef : this.tsh.createUnionType(G, valueTypeRef, exprTypeRef);
                _xifexpression_3 = _xifexpression_4;
            }
            return _xifexpression_3;
        }
        if (valueTypeRef != null) {
            return valueTypeRef;
        }
        if (exprTypeRef != null) {
            return exprTypeRef;
        }
        return null;
    }

    public TypeRef calculateExpectedType(Expression rootPoly, RuleEnvironment G, InferenceContext infCtx) {
        DestructNode _xifexpression = null;
        EObject _eContainer = rootPoly.eContainer();
        if (_eContainer instanceof VariableBinding) {
            EObject _eContainer_1 = rootPoly.eContainer();
            _xifexpression = DestructNode.unify((VariableBinding)((VariableBinding)_eContainer_1));
        } else {
            DestructNode _xifexpression_1 = null;
            EObject _eContainer_2 = rootPoly.eContainer();
            if (_eContainer_2 instanceof AssignmentExpression) {
                EObject _eContainer_3 = rootPoly.eContainer();
                _xifexpression_1 = DestructNode.unify((AssignmentExpression)((AssignmentExpression)_eContainer_3));
            } else {
                DestructNode _xifexpression_2 = null;
                EObject _eContainer_4 = rootPoly.eContainer();
                if (_eContainer_4 instanceof ForStatement) {
                    EObject _eContainer_5 = rootPoly.eContainer();
                    _xifexpression_2 = DestructNode.unify((ForStatement)((ForStatement)_eContainer_5));
                } else {
                    _xifexpression_2 = null;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        DestructNode rootDestructNode = _xifexpression;
        if (rootDestructNode == null) {
            return null;
        }
        return this.calculateExpectedType(rootDestructNode, G, infCtx);
    }

    private TypeRef calculateExpectedType(DestructNode destructNode, RuleEnvironment G, InferenceContext infCtx) {
        boolean _greaterThan;
        DestructNode[] _nestedNodes;
        ArrayList<Object> elementTypes = new ArrayList<Object>();
        ArrayList<TStructField> elementMembers = new ArrayList<TStructField>();
        int elemCount = ((List)Conversions.doWrapArray((Object)destructNode.getNestedNodes())).size();
        DestructNode[] destructNodeArray = _nestedNodes = destructNode.getNestedNodes();
        int n = _nestedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _tripleNotEquals;
            DestructNode nestedNode = destructNodeArray[n2];
            TypeRef _xifexpression = null;
            _xifexpression = nestedNode.getNestedNodes() != null && ((List)Conversions.doWrapArray((Object)nestedNode.getNestedNodes())).size() > 0 ? this.calculateExpectedType(nestedNode, G, infCtx) : this.createTypeFromLeafDestructNode(nestedNode, G);
            TypeRef elemExpectedType = _xifexpression;
            String _propName = nestedNode.getPropName();
            boolean bl = _tripleNotEquals = _propName != null;
            if (_tripleNotEquals) {
                TStructField field = TypesFactory.eINSTANCE.createTStructField();
                field.setName(nestedNode.getPropName());
                TypeRef _xifexpression_1 = null;
                if (elemExpectedType != null) {
                    _xifexpression_1 = elemExpectedType;
                } else {
                    ParameterizedTypeRef _xblockexpression = null;
                    InferenceVariable iv = infCtx.newInferenceVariable();
                    _xblockexpression = TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]);
                    _xifexpression_1 = _xblockexpression;
                }
                field.setTypeRef(_xifexpression_1);
                elementMembers.add(field);
            } else if (elemExpectedType != null) {
                elementTypes.add(elemExpectedType);
            } else {
                elementTypes.add(TypeRefsFactory.eINSTANCE.createWildcard());
            }
            ++n2;
        }
        ParameterizedTypeRefStructural _xifexpression = null;
        int _size = elementMembers.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _greaterThan_1;
            ParameterizedTypeRefStructural _xblockexpression = null;
            int _size_1 = elementTypes.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                throw new IllegalStateException("elementTypes and elementMembers can not both contain elements at the same time.");
            }
            _xifexpression = _xblockexpression = TypeUtils.createParameterizedTypeRefStructural((Type)RuleEnvironmentExtensions.objectType(G), (TypingStrategy)TypingStrategy.STRUCTURAL, (TStructMember[])((TStructMember[])Conversions.unwrapArray(elementMembers, TStructMember.class)));
        } else {
            boolean _greaterThan_1;
            ParameterizedTypeRefStructural _xifexpression_1 = null;
            int _size_1 = elementTypes.size();
            boolean bl3 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                ParameterizedTypeRef _xifexpression_2 = null;
                if (elemCount == 1) {
                    _xifexpression_2 = RuleEnvironmentExtensions.arrayTypeRef(G, (TypeArgument)elementTypes.get(0));
                } else {
                    ParameterizedTypeRef _xifexpression_3 = null;
                    _xifexpression_3 = elemCount > 1 ? RuleEnvironmentExtensions.iterableNTypeRef(G, elemCount, (TypeArgument[])Conversions.unwrapArray(elementTypes, TypeArgument.class)) : null;
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                _xifexpression_1 = null;
            }
            _xifexpression = _xifexpression_1;
        }
        ParameterizedTypeRefStructural retTypeRef = _xifexpression;
        if (retTypeRef != null && destructNode.getAstElement().eContainer() instanceof ForStatement) {
            retTypeRef = RuleEnvironmentExtensions.iterableTypeRef(G, new TypeArgument[]{retTypeRef});
        }
        return retTypeRef;
    }

    private TypeRef createTypeFromLeafDestructNode(DestructNode leafNode, RuleEnvironment G) {
        VariableDeclaration varDecl = leafNode.getVarDecl();
        IdentifierRef varRef = leafNode.getVarRef();
        if (varDecl != null) {
            TypeRef declaredTypeRef = varDecl.getDeclaredTypeRef();
            if (declaredTypeRef != null) {
                return declaredTypeRef;
            }
        } else if (varRef != null && varRef.getId() instanceof VariableDeclaration && ((VariableDeclaration)varRef.getId()).getDeclaredTypeRef() != null) {
            IdentifiableElement _id = varRef.getId();
            return ((VariableDeclaration)_id).getDeclaredTypeRef();
        }
        return null;
    }
}

