/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.io.FileUtils;

public class ProjectDescriptionUtils {
    public static final String NPM_SCOPE_PREFIX = "@";
    public static final char NPM_SCOPE_SEPARATOR = '/';
    public static final char NPM_SCOPE_SEPARATOR_ECLIPSE = ':';
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("(^)?[A-Za-z][A-Za-z_\\-\\.0-9]*");
    private static final Set<String> NPM_RESERVED_PACKAGE_NAMES = Sets.newHashSet((Object[])new String[]{"node_modules", "favicon.ico"});

    public static boolean isProjectNameWithScope(String projectName) {
        return projectName != null && projectName.startsWith(NPM_SCOPE_PREFIX) && projectName.indexOf(47) >= 0;
    }

    public static String getScopeName(String projectName) {
        return ProjectDescriptionUtils.isProjectNameWithScope(projectName) ? projectName.substring(0, projectName.indexOf(47)) : null;
    }

    public static String getPlainProjectName(String projectName) {
        return ProjectDescriptionUtils.isProjectNameWithScope(projectName) ? projectName.substring(projectName.indexOf(47) + 1) : projectName;
    }

    public static boolean isValidProjectName(String name) {
        String scopeName = ProjectDescriptionUtils.getScopeName(name);
        if (scopeName != null) {
            String plainProjectName = ProjectDescriptionUtils.getPlainProjectName(name);
            return ProjectDescriptionUtils.isValidScopeName(scopeName) && ProjectDescriptionUtils.isValidPlainProjectName(plainProjectName);
        }
        return ProjectDescriptionUtils.isValidPlainProjectName(name);
    }

    public static boolean isValidPlainProjectName(String name) {
        return ProjectDescriptionUtils.isValidNpmPackageName(name);
    }

    public static boolean isValidScopeName(String name) {
        if (name.startsWith(NPM_SCOPE_PREFIX)) {
            return ProjectDescriptionUtils.isValidNpmPackageName(name.substring(1));
        }
        return ProjectDescriptionUtils.isValidNpmPackageName(name);
    }

    private static boolean isValidNpmPackageName(String name) {
        return !Strings.isNullOrEmpty((String)name) && name.length() <= 214 && !NPM_RESERVED_PACKAGE_NAMES.contains(name) && IDENTIFIER_PATTERN.matcher(name).matches();
    }

    public static String deriveN4JSProjectNameFromURI(SafeURI<?> location) {
        if (location == null) {
            return null;
        }
        return ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(location.toURI());
    }

    public static String deriveN4JSProjectNameFromURI(URI uri) {
        String last;
        if (uri == null) {
            return null;
        }
        int segCount = uri.segmentCount();
        String string = last = segCount > 0 ? uri.segment(segCount - 1) : null;
        if (uri.isPlatform()) {
            if (last != null && last.startsWith(NPM_SCOPE_PREFIX)) {
                last = ProjectDescriptionUtils.replaceFirst(last, ':', '/');
            }
            return last;
        }
        if (uri.isFile()) {
            String secondToLast;
            String string2 = secondToLast = segCount > 1 ? uri.segment(segCount - 2) : null;
            if (secondToLast != null && secondToLast.startsWith(NPM_SCOPE_PREFIX)) {
                return String.valueOf(secondToLast) + '/' + last;
            }
            return last;
        }
        throw new IllegalArgumentException("neither a file nor a platform URI: " + uri);
    }

    public static String convertN4JSProjectNameToEclipseProjectName(String name) {
        if (name != null && name.startsWith(NPM_SCOPE_PREFIX)) {
            return ProjectDescriptionUtils.replaceFirst(name, '/', ':');
        }
        return name;
    }

    public static String convertEclipseProjectNameToN4JSProjectName(String name) {
        if (name != null && name.startsWith(NPM_SCOPE_PREFIX)) {
            return ProjectDescriptionUtils.replaceFirst(name, ':', '/');
        }
        return name;
    }

    private static String replaceFirst(String str, char oldChar, char newChar) {
        int idx;
        if (str != null && (idx = str.indexOf(oldChar)) >= 0) {
            return String.valueOf(str.substring(0, idx)) + newChar + str.substring(idx + 1);
        }
        return str;
    }

    public static String convertMainPathToModuleSpecifier(String path, List<String> sourceContainerPaths) {
        if (path == null) {
            return null;
        }
        if (!path.endsWith(".js")) {
            return null;
        }
        path = path.substring(0, path.length() - 3);
        path = ProjectDescriptionUtils.normalizeRelativePath(path);
        if (path == null) {
            return null;
        }
        List sourceContainerPathsNormalized = sourceContainerPaths.stream().map(ProjectDescriptionUtils::normalizeRelativePath).filter(p -> p != null).collect(Collectors.toList());
        for (String scp : sourceContainerPathsNormalized) {
            if (".".equals(scp)) {
                return path;
            }
            String scpSlash = String.valueOf(scp) + "/";
            if (!path.startsWith(scpSlash)) continue;
            return path.substring(scpSlash.length());
        }
        return null;
    }

    private static String normalizeRelativePath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (path.startsWith("/")) {
            return null;
        }
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        ArrayList<String> segmentsNew = new ArrayList<String>();
        String[] stringArray = path.split("/", -1);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!segment.isEmpty() && !".".equals(segment)) {
                if ("..".equals(segment)) {
                    if (segmentsNew.isEmpty()) {
                        return null;
                    }
                    segmentsNew.remove(segmentsNew.size() - 1);
                } else {
                    segmentsNew.add(segment);
                }
            }
            ++n2;
        }
        if (segmentsNew.isEmpty()) {
            return ".";
        }
        return Joiner.on((char)'/').join(segmentsNew);
    }

    public static int compareBySourceContainerType(SourceContainerDescription first, SourceContainerDescription other) {
        if (first == null) {
            return other == null ? 0 : 1;
        }
        if (other == null) {
            return -1;
        }
        return first.getSourceContainerType().compareTo((Enum)other.getSourceContainerType());
    }

    public static List<String> getPathsNormalized(SourceContainerDescription scd) {
        ArrayList<String> normalizedPaths = new ArrayList<String>(scd.getPaths().size());
        for (String path : scd.getPaths()) {
            String normalizedPath = FileUtils.normalizeToDotWhenEmpty((String)path);
            normalizedPaths.add(normalizedPath);
        }
        return normalizedPaths;
    }

    private ProjectDescriptionUtils() {
    }

    public static final class ProjectNameInfo {
        public final String projectFolderName;
        public final String parentFolderName;
        public final Optional<String> eclipseProjectName;

        private ProjectNameInfo(String projectFolderName, String parentFolderName, Optional<String> eclipseProjectName) {
            this.projectFolderName = projectFolderName;
            this.parentFolderName = parentFolderName;
            this.eclipseProjectName = eclipseProjectName;
        }

        public static ProjectNameInfo of(URI projectUri) {
            if (projectUri.isFile()) {
                projectUri.lastSegment().isEmpty();
                return new ProjectNameInfo(projectUri.lastSegment(), projectUri.trimSegments(1).lastSegment(), (Optional<String>)Optional.absent());
            }
            if (projectUri.isPlatform()) {
                String platformURI = projectUri.toPlatformString(true);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(platformURI);
                IPath path = resource.getLocation();
                return new ProjectNameInfo(path.lastSegment(), path.removeLastSegments(1).lastSegment(), (Optional<String>)(resource instanceof IProject ? Optional.of((Object)resource.getName()) : Optional.absent()));
            }
            throw new IllegalStateException("not a file or platform URI: " + projectUri);
        }
    }
}

