/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xtext.workspace;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;

public class WorkspaceChanges {
    public static final WorkspaceChanges NO_CHANGES = new WorkspaceChanges();
    protected boolean namesOrDependenciesChanged;
    protected List<URI> removedURIs;
    protected List<URI> addedURIs;
    protected List<URI> changedURIs;
    protected List<ISourceFolder> removedSourceFolders;
    protected List<ISourceFolder> addedSourceFolders;
    protected List<IProjectConfig> removedProjects;
    protected List<IProjectConfig> addedProjects;

    public static WorkspaceChanges createProjectRemoved(IProjectConfig project) {
        return new WorkspaceChanges(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(project), Collections.emptyList());
    }

    public static WorkspaceChanges createProjectAdded(IProjectConfig project) {
        return new WorkspaceChanges(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(project));
    }

    public static WorkspaceChanges createUrisChanged(List<URI> changedURIs) {
        return new WorkspaceChanges(false, Collections.emptyList(), Collections.emptyList(), changedURIs, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static WorkspaceChanges createUrisRemoved(List<URI> removedURIs) {
        return new WorkspaceChanges(false, removedURIs, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static WorkspaceChanges createUrisRemovedAndChanged(List<URI> removedURIs, List<URI> changedURIs) {
        return new WorkspaceChanges(false, removedURIs, changedURIs, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public WorkspaceChanges() {
        this(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public WorkspaceChanges(boolean namesOrDependenciesChanged, List<URI> removedURIs, List<URI> addedURIs, List<URI> changedURIs, List<ISourceFolder> removedSourceFolders, List<ISourceFolder> addedSourceFolders, List<IProjectConfig> removedProjects, List<IProjectConfig> addedProjects) {
        this.namesOrDependenciesChanged = namesOrDependenciesChanged;
        this.removedURIs = removedURIs;
        this.addedURIs = addedURIs;
        this.changedURIs = changedURIs;
        this.removedSourceFolders = removedSourceFolders;
        this.addedSourceFolders = addedSourceFolders;
        this.removedProjects = removedProjects;
        this.addedProjects = addedProjects;
    }

    public boolean isNamesOrDependenciesChanged() {
        return this.namesOrDependenciesChanged;
    }

    public List<URI> getRemovedURIs() {
        return this.removedURIs;
    }

    public List<URI> getAddedURIs() {
        return this.addedURIs;
    }

    public List<URI> getChangedURIs() {
        return this.changedURIs;
    }

    public List<ISourceFolder> getRemovedSourceFolders() {
        return this.removedSourceFolders;
    }

    public List<ISourceFolder> getAddedSourceFolders() {
        return this.addedSourceFolders;
    }

    public List<IProjectConfig> getRemovedProjects() {
        return this.removedProjects;
    }

    public List<IProjectConfig> getAddedProjects() {
        return this.addedProjects;
    }

    public List<ISourceFolder> getAllRemovedSourceFolders() {
        ArrayList<ISourceFolder> sourceFolders = new ArrayList<ISourceFolder>(this.removedSourceFolders);
        for (IProjectConfig project : this.removedProjects) {
            sourceFolders.addAll(project.getSourceFolders());
        }
        return sourceFolders;
    }

    public List<ISourceFolder> getAllAddedSourceFolders() {
        ArrayList<ISourceFolder> sourceFolders = new ArrayList<ISourceFolder>(this.addedSourceFolders);
        for (IProjectConfig project : this.addedProjects) {
            sourceFolders.addAll(project.getSourceFolders());
        }
        return sourceFolders;
    }

    public List<URI> scanAllRemovedURIs(IFileSystemScanner scanner) {
        ArrayList<URI> uris = new ArrayList<URI>(this.removedURIs);
        for (ISourceFolder sourceFolder : this.getAllRemovedSourceFolders()) {
            uris.addAll(sourceFolder.getAllResources(scanner));
        }
        return uris;
    }

    public List<URI> scanAllAddedURIs(IFileSystemScanner scanner) {
        ArrayList<URI> uris = new ArrayList<URI>(this.addedURIs);
        for (ISourceFolder sourceFolder : this.getAllAddedSourceFolders()) {
            uris.addAll(sourceFolder.getAllResources(scanner));
        }
        return uris;
    }

    public List<URI> scanAllAddedAndChangedURIs(IFileSystemScanner scanner) {
        ArrayList allChangedURIs = Lists.newArrayList((Iterable)Iterables.concat(this.scanAllAddedURIs(scanner), this.getChangedURIs()));
        return allChangedURIs;
    }

    public boolean isBuildOrderAffected() {
        return this.namesOrDependenciesChanged || !this.addedProjects.isEmpty() || !this.removedProjects.isEmpty();
    }

    public void merge(WorkspaceChanges changes) {
        this.namesOrDependenciesChanged |= changes.namesOrDependenciesChanged;
        this.removedURIs = Lists.newArrayList((Iterable)Iterables.concat(this.removedURIs, changes.removedURIs));
        this.addedURIs = Lists.newArrayList((Iterable)Iterables.concat(this.addedURIs, changes.addedURIs));
        this.changedURIs = Lists.newArrayList((Iterable)Iterables.concat(this.changedURIs, changes.changedURIs));
        this.removedSourceFolders = Lists.newArrayList((Iterable)Iterables.concat(this.removedSourceFolders, changes.removedSourceFolders));
        this.addedSourceFolders = Lists.newArrayList((Iterable)Iterables.concat(this.addedSourceFolders, changes.addedSourceFolders));
        this.removedProjects = Lists.newArrayList((Iterable)Iterables.concat(this.removedProjects, changes.removedProjects));
        this.addedProjects = Lists.newArrayList((Iterable)Iterables.concat(this.addedProjects, changes.addedProjects));
    }
}

