/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.flowgraphs.factories.ASTUtils;
import org.eclipse.n4js.flowgraphs.factories.CatchNodeFinder;
import org.eclipse.n4js.flowgraphs.factories.ComplexNodeMapper;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.EdgeUtils;
import org.eclipse.n4js.flowgraphs.model.FlowGraph;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.FinallyBlock;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Pair;

public class ControlFlowGraphFactory {
    private static final boolean PRINT_EDGE_DETAILS = false;

    public static FlowGraph build(SymbolFactory symbolFactory, Script script) {
        Measurement m;
        LinkedHashSet<ControlFlowElement> cfContainers = new LinkedHashSet<ControlFlowElement>();
        HashMap<ControlFlowElement, ComplexNode> cnMap = new HashMap<ControlFlowElement, ComplexNode>();
        String uriString = script.eResource().getURI().toString();
        ComplexNodeMapper cnMapper = null;
        Throwable throwable = null;
        Object var7_10 = null;
        try {
            m = N4JSDataCollectors.dcCreateNodes.getMeasurement("createNodes_" + uriString);
            try {
                ControlFlowGraphFactory.createComplexNodes(symbolFactory, script, cfContainers, cnMap);
                cnMapper = new ComplexNodeMapper(cnMap);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try {
            m = N4JSDataCollectors.dcConnectNodes.getMeasurement("connectNodes_" + uriString);
            try {
                ControlFlowGraphFactory.connectComplexNodes(cnMapper);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try {
            m = N4JSDataCollectors.dcJumpEdges.getMeasurement("jumpEdges_" + uriString);
            try {
                ControlFlowGraphFactory.createJumpEdges(cnMapper);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        FlowGraph cfg = new FlowGraph(script, cfContainers, cnMap);
        return cfg;
    }

    private static void createComplexNodes(SymbolFactory symbolFactory, Script script, Set<ControlFlowElement> cfContainers, Map<ControlFlowElement, ComplexNode> cnMap) {
        ReentrantASTIterator astIt = new ReentrantASTIterator(symbolFactory, cfContainers, cnMap, script);
        astIt.visitAll();
    }

    private static void connectComplexNodes(ComplexNodeMapper cnMapper) {
        for (ComplexNode cn : cnMapper.getAll()) {
            LinkedList<Node> removeNodes = new LinkedList<Node>();
            for (Node mNode : cn.getNodes()) {
                if (mNode == cn.getExit()) continue;
                ControlFlowGraphFactory.connectNode(cnMapper, mNode);
            }
            for (Node mNode : cn.getNodes()) {
                if (!ControlFlowGraphFactory.isRemovableNode(mNode)) continue;
                removeNodes.add(mNode);
            }
            for (Node removeNode : removeNodes) {
                ControlFlowGraphFactory.removeNode(cn, removeNode);
            }
        }
    }

    private static void connectNode(ComplexNodeMapper cnMapper, Node mNode) {
        ComplexNode subCN;
        Node internalStartNode = mNode;
        ControlFlowElement subASTElem = mNode.getDelegatedControlFlowElement();
        if (subASTElem != null && (subCN = cnMapper.get(subASTElem)) != null) {
            EdgeUtils.connectCF(mNode, subCN.getEntry());
            internalStartNode = subCN.getExit();
        }
        Set<Node> internalSuccs = mNode.getInternalSuccessors();
        for (Node internalSucc : internalSuccs) {
            ControlFlowType cfType = mNode.getInternalSuccessorControlFlowType(internalSucc);
            EdgeUtils.connectCF(internalStartNode, internalSucc, cfType);
        }
    }

    private static boolean isRemovableNode(Node mNode) {
        boolean remDel = true;
        remDel = remDel && mNode instanceof DelegatingNode;
        remDel = remDel && !(mNode instanceof RepresentingNode);
        remDel = remDel && mNode.jumpToken.isEmpty();
        remDel = remDel && mNode.catchToken.isEmpty();
        remDel = remDel && mNode.getInternalPredecessors().size() == 1;
        remDel = remDel && mNode.pred.size() == 1;
        remDel = remDel && mNode.succ.size() == 1;
        remDel = remDel && mNode.pred.first().cfType == ControlFlowType.Successor;
        remDel = remDel && mNode.succ.first().cfType == ControlFlowType.Successor;
        remDel = remDel && mNode.effectInfos.isEmpty();
        return remDel;
    }

    private static void removeNode(ComplexNode cn, Node mNode) {
        ControlFlowEdge e1 = mNode.pred.first();
        ControlFlowEdge e2 = mNode.succ.first();
        Node pred = e1.start;
        Node succ = e2.end;
        EdgeUtils.removeCF(e1);
        EdgeUtils.removeCF(e2);
        cn.removeNodeChecks(mNode);
        cn.removeNode(mNode);
        for (Node intPred : mNode.getInternalPredecessors()) {
            intPred.removeInternalSuccessor(mNode);
        }
        for (Node intSucc : mNode.getInternalSuccessors()) {
            intSucc.removeInternalPredecessor(mNode);
        }
        mNode.getInternalPredecessors().clear();
        mNode.getInternalSuccessors().clear();
        EdgeUtils.connectCF(pred, succ);
    }

    private static void createJumpEdges(ComplexNodeMapper cnMapper) {
        for (ComplexNode cn : cnMapper.getAll()) {
            Node jumpNode = cn.getJump();
            if (jumpNode == null) continue;
            for (JumpToken jumpToken : jumpNode.jumpToken) {
                ControlFlowGraphFactory.connectToJumpTarget(cnMapper, jumpNode, jumpToken);
            }
        }
    }

    private static void connectToJumpTarget(ComplexNodeMapper cnMapper, Node jumpNode, JumpToken jumpToken) {
        Pair<Node, ControlFlowType> catcher = CatchNodeFinder.find(jumpToken, jumpNode, cnMapper);
        if (catcher == null) {
            String jumpTokenStr = ControlFlowGraphFactory.getJumpTokenDetailString(jumpToken, jumpNode);
            System.err.println("Could not find catching node for jump token '" + jumpTokenStr + "'");
            return;
        }
        Node catchNode = (Node)catcher.getKey();
        ControlFlowType newEdgeType = (ControlFlowType)((Object)catcher.getValue());
        FinallyBlock enteringFinallyBlock = ControlFlowGraphFactory.getEnteringFinallyBlock(catchNode);
        boolean isExitingFinallyBlock = ControlFlowGraphFactory.isExitingFinallyBlock(cnMapper, jumpNode);
        if (enteringFinallyBlock != null || isExitingFinallyBlock) {
            boolean equalEdgeExistsAlready = ControlFlowGraphFactory.equalEdgeExistsAlready(jumpNode, jumpToken, catchNode);
            if (!equalEdgeExistsAlready) {
                EdgeUtils.connectCF(jumpNode, catchNode, jumpToken);
            }
        } else {
            try {
                EdgeUtils.connectCF(jumpNode, catchNode, newEdgeType);
            }
            catch (Exception e) {
                ControlFlowGraphFactory.printInfo(cnMapper, jumpNode, catchNode, newEdgeType);
                throw e;
            }
        }
        if (enteringFinallyBlock != null) {
            Block block = enteringFinallyBlock.getBlock();
            ComplexNode cnBlock = cnMapper.get((ControlFlowElement)block);
            Node exitFinallyBlock = cnBlock.getExit();
            ControlFlowGraphFactory.connectToJumpTarget(cnMapper, exitFinallyBlock, jumpToken);
        }
    }

    private static void printInfo(ComplexNodeMapper cnMapper, Node jumpNode, Node catchNode, ControlFlowType newEdgeType) {
        System.out.println("ERROR");
        System.out.println("jump from source: " + ASTUtils.getNodeDetailString(jumpNode));
        System.out.println("jump to target  : " + ASTUtils.getNodeDetailString(catchNode));
        System.out.println("jump type       : " + (Object)((Object)newEdgeType));
        System.out.println("jump node tokens: " + String.join((CharSequence)", ", jumpNode.jumpToken.stream().map(t -> t.toString()).collect(Collectors.joining(","))));
        Script script = (Script)EcoreUtil2.getContainerOfType((EObject)jumpNode.getControlFlowElement(), Script.class);
        String sourceText = FGUtils.getSourceText((EObject)script);
        System.out.println("Source was      :");
        System.out.println(sourceText);
        System.out.println("All jump nodes  :");
        for (ComplexNode cn : cnMapper.getAll()) {
            Node jumpNode2 = cn.getJump();
            if (jumpNode2 == null) continue;
            System.out.println("   " + ASTUtils.getNodeDetailString(jumpNode2));
        }
        System.out.println("END ERROR.\n");
    }

    private static boolean equalEdgeExistsAlready(Node jumpNode, JumpToken jumpToken, Node catchNode) {
        boolean equalEdgeExistsAlready = false;
        for (ControlFlowEdge cfEdge : catchNode.pred) {
            equalEdgeExistsAlready |= cfEdge.cfType == jumpToken.cfType && cfEdge.start == jumpNode;
        }
        return equalEdgeExistsAlready;
    }

    private static FinallyBlock getEnteringFinallyBlock(Node catchNode) {
        if (catchNode.name.equals("finally")) {
            ControlFlowElement cfe = catchNode.getDelegatedControlFlowElement();
            EObject cfeContainer = cfe.eContainer();
            return (FinallyBlock)cfeContainer;
        }
        return null;
    }

    private static boolean isExitingFinallyBlock(ComplexNodeMapper cnMapper, Node node) {
        ControlFlowElement cfe = node.getControlFlowElement();
        ComplexNode cn = cnMapper.get(cfe);
        boolean isExitingFinallyBlock = true;
        isExitingFinallyBlock &= cfe instanceof Block;
        isExitingFinallyBlock &= cfe.eContainer() instanceof FinallyBlock;
        return isExitingFinallyBlock &= cn.getExit() == node;
    }

    private static String getJumpTokenDetailString(JumpToken jumpToken, Node jumpNode) {
        String jNode = ASTUtils.getNodeDetailString(jumpNode);
        String jmpStr = String.valueOf(jNode) + " >> " + jumpToken.toString();
        return jmpStr;
    }

    private static void printAllEdgeDetails(ComplexNodeMapper cnMapper) {
        System.out.println("\nAll edges:");
        HashSet<ControlFlowEdge> allEdges = new HashSet<ControlFlowEdge>();
        for (ComplexNode cn : cnMapper.getAll()) {
            for (Node n : cn.getNodes()) {
                allEdges.addAll(n.pred);
                allEdges.addAll(n.succ);
            }
        }
        for (ControlFlowEdge edge : allEdges) {
            System.out.println(edge);
        }
    }
}

