/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;

public class WorkspaceAwareResourceLocator
extends ResourceSetImpl.ResourceLocator {
    private static final Logger LOG = Logger.getLogger(WorkspaceAwareResourceLocator.class);
    private final XWorkspaceManager workspaceManager;

    public WorkspaceAwareResourceLocator(ResourceSetImpl resourceSet, XWorkspaceManager workspaceManager) {
        super(resourceSet);
        this.workspaceManager = workspaceManager;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource candidate = (Resource)this.resourceSet.getURIResourceMap().get(uri);
        if (candidate != null) {
            if (loadOnDemand && !candidate.isLoaded()) {
                LOG.warn((Object)("Returning a resource that is not loaded even though loadOnDemand was set to true: " + candidate.getURI()));
            }
            return candidate;
        }
        XProjectManager projectManager = this.workspaceManager.getProjectManager(uri);
        if (projectManager == null || projectManager.getResourceSet() == this.resourceSet) {
            return this.basicGetResource(uri, loadOnDemand);
        }
        return projectManager.getResourceSet().getResource(uri, loadOnDemand);
    }
}

