/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.transpiler.InformationRegistry;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.transpiler.im.SymbolTable;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TranspilerDebugUtils {
    public void validateState(TranspilerState state, boolean allowDanglingSecondaryReferencesInSTEs) throws AssertionError {
        EClass _parameterizedPropertyAccessExpression = N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression();
        EClass _identifierRef = N4JSPackage.eINSTANCE.getIdentifierRef();
        EClass _parameterizedTypeRef = TypeRefsPackage.eINSTANCE.getParameterizedTypeRef();
        List replacedEClasses = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EClass[]{_parameterizedPropertyAccessExpression, _identifierRef, _parameterizedTypeRef}));
        Functions.Function1 _function = it -> replacedEClasses.contains(it.eClass());
        EObject badObject = (EObject)IteratorExtensions.findFirst((Iterator)state.im.eAllContents(), (Functions.Function1)_function);
        EClass _eClass = null;
        if (badObject != null) {
            _eClass = badObject.eClass();
        }
        String _name = null;
        if (_eClass != null) {
            _name = _eClass.getName();
        }
        String _plus = "intermediate model should not contain objects of type " + _name;
        TranspilerDebugUtils.assertNull(_plus, badObject);
        Functions.Function1 _function_1 = it -> {
            boolean _allowedCrossRefToOutside = this.allowedCrossRefToOutside((EObject)it, transpilerState.info);
            return !_allowedCrossRefToOutside;
        };
        Functions.Function1 _function_2 = it -> TranspilerDebugUtils.hasCrossRefToOutsideOf(it, state);
        TranspilerDebugUtils.assertFalse("intermediate model should not have a cross-reference to an element outside the intermediate model (except for SymbolTableEntry)", IteratorExtensions.exists((Iterator)IteratorExtensions.filter((Iterator)state.im.eAllContents(), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        SymbolTable st = state.im.getSymbolTable();
        TranspilerDebugUtils.assertNotNull("intermediate model should have a symbol table", st);
        EList<SymbolTableEntry> _entries = st.getEntries();
        for (SymbolTableEntry ste : _entries) {
            boolean _tripleNotEquals;
            if (ste instanceof SymbolTableEntryOriginal) {
                TranspilerDebugUtils.assertNotNull("originalTarget should not be null", ((SymbolTableEntryOriginal)ste).getOriginalTarget());
                TranspilerDebugUtils.assertFalse("originalTarget should not be an element in the intermediate model", TranspilerDebugUtils.isElementInIntermediateModelOf((EObject)((SymbolTableEntryOriginal)ste).getOriginalTarget(), state));
            }
            if (allowDanglingSecondaryReferencesInSTEs) continue;
            Functions.Function1 _function_3 = it -> TranspilerDebugUtils.isElementInIntermediateModelOf((EObject)it, state);
            TranspilerDebugUtils.assertTrue("all elementsOfThisName should be elements in the intermediate model", IterableExtensions.forall(ste.getElementsOfThisName(), (Functions.Function1)_function_3));
            Functions.Function1 _function_4 = it -> TranspilerDebugUtils.isElementInIntermediateModelOf(it, state);
            TranspilerDebugUtils.assertTrue("all referencingElements should be elements in the intermediate model", IterableExtensions.forall(ste.getReferencingElements(), (Functions.Function1)_function_4));
            if (!(ste instanceof SymbolTableEntryOriginal)) continue;
            ImportSpecifier _importSpecifier = ((SymbolTableEntryOriginal)ste).getImportSpecifier();
            boolean bl = _tripleNotEquals = _importSpecifier != null;
            if (!_tripleNotEquals) continue;
            TranspilerDebugUtils.assertTrue("importSpecifier should be an element in the intermediate model", TranspilerDebugUtils.isElementInIntermediateModelOf((EObject)((SymbolTableEntryOriginal)ste).getImportSpecifier(), state));
        }
    }

    private boolean allowedCrossRefToOutside(EObject eobj, InformationRegistry info) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (eobj instanceof SymbolTableEntry) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    private static boolean hasCrossRefToOutsideOf(EObject elementInIntermediateModel, TranspilerState state) {
        Functions.Function1 _function = it -> {
            boolean _not;
            boolean _isElementInIntermediateModelOf = TranspilerDebugUtils.isElementInIntermediateModelOf(it, state);
            boolean bl = _not = !_isElementInIntermediateModelOf;
            if (_not) {
                return true;
            }
            return false;
        };
        return IterableExtensions.exists((Iterable)elementInIntermediateModel.eCrossReferences(), (Functions.Function1)_function);
    }

    private static boolean isElementInIntermediateModelOf(EObject eobj, TranspilerState state) {
        Script_IM _containerOfType = (Script_IM)EcoreUtil2.getContainerOfType((EObject)eobj, Script_IM.class);
        return _containerOfType == state.im;
    }

    public static void assertTrue(String message, boolean value) throws AssertionError {
        if (!value) {
            TranspilerDebugUtils.assertionFailure(message);
        }
    }

    public static void assertFalse(String message, boolean value) throws AssertionError {
        if (value) {
            TranspilerDebugUtils.assertionFailure(message);
        }
    }

    public static void assertNull(String message, Object value) throws AssertionError {
        if (value != null) {
            TranspilerDebugUtils.assertionFailure(message);
        }
    }

    public static void assertNotNull(String message, Object value) throws AssertionError {
        if (value == null) {
            TranspilerDebugUtils.assertionFailure(message);
        }
    }

    private static void assertionFailure(String message) throws AssertionError {
        AssertionError ex = new AssertionError((Object)message);
        ((Throwable)((Object)ex)).printStackTrace();
        throw ex;
    }

    public static void dumpGraph(TranspilerState state, String label) {
        UtilN4.takeSnapshotInGraphView((String)label, (Object)state.im);
    }

    public static void dump(TranspilerState state) {
        InputOutput.println((Object)TranspilerDebugUtils.dumpToString(state));
    }

    public static String dumpToString(TranspilerState state) {
        StringWriter w = new StringWriter();
        TranspilerDebugUtils.dump(state, w);
        return w.toString();
    }

    public static void dump(TranspilerState state, Writer out) {
        PrintWriter w = new PrintWriter(out);
        TranspilerDebugUtils.dump(w, (EObject)state.im, 0);
    }

    private static void dump(PrintWriter w, EObject obj, int indentLevel) {
        TranspilerDebugUtils.indent(w, indentLevel);
        TranspilerDebugUtils.printObj(w, obj, true, indentLevel);
        w.println();
        EList _eContents = obj.eContents();
        for (EObject child : _eContents) {
            TranspilerDebugUtils.dump(w, child, indentLevel + 1);
        }
    }

    private static void printObj(PrintWriter w, EObject obj, boolean includeCrossRefs, int indentLevel) {
        String objStr;
        int idx;
        w.print(obj.eClass().getName());
        if (obj instanceof IdentifiableElement || obj instanceof NamedElement || obj instanceof VariableDeclaration || obj instanceof ImportSpecifier || obj instanceof SymbolTableEntry) {
            String _hexString = Integer.toHexString(obj.hashCode());
            String _plus = " @" + _hexString;
            w.print(_plus);
        }
        if ((idx = (objStr = obj.toString()).indexOf("(")) >= 0) {
            String _substring = objStr.substring(idx);
            String _plus_1 = " " + _substring;
            w.print(_plus_1);
        }
        if (includeCrossRefs) {
            boolean _not;
            Functions.Function1 _function = it -> {
                boolean _isContainment = it.isContainment();
                return !_isContainment;
            };
            Iterable crossRefs = IterableExtensions.filter((Iterable)obj.eClass().getEAllReferences(), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)crossRefs);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                for (EReference ref : crossRefs) {
                    w.println();
                    TranspilerDebugUtils.indent(w, indentLevel);
                    String _name = ref.getName();
                    String _plus_2 = "--" + _name;
                    String _plus_3 = String.valueOf(_plus_2) + "--> ";
                    w.print(_plus_3);
                    boolean _isMany = ref.isMany();
                    if (_isMany) {
                        w.print("[");
                        Object _eGet = obj.eGet((EStructuralFeature)ref);
                        EList targets = (EList)_eGet;
                        Iterator iter = targets.iterator();
                        while (iter.hasNext()) {
                            EObject currTarget = (EObject)iter.next();
                            if (currTarget != null) {
                                TranspilerDebugUtils.printObj(w, currTarget, false, indentLevel);
                            } else {
                                w.print("null");
                            }
                            boolean _hasNext = iter.hasNext();
                            if (!_hasNext) continue;
                            w.print(", ");
                        }
                        w.print("]");
                        continue;
                    }
                    Object _eGet_1 = obj.eGet((EStructuralFeature)ref);
                    EObject target = (EObject)_eGet_1;
                    if (target != null) {
                        TranspilerDebugUtils.printObj(w, target, false, indentLevel);
                        continue;
                    }
                    w.print("null");
                }
            }
        }
    }

    private static void indent(PrintWriter w, int indentLevel) {
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, indentLevel, true);
        for (Integer i : _doubleDotLessThan) {
            w.print("\t");
        }
    }
}

