/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import org.eclipse.n4js.conversion.N4JSValueConverterException;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.conversion.ValueConverterUtils;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public class IdentifierValueConverter
extends IDValueConverter {
    protected String toEscapedString(String value) {
        return ValueConverterUtils.convertToEscapedString(value, false);
    }

    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            String result = IdentifierValueConverter.convertFromN4JSIdentifier(string, node);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    public static String convertFromN4JSIdentifier(String jsString, INode node) {
        ValueConverterUtils.CharacterValidityChecker validityChecker = (ch, offset) -> !(offset == 0 ? !N4JSLanguageUtils.isValidIdentifierStart(ch) : !N4JSLanguageUtils.isValidIdentifierPart(ch));
        ValueConverterUtils.StringConverterResult result = ValueConverterUtils.convertFromEscapedString(jsString, false, false, true, validityChecker);
        if (result.hasError()) {
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_IDENT_ESCAPE_SEQ(jsString, result.getErrorOffset()), "VCO_IDENT_ESCAPE_SEQ", node, result.getValue(), null);
        }
        if (result.hasInvalidChar()) {
            if (result.getValue().length() != 0) {
                throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_IDENT_ILLEGAL_CHAR_WITH_RESULT(result.getValue(), jsString, result.getInvalidCharOffset()), "VCO_IDENT_ILLEGAL_CHAR_WITH_RESULT", node, result.getValue(), null);
            }
            throw new N4JSValueConverterException(IssueCodes.getMessageForVCO_IDENT_ILLEGAL_CHAR(jsString, result.getInvalidCharOffset()), "VCO_IDENT_ILLEGAL_CHAR", node, null);
        }
        return result.getValue();
    }
}

