/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.N4JSRuntimeCore;
import org.eclipse.n4js.internal.lsp.N4JSProjectConfig;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.ProjectDiscoveryHelper;
import org.eclipse.n4js.xtext.workspace.WorkspaceChanges;
import org.eclipse.n4js.xtext.workspace.XIWorkspaceConfig;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.workspace.IProjectConfig;

public class N4JSWorkspaceConfig
implements XIWorkspaceConfig {
    private final URI baseDirectory;
    private final IN4JSCore delegate;

    public N4JSWorkspaceConfig(URI baseDirectory, IN4JSCore delegate) {
        this.baseDirectory = baseDirectory;
        this.delegate = delegate;
    }

    public IProjectConfig findProjectByName(String name) {
        IN4JSProject project = (IN4JSProject)this.delegate.findProject(new N4JSProjectName(name)).orNull();
        if (project != null) {
            return new N4JSProjectConfig(this, project);
        }
        return null;
    }

    public IProjectConfig findProjectContaining(URI member) {
        IN4JSProject project = (IN4JSProject)this.delegate.findProject(member).orNull();
        if (project != null) {
            return new N4JSProjectConfig(this, project);
        }
        return null;
    }

    public Set<? extends IProjectConfig> getProjects() {
        HashSet<N4JSProjectConfig> pConfigs = new HashSet<N4JSProjectConfig>();
        for (IN4JSProject iN4JSProject : this.delegate.findAllProjects()) {
            pConfigs.add(new N4JSProjectConfig(this, iN4JSProject));
        }
        return pConfigs;
    }

    @Override
    public URI getPath() {
        return this.baseDirectory;
    }

    @Override
    public WorkspaceChanges update(URI changedResource, Function<String, ProjectDescription> pdProvider) {
        boolean wasExistingInWorkspace;
        IProjectConfig project = this.findProjectContaining(changedResource);
        Set<? extends IProjectConfig> oldProjects = this.getProjects();
        WorkspaceChanges update = new WorkspaceChanges();
        FileURI projectUri = project != null ? new FileURI(new File(project.getPath().toFileString())) : null;
        boolean bl = wasExistingInWorkspace = projectUri != null && ((N4JSRuntimeCore)this.delegate).isRegistered(projectUri);
        if (project != null && wasExistingInWorkspace) {
            ProjectDescription projectDescription = pdProvider.apply(project.getName());
            update.merge(((N4JSProjectConfig)project).update(changedResource, projectDescription));
            if (((N4JSProjectConfig)project).isWorkspacesProject()) {
                update.merge(this.detectAddedRemovedProjects(oldProjects));
            }
        } else {
            update.merge(this.detectAddedRemovedProjects(oldProjects));
        }
        if (!update.getAddedProjects().isEmpty() || !update.getRemovedProjects().isEmpty()) {
            for (IProjectConfig iProjectConfig : oldProjects) {
                ProjectDescription pd = pdProvider.apply(iProjectConfig.getName());
                if (pd == null) continue;
                ((N4JSProjectConfig)iProjectConfig).updateProjectDescription(pd);
            }
        }
        return update;
    }

    private WorkspaceChanges detectAddedRemovedProjects(Set<? extends IProjectConfig> oldProjects) {
        ((N4JSRuntimeCore)this.delegate).deregisterAll();
        ProjectDiscoveryHelper projectDiscoveryHelper = ((N4JSRuntimeCore)this.delegate).getProjectDiscoveryHelper();
        Path baseDir = new FileURI(this.getPath()).toFile().toPath();
        LinkedHashSet<Path> newProjectPaths = projectDiscoveryHelper.collectAllProjectDirs(baseDir);
        for (Path newProjectPath : newProjectPaths) {
            ((N4JSRuntimeCore)this.delegate).registerProject(newProjectPath.toFile());
        }
        Map<URI, IProjectConfig> oldProjectsMap = this.getProjectsMap(oldProjects);
        Map<URI, IProjectConfig> newProjectsMap = this.getProjectsMap(this.getProjects());
        ArrayList<IProjectConfig> addedProjects = new ArrayList<IProjectConfig>();
        ArrayList<IProjectConfig> removedProjects = new ArrayList<IProjectConfig>();
        for (URI uri : Sets.union(oldProjectsMap.keySet(), newProjectsMap.keySet())) {
            boolean isOld = oldProjectsMap.containsKey(uri);
            boolean isNew = newProjectsMap.containsKey(uri);
            if (isOld && !isNew) {
                removedProjects.add(oldProjectsMap.get(uri));
                continue;
            }
            if (isOld || !isNew) continue;
            addedProjects.add(newProjectsMap.get(uri));
        }
        boolean dependenciesChanged = !addedProjects.isEmpty() || !removedProjects.isEmpty();
        return new WorkspaceChanges(dependenciesChanged, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), removedProjects, addedProjects);
    }

    private Map<URI, IProjectConfig> getProjectsMap(Set<? extends IProjectConfig> projects) {
        HashMap<URI, IProjectConfig> projectsMap = new HashMap<URI, IProjectConfig>();
        for (IProjectConfig iProjectConfig : projects) {
            projectsMap.put(iProjectConfig.getPath(), iProjectConfig);
        }
        return projectsMap;
    }
}

