/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.locations;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.OSInfo;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

public abstract class SafeURI<U extends SafeURI<U>> {
    private final URI wrapped;

    protected SafeURI(URI wrapped) {
        this.wrapped = this.validate(wrapped);
    }

    protected URI validate(URI given) throws IllegalArgumentException, NullPointerException {
        Preconditions.checkNotNull((Object)given);
        List segments = given.segmentsList();
        int segCountMax = given.hasTrailingPathSeparator() ? segments.size() - 1 : segments.size();
        int i = 0;
        while (i < segCountMax) {
            String segment = (String)segments.get(i);
            Preconditions.checkArgument((segment.length() > 0 ? 1 : 0) != 0, (String)"'%s'", (Object)given);
            if (OSInfo.isWindows()) {
                Preconditions.checkArgument((!segment.contains(File.separator) ? 1 : 0) != 0);
            }
            ++i;
        }
        return given;
    }

    public URI toURI() {
        return this.wrapped;
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SafeURI other = (SafeURI)obj;
        return this.wrapped.equals(other.wrapped);
    }

    public String toString() {
        return this.toURI().toString();
    }

    public abstract boolean isFile();

    public abstract String getName();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract Iterable<? extends U> getChildren();

    public abstract InputStream getContents() throws IOException;

    public abstract String getAbsolutePath();

    public final U withTrailingPathDelimiter() {
        URI uri = this.toURI();
        if (uri.hasTrailingPathSeparator()) {
            SafeURI result = this;
            return (U)result;
        }
        return this.createFrom(uri.appendSegment(""));
    }

    public final U resolve(String relativePath) {
        URI base = ((SafeURI)this.withTrailingPathDelimiter()).toURI();
        URI result = URI.createURI((String)relativePath).resolve(base);
        return this.createFrom(result);
    }

    protected abstract U createFrom(URI var1);

    public List<String> deresolve(U base) {
        Preconditions.checkArgument((boolean)base.getClass().equals(this.getClass()));
        URI baseURI = ((SafeURI)((SafeURI)base).withTrailingPathDelimiter()).toURI();
        URI result = this.toURI().deresolve(baseURI, false, true, true);
        return result.segmentsList();
    }

    public final U appendPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        return this.appendRelativeURI(URI.createURI((String)path));
    }

    private U appendRelativeURI(URI relativeURI) {
        String[] segments = relativeURI.segments();
        if (segments.length == 0) {
            throw new IllegalArgumentException("Cannot append empty URI.");
        }
        if (!URI.validSegments((String[])segments)) {
            throw new IllegalArgumentException(String.valueOf(relativeURI));
        }
        if (segments.length == 1 && segments[0].isEmpty()) {
            throw new IllegalArgumentException("Use withTrailingPathDelimiter instead");
        }
        int i = 0;
        while (i < segments.length - 1) {
            if (segments[i].isEmpty()) {
                throw new IllegalArgumentException("Cannot add intermediate empty segments");
            }
            ++i;
        }
        URI base = ((SafeURI)this.withTrailingPathDelimiter()).toURI();
        URI result = relativeURI.resolve(base);
        return this.createFrom(result);
    }

    public final U appendSegment(String segment) {
        return this.appendSegments(segment);
    }

    public final U appendSegments(String ... segments) {
        return this.appendRelativeURI(URI.createHierarchicalURI((String[])segments, null, null));
    }

    public final boolean isEmpty() {
        return this.toURI().isEmpty();
    }

    public U getParent() {
        URI uri = this.toURI();
        if (uri.segmentCount() <= 0) {
            return null;
        }
        return this.createFrom(uri.trimSegments(1));
    }

    public N4JSProjectName findProjectName() {
        U root = this.getProjectRoot();
        if (root != null) {
            return ((SafeURI)root).getProjectName();
        }
        return null;
    }

    public N4JSProjectName getProjectName() {
        String guess = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(this);
        if (guess != null) {
            return new N4JSProjectName(guess);
        }
        return null;
    }

    public boolean isProjectRootDirectory() {
        return this.isDirectory() && (((SafeURI)this.appendSegment("package.json")).isFile() || ((SafeURI)this.appendSegment("package.json.xt")).isFile());
    }

    public boolean isPackageJsonLocation() {
        URI raw = this.toURI();
        if (raw.hasTrailingPathSeparator()) {
            return false;
        }
        String filename = raw.lastSegment();
        return "package.json".equals(filename) || filename.length() == "package.json".length() + 3 && filename.startsWith("package.json") && filename.endsWith("xt") && filename.charAt(filename.length() - 3) == '.';
    }

    public U getProjectRoot() {
        SafeURI<U> result = this;
        if (this.isFile()) {
            result = result.getParent();
        }
        while (result != null) {
            if (result.isProjectRootDirectory()) {
                return (U)result;
            }
            result = result.getParent();
        }
        return null;
    }

    public abstract FileURI resolveSymLinks();

    public abstract Iterator<U> getAllChildren();

    public abstract void delete(Consumer<? super IOException> var1);

    public final Path toFileSystemPath() {
        return this.toJavaIoFile().toPath();
    }

    public abstract File toJavaIoFile();

    public abstract FileURI toFileURI();
}

