/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.helper;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public final class IssuesProvider
implements Provider<List<Issue>> {
    private final IResourceValidator rv;
    private final Resource r;
    private final OperationCanceledManager operationCanceledManager;
    private final CancelIndicator ci;
    private final CheckMode checkMode;

    public IssuesProvider(IResourceValidator resourceValidator, Resource res, CheckMode checkMode, OperationCanceledManager operationCanceledManager, CancelIndicator ci) {
        this.rv = resourceValidator;
        this.r = res;
        this.checkMode = checkMode;
        this.operationCanceledManager = operationCanceledManager;
        this.ci = ci;
    }

    public List<Issue> get() throws OperationCanceledError {
        this.operationCanceledManager.checkCanceled(this.ci);
        List issues = this.rv.validate(this.r, this.checkMode, this.ci);
        if (!issues.contains(null)) {
            this.operationCanceledManager.checkCanceled(this.ci);
            return issues;
        }
        ArrayList<Issue> result = new ArrayList<Issue>(issues);
        result.removeAll(Collections.singleton(null));
        this.operationCanceledManager.checkCanceled(this.ci);
        return result;
    }
}

