/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.classifiers;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSClassifierWizardModel;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSNewClassifierWizardPage;
import org.eclipse.n4js.ui.wizard.generator.WorkspaceWizardGenerator;
import org.eclipse.n4js.ui.wizard.generator.WorkspaceWizardGeneratorException;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.LanguageSpecificURIEditorOpener;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public abstract class N4JSNewClassifierWizard<M extends N4JSClassifierWizardModel>
extends Wizard
implements INewWizard {
    private static Logger LOGGER = Logger.getLogger(N4JSNewClassifierWizard.class);
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private LanguageSpecificURIEditorOpener uriOpener;

    public final void init(IWorkbench workbench, IStructuredSelection selection) {
        this.init(workbench, selection, false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection, boolean nested) {
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle("New N4JS " + StringExtensions.toFirstUpper((String)((N4JSClassifierWizardModel)this.getModel()).getClassifierName()));
        this.setNeedsProgressMonitor(true);
        this.parseIntialSelection(selection, nested);
    }

    private void parseIntialSelection(IStructuredSelection selection, boolean nested) {
        WorkspaceWizardModel.populateModelFromInitialSelection(this.getModel(), selection, nested, this.n4jsCore);
        this.getPage().setModel(this.getModel());
    }

    public boolean performFinish() {
        final IPath fileLocation = ((N4JSClassifierWizardModel)this.getModel()).computeFileLocation();
        IRunnableWithProgress createClassifierRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                if (!workspaceRoot.getFile(fileLocation).exists()) {
                    IProject parent = workspaceRoot.getProject(((WorkspaceWizardModel)N4JSNewClassifierWizard.this.getModel()).getProject().toString());
                    try {
                        String[] stringArray = fileLocation.makeRelativeTo(((WorkspaceWizardModel)N4JSNewClassifierWizard.this.getModel()).getProject()).removeLastSegments(1).segments();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String segment = stringArray[n2];
                            IFolder subfolder = parent.getFolder((IPath)new Path(segment));
                            if (!subfolder.exists()) {
                                subfolder.create(true, true, null);
                            }
                            parent = subfolder;
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                N4JSNewClassifierWizard.this.doGenerateClassifier((IProgressMonitor)subMonitor);
                monitor.done();
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> N4JSNewClassifierWizard.this.uriOpener.open(URI.createPlatformResourceURI((String)fileLocation.toString(), (boolean)true), true));
            }
        };
        try {
            this.getContainer().run(true, false, createClassifierRunnable);
        }
        catch (InvocationTargetException e) {
            String classifierName = ((N4JSClassifierWizardModel)this.getModel()).getClassifierName();
            LOGGER.error((Object)("Failed to create the new " + classifierName), e.getTargetException());
            this.setErrorMessage("Failed to create the new " + classifierName + ": " + e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getPage());
    }

    private void setErrorMessage(String message) {
        IWizardPage currentPage;
        IWizardContainer container = this.getContainer();
        if (container != null && (currentPage = container.getCurrentPage()) instanceof DialogPage) {
            ((DialogPage)currentPage).setErrorMessage(message);
        }
    }

    protected abstract M getModel();

    protected void doGenerateClassifier(IProgressMonitor monitor) throws WorkspaceWizardGeneratorException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        WorkspaceWizardGenerator<M> generator = this.getGenerator();
        generator.performProjectDescriptionChanges(this.getModel(), monitor);
        monitor.worked(1);
        generator.writeToFile(this.getModel(), monitor);
        monitor.worked(1);
    }

    protected abstract WorkspaceWizardGenerator<M> getGenerator();

    protected abstract N4JSNewClassifierWizardPage<M> getPage();
}

