/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.PropertyNameKind;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;

public class SimplifyTransformation
extends Transformation {
    @Inject
    private N4JSTypeSystem ts;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<LiteralOrComputedPropertyName> _function = it -> this.simplify((LiteralOrComputedPropertyName)it);
        this.collectNodes((EObject)this.getState().im, LiteralOrComputedPropertyName.class, false).forEach(_function);
    }

    private void simplify(LiteralOrComputedPropertyName name) {
        if (name.getKind() == PropertyNameKind.COMPUTED && this.isOfTypeStringInAST(name.getExpression())) {
            this.replace(name.getExpression(), (Expression)TranspilerBuilderBlocks._StringLiteral((String)name.getComputedName()));
        }
        if (name.getKind() == PropertyNameKind.COMPUTED && name.getExpression() instanceof StringLiteral) {
            name.setKind(PropertyNameKind.STRING);
            name.setLiteralName(name.getComputedName());
            name.setComputedName(null);
            this.remove((EObject)name.getExpression());
        }
        if (name.getKind() == PropertyNameKind.STRING && name.getLiteralName() != null && N4JSLanguageUtils.isValidIdentifier((String)name.getLiteralName())) {
            name.setKind(PropertyNameKind.IDENTIFIER);
        }
    }

    private boolean isOfTypeStringInAST(Expression expressionInIM) {
        TypeRef typeRef;
        Expression expressionInAST = (Expression)this.getState().tracer.getOriginalASTNodeOfSameType((EObject)expressionInIM, false);
        if (expressionInAST != null && !((typeRef = this.ts.type(this.getState().G, (TypableElement)expressionInAST)) instanceof UnknownTypeRef)) {
            return this.ts.subtypeSucceeded(this.getState().G, (TypeArgument)typeRef, (TypeArgument)RuleEnvironmentExtensions.stringTypeRef((RuleEnvironment)this.getState().G));
        }
        return false;
    }
}

