/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.MultiCleartriggerCache;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.ui.internal.ProjectDescriptionLoadListener;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;

@Singleton
public class EclipseBasedN4JSWorkspace
extends InternalN4JSWorkspace {
    private final IWorkspaceRoot workspace;
    private final ProjectDescriptionLoader projectDescriptionLoader;
    private final MultiCleartriggerCache cache;
    private ProjectDescriptionLoadListener listener;

    @Inject
    public EclipseBasedN4JSWorkspace(IWorkspaceRoot workspace, ProjectDescriptionLoader projectDescriptionLoader, MultiCleartriggerCache cache) {
        this.workspace = workspace;
        this.projectDescriptionLoader = projectDescriptionLoader;
        this.cache = cache;
    }

    IWorkspaceRoot getWorkspace() {
        return this.workspace;
    }

    public URI findProjectWith(URI nestedLocation) {
        if (nestedLocation.isPlatformResource()) {
            return URI.createPlatformResourceURI((String)nestedLocation.segment(1), (boolean)true);
        }
        if (nestedLocation.isFile()) {
            String nested = nestedLocation.toString();
            IProject[] iProjectArray = this.workspace.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                URI projURI = URI.createFileURI((String)proj.getLocation().toFile().toString());
                String ps = projURI.toString();
                if (nested.startsWith(ps)) {
                    return projURI;
                }
                ++n2;
            }
        }
        return null;
    }

    public URI findProjectForName(String projectName) {
        if (projectName == null) {
            return null;
        }
        IProject[] iProjectArray = this.workspace.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            URI uri = URIUtils.convert((IResource)prj);
            String n4jsProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)uri);
            if (projectName.equals(n4jsProjectName)) {
                return uri;
            }
            ++n2;
        }
        return null;
    }

    public ProjectDescription getProjectDescription(URI location) {
        if (!location.isPlatformResource()) {
            return null;
        }
        ProjectDescriptionLoaderAndNotifier supplier = new ProjectDescriptionLoaderAndNotifier(location);
        ProjectDescription existing = (ProjectDescription)this.cache.get((Supplier)((Object)supplier), "PROJECT_DESCRIPTIONS", location);
        return existing;
    }

    public Collection<URI> getAllProjectLocations() {
        LinkedList<URI> prjLocations = new LinkedList<URI>();
        IProject[] iProjectArray = this.workspace.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            URI uri = URIUtils.convert((IResource)prj);
            prjLocations.add(uri);
            ++n2;
        }
        return prjLocations;
    }

    public URI getLocation(URI projectURI, ProjectReference projectReference) {
        String expectedEclipseProjectName;
        IProject existingProject;
        String expectedProjectName = projectReference.getProjectName();
        if (expectedProjectName != null && expectedProjectName.length() > 0 && (existingProject = this.workspace.getProject(expectedEclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)expectedProjectName))).isAccessible()) {
            return URI.createPlatformResourceURI((String)expectedEclipseProjectName, (boolean)true);
        }
        return null;
    }

    public UnmodifiableIterator<URI> getFolderIterator(URI folderLocation) {
        IFolder container;
        if (URIUtils.isPlatformResourceUriPointingToProject((URI)folderLocation)) {
            String n4jsProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)folderLocation);
            String eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)n4jsProjectName);
            container = this.workspace.getProject(eclipseProjectName);
        } else {
            container = this.workspace.getFolder((IPath)new Path(folderLocation.toPlatformString(true)));
        }
        if (container != null && container.exists()) {
            final LinkedList result = Lists.newLinkedList();
            try {
                container.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.getType() == 1) {
                            result.add(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true));
                        }
                        return resource.getType() != 2 || !resource.getName().equals("node_modules");
                    }
                });
                return Iterators.unmodifiableIterator(result.iterator());
            }
            catch (CoreException e) {
                return Iterators.unmodifiableIterator(result.iterator());
            }
        }
        return Iterators.unmodifiableIterator(Collections.emptyIterator());
    }

    public URI findArtifactInFolder(URI folderLocation, String folderRelativePath) {
        String folderLocationString = folderLocation.toPlatformString(true);
        if (folderLocationString != null) {
            IFile file;
            IFolder folder = this.workspace.getFolder((IPath)new Path(folderLocationString));
            String subPathStr = folderRelativePath.replace(File.separator, "/");
            Path subPath = new Path(subPathStr);
            IFile iFile = file = folder != null ? folder.getFile((IPath)subPath) : null;
            if (file != null && file.exists()) {
                return folderLocation.appendSegments(subPathStr.split("/"));
            }
        }
        return null;
    }

    void setProjectDescriptionLoadListener(ProjectDescriptionLoadListener listener) {
        this.listener = listener;
    }

    private class ProjectDescriptionLoaderAndNotifier
    implements MultiCleartriggerCache.CleartriggerSupplier<ProjectDescription> {
        final URI location;

        public ProjectDescriptionLoaderAndNotifier(URI location) {
            this.location = location;
        }

        public ProjectDescription get() {
            ProjectDescription pd = EclipseBasedN4JSWorkspace.this.projectDescriptionLoader.loadProjectDescriptionAtLocation(this.location);
            return pd;
        }

        public void postSupply() {
            if (EclipseBasedN4JSWorkspace.this.listener != null) {
                EclipseBasedN4JSWorkspace.this.listener.onDescriptionLoaded(this.location);
            }
        }
    }
}

