/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RuleApplicationTrace {
    private static final String DEEP_CLONING = "deep cloning of trace disabled";
    private static final Logger LOGGER = Logger.getLogger(RuleApplicationTrace.class);
    protected List<Object> trace = new ArrayList<Object>();

    public void addToTrace(Object traceElement) {
        if (traceElement != null) {
            this.trace.add(traceElement);
        }
    }

    public void addAsSubtrace(RuleApplicationTrace subTrace) {
        if (subTrace != null) {
            this.trace.add(subTrace);
        }
    }

    public void addObjectAsSubtrace(Object traceElement) {
        if (traceElement != null) {
            RuleApplicationTrace subTrace = new RuleApplicationTrace();
            subTrace.addToTrace(traceElement);
            this.trace.add(subTrace);
        }
    }

    public List<Object> getTrace() {
        return this.trace;
    }

    public boolean isEmpty() {
        return this.trace.isEmpty();
    }

    public RuleApplicationTrace snapshot() {
        return this.performSafeDeepCloning();
    }

    protected RuleApplicationTrace performSafeDeepCloning() {
        RuleApplicationTrace cloned = null;
        try {
            cloned = (RuleApplicationTrace)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            LOGGER.info((Object)DEEP_CLONING, (Throwable)e);
            return this;
        }
        catch (IllegalAccessException e) {
            LOGGER.info((Object)DEEP_CLONING, (Throwable)e);
            return this;
        }
        cloned.trace = new ArrayList<Object>();
        for (Object orig : this.trace) {
            if (orig instanceof RuleApplicationTrace) {
                cloned.trace.add(((RuleApplicationTrace)orig).performSafeDeepCloning());
                continue;
            }
            cloned.trace.add(orig);
        }
        return cloned;
    }
}

