/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.Result2;
import org.eclipse.xsemantics.runtime.Result3;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xsemantics.runtime.StringRepresentationPostProcessor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.PolymorphicDispatcher;

public class StringRepresentation {
    public static final String FAILED_REPRESENTATION = "failed";
    public static final String NULL_REPRESENTATION = "null";
    @Inject
    protected StringRepresentationPostProcessor postProcessor;
    private PolymorphicDispatcher<String> dispatcher = PolymorphicDispatcher.createForSingleTarget((String)"stringRep", (Object)this);

    public String string(Object object) {
        if (object == null) {
            return NULL_REPRESENTATION;
        }
        return (String)this.dispatcher.invoke(new Object[]{object});
    }

    public String stringIterable(Iterable iterable) {
        StringBuilder buffer = new StringBuilder();
        for (Object object : iterable) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.string(object));
        }
        return buffer.toString();
    }

    protected String quoted(String buffer) {
        return "'" + buffer + "'";
    }

    protected <T> String stringRep(Class<T> clazz) {
        return clazz.getSimpleName();
    }

    protected String stringRep(EClassifier eClassifier) {
        return eClassifier.getName();
    }

    protected String stringRep(Object value) {
        return value.toString();
    }

    protected String withType(String typeName, String s) {
        return String.valueOf(typeName) + " " + this.quoted(s);
    }

    protected String stringRep(EObject eObject) {
        return this.postProcessor.process(this.stringRepForEObjectNotProcessed(eObject));
    }

    protected String stringRepForEObjectNotProcessed(EObject eObject) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
        if (node != null) {
            return NodeModelUtils.getTokenText((INode)node);
        }
        return this.stringRepForEObject(eObject);
    }

    protected String stringRepForEObject(EObject eObject) {
        EClass eClass = eObject.eClass();
        EStructuralFeature nameFeature = eClass.getEStructuralFeature("name");
        String stringRepEClass = this.stringRep((EClassifier)eClass);
        if (nameFeature != null) {
            Object eGet = eObject.eGet(nameFeature);
            return this.withType(stringRepEClass, this.string(eGet));
        }
        EList eStructuralFeatures = eClass.getEStructuralFeatures();
        for (EStructuralFeature feature : eStructuralFeatures) {
            String rep = this.stringRepForEStructuralFeature(eObject, stringRepEClass, feature);
            if (rep == null) continue;
            return rep;
        }
        return stringRepEClass;
    }

    private String stringRepForEStructuralFeature(EObject eObject, String stringRepEClass, EStructuralFeature feature) {
        if (feature instanceof EAttribute) {
            Object eGet;
            EAttribute attribute = (EAttribute)feature;
            if ("EString".equals(attribute.getEType().getName()) && (eGet = eObject.eGet((EStructuralFeature)attribute)) != null) {
                return this.withType(stringRepEClass, this.string(eGet));
            }
        } else {
            Object ref = eObject.eGet(feature, true);
            if (ref != null) {
                return this.withType(stringRepEClass, this.string(ref));
            }
        }
        return null;
    }

    protected String stringRep(List list) {
        return "[" + this.stringIterable(list) + "]";
    }

    protected String stringRep(RuleEnvironment environment) {
        if (environment.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<Object, Object>> entrySet = environment.getEnvironment().entrySet();
        TreeSet<String> strings = new TreeSet<String>();
        for (Map.Entry<Object, Object> entry : entrySet) {
            strings.add(String.valueOf(this.string(entry.getKey())) + " <- " + this.string(entry.getValue()));
        }
        buffer.append(((Object)strings).toString());
        if (environment.getNext() != null) {
            buffer.append("::" + this.stringRep(environment.getNext()));
        }
        return buffer.toString();
    }

    protected String stringRep(Result<?> result) {
        return "Result " + (result.failed() ? FAILED_REPRESENTATION : this.string(result.getValue()));
    }

    protected String stringRep(Result2<?, ?> result) {
        return "Result2 " + (result.failed() ? FAILED_REPRESENTATION : String.valueOf(this.string(result.getFirst())) + ", " + this.string(result.getSecond()));
    }

    protected String stringRep(Result3<?, ?, ?> result) {
        return "Result3 " + (result.failed() ? FAILED_REPRESENTATION : String.valueOf(this.string(result.getFirst())) + ", " + this.string(result.getSecond()) + ", " + this.string(result.getThird()));
    }
}

