/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import java.util.Optional;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class XpectConsole {
    private final MessageConsole messageConsole;
    private static final int MSG_LOG = 0;
    private static final int MSG_INFORMATION = 1;
    private static final int MSG_WARNING = 2;
    private static final int MSG_SUCCESS = 3;
    private static final int MSG_ERROR = 4;

    XpectConsole(MessageConsole nonNullMessageConsole) {
        this.messageConsole = Optional.of(nonNullMessageConsole).get();
    }

    public void log(String message) {
        this.write(message, 0);
    }

    public void info(String message) {
        this.write(message, 1);
    }

    public void warn(String message) {
        this.write(message, 2);
    }

    public void success(String message) {
        this.write(message, 2);
    }

    public void error(String message) {
        this.write(message, 4);
    }

    private void write(final String msg, final int msgKind) {
        if (msg == null) {
            return;
        }
        this.messageConsole.activate();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XpectConsole.this.getNewMessageConsoleStream(msgKind).println(msg);
            }
        });
    }

    public void clear() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                XpectConsole.this.messageConsole.clearConsole();
            }
        });
    }

    private MessageConsoleStream getNewMessageConsoleStream(int msgKind) {
        int swtColorId = 2;
        switch (msgKind) {
            case 0: {
                swtColorId = 2;
                break;
            }
            case 1: {
                swtColorId = 16;
                break;
            }
            case 4: {
                swtColorId = 12;
                break;
            }
            case 2: {
                swtColorId = 8;
                break;
            }
            case 3: {
                swtColorId = 6;
                break;
            }
            default: {
                swtColorId = 2;
            }
        }
        MessageConsoleStream msgConsoleStream = this.messageConsole.newMessageStream();
        msgConsoleStream.setColor(Display.getCurrent().getSystemColor(swtColorId));
        return msgConsoleStream;
    }
}

