/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.migrations;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4idl.migrations.AndSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.ArrayTypeSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.ConstantSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.OrSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.n4js.n4idl.migrations.TypeSwitchCondition;
import org.eclipse.n4js.n4idl.migrations.TypeTypeCondition;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MigrationSwitchComputer {
    public SwitchCondition compute(TypeRef ref) throws UnhandledTypeRefException {
        boolean _isUnhandledBuiltInType;
        boolean _isParameterizedArrayTypeRef;
        boolean _matched = false;
        if (ref instanceof ParameterizedTypeRef && (_isParameterizedArrayTypeRef = this.isParameterizedArrayTypeRef((ParameterizedTypeRef)ref))) {
            _matched = true;
            TypeArgument _get = (TypeArgument)((ParameterizedTypeRef)ref).getTypeArgs().get(0);
            return SwitchCondition.arrayOf(this.compute((TypeRef)_get));
        }
        if (!_matched && ref instanceof ParameterizedTypeRef && (_isUnhandledBuiltInType = this.isUnhandledBuiltInType(((ParameterizedTypeRef)ref).getDeclaredType()))) {
            _matched = true;
            throw new UnhandledTypeRefException(ref);
        }
        if (!_matched && ref instanceof ParameterizedTypeRef) {
            _matched = true;
            return SwitchCondition.instanceOf(((ParameterizedTypeRef)ref).getDeclaredType());
        }
        if (!_matched && ref instanceof TypeTypeRef && ((TypeTypeRef)ref).getTypeArg() instanceof TypeRef && ((TypeRef)((TypeTypeRef)ref).getTypeArg()).getDeclaredType() != null) {
            _matched = true;
            TypeArgument _typeArg = ((TypeTypeRef)ref).getTypeArg();
            return SwitchCondition.type(((TypeRef)_typeArg).getDeclaredType());
        }
        throw new UnhandledTypeRefException(ref);
    }

    public TypeRef toSwitchRecognizableTypeRef(RuleEnvironment ruleEnv, TypeRef typeRef) throws UnhandledTypeRefException {
        SwitchCondition condition = this.compute(typeRef);
        return this.toTypeRef(ruleEnv, condition);
    }

    public TypeRef toTypeRef(RuleEnvironment ruleEnv, SwitchCondition condition) {
        return SwitchCondition2TypeRefConverter.toTypeRef(ruleEnv, condition);
    }

    private BuiltInTypeScope getBuiltInTypes(EObject context) {
        return BuiltInTypeScope.get((ResourceSet)context.eResource().getResourceSet());
    }

    private boolean isParameterizedArrayTypeRef(ParameterizedTypeRef typeRef) {
        return Objects.equal((Object)typeRef.getDeclaredType(), (Object)this.getBuiltInTypes((EObject)typeRef).getArrayType()) && typeRef.getTypeArgs().size() > 0 && typeRef.getTypeArgs().get(0) instanceof TypeRef;
    }

    private boolean isUnhandledBuiltInType(Type type) {
        return type != null && !(type instanceof PrimitiveType) && type instanceof TInterface && type.isProvidedByRuntime();
    }

    private static final class SwitchCondition2TypeRefConverter {
        private SwitchCondition2TypeRefConverter() {
        }

        public static TypeRef _toTypeRef(RuleEnvironment env, AndSwitchCondition condition) {
            Functions.Function1 _function = o -> SwitchCondition2TypeRefConverter.toTypeRef(env, o);
            return TypeUtils.createNonSimplifiedIntersectionType((Iterable)ListExtensions.map(condition.operands, (Functions.Function1)_function));
        }

        public static TypeRef _toTypeRef(RuleEnvironment env, OrSwitchCondition condition) {
            Functions.Function1 _function = o -> SwitchCondition2TypeRefConverter.toTypeRef(env, o);
            return TypeUtils.createNonSimplifiedUnionType((Iterable)ListExtensions.map(condition.operands, (Functions.Function1)_function));
        }

        public static TypeRef _toTypeRef(RuleEnvironment env, TypeSwitchCondition condition) {
            return TypeUtils.createTypeRef((Type)condition.type, (TypingStrategy)TypingStrategy.DEFAULT, (boolean)true, (TypeArgument[])new TypeArgument[0]);
        }

        public static TypeRef _toTypeRef(RuleEnvironment env, TypeTypeCondition condition) {
            return TypeUtils.createTypeTypeRef((Type)condition.type, (boolean)false);
        }

        public static TypeRef _toTypeRef(RuleEnvironment env, ConstantSwitchCondition condition) {
            return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.anyType(env), (TypeArgument[])new TypeArgument[0]);
        }

        public static TypeRef _toTypeRef(RuleEnvironment env, ArrayTypeSwitchCondition condition) {
            return RuleEnvironmentExtensions.arrayTypeRef(env, new TypeArgument[]{SwitchCondition2TypeRefConverter.toTypeRef(env, condition.elementTypeCondition)});
        }

        public static TypeRef toTypeRef(RuleEnvironment env, SwitchCondition condition) {
            if (condition instanceof AndSwitchCondition) {
                return SwitchCondition2TypeRefConverter._toTypeRef(env, (AndSwitchCondition)condition);
            }
            if (condition instanceof ArrayTypeSwitchCondition) {
                return SwitchCondition2TypeRefConverter._toTypeRef(env, (ArrayTypeSwitchCondition)condition);
            }
            if (condition instanceof ConstantSwitchCondition) {
                return SwitchCondition2TypeRefConverter._toTypeRef(env, (ConstantSwitchCondition)condition);
            }
            if (condition instanceof OrSwitchCondition) {
                return SwitchCondition2TypeRefConverter._toTypeRef(env, (OrSwitchCondition)condition);
            }
            if (condition instanceof TypeSwitchCondition) {
                return SwitchCondition2TypeRefConverter._toTypeRef(env, (TypeSwitchCondition)condition);
            }
            if (condition instanceof TypeTypeCondition) {
                return SwitchCondition2TypeRefConverter._toTypeRef(env, (TypeTypeCondition)condition);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(env, condition).toString());
        }
    }

    public static final class UnhandledTypeRefException
    extends Exception {
        public UnhandledTypeRefException(TypeRef typeRef) {
            super(String.format("The (sub-)expression %s cannot be handled by the TypeSwitch computer", typeRef.getTypeRefAsString()));
        }
    }
}

