/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.ASTProcessor;
import org.eclipse.n4js.postprocessing.AbstractProcessor;
import org.eclipse.n4js.postprocessing.PolyProcessor;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
class DestructureProcessor
extends AbstractProcessor {
    @Inject
    private ASTProcessor astProcessor;
    @Inject
    private PolyProcessor polyProcessor;

    DestructureProcessor() {
    }

    public void typeDestructuringPattern(RuleEnvironment G, EObject node, ASTMetaInfoCache cache, int indentLevel) {
        UnknownTypeRef _createUnknownTypeRef = TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
        Result _result = new Result((Object)_createUnknownTypeRef);
        cache.storeType((TypableElement)node, (Result<TypeRef>)_result);
        if (node instanceof ObjectLiteral) {
            Functions.Function1 _function = it -> it.getExpression();
            Functions.Function1 _function_1 = it -> this.polyProcessor.isResponsibleFor((TypableElement)it) && !this.polyProcessor.isEntryPoint((TypableElement)it);
            Consumer<Expression> _function_2 = it -> this.polyProcessor.inferType(G, (Expression)it, cache);
            IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)((ObjectLiteral)node).getPropertyAssignments(), PropertyNameValuePair.class), (Functions.Function1)_function)), (Functions.Function1)_function_1).forEach(_function_2);
            Procedures.Procedure1 _function_3 = dtr -> {
                Procedures.Procedure0 _function_4 = () -> EcoreUtil.replace((EObject)dtr, (EObject)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function_4, (Object[])new Object[]{dtr.eContainer()});
            };
            IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)((ObjectLiteral)node).getDefinedType().eAllContents(), DeferredTypeRef.class), (Procedures.Procedure1)_function_3);
            Consumer<PropertyAssignment> _function_4 = it -> {
                UnknownTypeRef _createUnknownTypeRef_1 = TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
                Result _result_1 = new Result((Object)_createUnknownTypeRef_1);
                cache.storeType((TypableElement)it, (Result<TypeRef>)_result_1);
            };
            ((ObjectLiteral)node).getPropertyAssignments().forEach(_function_4);
        }
        Functions.Function1 _function_5 = it -> it instanceof ObjectLiteral || it instanceof ArrayLiteral;
        Functions.Function1 _function_6 = it -> {
            Result<TypeRef> _typeFailSafe = cache.getTypeFailSafe((TypableElement)it);
            return _typeFailSafe == null;
        };
        Procedures.Procedure1 _function_7 = it -> {
            UnknownTypeRef _createUnknownTypeRef_1 = TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
            Result _result_1 = new Result((Object)_createUnknownTypeRef_1);
            cache.storeType((TypableElement)it, (Result<TypeRef>)_result_1);
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.filter((Iterator)node.eAllContents(), (Functions.Function1)_function_5), (Functions.Function1)_function_6), (Procedures.Procedure1)_function_7);
    }

    public Result<TypeRef> handleForwardReferenceWhileTypingDestructuringPattern(RuleEnvironment G, TypableElement node, ASTMetaInfoCache cache) {
        EObject parent = node.eContainer();
        boolean isCyclicForwardReference = cache.astNodesCurrentlyBeingTyped.contains(node);
        if (isCyclicForwardReference) {
            if (parent instanceof VariableBinding && ((VariableBinding)parent).getExpression() == node) {
                ParameterizedTypeRef _anyTypeRef = RuleEnvironmentExtensions.anyTypeRef(G);
                return new Result((Object)_anyTypeRef);
            }
            if (parent instanceof ForStatement && ((ForStatement)parent).getExpression() == node) {
                ParameterizedTypeRef _anyTypeRef_1 = RuleEnvironmentExtensions.anyTypeRef(G);
                return new Result((Object)_anyTypeRef_1);
            }
        }
        AbstractProcessor.log(0, "===START of other identifiable sub-tree");
        RuleEnvironment G_fresh = RuleEnvironmentExtensions.wrap(G);
        this.astProcessor.processSubtree(G_fresh, (EObject)node, cache, 0);
        cache.forwardProcessedSubTrees.add((EObject)node);
        AbstractProcessor.log(0, "===END of other identifiable sub-tree");
        return cache.getType(node);
    }

    public boolean isForwardReferenceWhileTypingDestructuringPattern(EObject obj) {
        if (obj instanceof Expression) {
            EObject parent = ((Expression)obj).eContainer();
            if (parent instanceof ForStatement) {
                return DestructureUtils.isTopOfDestructuringForStatement((EObject)parent);
            }
            if (parent instanceof AssignmentExpression) {
                return DestructureUtils.isTopOfDestructuringAssignment((EObject)parent);
            }
            return parent instanceof VariableBinding || parent instanceof BindingElement || parent instanceof VariableDeclaration && parent.eContainer() instanceof BindingElement;
        }
        return false;
    }
}

