/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.MemberFactory;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.xsemantics.runtime.RuleEnvironment;

public abstract class ComposedMemberFactory
implements MemberFactory {
    protected final ComposedMemberInfo cmi;
    protected final MemberFactory specialMemberFactory;
    protected final MemberType memberType;

    ComposedMemberFactory(ComposedMemberInfo cmi) {
        this.cmi = cmi;
        this.memberType = this.getNewMemberType();
        this.specialMemberFactory = this.memberType != null ? this.getMemberFactory() : null;
    }

    protected abstract MemberType getNewMemberType();

    protected abstract MemberFactory getMemberFactory();

    public boolean isEmpty() {
        return this.cmi.isEmpty();
    }

    @Override
    public TMember create(String name) {
        if (this.specialMemberFactory == null) {
            return null;
        }
        TMember composedMember = this.specialMemberFactory.create(name);
        composedMember.getConstituentMembers().addAll(this.getConstituentMembers());
        return composedMember;
    }

    protected boolean allTypeRefAreEqual() {
        N4JSTypeSystem ts = this.cmi.getTypeSystem();
        List<TypeRef> allTypeRefs = this.cmi.getTypeRefsOfMemberType(MemberType.METHOD, MemberType.FIELD, MemberType.GETTER, MemberType.SETTER);
        TypeRef siTypeRef = ts.createSimplifiedIntersection(allTypeRefs, this.cmi.getResource());
        for (TypeRef firstNonNullTypeRef : allTypeRefs) {
            if (firstNonNullTypeRef == null) continue;
            RuleEnvironment G = this.cmi.getRuleEnvironmentForTypeRef(firstNonNullTypeRef);
            boolean equalTypeRefs = ts.equaltypeSucceeded(G, (TypeArgument)firstNonNullTypeRef, (TypeArgument)siTypeRef);
            return equalTypeRefs;
        }
        return true;
    }
}

