/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.scoping.members.ComposedMemberInfoBuilder;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.Pair;

public class ComposedMemberInfo {
    private final boolean isWriteAccess;
    private final Resource resource;
    private final N4JSTypeSystem ts;
    private final List<ComposedMemberInfoBuilder.ToBeComposedMemberInfo> siblings;
    private boolean isInitialized = false;
    private boolean isEmpty = true;
    private boolean isSiblingMissing = false;
    private boolean hasMultipleMemberTypes = false;
    private boolean hasFieldMemberType = false;
    private boolean hasGetterMemberType = false;
    private boolean hasSetterMemberType = false;
    private boolean hasMethodMemberType = false;
    private boolean hasNonMethodMemberType = false;
    private boolean onlyMethodMemberTypes = true;
    private boolean onlyFieldMemberTypes = true;
    private boolean onlyGetterMemberTypes = true;
    private boolean onlySetterMemberTypes = true;
    private boolean hasReadOnlyField = false;
    private boolean onlyReadOnlyFields = true;
    private final boolean hasValidationProblem = false;
    private MemberAccessModifier accessibilityMin = MemberAccessModifier.PUBLIC;
    private MemberAccessModifier accessibilityMax = MemberAccessModifier.PRIVATE;
    private final Map<MemberType, List<TypeRef>> typeRefsMap = new HashMap<MemberType, List<TypeRef>>();
    private final List<TypeRef> typeRefs = new ArrayList<TypeRef>();
    private final List<TypeRef> methodTypeRefsVoid = new ArrayList<TypeRef>();
    private final List<TypeRef> methodTypeRefsNonVoid = new ArrayList<TypeRef>();
    private final Map<TypeRef, RuleEnvironment> typeRef2G = new HashMap<TypeRef, RuleEnvironment>();
    private final List<ComposedFParInfo> fParameters = new ArrayList<ComposedFParInfo>();
    private boolean isVariadicButLastFParIsDifferent = false;

    ComposedMemberInfo(boolean writeAccess, Resource resource, N4JSTypeSystem ts, List<ComposedMemberInfoBuilder.ToBeComposedMemberInfo> siblings) {
        this.isWriteAccess = writeAccess;
        this.resource = resource;
        this.ts = ts;
        this.siblings = new LinkedList<ComposedMemberInfoBuilder.ToBeComposedMemberInfo>();
        this.siblings.addAll(siblings);
    }

    private synchronized void initMemberAggregate() {
        if (this.isInitialized) {
            return;
        }
        this.isSiblingMissing = this.siblings.contains(null);
        MemberType lastMType = null;
        for (ComposedMemberInfoBuilder.ToBeComposedMemberInfo toBeComposedMemberInfo : this.siblings) {
            if (toBeComposedMemberInfo == null) continue;
            this.isEmpty = false;
            TMember member = toBeComposedMemberInfo.member;
            RuleEnvironment G = toBeComposedMemberInfo.G;
            boolean structFieldInitMode = toBeComposedMemberInfo.structFieldInitMode;
            lastMType = this.handleMemberTypes(lastMType, member, structFieldInitMode);
            this.handleReadOnlyField(member);
            this.handleAccessibility(member);
            this.handleTypeRefLists(member, G);
            this.handleFParameters(member, G);
        }
        LinkedList currVariadicAccumulated = new LinkedList();
        for (ComposedFParInfo fpAggr : this.fParameters) {
            this.initFParAggregate(fpAggr);
            currVariadicAccumulated.addAll(fpAggr.typeRefsVariadic);
            fpAggr.typeRefsVariadicAccumulated.addAll(currVariadicAccumulated);
        }
        this.handleIsVariadicButLastFParIsDifferent();
        this.handleValidationProblems();
        this.isInitialized = true;
    }

    private void initFParAggregate(ComposedFParInfo fpAggr) {
        for (Pair fpPair : fpAggr.fpSiblings) {
            TypeRef typeRefSubst;
            TFormalParameter tFpar = (TFormalParameter)fpPair.getKey();
            RuleEnvironment G = (RuleEnvironment)fpPair.getValue();
            String nextName = tFpar.getName();
            if (nextName != null && !fpAggr.names.contains(nextName)) {
                fpAggr.names.add(nextName);
            }
            if ((typeRefSubst = this.ts.substTypeVariablesInTypeRef(G, tFpar.getTypeRef())) != null && !(typeRefSubst instanceof UnknownTypeRef)) {
                TypeRef typeRefCopy = (TypeRef)TypeUtils.copyIfContained((EObject)typeRefSubst);
                fpAggr.typeRefs.add(typeRefCopy);
                if (tFpar.isVariadic()) {
                    fpAggr.typeRefsVariadic.add(typeRefCopy);
                }
            }
            ComposedFParInfo composedFParInfo = fpAggr;
            composedFParInfo.allOptional = composedFParInfo.allOptional & tFpar.isOptional();
            ComposedFParInfo composedFParInfo2 = fpAggr;
            composedFParInfo2.allNonOptional = composedFParInfo2.allNonOptional & !tFpar.isOptional();
        }
    }

    private MemberType handleMemberTypes(MemberType lastMType, TMember member, boolean isStructFieldInit) {
        MemberType currMType = member.getMemberType();
        if (isStructFieldInit && currMType == MemberType.SETTER) {
            currMType = MemberType.GETTER;
        }
        lastMType = lastMType == null ? currMType : lastMType;
        this.hasMultipleMemberTypes |= currMType != lastMType;
        this.hasFieldMemberType |= currMType == MemberType.FIELD;
        this.hasGetterMemberType |= currMType == MemberType.GETTER;
        this.hasSetterMemberType |= currMType == MemberType.SETTER;
        this.hasMethodMemberType |= currMType == MemberType.METHOD;
        this.hasNonMethodMemberType |= currMType != MemberType.METHOD;
        this.onlyMethodMemberTypes &= currMType == MemberType.METHOD;
        this.onlyFieldMemberTypes &= currMType == MemberType.FIELD;
        this.onlyGetterMemberTypes &= currMType == MemberType.GETTER;
        this.onlySetterMemberTypes &= currMType == MemberType.SETTER;
        lastMType = currMType;
        return lastMType;
    }

    private void handleReadOnlyField(TMember member) {
        boolean isReadOnlyField = false;
        if (member instanceof TField) {
            TField tField = (TField)member;
            isReadOnlyField = !tField.isWriteable();
        }
        this.hasReadOnlyField |= isReadOnlyField;
        this.onlyReadOnlyFields &= isReadOnlyField;
    }

    private void handleAccessibility(TMember member) {
        MemberAccessModifier currAccessibility = member.getMemberAccessModifier();
        if (this.accessibilityMax.getValue() < currAccessibility.getValue()) {
            this.accessibilityMax = currAccessibility;
        }
        if (this.accessibilityMin.getValue() > currAccessibility.getValue()) {
            this.accessibilityMin = currAccessibility;
        }
    }

    private void handleTypeRefLists(TMember member, RuleEnvironment G) {
        TypeRef typeRef = TypeUtils.getMemberTypeRef((TMember)member);
        TypeRef typeRefSubst = this.ts.substTypeVariablesInTypeRef(G, typeRef);
        if (typeRefSubst != null && !(typeRefSubst instanceof UnknownTypeRef)) {
            MemberType currMType;
            TypeRef typeRefCopy = (TypeRef)TypeUtils.copyIfContained((EObject)typeRefSubst);
            this.typeRefs.add(typeRefCopy);
            this.typeRef2G.put(typeRefCopy, G);
            if (member.getMemberType() == MemberType.METHOD) {
                if (TypeUtils.isVoid((TypeArgument)typeRefCopy)) {
                    this.methodTypeRefsVoid.add(typeRefCopy);
                } else {
                    this.methodTypeRefsNonVoid.add(typeRefCopy);
                }
            }
            if (!this.typeRefsMap.containsKey(currMType = member.getMemberType())) {
                this.typeRefsMap.put(currMType, new LinkedList());
            }
            List<TypeRef> typeRefsOfMemberType = this.typeRefsMap.get(currMType);
            typeRefsOfMemberType.add(typeRefCopy);
        }
    }

    private void handleFParameters(TMember member, RuleEnvironment G) {
        EList fpars = null;
        if (member instanceof TMethod) {
            TMethod method = (TMethod)member;
            fpars = method.getFpars();
        }
        if (member instanceof TSetter) {
            TSetter setter = (TSetter)member;
            fpars = new BasicEList();
            fpars.add((Object)setter.getFpar());
        }
        if (fpars != null) {
            int i = 0;
            while (i < fpars.size()) {
                TFormalParameter fpar = (TFormalParameter)fpars.get(i);
                if (this.fParameters.size() <= i) {
                    this.fParameters.add(new ComposedFParInfo());
                }
                ComposedFParInfo fpAggr = this.fParameters.get(i);
                Pair fpPair = new Pair((Object)fpar, (Object)G);
                fpAggr.fpSiblings.add(fpPair);
                ++i;
            }
        }
    }

    private void handleIsVariadicButLastFParIsDifferent() {
        boolean result = false;
        if (!this.fParameters.isEmpty()) {
            ComposedFParInfo lastFpar = this.fParameters.get(this.fParameters.size() - 1);
            List<TypeRef> variadics = lastFpar.getTypeRefsVariadicAccumulated();
            if (!lastFpar.allOptional() && !variadics.isEmpty()) {
                result = true;
            }
            block0: for (TypeRef lfpTypeRef : lastFpar.getTypeRefs()) {
                for (TypeRef variTypeRef : variadics) {
                    if (variTypeRef.getDeclaredType() == lfpTypeRef.getDeclaredType()) continue;
                    result = true;
                    continue block0;
                }
            }
        }
        this.isVariadicButLastFParIsDifferent = result;
    }

    private void handleValidationProblems() {
        for (ComposedMemberInfoBuilder.ToBeComposedMemberInfo toBeComposedMemberInfo : this.siblings) {
            TMember member;
            if (toBeComposedMemberInfo == null || !((member = toBeComposedMemberInfo.member) instanceof TMethod)) continue;
            TMethod tMethod = (TMethod)member;
            int i = 0;
            while (i < tMethod.getFpars().size()) {
                TFormalParameter currFP = (TFormalParameter)tMethod.getFpars().get(i);
                if (currFP.isVariadic() && tMethod.getFpars().size() > i + 1) {
                    ComposedFParInfo currFPA = this.fParameters.get(i);
                    currFPA.hasValidationProblem = true;
                    return;
                }
                ++i;
            }
        }
    }

    public N4JSTypeSystem getTypeSystem() {
        return this.ts;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isEmpty() {
        this.initMemberAggregate();
        return this.isEmpty;
    }

    public boolean isWriteAccess() {
        return this.isWriteAccess;
    }

    public boolean isSiblingMissing() {
        this.initMemberAggregate();
        return this.isSiblingMissing;
    }

    public boolean hasMultipleMemberTypes() {
        this.initMemberAggregate();
        return this.hasMultipleMemberTypes;
    }

    public boolean hasFieldMemberType() {
        this.initMemberAggregate();
        return this.hasFieldMemberType;
    }

    public boolean hasGetterMemberType() {
        this.initMemberAggregate();
        return this.hasGetterMemberType;
    }

    public boolean hasSetterMemberType() {
        this.initMemberAggregate();
        return this.hasSetterMemberType;
    }

    public boolean hasMethodMemberType() {
        this.initMemberAggregate();
        return this.hasMethodMemberType;
    }

    public boolean hasNonMethodMemberType() {
        this.initMemberAggregate();
        return this.hasNonMethodMemberType;
    }

    public boolean onlyMethodMemberTypes() {
        this.initMemberAggregate();
        return this.onlyMethodMemberTypes;
    }

    public boolean onlyFieldMemberTypes() {
        this.initMemberAggregate();
        return this.onlyFieldMemberTypes;
    }

    public boolean onlyGetterMemberTypes() {
        this.initMemberAggregate();
        return this.onlyGetterMemberTypes;
    }

    public boolean onlySetterMemberTypes() {
        this.initMemberAggregate();
        return this.onlySetterMemberTypes;
    }

    public boolean hasReadOnlyField() {
        this.initMemberAggregate();
        return this.hasReadOnlyField;
    }

    public boolean onlyReadOnlyFields() {
        this.initMemberAggregate();
        return this.onlyReadOnlyFields;
    }

    public MemberAccessModifier getAccessabilityMin() {
        this.initMemberAggregate();
        return this.accessibilityMin;
    }

    public MemberAccessModifier getAccessabilityMax() {
        this.initMemberAggregate();
        return this.accessibilityMax;
    }

    public boolean hasValidationProblem() {
        this.initMemberAggregate();
        return false;
    }

    public List<TypeRef> getTypeRefsOfMemberType(MemberType ... memberTypes) {
        this.initMemberAggregate();
        LinkedList<TypeRef> resultTypeRefs = new LinkedList<TypeRef>();
        if (memberTypes == null) {
            for (List<TypeRef> franzLiszt : this.typeRefsMap.values()) {
                resultTypeRefs.addAll(franzLiszt);
            }
            return resultTypeRefs;
        }
        MemberType[] memberTypeArray = memberTypes;
        int n = memberTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MemberType memberType = memberTypeArray[n2];
            if (this.typeRefsMap.containsKey(memberType)) {
                resultTypeRefs.addAll((Collection<TypeRef>)this.typeRefsMap.get(memberType));
            }
            ++n2;
        }
        return resultTypeRefs;
    }

    public List<TypeRef> getMethodTypeRefsNonVoid() {
        this.initMemberAggregate();
        return this.methodTypeRefsNonVoid;
    }

    public List<TypeRef> getMethodTypeRefsVoid() {
        this.initMemberAggregate();
        return this.methodTypeRefsVoid;
    }

    public RuleEnvironment getRuleEnvironmentForTypeRef(TypeRef typeRef) {
        this.initMemberAggregate();
        return this.typeRef2G.get(typeRef);
    }

    public List<ComposedFParInfo> getFParAggregates() {
        this.initMemberAggregate();
        return this.fParameters;
    }

    public boolean isVariadicButLastFParIsDifferent() {
        this.initMemberAggregate();
        return this.isVariadicButLastFParIsDifferent;
    }

    public List<TMember> getConstituentMembers() {
        this.initMemberAggregate();
        return this.siblings.stream().filter(Objects::nonNull).map(sibling -> sibling.member).collect(Collectors.toList());
    }

    public static class ComposedFParInfo {
        private final List<Pair<TFormalParameter, RuleEnvironment>> fpSiblings = new ArrayList<Pair<TFormalParameter, RuleEnvironment>>();
        private final List<String> names = new LinkedList<String>();
        private boolean allOptional = true;
        private boolean allNonOptional = true;
        private boolean hasValidationProblem = false;
        private final List<TypeRef> typeRefs = new ArrayList<TypeRef>();
        private final List<TypeRef> typeRefsVariadic = new ArrayList<TypeRef>();
        private final List<TypeRef> typeRefsVariadicAccumulated = new ArrayList<TypeRef>();

        public String getName() {
            return Joiner.on((String)"_").join(this.names);
        }

        public boolean allOptional() {
            return this.allOptional;
        }

        public boolean allNonOptional() {
            return this.allNonOptional;
        }

        public boolean hasValidationProblem() {
            return this.hasValidationProblem;
        }

        public List<TypeRef> getTypeRefs() {
            return this.typeRefs;
        }

        public List<TypeRef> getTypeRefsVariadic() {
            return this.typeRefsVariadic;
        }

        public List<TypeRef> getTypeRefsVariadicAccumulated() {
            return this.typeRefsVariadicAccumulated;
        }
    }
}

