/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.xsemantics.runtime.RuleEnvironment;

public class ComposedMemberInfoBuilder {
    private boolean writeAccess;
    private Resource resource;
    private N4JSTypeSystem ts;
    private List<ToBeComposedMemberInfo> siblings;

    public void init(boolean writeAccess, Resource resource, N4JSTypeSystem ts) {
        Objects.isNull(this.siblings);
        this.writeAccess = writeAccess;
        this.resource = resource;
        this.ts = ts;
        this.siblings = new LinkedList<ToBeComposedMemberInfo>();
    }

    public void addMember(TMember member, RuleEnvironment G, boolean structFieldInitMode) {
        Objects.nonNull(this.siblings);
        ToBeComposedMemberInfo info = null;
        if (member != null) {
            info = new ToBeComposedMemberInfo(member, G, structFieldInitMode);
        }
        this.siblings.add(info);
    }

    public ComposedMemberInfo get() {
        ComposedMemberInfo cmi = new ComposedMemberInfo(this.writeAccess, this.resource, this.ts, this.siblings);
        return cmi;
    }

    public static final class ToBeComposedMemberInfo {
        final TMember member;
        final RuleEnvironment G;
        final boolean structFieldInitMode;

        public ToBeComposedMemberInfo(TMember member, RuleEnvironment G, boolean structFieldInitMode) {
            this.member = member;
            this.G = G;
            this.structFieldInitMode = structFieldInitMode;
        }
    }
}

