/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.n4js.typesystem.TypeSystemHelperStrategy;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

@Singleton
public class SubtypeComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public boolean isSubtypeFunction(RuleEnvironment G, FunctionTypeExprOrRef left, FunctionTypeExprOrRef right) {
        boolean _not;
        int _size_1;
        boolean _tripleNotEquals;
        EList leftTypeVars = left.getTypeVars();
        EList rightTypeVars = right.getTypeVars();
        if (leftTypeVars.isEmpty() && rightTypeVars.isEmpty()) {
            return this.primIsSubtypeFunction(G, left, right);
        }
        if (!leftTypeVars.isEmpty() && rightTypeVars.isEmpty()) {
            CancelIndicator _cancelIndicator = RuleEnvironmentExtensions.getCancelIndicator(G);
            InferenceContext infCtx = new InferenceContext(this.ts, this.tsh, this.operationCanceledManager, _cancelIndicator, G, new InferenceVariable[0]);
            FunctionTypeExprOrRef left_withInfVars = infCtx.newInferenceVariablesFor(left);
            infCtx.addConstraint((TypeArgument)left_withInfVars, (TypeArgument)right, Variance.CO);
            Map<InferenceVariable, TypeRef> solution = infCtx.solve();
            if (solution != null) {
                RuleEnvironment G_solution = RuleEnvironmentExtensions.newRuleEnvironment(G);
                Consumer<Map.Entry> _function = it -> RuleEnvironmentExtensions.addTypeMapping(G_solution, (TypeVariable)it.getKey(), (TypeArgument)it.getValue());
                solution.entrySet().forEach(_function);
                TypeRef leftSubst = this.ts.substTypeVariablesInTypeRef(G_solution, (TypeRef)left_withInfVars);
                if (leftSubst instanceof FunctionTypeExprOrRef) {
                    return this.primIsSubtypeFunction(G, (FunctionTypeExprOrRef)leftSubst, right);
                }
            }
            return false;
        }
        int _size = leftTypeVars.size();
        boolean bl = _tripleNotEquals = _size != (_size_1 = rightTypeVars.size());
        if (_tripleNotEquals) {
            return false;
        }
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
        int _size_2 = leftTypeVars.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_2, true);
        for (Integer i : _doubleDotLessThan) {
            RuleEnvironmentExtensions.addTypeMapping(G2, (TypeVariable)rightTypeVars.get(i.intValue()), (TypeArgument)TypeUtils.createTypeRef((Type)((Type)leftTypeVars.get(i.intValue())), (TypeArgument[])new TypeArgument[0]));
        }
        TypeRef rightSubst = this.ts.substTypeVariablesInTypeRef(G2, (TypeRef)right);
        boolean bl2 = _not = !(rightSubst instanceof FunctionTypeExprOrRef) || !this.primIsSubtypeFunction(G, left, (FunctionTypeExprOrRef)rightSubst);
        if (_not) {
            return false;
        }
        Type _declaredType = left.getDeclaredType();
        EObject _eContainer = null;
        if (_declaredType != null) {
            _eContainer = _declaredType.eContainer();
        }
        if (_eContainer instanceof TClassifier) {
            EObject _eContainer_1 = left.getDeclaredType().eContainer();
            this._typeSystemHelper.addSubstitutions(G2, (TypeRef)TypeUtils.createTypeRef((Type)((TClassifier)_eContainer_1), (TypeArgument[])new TypeArgument[0]));
        }
        return this.isMatchingTypeVariableBounds(G2, (List<TypeVariable>)leftTypeVars, (List<TypeVariable>)rightTypeVars);
    }

    private boolean primIsSubtypeFunction(RuleEnvironment G, FunctionTypeExprOrRef left, FunctionTypeExprOrRef right) {
        boolean _isSubtype_1;
        TFormalParameter R;
        int n;
        int k;
        TypeRef leftReturnTypeRef = left.getReturnTypeRef();
        TypeRef rightReturnTypeRef = right.getReturnTypeRef();
        if (rightReturnTypeRef != null) {
            VoidType _voidType;
            boolean _tripleNotEquals;
            Type _declaredType = rightReturnTypeRef.getDeclaredType();
            boolean bl = _tripleNotEquals = _declaredType != (_voidType = RuleEnvironmentExtensions.voidType(G));
            if (_tripleNotEquals) {
                boolean _tripleNotEquals_1;
                Type rightFunType = right.getDeclaredType();
                boolean _xifexpression = false;
                _xifexpression = rightFunType instanceof TFunction ? ((TFunction)rightFunType).isReturnValueOptional() : right.isReturnValueOptional();
                boolean isRightReturnOptional = _xifexpression;
                Type _declaredType_1 = leftReturnTypeRef.getDeclaredType();
                VoidType _voidType_1 = RuleEnvironmentExtensions.voidType(G);
                boolean bl2 = _tripleNotEquals_1 = _declaredType_1 != _voidType_1;
                if (_tripleNotEquals_1) {
                    boolean _not;
                    if (left.isReturnValueOptional() && !isRightReturnOptional) {
                        return false;
                    }
                    boolean _isSubtype = this.isSubtype(G, (TypeArgument)leftReturnTypeRef, (TypeArgument)rightReturnTypeRef);
                    boolean bl3 = _not = !_isSubtype;
                    if (_not) {
                        return false;
                    }
                } else if (!isRightReturnOptional && !this.ts.equaltypeSucceeded(G, (TypeArgument)rightReturnTypeRef, (TypeArgument)RuleEnvironmentExtensions.undefinedTypeRef(G))) {
                    return false;
                }
            }
        }
        if ((k = left.getFpars().size()) <= (n = right.getFpars().size())) {
            if (k > 0) {
                int i = 0;
                while (i < k) {
                    boolean _not_1;
                    R = (TFormalParameter)right.getFpars().get(i);
                    TFormalParameter L = (TFormalParameter)left.getFpars().get(i);
                    if ((R.isVariadic() || R.isOptional()) && !L.isOptional() && !L.isVariadic()) {
                        return false;
                    }
                    _isSubtype_1 = this.isSubtype(G, (TypeArgument)R.getTypeRef(), (TypeArgument)L.getTypeRef());
                    boolean bl = _not_1 = !_isSubtype_1;
                    if (_not_1) {
                        return false;
                    }
                    ++i;
                }
                TFormalParameter L = (TFormalParameter)left.getFpars().get(k - 1);
                boolean _isVariadic = L.isVariadic();
                if (_isVariadic) {
                    while (i < n) {
                        boolean _not_1;
                        TFormalParameter R2 = (TFormalParameter)right.getFpars().get(i);
                        boolean _isSubtype_12 = this.isSubtype(G, (TypeArgument)R2.getTypeRef(), (TypeArgument)L.getTypeRef());
                        boolean bl = _not_1 = !_isSubtype_12;
                        if (_not_1) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
        } else {
            int i_1 = 0;
            while (i_1 < n) {
                boolean _not_1;
                R = (TFormalParameter)right.getFpars().get(i_1);
                TFormalParameter L_1 = (TFormalParameter)left.getFpars().get(i_1);
                if ((R.isVariadic() || R.isOptional()) && !L_1.isOptional() && !L_1.isVariadic()) {
                    return false;
                }
                _isSubtype_1 = this.isSubtype(G, (TypeArgument)R.getTypeRef(), (TypeArgument)L_1.getTypeRef());
                boolean bl = _not_1 = !_isSubtype_1;
                if (_not_1) {
                    return false;
                }
                ++i_1;
            }
            TFormalParameter _xifexpression_1 = null;
            _xifexpression_1 = n > 0 ? (TFormalParameter)right.getFpars().get(n - 1) : null;
            TFormalParameter R3 = _xifexpression_1;
            while (i_1 < k) {
                boolean _not_1;
                TFormalParameter L_1 = (TFormalParameter)left.getFpars().get(i_1);
                boolean bl = _not_1 = !L_1.isOptional() && !L_1.isVariadic();
                if (_not_1) {
                    return false;
                }
                if (R3 != null && R3.isVariadic()) {
                    boolean _not_2;
                    boolean _isSubtype_13 = this.isSubtype(G, (TypeArgument)R3.getTypeRef(), (TypeArgument)L_1.getTypeRef());
                    boolean bl4 = _not_2 = !_isSubtype_13;
                    if (_not_2) {
                        return false;
                    }
                }
                ++i_1;
            }
        }
        TypeRef rThis = right.getDeclaredThisType();
        TypeRef lThis = left.getDeclaredThisType();
        if (rThis != null) {
            return lThis == null || this.isSubtype(G, (TypeArgument)rThis, (TypeArgument)lThis);
        }
        return lThis == null;
    }

    private boolean isMatchingTypeVariableBounds(RuleEnvironment G, List<TypeVariable> left, List<TypeVariable> right) {
        int i = 0;
        while (i < right.size()) {
            boolean _not;
            TypeVariable leftTypeVar = left.get(i);
            TypeVariable rightTypeVar = right.get(i);
            TypeRef leftDeclUB = leftTypeVar.getDeclaredUpperBound();
            TypeRef rightDeclUB = rightTypeVar.getDeclaredUpperBound();
            TypeRef _xifexpression = null;
            _xifexpression = leftDeclUB == null ? N4JSLanguageUtils.getTypeVariableImplicitUpperBound(G) : leftDeclUB;
            TypeRef leftUpperBound = _xifexpression;
            TypeRef _xifexpression_1 = null;
            _xifexpression_1 = rightDeclUB == null ? N4JSLanguageUtils.getTypeVariableImplicitUpperBound(G) : rightDeclUB;
            TypeRef rightUpperBound = _xifexpression_1;
            TypeRef rightUpperBoundSubst = this.ts.substTypeVariablesInTypeRef(G, rightUpperBound);
            boolean _isSubtype = this.isSubtype(G, (TypeArgument)rightUpperBoundSubst, (TypeArgument)leftUpperBound);
            boolean bl = _not = !_isSubtype;
            if (_not) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSubtype(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        Boolean _elvis = null;
        Boolean _value = (Boolean)this.ts.subtype(G, left, right).getValue();
        _elvis = _value != null ? _value : Boolean.valueOf(false);
        return _elvis;
    }
}

