/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xsemantics.runtime.RuleFailedException;

public class TypeSystemErrorExtensions {
    public static final Object PRIORITY_ERROR = new Object();

    public static final boolean isPriorityError(RuleFailedException e) {
        return e.getErrorInformations().stream().anyMatch(info -> info.getData() == PRIORITY_ERROR);
    }

    public static final boolean isOrCausedByPriorityError(RuleFailedException e) {
        return TypeSystemErrorExtensions.getFailureChainAsList(e).stream().anyMatch(currE -> TypeSystemErrorExtensions.isPriorityError(currE));
    }

    public static final String compileMessage(RuleFailedException ex) {
        ArrayList<String> prioMsgs = new ArrayList<String>();
        Object curr = ex;
        while (curr instanceof RuleFailedException) {
            if (((Throwable)curr).getMessage() != null && TypeSystemErrorExtensions.isPriorityError((RuleFailedException)curr)) {
                prioMsgs.add(TypeSystemErrorExtensions.prepareMessage(((Throwable)curr).getMessage()));
            }
            curr = ((Throwable)curr).getCause();
        }
        return !prioMsgs.isEmpty() ? Joiner.on((String)"\nCaused by:\n").join(prioMsgs) : TypeSystemErrorExtensions.prepareMessage(ex.getMessage());
    }

    private static final String prepareMessage(String message) {
        String result = message;
        if (!(result = UtilN4.trimPrefix((String)result, (String[])new String[]{"failed: "})).endsWith(".")) {
            result = String.valueOf(result) + ".";
        }
        return result;
    }

    private static final List<RuleFailedException> getFailureChainAsList(RuleFailedException e) {
        LinkedList<RuleFailedException> result = new LinkedList<RuleFailedException>();
        RuleFailedException curr = e;
        while (curr != null) {
            if (curr.getMessage() != null) {
                result.add(curr);
            }
            curr = curr.getPrevious();
        }
        return result;
    }
}

