/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.constraints;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.typesystem.constraints.TypeBound;
import org.eclipse.n4js.typesystem.constraints.TypeConstraint;
import org.eclipse.xsemantics.runtime.RuleEnvironment;

final class BoundSet {
    private static final boolean DEBUG = false;
    private final InferenceContext ic;
    private final RuleEnvironment G;
    private final N4JSTypeSystem ts;
    private final SetMultimap<InferenceVariable, TypeBound> boundsPerInfVar = LinkedHashMultimap.create();
    private final Map<InferenceVariable, TypeRef> instantiations = new LinkedHashMap<InferenceVariable, TypeRef>();
    private final Set<TypeBound> incorporatedBounds = new HashSet<TypeBound>();
    private boolean haveBoundFALSE;
    private boolean haveRawTypeRef;

    public BoundSet(InferenceContext ic, RuleEnvironment G, N4JSTypeSystem ts) {
        this.ic = ic;
        this.G = G;
        this.ts = ts;
    }

    public boolean hasBoundFALSE() {
        return this.haveBoundFALSE;
    }

    public int size() {
        return this.boundsPerInfVar.size();
    }

    public TypeBound[] getAllBounds() {
        Collection allBounds = this.boundsPerInfVar.values();
        return allBounds.toArray(new TypeBound[allBounds.size()]);
    }

    public Set<TypeBound> getBounds(InferenceVariable infVar) {
        return this.boundsPerInfVar.get((Object)infVar);
    }

    public boolean isBounded(InferenceVariable infVar) {
        return this.boundsPerInfVar.containsKey((Object)infVar);
    }

    public boolean isUnbounded(InferenceVariable infVar) {
        return !this.boundsPerInfVar.containsKey((Object)infVar);
    }

    public boolean addBound(boolean b) {
        if (!b && !this.haveBoundFALSE) {
            this.haveBoundFALSE = true;
            return true;
        }
        return false;
    }

    public boolean addBound(TypeBound bound) {
        if (bound.isTrivial()) {
            return false;
        }
        boolean wasAdded = this.internal_addBound(bound);
        return wasAdded;
    }

    private boolean internal_addBound(TypeBound bound) {
        boolean wasAdded = this.boundsPerInfVar.put((Object)bound.left, (Object)bound);
        if (wasAdded) {
            if (TypeUtils.isRawTypeRef((TypeRef)bound.right)) {
                this.haveRawTypeRef = true;
            }
            if (bound.variance == Variance.INV && TypeUtils.isProper((TypeArgument)bound.right) && !TypeUtils.isRawTypeRef((TypeRef)bound.right)) {
                this.instantiations.put(bound.left, bound.right);
            }
        }
        return wasAdded;
    }

    private void removeBound(TypeBound bound) {
        this.boundsPerInfVar.remove((Object)bound.left, (Object)bound);
        this.incorporatedBounds.remove(bound);
    }

    public Map<InferenceVariable, TypeRef> getInstantiations() {
        return ImmutableMap.copyOf(this.instantiations);
    }

    public TypeRef[] collectLowerBounds(InferenceVariable infVar, boolean onlyProper, boolean resolveRawTypes) {
        return this.collectBounds(infVar, onlyProper, resolveRawTypes, b -> !(b.variance != Variance.CONTRA && b.variance != Variance.INV || b.variance == Variance.CONTRA && b.right.isBottomType()));
    }

    public TypeRef[] collectUpperBounds(InferenceVariable infVar, boolean onlyProper, boolean resolveRawTypes) {
        return this.collectBounds(infVar, onlyProper, resolveRawTypes, b -> !(b.variance != Variance.CO && b.variance != Variance.INV || b.variance == Variance.CO && b.right.isTopType()));
    }

    private TypeRef[] collectBounds(InferenceVariable infVar, boolean onlyProper, boolean resolveRawTypes, Predicate<? super TypeBound> predicate) {
        Set<TypeBound> bounds = resolveRawTypes ? this.resolveRawTypes(this.getBounds(infVar)) : this.getBounds(infVar);
        Stream<TypeRef> result = bounds.stream().filter(predicate).map(b -> b.right);
        if (onlyProper) {
            result = result.filter(t -> TypeUtils.isProper((TypeArgument)t));
        }
        return (TypeRef[])result.toArray(TypeRef[]::new);
    }

    private Set<TypeBound> resolveRawTypes(Set<TypeBound> typeBounds) {
        if (!this.haveRawTypeRef) {
            return typeBounds;
        }
        if (typeBounds.isEmpty()) {
            return typeBounds;
        }
        ArrayList<TypeBound> result = new ArrayList<TypeBound>(typeBounds);
        HashSet<Type> genTypesWithNonRawTypeRefs = new HashSet<Type>();
        HashSet<TypeBound> boundsWithRawTypeRef = new HashSet<TypeBound>();
        for (TypeBound tb : result) {
            ParameterizedTypeRef ptr;
            Type declType;
            if (!(tb.right instanceof ParameterizedTypeRef) || (declType = (ptr = (ParameterizedTypeRef)tb.right).getDeclaredType()) == null || !declType.isGeneric()) continue;
            boolean isRaw = TypeUtils.isRawTypeRef((TypeRef)ptr);
            if (isRaw) {
                boundsWithRawTypeRef.add(tb);
                continue;
            }
            genTypesWithNonRawTypeRefs.add(declType);
        }
        for (TypeBound currTB : boundsWithRawTypeRef) {
            if (!genTypesWithNonRawTypeRefs.contains(currTB.right.getDeclaredType())) continue;
            result.remove(currTB);
        }
        int len = result.size();
        int i = 0;
        while (i < len) {
            result.set(i, ((TypeBound)result.get(i)).sanitizeRawTypeRef());
            ++i;
        }
        return new LinkedHashSet<TypeBound>(result);
    }

    public boolean isInstantiated(InferenceVariable infVar) {
        return infVar != null && this.instantiations.containsKey(infVar);
    }

    public boolean dependsOnResolutionOf(InferenceVariable infVar, InferenceVariable candidate) {
        for (TypeBound currBound : this.getBounds(infVar)) {
            if (!TypeUtils.isOrContainsRefToTypeVar((EObject)currBound.right, (TypeVariable[])new TypeVariable[]{candidate})) continue;
            return true;
        }
        return false;
    }

    public void dumpInstantiations() {
        for (Map.Entry<InferenceVariable, TypeRef> e : this.instantiations.entrySet()) {
            this.log(String.valueOf(String.valueOf(e.getKey().getTypeAsString())) + " -> " + e.getValue().getTypeRefAsString());
        }
    }

    public void incorporate() {
        boolean updated;
        do {
            updated = false;
            TypeBound[] bounds = this.getAllBounds();
            int len = bounds.length;
            if (len < 2) {
                return;
            }
            int i = 0;
            while (i < len) {
                TypeBound boundI = bounds[i];
                boolean isIncorporatedI = this.incorporatedBounds.contains(boundI);
                int j = i + 1;
                while (j < len) {
                    boolean bothAlreadyIncorporated;
                    TypeBound boundJ = bounds[j];
                    boolean isIncorporatedJ = this.incorporatedBounds.contains(boundJ);
                    boolean bl = bothAlreadyIncorporated = isIncorporatedI && isIncorporatedJ;
                    if (!bothAlreadyIncorporated) {
                        TypeConstraint newConstraint = this.combine(boundI, boundJ);
                        if (newConstraint != null) {
                            updated |= this.ic.reducer.reduce(newConstraint);
                        }
                        if (this.ic.isDoomed()) {
                            return;
                        }
                    }
                    ++j;
                }
                if (!isIncorporatedI) {
                    this.incorporatedBounds.add(boundI);
                }
                ++i;
            }
        } while (updated);
    }

    private TypeConstraint combine(TypeBound boundI, TypeBound boundJ) {
        switch (boundI.variance) {
            case INV: {
                switch (boundJ.variance) {
                    case INV: {
                        return this.combineInvInv(boundI, boundJ);
                    }
                    case CO: 
                    case CONTRA: {
                        return this.combineInvVar(boundI, boundJ);
                    }
                }
                break;
            }
            case CO: {
                switch (boundJ.variance) {
                    case INV: {
                        return this.combineInvVar(boundJ, boundI);
                    }
                    case CONTRA: {
                        return this.combineContraCo(boundJ, boundI);
                    }
                    case CO: {
                        return this.combineBothCoOrBothContra(boundI, boundJ);
                    }
                }
                break;
            }
            case CONTRA: {
                switch (boundJ.variance) {
                    case INV: {
                        return this.combineInvVar(boundJ, boundI);
                    }
                    case CO: {
                        return this.combineContraCo(boundI, boundJ);
                    }
                    case CONTRA: {
                        return this.combineBothCoOrBothContra(boundI, boundJ);
                    }
                }
            }
        }
        throw new IllegalStateException("unreachable");
    }

    private TypeConstraint combineInvInv(TypeBound boundS, TypeBound boundT) {
        if (boundS.left == boundT.left) {
            return new TypeConstraint((TypeArgument)boundS.right, (TypeArgument)boundT.right, Variance.INV);
        }
        TypeConstraint newConstraint = this.combineInvInvWithProperType(boundS, boundT);
        if (newConstraint != null) {
            return newConstraint;
        }
        newConstraint = this.combineInvInvWithProperType(boundT, boundS);
        if (newConstraint != null) {
            return newConstraint;
        }
        return null;
    }

    private TypeConstraint combineInvInvWithProperType(TypeBound boundWithProperRHS, TypeBound boundOther) {
        InferenceVariable alpha = boundWithProperRHS.left;
        TypeRef U = boundWithProperRHS.right;
        TypeRef T = boundOther.right;
        if (TypeUtils.isProper((TypeArgument)U) && TypeUtils.getReferencedTypeVars((EObject)T).contains(alpha)) {
            InferenceVariable beta = boundOther.left;
            TypeRef T_subst = this.substituteInferenceVariable(T, alpha, (TypeArgument)U);
            this.removeBound(boundOther);
            return new TypeConstraint((TypeArgument)BoundSet.typeRef(beta), (TypeArgument)T_subst, Variance.INV);
        }
        return null;
    }

    private TypeConstraint combineInvVar(TypeBound boundS, TypeBound boundT) {
        InferenceVariable alpha = boundS.left;
        InferenceVariable beta = boundT.left;
        TypeRef S = boundS.right;
        TypeRef T = boundT.right;
        Variance Phi = boundT.variance;
        if (alpha == beta) {
            return new TypeConstraint((TypeArgument)S, (TypeArgument)T, Phi);
        }
        if (alpha == T.getDeclaredType()) {
            return new TypeConstraint((TypeArgument)BoundSet.typeRef(beta), (TypeArgument)S, Phi);
        }
        if (TypeUtils.isInferenceVariable((TypeRef)S)) {
            InferenceVariable gamma = (InferenceVariable)S.getDeclaredType();
            if (gamma == beta) {
                return new TypeConstraint((TypeArgument)BoundSet.typeRef(alpha), (TypeArgument)T, Phi);
            }
            if (gamma == T.getDeclaredType()) {
                return new TypeConstraint((TypeArgument)BoundSet.typeRef(beta), (TypeArgument)BoundSet.typeRef(alpha), Phi);
            }
        }
        if (TypeUtils.isProper((TypeArgument)S) && TypeUtils.getReferencedTypeVars((EObject)T).contains(alpha)) {
            TypeRef T_subst = this.substituteInferenceVariable(T, alpha, (TypeArgument)S);
            this.removeBound(boundT);
            return new TypeConstraint((TypeArgument)BoundSet.typeRef(beta), (TypeArgument)T_subst, Phi);
        }
        return null;
    }

    private TypeConstraint combineContraCo(TypeBound boundS, TypeBound boundT) {
        InferenceVariable gamma;
        InferenceVariable alpha = boundS.left;
        InferenceVariable beta = boundT.left;
        TypeRef S = boundS.right;
        TypeRef T = boundT.right;
        if (alpha == beta) {
            return new TypeConstraint((TypeArgument)S, (TypeArgument)T, Variance.CO);
        }
        if (TypeUtils.isInferenceVariable((TypeRef)S) && (gamma = (InferenceVariable)S.getDeclaredType()) == T.getDeclaredType()) {
            return new TypeConstraint((TypeArgument)BoundSet.typeRef(alpha), (TypeArgument)BoundSet.typeRef(beta), Variance.CONTRA);
        }
        return null;
    }

    private TypeConstraint combineBothCoOrBothContra(TypeBound boundS, TypeBound boundT) {
        InferenceVariable alpha = boundS.left;
        InferenceVariable beta = boundT.left;
        TypeRef S = boundS.right;
        TypeRef T = boundT.right;
        if (alpha == T.getDeclaredType()) {
            return new TypeConstraint((TypeArgument)BoundSet.typeRef(beta), (TypeArgument)S, boundS.variance);
        }
        if (S.getDeclaredType() == beta) {
            return new TypeConstraint((TypeArgument)BoundSet.typeRef(alpha), (TypeArgument)T, boundS.variance);
        }
        return null;
    }

    private static TypeRef typeRef(InferenceVariable infVar) {
        return TypeUtils.createTypeRef((Type)infVar, (TypeArgument[])new TypeArgument[0]);
    }

    private TypeRef substituteInferenceVariable(TypeRef typeRef, InferenceVariable infVar, TypeArgument typeArg) {
        RuleEnvironment Gtemp = RuleEnvironmentExtensions.wrap(this.G);
        RuleEnvironmentExtensions.addTypeMapping(Gtemp, (TypeVariable)infVar, typeArg);
        TypeRef result = (TypeRef)this.ts.substTypeVariables(Gtemp, (TypeArgument)typeRef).getValue();
        return result;
    }

    private void log(String message) {
        this.ic.log(message);
    }
}

