/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.osgi.framework.Version;

public class JUnitLaunchConfigurationDelegate
extends org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate {
    private String fWorkspaceLocation;
    protected File fConfigDir = null;
    private Map<String, IPluginModelBase> fAllBundles;
    private Map<IPluginModelBase, String> fModels;

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall launcher = VMHelper.createLauncher(configuration);
        return launcher.getVMRunner(mode);
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        if (TargetPlatformHelper.getTargetVersion() >= 3.3) {
            return "org.eclipse.equinox.launcher.Main";
        }
        return "org.eclipse.core.launcher.Main";
    }

    private String getTestPluginId(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject.getProject());
        if (model == null) {
            this.abort(NLS.bind((String)PDEMessages.JUnitLaunchConfiguration_error_notaplugin, (Object)javaProject.getProject().getName()), null, 0);
        }
        if (model instanceof IFragmentModel) {
            return ((IFragmentModel)model).getFragment().getPluginId();
        }
        return model.getPluginBase().getId();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.launching", code, message, exception));
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List<String> vmArguments, List<String> programArgs) throws CoreException {
        String modAllSystem;
        String[] userArgs;
        super.collectExecutionArguments(configuration, vmArguments, programArgs);
        programArgs.add("-application");
        String application = this.getApplication(configuration);
        programArgs.add(application);
        if (configuration.getAttribute("useProduct", false)) {
            programArgs.add("-product");
            programArgs.add(configuration.getAttribute("product", ""));
        } else {
            String defaultApplication = TargetPlatform.getDefaultApplication();
            if ("org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                defaultApplication = null;
            } else if ("org.eclipse.pde.junit.runtime.nonuithreadtestapplication".equals(application)) {
                defaultApplication = "org.eclipse.pde.junit.runtime.coretestapplication";
            }
            String testApplication = configuration.getAttribute("testApplication", defaultApplication);
            if (testApplication != null) {
                programArgs.add("-testApplication");
                programArgs.add(testApplication);
            }
        }
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        if (this.fWorkspaceLocation.length() > 0) {
            programArgs.add("-data");
            programArgs.add(this.fWorkspaceLocation);
        }
        String productID = LaunchConfigurationHelper.getProductID(configuration);
        LaunchConfigurationHelper.createConfigIniFile(configuration, productID, this.fAllBundles, this.fModels, this.getConfigurationDirectory(configuration));
        TargetPlatformHelper.checkPluginPropertiesConsistency(this.fAllBundles, (File)this.getConfigurationDirectory(configuration));
        programArgs.add("-configuration");
        programArgs.add("file:" + new Path(this.getConfigurationDirectory(configuration).getPath()).addTrailingSeparator().toString());
        programArgs.add("-dev");
        programArgs.add(ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.getConfigurationDirectory(configuration).toString()) + "/dev.properties"), this.fAllBundles));
        IPluginModelBase base = this.findPlugin("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) < 0) {
            programArgs.add("-pdelaunch");
        }
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            String path = String.valueOf(this.getConfigurationDirectory(configuration).getPath()) + '/' + ".options";
            programArgs.add(LaunchArgumentsHelper.getTracingFileArgument(configuration, path));
        }
        String[] stringArray = userArgs = LaunchArgumentsHelper.getUserProgramArgumentArray(configuration);
        int n = userArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String userArg = stringArray[n2];
            if (!userArg.equals("-debug") || !programArgs.contains("-debug")) {
                programArgs.add(userArg);
            }
            ++n2;
        }
        if (!configuration.getAttribute("append.args", false)) {
            if (!programArgs.contains("-os")) {
                programArgs.add("-os");
                programArgs.add(TargetPlatform.getOS());
            }
            if (!programArgs.contains("-ws")) {
                programArgs.add("-ws");
                programArgs.add(TargetPlatform.getWS());
            }
            if (!programArgs.contains("-arch")) {
                programArgs.add("-arch");
                programArgs.add(TargetPlatform.getOSArch());
            }
        }
        programArgs.add("-testpluginname");
        programArgs.add(this.getTestPluginId(configuration));
        IVMInstall launcher = VMHelper.createLauncher(configuration);
        boolean isModular = JavaRuntime.isModularJava((IVMInstall)launcher);
        if (isModular && !vmArguments.contains(modAllSystem = "--add-modules=ALL-SYSTEM")) {
            vmArguments.add(modAllSystem);
        }
    }

    protected String getApplication(ILaunchConfiguration configuration) {
        String application = null;
        boolean shouldRunInUIThread = true;
        try {
            shouldRunInUIThread = configuration.getAttribute("run_in_ui_thread", true);
        }
        catch (CoreException coreException) {}
        if (!shouldRunInUIThread) {
            return "org.eclipse.pde.junit.runtime.nonuithreadtestapplication";
        }
        try {
            application = configuration.getAttribute("application", null);
        }
        catch (CoreException coreException) {}
        if (application == null) {
            Version version;
            int major;
            BundleDescription desc;
            IPluginModelBase model = this.fAllBundles.get("org.eclipse.pde.junit.runtime");
            BundleDescription bundleDescription = desc = model != null ? model.getBundleDescription() : null;
            if (desc != null && (major = (version = desc.getVersion()).getMajor()) >= 3 && version.getMinor() >= 3 && !TargetPlatformHelper.usesNewApplicationModel()) {
                application = "org.eclipse.pde.junit.runtime.legacytestapplication";
            }
        }
        if (application == null) {
            application = "org.eclipse.pde.junit.runtime.uitestapplication";
        }
        return application;
    }

    private IPluginModelBase findPlugin(String id) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null) {
            model = PDECore.getDefault().findPluginInHost(id);
        }
        if (model == null) {
            this.abort(NLS.bind((String)PDEMessages.JUnitLaunchConfiguration_error_missingPlugin, (Object)id), null, 0);
        }
        return model;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getUserProgramArguments(configuration);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmArgs = LaunchArgumentsHelper.getUserVMArguments(configuration);
        IPluginModelBase base = this.fAllBundles.get("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) >= 0) {
            vmArgs = this.concatArg(vmArgs, "-Declipse.pde.launch=true");
        }
        if (this.fAllBundles.containsKey("org.eclipse.equinox.p2.core") && vmArgs.indexOf("-Declipse.p2.data.area=") < 0) {
            vmArgs = this.concatArg(vmArgs, "-Declipse.p2.data.area=@config.dir" + File.separator + "p2");
        }
        return vmArgs;
    }

    private String concatArg(String vmArgs, String arg) {
        if (vmArgs.length() > 0 && !vmArgs.endsWith(" ")) {
            vmArgs = vmArgs.concat(" ");
        }
        return vmArgs.concat(arg);
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath(configuration);
        if (classpath == null) {
            this.abort(PDEMessages.WorkbenchLauncherConfigurationDelegate_noStartup, null, 0);
        }
        return classpath;
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getWorkingDirectory(configuration);
    }

    public Map<String, Object> getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getVMSpecificAttributesMap(configuration);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.pde.ui.workbenchClasspathProvider".equals(id)) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.doSave();
        }
        this.manageLaunch(launch);
    }

    protected File getConfigurationDirectory(ILaunchConfiguration configuration) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(configuration);
        }
        return this.fConfigDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LaunchPluginValidator.getAffectedProjects(configuration);
    }

    protected void manageLaunch(ILaunch launch) {
        PDELaunchingPlugin.getDefault().getLaunchListener().manage(launch);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] requiredPlugins;
        this.fWorkspaceLocation = null;
        this.fConfigDir = null;
        this.fModels = BundleLauncherHelper.getMergedBundleMap(configuration, false);
        this.fAllBundles = new HashMap<String, IPluginModelBase>(this.fModels.size());
        for (IPluginModelBase model : this.fModels.keySet()) {
            this.fAllBundles.put(model.getPluginBase().getId(), model);
        }
        String[] stringArray = requiredPlugins = this.getRequiredPlugins(configuration);
        int n = requiredPlugins.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredPlugin = stringArray[n2];
            String id = requiredPlugin;
            if (!this.fAllBundles.containsKey(id)) {
                IPluginModelBase model = this.findPlugin(id);
                this.fAllBundles.put(id, model);
                this.fModels.put(model, "default:default");
            }
            ++n2;
        }
        boolean autoValidate = configuration.getAttribute("automaticValidate", false);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(autoValidate ? 3 : 4));
        if (autoValidate) {
            this.validatePluginDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
        }
        this.validateProjectDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
        LauncherUtils.setLastLaunchMode(launch.getLaunchMode());
        this.clear(configuration, (IProgressMonitor)subMonitor.split(1));
        launch.setAttribute("configLocation", this.getConfigurationDirectory(configuration).toString());
        this.synchronizeManifests(configuration, (IProgressMonitor)subMonitor.split(1));
    }

    private String[] getRequiredPlugins(ILaunchConfiguration configuration) {
        ITestKind testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind((ILaunchConfiguration)configuration);
        if ("org.eclipse.jdt.junit.loader.junit4".equals(testKind.getId())) {
            return new String[]{"org.junit", "org.eclipse.jdt.junit.runtime", "org.eclipse.pde.junit.runtime", "org.eclipse.jdt.junit4.runtime"};
        }
        return new String[]{"org.junit", "org.eclipse.jdt.junit.runtime", "org.eclipse.pde.junit.runtime"};
    }

    protected void synchronizeManifests(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LaunchConfigurationHelper.synchronizeManifests(configuration, this.getConfigurationDirectory(configuration));
        monitor.done();
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon;
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        if (!LauncherUtils.clearWorkspace(configuration, this.fWorkspaceLocation, (IProgressMonitor)(subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)50)).split(25))) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        subMon.setWorkRemaining(25);
        if (subMon.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigurationDirectory(configuration), (IProgressMonitor)subMon.split(25));
        }
        subMon.done();
    }

    protected void validateProjectDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LauncherUtils.validateProjectDependencies(configuration, monitor);
    }

    protected void validatePluginDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        EclipsePluginValidationOperation op = new EclipsePluginValidationOperation(configuration);
        LaunchPluginValidator.runValidationOperation(op, monitor);
    }
}

