/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.im.DelegatingGetterDeclaration;
import org.eclipse.n4js.transpiler.im.DelegatingMember;
import org.eclipse.n4js.transpiler.im.ImFactory;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ReferencingElementExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.SuperInterfacesIterable;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class DelegationAssistant
extends TransformationAssistant {
    @Inject
    private TypeAssistant typeAssistant;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DelegatingMember createDelegatingMember(TClassifier origin, TMember target) {
        boolean _not_1;
        boolean _tripleEquals;
        ContainerType _containingType = target.getContainingType();
        boolean bl = _tripleEquals = _containingType == origin;
        if (_tripleEquals) {
            throw new IllegalArgumentException("no point in delegating to an owned member");
        }
        DelegatingGetterDeclaration _switchResult = null;
        boolean _matched = false;
        if (target instanceof TField) {
            _matched = true;
            throw new IllegalArgumentException("delegation to fields not supported yet");
        }
        if (target instanceof TGetter) {
            _matched = true;
            _switchResult = ImFactory.eINSTANCE.createDelegatingGetterDeclaration();
        }
        if (!_matched && target instanceof TSetter) {
            _matched = true;
            _switchResult = ImFactory.eINSTANCE.createDelegatingSetterDeclaration();
        }
        if (!_matched && target instanceof TMethod) {
            _matched = true;
            _switchResult = ImFactory.eINSTANCE.createDelegatingMethodDeclaration();
        }
        DelegatingGetterDeclaration result = _switchResult;
        ((PropertyNameOwner)result).setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName((String)target.getName()));
        ((DelegatingMember)result).setDelegationTarget(this.getSymbolTableEntryOriginal((IdentifiableElement)target, true));
        boolean _isStatic = target.isStatic();
        if (_isStatic) {
            EList _declaredModifiers = ((DelegatingMember)result).getDeclaredModifiers();
            _declaredModifiers.add((Object)N4Modifier.STATIC);
        }
        if (origin instanceof TInterface) {
            boolean _not;
            EObject _eContainer = target.eContainer();
            boolean bl2 = _not = !(_eContainer instanceof TInterface);
            if (_not) {
                throw new IllegalArgumentException("cannot delegate from an interface to member of a class");
            }
            ContainerType<?> tSuper = this.getDirectSuperTypeBequestingMember(origin, target);
            ((DelegatingMember)result).setDelegationBaseType(this.getSymbolTableEntryOriginal((IdentifiableElement)tSuper, false));
            ((DelegatingMember)result).setDelegationSuperClassSteps(0);
        } else if (origin instanceof TClass) {
            TClass tAncestor = this.getAncestorClassBequestingMember((TClass)origin, target);
            if (tAncestor != origin) {
                Type _declaredType = ((TClass)origin).getSuperClassRef().getDeclaredType();
                TClass tSuper_1 = (TClass)_declaredType;
                ((DelegatingMember)result).setDelegationBaseType(this.getSymbolTableEntryOriginal((IdentifiableElement)tSuper_1, false));
                int _distanceToAncestorClass = DelegationAssistant.getDistanceToAncestorClass((TClass)origin, tAncestor);
                int _minus = _distanceToAncestorClass - 1;
                ((DelegatingMember)result).setDelegationSuperClassSteps(_minus);
            } else {
                if (tAncestor == null) throw new IllegalStateException("cannot find target (probably not an inherited member)");
                ContainerType<?> tSuper_2 = this.getDirectSuperTypeBequestingMember(origin, target);
                ((DelegatingMember)result).setDelegationBaseType(this.getSymbolTableEntryOriginal((IdentifiableElement)tSuper_2, false));
                ((DelegatingMember)result).setDelegationSuperClassSteps(0);
            }
        } else {
            String _name = origin.eClass().getName();
            String _plus = "unsupported subtype of TClassifier: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        ((DelegatingMember)result).setDelegationTargetIsAbstract(target.isAbstract());
        boolean _isAbstract = target.isAbstract();
        boolean bl3 = _not_1 = !_isAbstract;
        if (!_not_1) return (DelegatingMember)result;
        ((FunctionOrFieldAccessor)result).setBody(TranspilerBuilderBlocks._Block((Statement[])new Statement[0]));
        return (DelegatingMember)result;
    }

    public Expression createDelegationCode(DelegatingMember delegator) {
        boolean baseIsInterface;
        SymbolTableEntryOriginal baseSTE = delegator.getDelegationBaseType();
        IdentifiableElement _originalTarget = null;
        if (baseSTE != null) {
            _originalTarget = baseSTE.getOriginalTarget();
        }
        if (baseIsInterface = _originalTarget instanceof TInterface) {
            boolean _not;
            String targetName = delegator.getDelegationTarget().getName();
            boolean targetIsSymbol = targetName != null && targetName.startsWith("#");
            SymbolTableEntryOriginal targetSTE = delegator.getDelegationTarget();
            Expression _xifexpression = null;
            boolean _isStatic = delegator.isStatic();
            boolean bl = _not = !_isStatic;
            if (_not) {
                ConditionalExpression _xblockexpression = null;
                SymbolTableEntryInternal $methodsSTE = this.steFor_$methods();
                SymbolTableEntry valueSTE = this.getPropertyDescriptorValueProperty((N4MemberDeclaration)delegator);
                ConditionalExpression _xifexpression_1 = null;
                if (!targetIsSymbol) {
                    ReturnStatement __ReturnStmnt = TranspilerBuilderBlocks._ReturnStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)baseSTE, new SymbolTableEntry[]{$methodsSTE, targetSTE, valueSTE, this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.functionType((RuleEnvironment)this.getState().G), "apply", false, false, true)}), (Expression[])new Expression[]{TranspilerBuilderBlocks._ThisLiteral(), TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_arguments())}));
                    _xifexpression_1 = TranspilerBuilderBlocks._ConditionalExpr((Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)baseSTE, new SymbolTableEntry[]{$methodsSTE}), (Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)baseSTE, new SymbolTableEntry[]{$methodsSTE, targetSTE, valueSTE}), (Expression)TranspilerBuilderBlocks._FunExpr((boolean)false, (Statement[])new Statement[]{__ReturnStmnt}));
                } else {
                    ReturnStatement __ReturnStmnt_1 = TranspilerBuilderBlocks._ReturnStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._IndexAccessExpr((Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)baseSTE, new SymbolTableEntry[]{$methodsSTE}), (Expression)this.typeAssistant.getMemberNameAsSymbol(targetName)), (SymbolTableEntry[])new SymbolTableEntry[]{valueSTE, this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.functionType((RuleEnvironment)this.getState().G), "apply", false, false, true)}), (Expression[])new Expression[]{TranspilerBuilderBlocks._ThisLiteral(), TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_arguments())}));
                    _xifexpression_1 = TranspilerBuilderBlocks._ConditionalExpr((Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)baseSTE, new SymbolTableEntry[]{$methodsSTE}), (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._IndexAccessExpr((Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)baseSTE, new SymbolTableEntry[]{$methodsSTE}), (Expression)this.typeAssistant.getMemberNameAsSymbol(targetName)), (SymbolTableEntry[])new SymbolTableEntry[]{valueSTE}), (Expression)TranspilerBuilderBlocks._FunExpr((boolean)false, (Statement[])new Statement[]{__ReturnStmnt_1}));
                }
                _xblockexpression = _xifexpression_1;
                _xifexpression = _xblockexpression;
            } else {
                Object _xifexpression_1 = null;
                _xifexpression_1 = !targetIsSymbol ? this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)baseSTE, new SymbolTableEntry[]{targetSTE}) : TranspilerBuilderBlocks._IndexAccessExpr((Expression)this.__NSSafe_IdentRef((SymbolTableEntry)baseSTE), (Expression)this.typeAssistant.getMemberNameAsSymbol(targetName));
                _xifexpression = (Expression)_xifexpression_1;
            }
            return _xifexpression;
        }
        Expression ctorOfClassOfTarget = this.createAccessToClassConstructor((SymbolTableEntry)baseSTE, delegator.getDelegationSuperClassSteps());
        Expression result = this.createAccessToMemberFunction(ctorOfClassOfTarget, false, (N4MemberDeclaration)delegator);
        return result;
    }

    public Expression createAccessToClassConstructor(SymbolTableEntry classSTE, int superClassSteps) {
        TClassifier objectType = RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G);
        SymbolTableEntryOriginal objectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)objectType, true);
        ReferencingElementExpression_IM result = this.__NSSafe_IdentRef(classSTE);
        if (superClassSteps > 0) {
            SymbolTableEntryOriginal getPrototypeOfSTE = this.getSymbolTableEntryForMember(objectType, "getPrototypeOf", false, true, true);
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, superClassSteps, true);
            for (Integer n : _doubleDotLessThan) {
                result = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)objectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{getPrototypeOfSTE}), (Expression[])new Expression[]{result});
            }
        }
        return result;
    }

    public Expression createAccessToMemberFunction(Expression protoOrCtorExpr, boolean exprIsProto, N4MemberDeclaration member) {
        if (member instanceof N4FieldDeclaration) {
            throw new IllegalArgumentException("no member function available for fields");
        }
        Expression accessToMemberDefinition = this.createAccessToMemberDefinition(protoOrCtorExpr, exprIsProto, member);
        ParameterizedPropertyAccessExpression_IM result = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)accessToMemberDefinition, (SymbolTableEntry[])new SymbolTableEntry[]{this.getPropertyDescriptorValueProperty(member)});
        return result;
    }

    public Expression createAccessToMemberDefinition(Expression protoOrCtorExpr, boolean exprIsProto, N4MemberDeclaration member) {
        String memberName = member.getName();
        boolean memberIsSymbol = memberName != null && memberName.startsWith("#");
        SymbolTableEntry memberSTE = this.findSymbolTableEntryForElement((NamedElement)member, true);
        TClassifier objectType = RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G);
        SymbolTableEntryOriginal objectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)objectType, true);
        SymbolTableEntryOriginal getOwnPropertyDescriptorSTE = this.getSymbolTableEntryForMember(objectType, "getOwnPropertyDescriptor", false, true, true);
        boolean isStatic = member.isStatic();
        Expression arg0 = protoOrCtorExpr;
        if (!exprIsProto && !isStatic) {
            SymbolTableEntryOriginal prototypeSTE = this.getSymbolTableEntryForMember(objectType, "prototype", false, true, true);
            arg0 = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)arg0, (SymbolTableEntry[])new SymbolTableEntry[]{prototypeSTE});
        } else if (exprIsProto && isStatic) {
            SymbolTableEntryOriginal constructorSTE = this.getSymbolTableEntryForMember(objectType, "constructor", false, false, true);
            arg0 = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)arg0, (SymbolTableEntry[])new SymbolTableEntry[]{constructorSTE});
        }
        Object _xifexpression = null;
        _xifexpression = !memberIsSymbol ? TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)memberSTE) : this.typeAssistant.getMemberNameAsSymbol(memberName);
        StringLiteral arg1 = _xifexpression;
        ParameterizedCallExpression result = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)objectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{getOwnPropertyDescriptorSTE}), (Expression[])new Expression[]{arg0, arg1});
        return result;
    }

    public Expression createAccessToSuperClass(N4ClassDeclaration baseClassDecl, boolean isStatic) {
        SymbolTableEntryOriginal superClassSTE = this.typeAssistant.getSuperClassSTE(baseClassDecl);
        SymbolTableEntryOriginal prototypeSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "prototype", false, true, true);
        Object _xifexpression = null;
        _xifexpression = !isStatic ? this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)superClassSTE, new SymbolTableEntry[]{prototypeSTE}) : this.__NSSafe_IdentRef((SymbolTableEntry)superClassSTE);
        return _xifexpression;
    }

    public Expression createAccessToSuperClassBequestingMember(N4ClassDeclaration baseClassDecl, boolean isStatic, SymbolTableEntryOriginal memberSTE) {
        TClass tClassBase = this.getState().info.getOriginalDefinedType(baseClassDecl);
        IdentifiableElement _originalTarget = memberSTE.getOriginalTarget();
        TMember member = (TMember)_originalTarget;
        TClass tClassTarget = this.getAncestorClassBequestingMember(tClassBase, member);
        int dist = DelegationAssistant.getDistanceToAncestorClass(tClassBase, tClassTarget);
        SymbolTableEntryInternal __proto__STE = this.steFor___proto__();
        Expression superAccess = this.createAccessToSuperClass(baseClassDecl, isStatic);
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, dist, true);
        for (Integer i : _doubleDotLessThan) {
            superAccess = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)superAccess, (SymbolTableEntry[])new SymbolTableEntry[]{__proto__STE});
        }
        return superAccess;
    }

    private ContainerType<?> getDirectSuperTypeBequestingMember(TClassifier classifier, TMember inheritedMember) {
        return this.getState().memberCollector.directSuperTypeBequestingMember(classifier, inheritedMember);
    }

    private TClass getAncestorClassBequestingMember(TClass classifier, TMember inheritedOrConsumedMember) {
        TClass _xblockexpression = null;
        ContainerType containingType = inheritedOrConsumedMember.getContainingType();
        TClass _xifexpression = null;
        if (containingType == classifier) {
            return classifier;
        }
        TClass _xifexpression_1 = null;
        if (containingType instanceof TInterface) {
            _xifexpression_1 = SuperInterfacesIterable.of((TClassifier)classifier).findClassImplementingInterface((TInterface)containingType);
        } else {
            TClass _xifexpression_2 = null;
            if (!(containingType instanceof TClass)) {
                String _name = containingType.eClass().getName();
                String _plus = "unsupported subtype of TClassifier: " + _name;
                throw new IllegalArgumentException(_plus);
            }
            _xifexpression_2 = (TClass)containingType;
            _xifexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private static int getDistanceToAncestorClass(TClass base, TClass ancestorClass) {
        if (ancestorClass == null || ancestorClass == base) {
            return 0;
        }
        RecursionGuard guard = new RecursionGuard();
        int result = 0;
        TClass curr = base;
        while (curr != null && curr != ancestorClass) {
            boolean _tryNext = guard.tryNext((Object)curr);
            if (!_tryNext) continue;
            ++result;
            ParameterizedTypeRef _superClassRef = curr.getSuperClassRef();
            Type _declaredType = null;
            if (_superClassRef != null) {
                _declaredType = _superClassRef.getDeclaredType();
            }
            curr = (TClass)_declaredType;
        }
        int _xifexpression = 0;
        _xifexpression = curr != null ? result : 0;
        return _xifexpression;
    }

    private SymbolTableEntry getPropertyDescriptorValueProperty(N4MemberDeclaration delegator) {
        SymbolTableEntryInternal _switchResult = null;
        boolean _matched = false;
        if (delegator instanceof N4GetterDeclaration) {
            _matched = true;
            _switchResult = this.steFor_get();
        }
        if (!_matched && delegator instanceof N4SetterDeclaration) {
            _matched = true;
            _switchResult = this.steFor_set();
        }
        if (!_matched && delegator instanceof N4MethodDeclaration) {
            _matched = true;
            _switchResult = this.steFor_value();
        }
        return _switchResult;
    }
}

