/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Messages;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileSynchronizer {
    private static final String RECONCILER_APPLICATION_ID = "org.eclipse.equinox.p2.reconciler.application";
    private static final String TIMESTAMPS_FILE_PREFIX = "timestamps";
    private static final String PROFILE_TIMESTAMP = "PROFILE";
    private static final String NO_TIMESTAMP = "-1";
    private static final String PROP_FROM_DROPINS = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    private static final String INCLUSION_OPTIONAL = "OPTIONAL";
    private static final String INCLUSION_STRICT = "STRICT";
    private static final String CACHE_EXTENSIONS = "org.eclipse.equinox.p2.cache.extensions";
    private static final String PIPE = "|";
    private static final String EXPLANATION = "org.eclipse.equinox.p2.director.explain";
    static final String PROP_IGNORE_USER_CONFIGURATION = "eclipse.ignoreUserConfiguration";
    final IProfile profile;
    final Map<String, IMetadataRepository> repositoryMap;
    private Map<String, String> timestamps;
    private final IProvisioningAgent agent;

    public ProfileSynchronizer(IProvisioningAgent agent, IProfile profile, Collection<IMetadataRepository> repositories) {
        this.agent = agent;
        this.profile = profile;
        this.repositoryMap = new HashMap<String, IMetadataRepository>();
        for (IMetadataRepository repository : repositories) {
            this.repositoryMap.put(repository.getLocation().toString(), repository);
        }
    }

    public IStatus synchronize(IProgressMonitor monitor) {
        IStatus result;
        IStatus addRemoveResult;
        IStatus moveResult;
        this.readTimestamps();
        if (this.isUpToDate()) {
            return Status.OK_STATUS;
        }
        ProvisioningContext context = this.getContext();
        context.setProperty(EXPLANATION, Boolean.valueOf(Tracing.DEBUG_RECONCILER).toString());
        String updatedCacheExtensions = this.synchronizeCacheExtensions();
        ReconcilerProfileChangeRequest request = this.createProfileChangeRequest(context);
        if (request == null) {
            if (updatedCacheExtensions == null) {
                return Status.OK_STATUS;
            }
            IStatus engineResult = this.setProperty(CACHE_EXTENSIONS, updatedCacheExtensions, context, null);
            if (engineResult.getSeverity() != 4 && engineResult.getSeverity() != 8) {
                this.writeTimestamps();
            }
            return engineResult;
        }
        if (updatedCacheExtensions != null) {
            request.setProfileProperty(CACHE_EXTENSIONS, updatedCacheExtensions);
        }
        if ((moveResult = this.performRemoveForMovedIUs(request, context, monitor)).getSeverity() == 4 || moveResult.getSeverity() == 8) {
            return moveResult;
        }
        if (!request.getRemovals().isEmpty()) {
            ArrayList<RequiredCapability> requirements = new ArrayList<RequiredCapability>();
            for (IInstallableUnit unit : request.getRemovals()) {
                RequiredCapability req = new RequiredCapability("org.eclipse.equinox.p2.iu", unit.getId(), new VersionRange(unit.getVersion(), true, unit.getVersion(), true), null, 0, 0, false, null);
                requirements.add(req);
            }
            request.addExtraRequirements(requirements);
        }
        if ((addRemoveResult = this.performAddRemove(request, context, monitor)).getSeverity() == 4 || addRemoveResult.getSeverity() == 8) {
            return addRemoveResult;
        }
        this.writeTimestamps();
        IStatus applyResult = this.applyConfiguration(false);
        IProfileRegistry profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry != null && !(result = profileRegistry.setProfileStateProperty(this.profile.getProfileId(), this.profile.getTimestamp(), "org.eclipse.equinox.p2.state.hidden", Boolean.TRUE.toString())).isOK()) {
            LogHelper.log((IStatus)result);
        }
        return applyResult;
    }

    private IQueryResult<IInstallableUnit> getStrictRoots() {
        return this.profile.query((IQuery)new IUProfilePropertyQuery(INCLUSION_RULES, INCLUSION_STRICT), null);
    }

    private IStatus performAddRemove(ReconcilerProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) {
        for (IInstallableUnit iu : request.getMoves()) {
            request.add(iu);
            request.setInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS, Boolean.TRUE.toString());
            request.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
            request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock", Integer.toString(1));
        }
        Collection additions = request.getAdditions();
        Collection removals = request.getRemovals();
        if (additions.isEmpty() && removals.isEmpty()) {
            return Status.OK_STATUS;
        }
        boolean removeStrictRoots = false;
        if (removeStrictRoots) {
            return this.performStrictRootRemoval(request, context, monitor);
        }
        IProvisioningPlan plan = this.createProvisioningPlan(request, context, monitor);
        this.debug(request, plan);
        return this.executePlan(plan, context, monitor);
    }

    private IStatus performStrictRootRemoval(ReconcilerProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) {
        Collection removals = request.getRemovals();
        if (removals.isEmpty()) {
            IProvisioningPlan plan = this.createProvisioningPlan(request, context, monitor);
            this.debug(request, plan);
            return this.executePlan(plan, context, monitor);
        }
        ProfileChangeRequest finalRequest = (ProfileChangeRequest)request.clone();
        Set strictRoots = this.getStrictRoots().toUnmodifiableSet();
        ArrayList<IRequirement> forceNegation = new ArrayList<IRequirement>(removals.size());
        for (IInstallableUnit iu : removals) {
            forceNegation.add(this.createNegation(iu));
        }
        request.addExtraRequirements(forceNegation);
        for (IInstallableUnit iu : strictRoots) {
            request.setInstallableUnitProfileProperty(iu, INCLUSION_RULES, INCLUSION_OPTIONAL);
        }
        IProvisioningPlan plan = this.createProvisioningPlan(request, context, monitor);
        this.debug(request, plan);
        if (!plan.getStatus().isOK()) {
            return plan.getStatus();
        }
        int removedRoots = 0;
        for (IInstallableUnit initialRoot : strictRoots) {
            if (plan.getRemovals().query(QueryUtil.createIUQuery((IVersionedId)initialRoot), null).isEmpty()) continue;
            finalRequest.remove(initialRoot);
            finalRequest.setInstallableUnitProfileProperty(initialRoot, INCLUSION_RULES, INCLUSION_OPTIONAL);
            IRequirement negation = this.createNegation(initialRoot);
            ArrayList<IRequirement> extra = new ArrayList<IRequirement>();
            extra.add(negation);
            request.addExtraRequirements(extra);
            LogHelper.log((IStatus)new Status(1, PROP_FROM_DROPINS, NLS.bind((String)Messages.remove_root, (Object)initialRoot.getId(), (Object)initialRoot.getVersion())));
            ++removedRoots;
        }
        if (removedRoots == strictRoots.size()) {
            return new Status(4, PROP_FROM_DROPINS, Messages.remove_all_roots);
        }
        plan = this.createProvisioningPlan(finalRequest, context, monitor);
        if (!plan.getStatus().isOK()) {
            System.out.println("original request");
            System.out.println((Object)request);
            System.out.println("final request");
            System.out.println(finalRequest);
            throw new IllegalStateException("The second plan is not resolvable.");
        }
        return this.executePlan(plan, context, monitor);
    }

    private IStatus performRemoveForMovedIUs(ReconcilerProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) {
        Collection<IInstallableUnit> moves = request.getMoves();
        if (moves.isEmpty()) {
            return Status.OK_STATUS;
        }
        IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
        IProvisioningPlan plan = engine.createPlan(this.profile, context);
        for (IInstallableUnit unit : moves) {
            plan.removeInstallableUnit(unit);
        }
        return this.executePlan(plan, context, monitor);
    }

    private void writeTimestamps() {
        this.timestamps.clear();
        this.timestamps.put(PROFILE_TIMESTAMP, Long.toString(this.profile.getTimestamp()));
        for (Map.Entry<String, IMetadataRepository> entry : this.repositoryMap.entrySet()) {
            IMetadataRepository repository = entry.getValue();
            Map props = repository.getProperties();
            String timestamp = null;
            if (props != null) {
                timestamp = (String)props.get("p2.timestamp");
            }
            if (timestamp == null) {
                timestamp = NO_TIMESTAMP;
            }
            this.timestamps.put(entry.getKey(), timestamp);
        }
        try {
            File file = Activator.getContext().getDataFile(TIMESTAMPS_FILE_PREFIX + this.profile.getProfileId().hashCode());
            Activator.trace("Writing timestamp file to : " + file.getAbsolutePath());
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                CollectionUtils.storeProperties(this.timestamps, (OutputStream)os, (String)("Timestamps for " + this.profile.getProfileId()));
                if (Tracing.DEBUG_RECONCILER) {
                    for (String key : this.timestamps.keySet()) {
                        String value = this.timestamps.get(key);
                        Activator.trace(String.valueOf(key) + '=' + value);
                    }
                }
            }
            finally {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private boolean isUpToDate() {
        if ("true".equals(Activator.getContext().getProperty("osgi.checkConfiguration"))) {
            Activator.trace("User requested forced reconciliation via \"osgi.checkConfiguration=true\" System property.");
            Activator.trace("Performing reconciliation.");
            return false;
        }
        String lastKnownProfileTimeStamp = this.timestamps.remove(PROFILE_TIMESTAMP);
        if (lastKnownProfileTimeStamp == null) {
            Activator.trace("Profile timestamp not found in cache.");
            Activator.trace("Performing reconciliation.");
            return false;
        }
        String currentProfileTimestamp = Long.toString(this.profile.getTimestamp());
        if (!lastKnownProfileTimeStamp.equals(currentProfileTimestamp)) {
            Activator.trace("Profile timestamps not equal, expected: " + lastKnownProfileTimeStamp + ", actual=" + currentProfileTimestamp);
            Activator.trace("Performing reconciliation.");
            return false;
        }
        for (Map.Entry<String, IMetadataRepository> entry : this.repositoryMap.entrySet()) {
            String key;
            String lastKnownTimestamp;
            IMetadataRepository repository = entry.getValue();
            Map props = repository.getProperties();
            String currentTimestamp = null;
            if (props != null) {
                currentTimestamp = (String)props.get("p2.timestamp");
            }
            if (currentTimestamp == null) {
                currentTimestamp = NO_TIMESTAMP;
            }
            if ((lastKnownTimestamp = this.timestamps.remove(key = entry.getKey())) == null) {
                Activator.trace("No cached timestamp found for: " + key);
                Activator.trace("Performing reconciliation.");
                return false;
            }
            if (lastKnownTimestamp.equals(currentTimestamp)) continue;
            Activator.trace("Timestamps not equal for file: " + key + ", expected: " + lastKnownTimestamp + ", actual: " + currentTimestamp);
            Activator.trace("Performing reconciliation.");
            return false;
        }
        if (this.timestamps.size() == 0) {
            Activator.trace("Timestamps valid.");
            Activator.trace("Skipping reconciliation.");
            return true;
        }
        if (Tracing.DEBUG_RECONCILER) {
            Activator.trace("Extra values in timestamp file:");
            Iterator<String> iter = this.timestamps.keySet().iterator();
            while (iter.hasNext()) {
                Activator.trace(iter.next());
            }
            Activator.trace("Performing reconciliation.");
        }
        return false;
    }

    private void readTimestamps() {
        if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty(PROP_IGNORE_USER_CONFIGURATION))) {
            this.timestamps = new HashMap<String, String>();
            Activator.trace("Master profile changed.");
            Activator.trace("Performing reconciliation.");
            return;
        }
        File file = Activator.getContext().getDataFile(TIMESTAMPS_FILE_PREFIX + this.profile.getProfileId().hashCode());
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.timestamps = CollectionUtils.loadProperties((InputStream)is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.timestamps = new HashMap<String, String>();
            Activator.trace("Timestamp file does not exist.");
            Activator.trace("Performing reconciliation.");
        }
        catch (IOException e) {
            this.timestamps = new HashMap<String, String>();
            Activator.trace("Exception loading timestamp file: " + e.getMessage());
            Activator.trace("Performing reconciliation.");
        }
    }

    private ProvisioningContext getContext() {
        ArrayList<URI> repoURLs = new ArrayList<URI>();
        Iterator<String> iterator = this.repositoryMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                repoURLs.add(new URI(iterator.next()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        ProvisioningContext result = new ProvisioningContext(this.agent);
        result.setMetadataRepositories(repoURLs.toArray(new URI[repoURLs.size()]));
        result.setArtifactRepositories(new URI[0]);
        return result;
    }

    private String synchronizeCacheExtensions() {
        ArrayList<String> currentExtensions = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> repositories = new ArrayList<String>(this.repositoryMap.keySet());
        URL installArea = Activator.getOSGiInstallArea();
        try {
            final String OSGiInstallArea = String.valueOf(URIUtil.toURI((URL)installArea).toString()) + ".eclipseextension";
            Collections.sort(repositories, new Comparator<String>(){

                @Override
                public int compare(String left, String right) {
                    if (OSGiInstallArea.equals(left)) {
                        return -1;
                    }
                    if (OSGiInstallArea.equals(right)) {
                        return 1;
                    }
                    return left.compareTo(right);
                }
            });
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(4, PROP_FROM_DROPINS, "Unable to convert OSGi install area: " + installArea + " into URI.", (Throwable)e));
        }
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            String repositoryId = (String)it.next();
            try {
                IArtifactRepository repository = Activator.loadArtifactRepository(new URI(repositoryId), null);
                if (!(repository instanceof IFileArtifactRepository)) continue;
                currentExtensions.add(this.escapePipe(repositoryId));
                buffer.append(repositoryId);
                if (!it.hasNext()) continue;
                buffer.append(PIPE);
            }
            catch (ProvisionException provisionException) {
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        String currentExtensionsProperty = buffer.length() == 0 ? null : buffer.toString();
        ArrayList<String> previousExtensions = new ArrayList<String>();
        String previousExtensionsProperty = this.profile.getProperty(CACHE_EXTENSIONS);
        if (previousExtensionsProperty != null) {
            StringTokenizer tokenizer = new StringTokenizer(previousExtensionsProperty, PIPE);
            while (tokenizer.hasMoreTokens()) {
                previousExtensions.add(tokenizer.nextToken());
            }
        }
        if (previousExtensions.size() == currentExtensions.size() && previousExtensions.containsAll(currentExtensions)) {
            return null;
        }
        return currentExtensionsProperty;
    }

    private String escapePipe(String location) {
        int pipeIndex;
        String result = location;
        while ((pipeIndex = result.indexOf(44)) != -1) {
            result = String.valueOf(result.substring(0, pipeIndex)) + "%7C" + result.substring(pipeIndex + 1);
        }
        return result;
    }

    private Map<IInstallableUnit, IInstallableUnit> getProfileIUs() {
        IQueryResult profileQueryResult = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        HashMap<IInstallableUnit, IInstallableUnit> result = new HashMap<IInstallableUnit, IInstallableUnit>();
        for (IInstallableUnit iu : profileQueryResult) {
            result.put(iu, iu);
        }
        return result;
    }

    private Map<IInstallableUnit, IInstallableUnit> getAvailableProfileIUs() {
        IQueryResult profileQueryResult = this.profile.available(QueryUtil.createIUAnyQuery(), null);
        HashMap<IInstallableUnit, IInstallableUnit> result = new HashMap<IInstallableUnit, IInstallableUnit>();
        for (IInstallableUnit iu : profileQueryResult) {
            result.put(iu, iu);
        }
        return result;
    }

    public ReconcilerProfileChangeRequest createProfileChangeRequest(ProvisioningContext context) {
        ReconcilerProfileChangeRequest request = new ReconcilerProfileChangeRequest(this.profile);
        boolean resolve = Boolean.parseBoolean(this.profile.getProperty("org.eclipse.equinox.p2.resolve"));
        if (resolve) {
            request.removeProfileProperty("org.eclipse.equinox.p2.resolve");
        }
        ArrayList<IInstallableUnit> toRemove = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> toMove = new ArrayList<IInstallableUnit>();
        boolean foundIUsToAdd = false;
        Map<IInstallableUnit, IInstallableUnit> profileIUs = this.getProfileIUs();
        Map<IInstallableUnit, IInstallableUnit> availableProfileIUs = this.getAvailableProfileIUs();
        IQueryResult<IInstallableUnit> allIUs = this.getAllIUsFromRepos();
        Iterator iter = allIUs.iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iter.next();
            IInstallableUnit existing = profileIUs.get(iu);
            if (existing != null) {
                String one = iu.getProperty("file.name");
                String two = existing.getProperty("file.name");
                if (two == null) {
                    iter.remove();
                    continue;
                }
                if (one != null && !one.equals(two)) {
                    toMove.add(iu);
                    continue;
                }
            }
            if (QueryUtil.isGroup((IInstallableUnit)iu)) {
                request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            }
            request.setInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS, Boolean.TRUE.toString());
            request.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
            request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock", Integer.toString(1));
            if (foundIUsToAdd || availableProfileIUs.get(iu) != null) continue;
            foundIUsToAdd = true;
        }
        IQueryResult dropinIUs = this.profile.query((IQuery)new IUProfilePropertyQuery(PROP_FROM_DROPINS, Boolean.TRUE.toString()), null);
        Set all = allIUs.toUnmodifiableSet();
        for (IInstallableUnit iu : dropinIUs) {
            if (INCLUSION_STRICT.equals(this.profile.getInstallableUnitProperty(iu, INCLUSION_RULES))) {
                request.removeInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS);
                request.removeInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock");
                continue;
            }
            if (all.contains(iu)) continue;
            toRemove.add(iu);
        }
        if (!foundIUsToAdd && toRemove.isEmpty() && !resolve && toMove.isEmpty()) {
            if (Tracing.DEBUG_RECONCILER) {
                Tracing.debug((String)"[reconciler] Nothing to do.");
            }
            return null;
        }
        request.addAll(all);
        request.removeAll(toRemove);
        request.moveAll(toMove);
        this.debug(request);
        return request;
    }

    private IRequirement createNegation(IInstallableUnit unit) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)unit.getId(), (VersionRange)new VersionRange(unit.getVersion(), true, unit.getVersion(), true), null, (int)0, (int)0, (boolean)false);
    }

    private void debug(ReconcilerProfileChangeRequest request, IProvisioningPlan plan) {
        if (!Tracing.DEBUG_RECONCILER) {
            return;
        }
        ArrayList toAdd = new ArrayList(request.getAdditions());
        ArrayList toRemove = new ArrayList(request.getRemovals());
        ArrayList<IInstallableUnit> toMove = new ArrayList<IInstallableUnit>(request.getMoves());
        for (IInstallableUnit iu : plan.getRemovals().query(QueryUtil.createIUAnyQuery(), null)) {
            if (toRemove.remove(iu)) continue;
            Tracing.debug((String)("[reconciler] [plan] " + iu + " will be removed"));
        }
        for (IInstallableUnit iu : plan.getAdditions().query(QueryUtil.createIUAnyQuery(), null)) {
            if (toAdd.remove(iu)) continue;
            Tracing.debug((String)("[reconciler] [plan] " + iu + " will be added"));
        }
        toAdd.removeAll(toMove);
        if (toAdd.size() == 0 && toRemove.size() == 0) {
            Tracing.debug((String)"[reconciler] [plan] Plan matches the request.");
        }
        if (toAdd.size() != 0) {
            Tracing.debug((String)"[reconciler] [plan] Some units will not be installed, because they are already installed or there are dependency issues:");
            for (IInstallableUnit unit : toAdd) {
                Tracing.debug((String)("[reconciler] [plan] " + unit));
            }
        }
        if (toRemove.size() != 0) {
            Tracing.debug((String)"[reconciler] [plan] Some units will not be uninstalled:");
            for (IInstallableUnit unit : toRemove) {
                Tracing.debug((String)("[reconciler] [plan] " + unit));
            }
        }
    }

    private void debug(ReconcilerProfileChangeRequest request) {
        if (!Tracing.DEBUG_RECONCILER) {
            return;
        }
        Collection toAdd = request.getAdditions();
        if (toAdd == null || toAdd.size() == 0) {
            Tracing.debug((String)"[reconciler] No installable units to add.");
        } else {
            for (IInstallableUnit add : toAdd) {
                Tracing.debug((String)("[reconciler] Adding IU: " + add.getId() + ' ' + add.getVersion()));
            }
        }
        Map propsToAdd = request.getInstallableUnitProfilePropertiesToAdd();
        if (propsToAdd == null || propsToAdd.isEmpty()) {
            Tracing.debug((String)"[reconciler] No IU properties to add.");
        } else {
            for (Map.Entry entry : propsToAdd.entrySet()) {
                Tracing.debug((String)("[reconciler] Adding IU property: " + entry.getKey() + "->" + entry.getValue()));
            }
        }
        Collection toRemove = request.getRemovals();
        if (toRemove == null || toRemove.size() == 0) {
            Tracing.debug((String)"[reconciler] No installable units to remove.");
        } else {
            for (IInstallableUnit remove : toRemove) {
                Tracing.debug((String)("[reconciler] Removing IU: " + remove.getId() + ' ' + remove.getVersion()));
            }
        }
        Map propsToRemove = request.getInstallableUnitProfilePropertiesToRemove();
        if (propsToRemove == null || propsToRemove.isEmpty()) {
            Tracing.debug((String)"[reconciler] No IU properties to remove.");
        } else {
            for (Map.Entry entry : propsToRemove.entrySet()) {
                Tracing.debug((String)("[reconciler] Removing IU property: " + entry.getKey() + "->" + entry.getValue()));
            }
        }
        Collection<IInstallableUnit> toMove = request.getMoves();
        if (toMove == null || toMove.isEmpty()) {
            Tracing.debug((String)"[reconciler] No installable units to move.");
        } else {
            for (IInstallableUnit move : toMove) {
                Tracing.debug((String)("[reconciler] Moving IU: " + move.getId() + ' ' + move.getVersion()));
            }
        }
        Collection extra = request.getExtraRequirements();
        if (extra == null || extra.isEmpty()) {
            Tracing.debug((String)"[reconciler] No extra requirements.");
        } else {
            for (IRequirement requirement : extra) {
                Tracing.debug((String)("[reconciler] Extra requirement: " + requirement));
            }
        }
    }

    private IQueryResult<IInstallableUnit> getAllIUsFromRepos() {
        Collector allRepos = new Collector();
        for (IMetadataRepository repository : this.repositoryMap.values()) {
            allRepos.addAll(repository.query(QueryUtil.createIUAnyQuery(), null));
        }
        return allRepos;
    }

    private IProvisioningPlan createProvisioningPlan(ProfileChangeRequest request, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        IPlanner planner = (IPlanner)this.agent.getService(IPlanner.SERVICE_NAME);
        return planner.getProvisioningPlan((IProfileChangeRequest)request, provisioningContext, monitor);
    }

    private IStatus setProperty(String key, String value, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
        IProvisioningPlan plan = engine.createPlan(this.profile, provisioningContext);
        plan.setProfileProperty(key, value);
        IPhaseSet phaseSet = PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_PROPERTY});
        return engine.perform(plan, phaseSet, monitor);
    }

    private IStatus executePlan(IProvisioningPlan plan, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
        IPhaseSet phaseSet = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_COLLECT, PhaseSetFactory.PHASE_CHECK_TRUST});
        if (plan.getInstallerPlan() != null) {
            IStatus installerPlanStatus = engine.perform(plan.getInstallerPlan(), phaseSet, monitor);
            if (!installerPlanStatus.isOK()) {
                return installerPlanStatus;
            }
            this.applyConfiguration(true);
        }
        return engine.perform(plan, phaseSet, monitor);
    }

    private IStatus applyConfiguration(boolean isInstaller) {
        if (!isInstaller && ProfileSynchronizer.isReconciliationApplicationRunning()) {
            return Status.OK_STATUS;
        }
        BundleContext context = Activator.getContext();
        ServiceReference reference = context.getServiceReference(Configurator.class);
        Configurator configurator = (Configurator)context.getService(reference);
        try {
            try {
                configurator.applyConfiguration();
            }
            catch (IOException e) {
                Status status = new Status(4, PROP_FROM_DROPINS, "Unexpected failure applying configuration", (Throwable)e);
                context.ungetService(reference);
                return status;
            }
        }
        finally {
            context.ungetService(reference);
        }
        return Status.OK_STATUS;
    }

    static boolean isReconciliationApplicationRunning() {
        EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)Activator.getContext(), EnvironmentInfo.class);
        if (info == null) {
            return false;
        }
        String[] args = info.getCommandLineArgs();
        if (args == null) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && RECONCILER_APPLICATION_ID.equals(args[i].trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReconcilerProfileChangeRequest
    extends ProfileChangeRequest {
        List<IInstallableUnit> toMove = new ArrayList<IInstallableUnit>();

        public ReconcilerProfileChangeRequest(IProfile profile) {
            super(profile);
        }

        void moveAll(Collection<IInstallableUnit> list) {
            this.toMove.addAll(list);
        }

        Collection<IInstallableUnit> getMoves() {
            return this.toMove;
        }
    }
}

