/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.AbstractProcessor;
import org.eclipse.n4js.postprocessing.CompileTimeExpressionProcessor;
import org.eclipse.n4js.postprocessing.ComputedNameProcessor;
import org.eclipse.n4js.postprocessing.TypeDeferredProcessor;
import org.eclipse.n4js.postprocessing.TypeProcessor;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMigratable;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ASTProcessor
extends AbstractProcessor {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private ComputedNameProcessor computedNameProcessor;
    @Inject
    private TypeProcessor typeProcessor;
    @Inject
    private TypeDeferredProcessor typeDeferredProcessor;
    @Inject
    private CompileTimeExpressionProcessor compileTimeExpressionProcessor;
    @Inject
    private JavaScriptVariantHelper variantHelper;

    public void processAST(N4JSResource resource, CancelIndicator cancelIndicator) {
        if (resource == null) {
            throw new IllegalArgumentException("resource may not be null");
        }
        resource.clearResolving();
        URI _uRI = resource.getURI();
        String _plus = "### processing resource: " + _uRI;
        AbstractProcessor.log(0, _plus);
        Script script = resource.getScript();
        ASTMetaInfoCache cache = resource.getASTMetaInfoCacheVerifyContext();
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((Resource)resource);
        RuleEnvironmentExtensions.addCancelIndicator(G, cancelIndicator);
        try {
            this.processAST(G, script, cache);
        }
        finally {
            boolean _isDEBUG_LOG_RESULT;
            boolean _isCanceled = RuleEnvironmentExtensions.isCanceled(G);
            if (_isCanceled) {
                AbstractProcessor.log(0, "CANCELED by cancelIndicator");
            }
            if (_isDEBUG_LOG_RESULT = AbstractProcessor.isDEBUG_LOG_RESULT()) {
                URI _uRI_1 = resource.getURI();
                String _plus_1 = "### result for " + _uRI_1;
                AbstractProcessor.log(0, _plus_1);
                AbstractProcessor.log(4, (EObject)resource.getScript(), cache);
            }
            URI _uRI_2 = resource.getURI();
            String _plus_2 = "### done: " + _uRI_2;
            AbstractProcessor.log(0, _plus_2);
        }
    }

    private void processAST(RuleEnvironment G, Script script, ASTMetaInfoCache cache) {
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)script.eAllContents(), Expression.class));
        for (Expression node : _iterable) {
            this.compileTimeExpressionProcessor.evaluateCompileTimeExpression(G, node, cache, 0);
        }
        Iterable _iterable_1 = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)script.eAllContents(), LiteralOrComputedPropertyName.class));
        for (LiteralOrComputedPropertyName node_1 : _iterable_1) {
            this.computedNameProcessor.processComputedPropertyName(G, node_1, cache, 0);
        }
        this.processSubtree(G, (EObject)script, cache, 0);
        EObject eObj = null;
        while ((eObj = cache.postponedSubTrees.poll()) != null) {
            this.processSubtree(G, eObj, cache, 0);
        }
        for (FunctionOrFieldAccessor potentialContainer : cache.potentialContainersOfLocalArgumentsVariable) {
            boolean _tripleEquals;
            LocalArgumentsVariable lav = potentialContainer.get_lok();
            if (lav == null) continue;
            Result<TypeRef> _typeFailSafe = cache.getTypeFailSafe((TypableElement)lav);
            boolean bl = _tripleEquals = _typeFailSafe == null;
            if (!_tripleEquals) continue;
            this.processSubtree(G, (EObject)lav, cache, 0);
        }
    }

    void processSubtree(RuleEnvironment G, EObject node, ASTMetaInfoCache cache, int indentLevel) {
        boolean _not;
        AbstractProcessor.assertTrueIfRigid(cache, "argument 'node' must be an AST node", N4JSLanguageUtils.isASTNode(node));
        String _objectInfo = AbstractProcessor.getObjectInfo(node);
        String _plus = "processing: " + _objectInfo;
        AbstractProcessor.log(indentLevel, _plus);
        this.checkCanceled(G);
        boolean _contains = cache.forwardProcessedSubTrees.contains(node);
        if (_contains) {
            boolean _isDEBUG_LOG = AbstractProcessor.isDEBUG_LOG();
            if (_isDEBUG_LOG) {
                AbstractProcessor.log(indentLevel, "(subtree already processed as a forward reference)");
                if (node instanceof TypableElement) {
                    AbstractProcessor.log(indentLevel, cache.getTypeFailSafe((TypableElement)node));
                }
            }
            return;
        }
        boolean _contains_1 = cache.postponedSubTrees.contains(node);
        if (_contains_1) {
            throw new IllegalStateException("eager processing of postponed subtree");
        }
        boolean _add = cache.astNodesCurrentlyBeingTyped.add(node);
        boolean bl = _not = !_add;
        if (_not) {
            boolean _isDEBUG_LOG_1 = AbstractProcessor.isDEBUG_LOG();
            if (_isDEBUG_LOG_1) {
                AbstractProcessor.log(indentLevel, "(subtree currently in progress - skipping)");
            }
            return;
        }
        try {
            this.processNode_preChildren(G, node, cache, indentLevel);
            List<EObject> children = this.childrenToBeProcessed(G, node);
            for (EObject child : children) {
                boolean _isPostponedNode = this.isPostponedNode(child);
                if (_isPostponedNode) {
                    cache.postponedSubTrees.add(child);
                    continue;
                }
                this.processSubtree(G, child, cache, indentLevel + 1);
                this.checkCanceled(G);
            }
            this.processNode_postChildren(G, node, cache, indentLevel);
            this.resolveAndProcessReferencesInNode(node, cache);
        }
        finally {
            cache.astNodesCurrentlyBeingTyped.remove(node);
        }
    }

    private boolean isPostponedNode(EObject node) {
        return this.isPostponedInitializer(node) || N4JSASTUtils.isBodyOfFunctionOrFieldAccessor((EObject)node);
    }

    private boolean isPostponedInitializer(EObject node) {
        boolean _isHasInitializerAssignment;
        boolean isPostponedInitializer = false;
        EObject fpar = node.eContainer();
        if (fpar instanceof FormalParameter && node instanceof Expression && (_isHasInitializerAssignment = ((FormalParameter)fpar).isHasInitializerAssignment())) {
            boolean containsThisLiteral;
            boolean thisLiteralCausesCyclDep;
            EObject funDef = ((FormalParameter)fpar).eContainer();
            if (funDef instanceof FunctionExpression) {
                EList allFPars = ((FunctionExpression)funDef).getFpars();
                List allRefs = EcoreUtilN4.getAllContentsOfTypeStopAt((EObject)fpar, IdentifierRef.class, (EReference[])new EReference[]{N4JSPackage.Literals.FUNCTION_OR_FIELD_ACCESSOR__BODY});
                for (IdentifierRef ir : allRefs) {
                    boolean idRefCausesCyclDep;
                    IdentifiableElement id = ir.getId();
                    boolean bl = idRefCausesCyclDep = allFPars.contains((Object)id) || id instanceof VariableDeclaration && ((VariableDeclaration)id).getExpression() == funDef;
                    if (!idRefCausesCyclDep) continue;
                    isPostponedInitializer = true;
                }
            }
            boolean bl = thisLiteralCausesCyclDep = funDef instanceof PropertyMethodDeclaration || funDef instanceof FunctionExpression && funDef.eContainer() instanceof PropertyNameValuePair;
            if (thisLiteralCausesCyclDep && (containsThisLiteral = EcoreUtilN4.containsContentsOfTypeStopAt((EObject)fpar, ThisLiteral.class, (EReference[])new EReference[]{N4JSPackage.Literals.FUNCTION_OR_FIELD_ACCESSOR__BODY}))) {
                isPostponedInitializer = true;
            }
        }
        return isPostponedInitializer;
    }

    boolean processSubtree_forwardReference(RuleEnvironment G, TypableElement node, ASTMetaInfoCache cache) {
        Result<TypeRef> fromCache;
        boolean valid;
        AbstractProcessor.assertTrueIfRigid(cache, "argument 'node' must be an AST node", N4JSLanguageUtils.isASTNode((EObject)node));
        boolean bl = valid = N4JSLanguageUtils.isIdentifiableSubtree((EObject)node) || ASTProcessor.isExceptionCaseOfForwardReferencableSubtree((EObject)node);
        if (!valid) {
            Resource _eResource = node.eResource();
            XtextResource resource = (XtextResource)_eResource;
            if (resource != null) {
                String _text = resource.getParseResult().getRootNode().getText();
                String _plus = "forward reference only allowed to identifiable subtrees; but was: " + node + " in\n" + _text;
                AbstractProcessor.assertTrueIfRigid(cache, _plus, valid);
            } else {
                AbstractProcessor.assertTrueIfRigid(cache, "forward reference only allowed to identifiable subtrees; but was: " + node, valid);
            }
        }
        if ((fromCache = cache.getTypeFailSafe(node)) != null) {
            return true;
        }
        boolean _contains = cache.astNodesCurrentlyBeingTyped.contains(node);
        if (_contains) {
            boolean isCyclicForwardReference = cache.astNodesCurrentlyBeingTyped.contains(node);
            if (isCyclicForwardReference && (node instanceof VariableDeclaration || node instanceof N4ClassifierDeclaration || node instanceof N4FieldDeclaration || node instanceof PropertyNameValuePair && ((PropertyNameValuePair)node).getExpression() instanceof FunctionExpression || node instanceof PropertyGetterDeclaration || node instanceof PropertySetterDeclaration || node instanceof Expression && node.eContainer() instanceof YieldExpression)) {
                return true;
            }
            String _objectInfo = AbstractProcessor.getObjectInfo((EObject)node);
            String _plus_1 = "*#*#*#*#*#* illegal cyclic forward reference to " + _objectInfo;
            String _plus_2 = String.valueOf(_plus_1) + " (resource: ";
            Resource _eResource_1 = node.eResource();
            URI _uRI = null;
            if (_eResource_1 != null) {
                _uRI = _eResource_1.getURI();
            }
            String _plus_3 = String.valueOf(_plus_2) + _uRI;
            String msg = String.valueOf(_plus_3) + ")";
            AbstractProcessor.logErr(msg);
            return false;
        }
        boolean _isSemiCyclicForwardReferenceInForLoop = this.isSemiCyclicForwardReferenceInForLoop((EObject)node, cache);
        if (_isSemiCyclicForwardReferenceInForLoop) {
            return true;
        }
        boolean _contains_1 = cache.forwardProcessedSubTrees.contains(node);
        if (_contains_1) {
            throw new IllegalStateException();
        }
        String _objectInfo_1 = AbstractProcessor.getObjectInfo((EObject)node);
        String _plus_4 = "===START of identifiable sub-tree below " + _objectInfo_1;
        AbstractProcessor.log(0, _plus_4);
        RuleEnvironment G_fresh = RuleEnvironmentExtensions.newRuleEnvironment(G);
        this.processSubtree(G_fresh, (EObject)node, cache, 0);
        cache.forwardProcessedSubTrees.add((EObject)node);
        String _objectInfo_2 = AbstractProcessor.getObjectInfo((EObject)node);
        String _plus_5 = "===END of identifiable sub-tree below " + _objectInfo_2;
        AbstractProcessor.log(0, _plus_5);
        return true;
    }

    private void processNode_preChildren(RuleEnvironment G, EObject node, ASTMetaInfoCache cache, int indentLevel) {
        if (node instanceof FunctionOrFieldAccessor) {
            cache.potentialContainersOfLocalArgumentsVariable.add((FunctionOrFieldAccessor)node);
        }
        if (node instanceof FunctionDefinition) {
            this.handleAsyncFunctionDefinition(G, (FunctionDefinition)node, cache);
            this.handleGeneratorFunctionDefinition(G, (FunctionDefinition)node, cache);
        }
        this.typeDeferredProcessor.handleDeferredTypeRefs_preChildren(G, node, cache);
    }

    private void processNode_postChildren(RuleEnvironment G, EObject node, ASTMetaInfoCache cache, int indentLevel) {
        TExportableElement elem;
        this.typeDeferredProcessor.handleDeferredTypeRefs_postChildren(G, node, cache);
        this.typeProcessor.typeNode(G, node, cache, indentLevel);
        if (node instanceof NamedImportSpecifier && (elem = ((NamedImportSpecifier)node).getImportedElement()) != null) {
            N4JSTypeSystem tsCorrect = N4LanguageUtils.getServiceForContext((EObject)elem, N4JSTypeSystem.class).orElse(this.ts);
            tsCorrect.type(G, (TypableElement)elem);
        }
        if (node instanceof FunctionDeclaration && AnnotationDefinition.MIGRATION.hasAnnotation((AnnotableElement)((FunctionDeclaration)node))) {
            TFunction _definedFunction = ((FunctionDeclaration)node).getDefinedFunction();
            this.registerMigrationWithTypes((TMigration)_definedFunction);
        }
    }

    private List<EObject> childrenToBeProcessed(RuleEnvironment G, EObject obj) {
        boolean _allowVersionedTypes;
        boolean _isMigrateCall;
        Object _switchResult = null;
        boolean _matched = false;
        if (obj instanceof SetterDeclaration) {
            _matched = true;
            _switchResult = this.bringToFront((List)((SetterDeclaration)obj).eContents(), (T[])new EObject[]{((SetterDeclaration)obj).getFpar()});
        }
        if (!_matched && obj instanceof FunctionDefinition) {
            _matched = true;
            _switchResult = this.bringToFront((List)((FunctionDefinition)obj).eContents(), (T[])((EObject[])Conversions.unwrapArray((Object)((FunctionDefinition)obj).getFpars(), EObject.class)));
        }
        if (!_matched && obj instanceof CatchBlock) {
            _matched = true;
            _switchResult = this.bringToFront((List)((CatchBlock)obj).eContents(), (T[])new EObject[]{((CatchBlock)obj).getCatchVariable()});
        }
        if (!_matched && obj instanceof ForStatement) {
            _matched = true;
            _switchResult = this.bringToFront((List)((ForStatement)obj).eContents(), (T[])new EObject[]{((ForStatement)obj).getExpression()});
        }
        if (!_matched && obj instanceof ParameterizedCallExpression && (_isMigrateCall = MigrationUtils.isMigrateCall(obj))) {
            _matched = true;
            _switchResult = this.bringToFront((List)((ParameterizedCallExpression)obj).eContents(), (T[])((EObject[])Conversions.unwrapArray((Object)((ParameterizedCallExpression)obj).getArguments(), EObject.class)));
        }
        if (!_matched && obj instanceof Script && (_allowVersionedTypes = this.variantHelper.allowVersionedTypes(obj))) {
            _matched = true;
            Functions.Function1 _function = it -> MigrationUtils.isMigrationDefinition((FunctionDefinition)it);
            _switchResult = this.bringToFront((List)((Script)obj).eContents(), (T[])((EObject[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Script)obj).getScriptElements(), FunctionDeclaration.class), (Functions.Function1)_function), EObject.class)));
        }
        if (!_matched) {
            _switchResult = obj.eContents();
        }
        return _switchResult;
    }

    private static boolean isExceptionCaseOfForwardReferencableSubtree(EObject astNode) {
        return ASTProcessor.isExpressionInForOf(astNode);
    }

    private static boolean isExpressionInForOf(EObject astNode) {
        return astNode instanceof Expression && astNode.eContainer() instanceof ForStatement && ((ForStatement)astNode.eContainer()).isForOf() && astNode.eContainingFeature() == N4JSPackage.eINSTANCE.getIterationStatement_Expression();
    }

    boolean isSemiCyclicForwardReferenceInForLoop(EObject node, ASTMetaInfoCache cache) {
        EObject parent;
        if (node instanceof VariableDeclaration && (parent = ((VariableDeclaration)node).eContainer()) instanceof ForStatement) {
            return (((ForStatement)parent).isForIn() || ((ForStatement)parent).isForOf()) && cache.astNodesCurrentlyBeingTyped.contains(((ForStatement)parent).getExpression());
        }
        return false;
    }

    private void resolveAndProcessReferencesInNode(EObject astNode, ASTMetaInfoCache cache) {
        EList _eAllReferences = astNode.eClass().getEAllReferences();
        for (EReference eRef : _eAllReferences) {
            Object node;
            if (eRef.isContainment() || eRef.isContainer() || !((node = astNode.eGet((EStructuralFeature)eRef, true)) instanceof EObject)) continue;
            this.recordReferencesToLocalVariables(eRef, astNode, (EObject)node, cache);
        }
    }

    private void registerMigrationWithTypes(TMigration migration) {
        boolean _tripleNotEquals;
        boolean _not;
        if (migration == null) {
            return;
        }
        boolean _isEmpty = migration.getTypeVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return;
        }
        TMigratable _principalArgumentType = migration.getPrincipalArgumentType();
        boolean bl2 = _tripleNotEquals = _principalArgumentType != null;
        if (_tripleNotEquals) {
            this.registerMigrationWithType(migration, migration.getPrincipalArgumentType());
        }
    }

    private void registerMigrationWithType(TMigration migration, TMigratable migratable) {
        Procedures.Procedure0 _function = () -> {
            EList _migrations = migratable.getMigrations();
            _migrations.add((Object)migration);
        };
        EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{migratable});
    }

    private void recordReferencesToLocalVariables(EReference reference, EObject sourceNode, EObject targetNode, ASTMetaInfoCache cache) {
        Resource _eResource_1;
        boolean _tripleNotEquals;
        boolean _eIsProxy = targetNode.eIsProxy();
        if (_eIsProxy) {
            return;
        }
        Resource _eResource = sourceNode.eResource();
        boolean bl = _tripleNotEquals = _eResource != (_eResource_1 = targetNode.eResource());
        if (_tripleNotEquals) {
            return;
        }
        if (targetNode instanceof VariableDeclaration) {
            if (targetNode instanceof ExportedVariableDeclaration) {
                return;
            }
            cache.storeLocalVariableReference((VariableDeclaration)targetNode, sourceNode);
        }
    }

    private <T> List<T> bringToFront(List<T> l, T ... elements) {
        ArrayList<T> result = new ArrayList<T>(l);
        List elemSanitized = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray(elements))));
        result.removeAll(elemSanitized);
        result.addAll(0, elemSanitized);
        return result;
    }
}

