/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.scoping.members.MemberScopingHelper;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.util.AllSuperTypeRefsCollector;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DestructureHelper {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private MemberScopingHelper memberScopingHelper;

    public TypeRef getTypeOfVariableDeclarationInDestructuringPattern(RuleEnvironment G, VariableDeclaration vdecl) {
        boolean _tripleNotEquals;
        TypeRef _declaredTypeRef = vdecl.getDeclaredTypeRef();
        boolean bl = _tripleNotEquals = _declaredTypeRef != null;
        if (_tripleNotEquals) {
            return null;
        }
        EObject root = DestructureUtils.getRoot((EObject)vdecl.eContainer());
        if (root == null) {
            return null;
        }
        EObject rootParent = root.eContainer();
        if (rootParent instanceof VariableBinding) {
            EObject rootParent2 = ((VariableBinding)rootParent).eContainer();
            boolean isLocatedUnderForInOf = rootParent2 instanceof ForStatement && DestructureUtils.isTopOfDestructuringForStatement((EObject)rootParent2);
            DestructNode _xifexpression = null;
            _xifexpression = isLocatedUnderForInOf ? DestructNode.unify((ForStatement)((ForStatement)rootParent2)) : DestructNode.unify((VariableBinding)((VariableBinding)rootParent));
            DestructNode rootNode = _xifexpression;
            if (rootNode != null) {
                HashMap valueTypePerNode = CollectionLiterals.newHashMap();
                this.buildValueTypesMap(G, rootNode, valueTypePerNode, (EObject)((VariableBinding)rootParent).getPattern());
                Predicate<DestructNode> _function = it -> {
                    VariableDeclaration _variableDeclaration = it.getVariableDeclaration();
                    return _variableDeclaration == vdecl;
                };
                DestructNode node = rootNode.stream().filter(_function).findFirst().orElse(null);
                return (TypeRef)valueTypePerNode.get(node);
            }
        }
        return null;
    }

    public void buildValueTypesMap(RuleEnvironment G, DestructNode rootNode, Map<DestructNode, TypeRef> addHere, EObject contextObj) {
        boolean _tripleEquals;
        Expression _defaultExpr = null;
        if (rootNode != null) {
            _defaultExpr = rootNode.getDefaultExpr();
        }
        boolean bl = _tripleEquals = _defaultExpr == null;
        if (_tripleEquals) {
            return;
        }
        TypeRef valueTypeRef = (TypeRef)this.ts.type(G, (TypableElement)rootNode.getDefaultExpr()).getValue();
        valueTypeRef = this.ts.resolveType(G, (TypeArgument)valueTypeRef);
        EObject _eContainer = rootNode.getDefaultExpr().eContainer();
        if (_eContainer instanceof ForStatement) {
            valueTypeRef = this.extractIterableElementTypeUB(G, valueTypeRef);
        }
        if (valueTypeRef != null) {
            addHere.put(rootNode, valueTypeRef);
            DestructNode[] nestedNodes = rootNode.getNestedNodes();
            if (nestedNodes != null && !((List)Conversions.doWrapArray((Object)nestedNodes)).isEmpty()) {
                this.buildValueTypesMap(G, nestedNodes, valueTypeRef, addHere, contextObj);
            }
        }
    }

    private void buildValueTypesMap(RuleEnvironment G, DestructNode[] nodes, TypeRef valueTypeRef, Map<DestructNode, TypeRef> addHere, EObject contextObj) {
        block4: {
            block3: {
                boolean _not;
                boolean _arePositional = DestructNode.arePositional((DestructNode[])nodes);
                if (!_arePositional) break block3;
                List elementTypeRefs = IterableExtensions.toList(this.extractIterableElementTypesUBs(G, valueTypeRef));
                boolean _isEmpty = elementTypeRefs.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (!_not) break block4;
                int _size = elementTypeRefs.size();
                int maxIdx = _size - 1;
                int idx = 0;
                while (idx < ((List)Conversions.doWrapArray((Object)nodes)).size()) {
                    DestructNode currNode = nodes[idx];
                    TypeRef currValueTypeRef = (TypeRef)elementTypeRefs.get(Math.min(idx, maxIdx));
                    this.addTypeAndContinueWithChildren(G, currNode, currValueTypeRef, addHere, contextObj);
                    ++idx;
                }
                break block4;
            }
            IScope memberScope = this.createMemberScopeForPropertyAccess(valueTypeRef, contextObj, false);
            DestructNode[] destructNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                DestructNode currNode = destructNodeArray[n2];
                TypeRef currValueTypeRef = this.getPropertyTypeForNode(G, valueTypeRef, memberScope, currNode.getPropName(), null);
                if (currValueTypeRef != null) {
                    this.addTypeAndContinueWithChildren(G, currNode, currValueTypeRef, addHere, contextObj);
                }
                ++n2;
            }
        }
    }

    public IScope createMemberScopeForPropertyAccess(TypeRef receiverTypeRef, EObject contextObj, boolean checkVisibility) {
        TypingStrategy _typingStrategy = receiverTypeRef.getTypingStrategy();
        boolean structFieldInitMode = _typingStrategy == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
        return this.memberScopingHelper.createMemberScopeAllowingNonContainedMembers(receiverTypeRef, contextObj, checkVisibility, false, structFieldInitMode);
    }

    public TypeRef getPropertyTypeForNode(RuleEnvironment G, TypeRef parentValueTypeRef, IScope parentMemberScope, String propName, StringBuffer errorMessage) {
        EObject m;
        if (parentValueTypeRef == null || parentMemberScope == null) {
            return null;
        }
        IEObjectDescription mDesc = parentMemberScope.getSingleElement(QualifiedName.create((String)propName));
        if (mDesc instanceof AbstractDescriptionWithError && errorMessage != null) {
            errorMessage.append(((AbstractDescriptionWithError)mDesc).getMessage());
        }
        EObject _eObjectOrProxy = null;
        if (mDesc != null) {
            _eObjectOrProxy = mDesc.getEObjectOrProxy();
        }
        if ((m = _eObjectOrProxy) != null && !m.eIsProxy()) {
            TypeRef result;
            TypeRef _switchResult = null;
            boolean _matched = false;
            if (m instanceof TField) {
                _matched = true;
                _switchResult = ((TField)m).getTypeRef();
            }
            if (!_matched && m instanceof TGetter) {
                _matched = true;
                _switchResult = ((TGetter)m).getDeclaredTypeRef();
            }
            if ((result = _switchResult) != null) {
                RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
                this.tsh.addSubstitutions(G2, parentValueTypeRef);
                TypeArgument resultSubst = (TypeArgument)this.ts.substTypeVariables(G2, (TypeArgument)result).getValue();
                TypeRef _xifexpression = null;
                if (resultSubst != null) {
                    _xifexpression = (TypeRef)this.ts.upperBound(G2, resultSubst).getValue();
                }
                TypeRef resultSubstUB = _xifexpression;
                return resultSubstUB;
            }
        }
        return null;
    }

    private void addTypeAndContinueWithChildren(RuleEnvironment G, DestructNode currNode, TypeRef valueTypeRef, Map<DestructNode, TypeRef> addHere, EObject contextObj) {
        Object _xifexpression = null;
        boolean _isRest = currNode.isRest();
        _xifexpression = _isRest ? RuleEnvironmentExtensions.arrayTypeRef(G, new TypeArgument[]{valueTypeRef}) : valueTypeRef;
        TypeRef actualValueTypeRef = _xifexpression;
        TypeRef currTypeRef = this.mergeWithTypeOfDefaultExpression(G, actualValueTypeRef, currNode);
        if (currTypeRef != null) {
            addHere.put(currNode, currTypeRef);
            if (currNode.getNestedNodes() != null && !((List)Conversions.doWrapArray((Object)currNode.getNestedNodes())).isEmpty()) {
                this.buildValueTypesMap(G, currNode.getNestedNodes(), currTypeRef, addHere, contextObj);
            }
        }
    }

    private TypeRef mergeWithTypeOfDefaultExpression(RuleEnvironment G, TypeRef valueTypeRef, DestructNode node) {
        boolean _tripleNotEquals;
        TypeRef _xifexpression = null;
        Expression _defaultExpr = node.getDefaultExpr();
        boolean bl = _tripleNotEquals = _defaultExpr != null;
        if (_tripleNotEquals) {
            _xifexpression = (TypeRef)this.ts.type(G, (TypableElement)node.getDefaultExpr()).getValue();
        }
        TypeRef exprTypeRefRaw = _xifexpression;
        boolean _xifexpression_1 = false;
        if (exprTypeRefRaw != null) {
            _xifexpression_1 = this.ts.subtypeSucceeded(G, (TypeArgument)exprTypeRefRaw, (TypeArgument)RuleEnvironmentExtensions.undefinedTypeRef(G)) || this.ts.subtypeSucceeded(G, (TypeArgument)exprTypeRefRaw, (TypeArgument)RuleEnvironmentExtensions.nullTypeRef(G));
        }
        boolean isNullOrUndef = _xifexpression_1;
        TypeRef _xifexpression_2 = null;
        if (exprTypeRefRaw != null && !isNullOrUndef) {
            _xifexpression_2 = (TypeRef)this.ts.upperBound(G, (TypeArgument)exprTypeRefRaw).getValue();
        }
        TypeRef exprTypeRef = _xifexpression_2;
        if (valueTypeRef != null && exprTypeRef != null) {
            TypeRef _xifexpression_3 = null;
            boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)valueTypeRef, (TypeArgument)exprTypeRef);
            if (_subtypeSucceeded) {
                _xifexpression_3 = exprTypeRef;
            } else {
                TypeRef _xifexpression_4 = null;
                boolean _subtypeSucceeded_1 = this.ts.subtypeSucceeded(G, (TypeArgument)exprTypeRef, (TypeArgument)valueTypeRef);
                _xifexpression_4 = _subtypeSucceeded_1 ? valueTypeRef : this.tsh.createUnionType(G, valueTypeRef, exprTypeRef);
                _xifexpression_3 = _xifexpression_4;
            }
            return _xifexpression_3;
        }
        if (valueTypeRef != null) {
            return valueTypeRef;
        }
        if (exprTypeRef != null) {
            return exprTypeRef;
        }
        return null;
    }

    public Iterable<TypeRef> extractIterableElementTypesUBs(RuleEnvironment G, TypeRef typeRef) {
        Functions.Function1 _function = it -> (TypeRef)this.ts.upperBound(G, (TypeArgument)it).getValue();
        return IterableExtensions.map(this.extractIterableElementTypes(G, typeRef), (Functions.Function1)_function);
    }

    public Iterable<? extends TypeArgument> extractIterableElementTypes(RuleEnvironment G, TypeRef typeRef) {
        return this.extractIterableElementTypes(G, typeRef, true);
    }

    public TypeRef extractIterableElementTypeUB(RuleEnvironment G, TypeRef typeRef) {
        Functions.Function1 _function = it -> (TypeRef)this.ts.upperBound(G, (TypeArgument)it).getValue();
        return (TypeRef)IterableExtensions.head((Iterable)IterableExtensions.map(this.extractIterableElementTypes(G, typeRef, false), (Functions.Function1)_function));
    }

    public TypeArgument extractIterableElementType(RuleEnvironment G, TypeRef typeRef) {
        return (TypeArgument)IterableExtensions.head(this.extractIterableElementTypes(G, typeRef, false));
    }

    public TypeRef calculateExpectedType(Expression rootPoly, RuleEnvironment G, InferenceContext infCtx) {
        DestructNode _xifexpression = null;
        EObject _eContainer = rootPoly.eContainer();
        if (_eContainer instanceof VariableBinding) {
            EObject _eContainer_1 = rootPoly.eContainer();
            _xifexpression = DestructNode.unify((VariableBinding)((VariableBinding)_eContainer_1));
        } else {
            DestructNode _xifexpression_1 = null;
            EObject _eContainer_2 = rootPoly.eContainer();
            if (_eContainer_2 instanceof AssignmentExpression) {
                EObject _eContainer_3 = rootPoly.eContainer();
                _xifexpression_1 = DestructNode.unify((AssignmentExpression)((AssignmentExpression)_eContainer_3));
            } else {
                DestructNode _xifexpression_2 = null;
                EObject _eContainer_4 = rootPoly.eContainer();
                if (_eContainer_4 instanceof ForStatement) {
                    EObject _eContainer_5 = rootPoly.eContainer();
                    _xifexpression_2 = DestructNode.unify((ForStatement)((ForStatement)_eContainer_5));
                } else {
                    _xifexpression_2 = null;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        DestructNode rootDestructNode = _xifexpression;
        if (rootDestructNode == null) {
            return null;
        }
        return this.calculateExpectedType(rootDestructNode, G, infCtx);
    }

    private TypeRef calculateExpectedType(DestructNode destructNode, RuleEnvironment G, InferenceContext infCtx) {
        boolean _greaterThan;
        DestructNode[] _nestedNodes;
        ArrayList<Object> elementTypes = new ArrayList<Object>();
        ArrayList<TStructField> elementMembers = new ArrayList<TStructField>();
        int elemCount = ((List)Conversions.doWrapArray((Object)destructNode.getNestedNodes())).size();
        DestructNode[] destructNodeArray = _nestedNodes = destructNode.getNestedNodes();
        int n = _nestedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _tripleNotEquals;
            DestructNode nestedNode = destructNodeArray[n2];
            TypeRef _xifexpression = null;
            _xifexpression = nestedNode.getNestedNodes() != null && ((List)Conversions.doWrapArray((Object)nestedNode.getNestedNodes())).size() > 0 ? this.calculateExpectedType(nestedNode, G, infCtx) : this.createTypeFromLeafDestructNode(nestedNode, G);
            TypeRef elemExpectedType = _xifexpression;
            String _propName = nestedNode.getPropName();
            boolean bl = _tripleNotEquals = _propName != null;
            if (_tripleNotEquals) {
                TStructField field = TypesFactory.eINSTANCE.createTStructField();
                field.setName(nestedNode.getPropName());
                TypeRef _xifexpression_1 = null;
                if (elemExpectedType != null) {
                    _xifexpression_1 = elemExpectedType;
                } else {
                    ParameterizedTypeRef _xblockexpression = null;
                    InferenceVariable iv = infCtx.newInferenceVariable();
                    _xblockexpression = TypeUtils.createTypeRef((Type)iv, (TypeArgument[])new TypeArgument[0]);
                    _xifexpression_1 = _xblockexpression;
                }
                field.setTypeRef(_xifexpression_1);
                elementMembers.add(field);
            } else if (elemExpectedType != null) {
                elementTypes.add(elemExpectedType);
            } else {
                elementTypes.add(TypeRefsFactory.eINSTANCE.createWildcard());
            }
            ++n2;
        }
        ParameterizedTypeRefStructural _xifexpression = null;
        int _size = elementMembers.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _xifexpression = TypeUtils.createParameterizedTypeRefStructural((Type)RuleEnvironmentExtensions.objectType(G), (TypingStrategy)TypingStrategy.STRUCTURAL, (TStructMember[])((TStructMember[])Conversions.unwrapArray(elementMembers, TStructMember.class)));
        } else {
            ParameterizedTypeRef _xifexpression_2;
            boolean _greaterThan_1;
            ParameterizedTypeRef _xifexpression_1 = null;
            int _size_1 = elementTypes.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                _xifexpression_2 = null;
                if (elemCount == 1) {
                    _xifexpression_2 = RuleEnvironmentExtensions.arrayTypeRef(G, (TypeArgument)elementTypes.get(0));
                } else {
                    ParameterizedTypeRef _xifexpression_3 = null;
                    _xifexpression_3 = elemCount > 1 ? RuleEnvironmentExtensions.iterableNTypeRef(G, elemCount, (TypeArgument[])Conversions.unwrapArray(elementTypes, TypeArgument.class)) : null;
                    _xifexpression_2 = _xifexpression_3;
                }
            } else {
                throw new IllegalStateException("elementTypes and elementMembers can not both contain elements at the same time.");
            }
            _xifexpression_1 = _xifexpression_2;
            _xifexpression = _xifexpression_1;
        }
        ParameterizedTypeRefStructural retTypeRef = _xifexpression;
        if (retTypeRef != null && destructNode.getAstElement().eContainer() instanceof ForStatement) {
            retTypeRef = RuleEnvironmentExtensions.iterableTypeRef(G, new TypeArgument[]{retTypeRef});
        }
        return retTypeRef;
    }

    private TypeRef createTypeFromLeafDestructNode(DestructNode leafNode, RuleEnvironment G) {
        VariableDeclaration varDecl = leafNode.getVarDecl();
        IdentifierRef varRef = leafNode.getVarRef();
        if (varDecl != null) {
            TypeRef declaredTypeRef = varDecl.getDeclaredTypeRef();
            if (declaredTypeRef != null) {
                return declaredTypeRef;
            }
        } else if (varRef != null && varRef.getId() instanceof VariableDeclaration && ((VariableDeclaration)varRef.getId()).getDeclaredTypeRef() != null) {
            IdentifiableElement _id = varRef.getId();
            return ((VariableDeclaration)_id).getDeclaredTypeRef();
        }
        return null;
    }

    private Iterable<? extends TypeRef> extractIterableElementTypes(RuleEnvironment G, TypeRef typeRef, boolean includeIterableN) {
        Type declType;
        Iterable<TypeRef> result = null;
        Type _declaredType = null;
        if (typeRef != null) {
            _declaredType = typeRef.getDeclaredType();
        }
        if ((declType = _declaredType) == RuleEnvironmentExtensions.iterableType(G) || includeIterableN && RuleEnvironmentExtensions.isIterableN(G, (EObject)declType)) {
            result = this.toUpperBounds((Iterable<TypeArgument>)typeRef.getTypeArgs(), G);
        } else if (declType instanceof PrimitiveType) {
            TypeRef elementType = ((PrimitiveType)declType).getElementType();
            if (elementType != null) {
                TypeRef _copy = (TypeRef)TypeUtils.copy((EObject)elementType);
                result = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeRef[]{_copy}));
            }
        } else if (typeRef instanceof ComposedTypeRef) {
            boolean _not;
            ArrayList results = CollectionLiterals.newArrayList();
            EList _typeRefs = ((ComposedTypeRef)typeRef).getTypeRefs();
            for (TypeRef containedTypeRef : _typeRefs) {
                Iterable<? extends TypeRef> currResult = this.extractIterableElementTypes(G, containedTypeRef, includeIterableN);
                boolean _isEmpty = IterableExtensions.isEmpty(currResult);
                if (_isEmpty) {
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                results.add(currResult);
            }
            boolean _isEmpty = results.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                result = this.mergeListsOfTypeRefs(G, ((ComposedTypeRef)typeRef).getClass(), (Iterable[])Conversions.unwrapArray((Object)results, Iterable.class));
            }
        } else if (declType instanceof ContainerType) {
            boolean _not_1;
            ArrayList results_1 = CollectionLiterals.newArrayList();
            List _collect = AllSuperTypeRefsCollector.collect((ContainerType)((ContainerType)declType));
            for (ParameterizedTypeRef superTypeRef : _collect) {
                TInterface _iterableType;
                boolean _tripleEquals;
                boolean _or = false;
                Type _declaredType_1 = null;
                if (superTypeRef != null) {
                    _declaredType_1 = superTypeRef.getDeclaredType();
                }
                boolean bl = _tripleEquals = _declaredType_1 == (_iterableType = RuleEnvironmentExtensions.iterableType(G));
                if (_tripleEquals) {
                    _or = true;
                } else {
                    boolean bl2 = _or = includeIterableN && RuleEnvironmentExtensions.isIterableN(G, (EObject)superTypeRef);
                }
                if (!_or) continue;
                boolean isContainedInIterable = RuleEnvironmentExtensions.isIterableN(G, superTypeRef.eContainer());
                if (includeIterableN && isContainedInIterable) continue;
                results_1.add(this.toUpperBounds((Iterable<TypeArgument>)superTypeRef.getTypeArgs(), G));
            }
            boolean _isEmpty_1 = results_1.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                result = this.mergeListsOfTypeRefs(G, IntersectionTypeExpression.class, (Iterable[])Conversions.unwrapArray((Object)results_1, Iterable.class));
            }
            if (result == null) {
                Object res = G.get(Resource.class);
                if (res instanceof Resource) {
                    TMember m = this.containerTypesHelper.fromContext((Resource)res).findMember((ContainerType)declType, "#iterator", false, false);
                    if (m instanceof TMethod) {
                        TypeRef _returnTypeRef = ((TMethod)m).getReturnTypeRef();
                        EList _typeArgs = null;
                        if (_returnTypeRef != null) {
                            _typeArgs = _returnTypeRef.getTypeArgs();
                        }
                        result = this.toUpperBounds((Iterable<TypeArgument>)_typeArgs, G);
                    } else if (m instanceof TGetter) {
                        TypeRef _declaredTypeRef = ((TGetter)m).getDeclaredTypeRef();
                        EList _typeArgs_1 = null;
                        if (_declaredTypeRef != null) {
                            _typeArgs_1 = _declaredTypeRef.getTypeArgs();
                        }
                        result = this.toUpperBounds((Iterable<TypeArgument>)_typeArgs_1, G);
                    }
                } else {
                    throw new IllegalArgumentException("no or invalid Resource defined in rule environment G");
                }
            }
        }
        if (result == null || IterableExtensions.isEmpty(result)) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
        this.tsh.addSubstitutions(G2, typeRef);
        Functions.Function1 _function = it -> (TypeArgument)this.ts.substTypeVariables(G2, (TypeArgument)it).getValue();
        Iterable resultSubst = Iterables.filter((Iterable)IterableExtensions.map(result, (Functions.Function1)_function), TypeRef.class);
        return resultSubst;
    }

    private Iterable<TypeRef> toUpperBounds(Iterable<TypeArgument> typeArgs, RuleEnvironment G) {
        Functions.Function1 _function = it -> (TypeRef)this.ts.upperBound(G, (TypeArgument)it).getValue();
        return IterableExtensions.map(typeArgs, (Functions.Function1)_function);
    }

    private Iterable<? extends TypeRef> mergeListsOfTypeRefs(RuleEnvironment G, Class<? extends ComposedTypeRef> type, Iterable<? extends TypeRef> ... iterablesToMerge) {
        int rs = ((List)Conversions.doWrapArray(iterablesToMerge)).size();
        if (rs == 0) {
            return CollectionLiterals.emptyList();
        }
        if (rs == 1) {
            return (Iterable)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray(iterablesToMerge)));
        }
        Functions.Function1 _function = it -> IterableExtensions.toList((Iterable)it);
        List listsToMerge = IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray(iterablesToMerge)), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it.size();
        Functions.Function2 _function_2 = (a, b) -> Math.max(a, b);
        int maxNumOfElems = (Integer)IterableExtensions.reduce((Iterable)ListExtensions.map((List)listsToMerge, (Functions.Function1)_function_1), (Functions.Function2)_function_2);
        ArrayList result = CollectionLiterals.newArrayList();
        TypeRef[] types_of_element_i_across_results = new TypeRef[rs];
        int i = 0;
        while (i < maxNumOfElems) {
            int j = 0;
            while (j < rs) {
                TypeRef type_of_element_i_in_result_j;
                List result_j = (List)listsToMerge.get(j);
                if (result_j == null || result_j.isEmpty()) {
                    throw new IllegalArgumentException("iterablesToMerge may not contain null values or empty iterables");
                }
                int _size = result_j.size();
                int _minus = _size - 1;
                int idxSafe = Math.min(i, _minus);
                types_of_element_i_across_results[j] = type_of_element_i_in_result_j = (TypeRef)result_j.get(idxSafe);
                ++j;
            }
            TypeRef _xifexpression = null;
            boolean _isAssignableFrom = UnionTypeExpression.class.isAssignableFrom(type);
            if (_isAssignableFrom) {
                _xifexpression = this.tsh.createUnionType(G, types_of_element_i_across_results);
            } else {
                TypeRef _xifexpression_1 = null;
                boolean _isAssignableFrom_1 = IntersectionTypeExpression.class.isAssignableFrom(type);
                if (!_isAssignableFrom_1) {
                    String _name = null;
                    if (type != null) {
                        _name = type.getName();
                    }
                    String _plus = "unknown subtype of ComposedTypeRef: " + _name;
                    throw new IllegalArgumentException(_plus);
                }
                _xifexpression_1 = this.tsh.createIntersectionType(G, types_of_element_i_across_results);
                _xifexpression = _xifexpression_1;
            }
            TypeRef type_of_element_i = _xifexpression;
            result.add(type_of_element_i);
            ++i;
        }
        return result;
    }
}

