/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.AbstractCompleteHierarchyTraverser;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.RuleEnvironmentExtensions;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LazyOverrideAwareMemberCollector
extends AbstractCompleteHierarchyTraverser<List<TMember>> {
    private final boolean includeImplicitSuperTypes;
    private List<TMember> result;
    private final RuleEnvironment G;
    private final boolean onlyInheritedMembers;

    public static List<TMember> collectAllMembers(ContainerType<?> type) {
        return (List)new LazyOverrideAwareMemberCollector(type, true, false).getResult();
    }

    public static List<TMember> collectAllInheritedMembers(ContainerType<?> type) {
        return (List)new LazyOverrideAwareMemberCollector(type, true, true).getResult();
    }

    public static List<TMember> collectAllDeclaredMembers(ContainerType<?> type) {
        return (List)new LazyOverrideAwareMemberCollector(type, false, false).getResult();
    }

    public static List<TMember> collectAllDeclaredInheritedMembers(ContainerType<?> type) {
        return (List)new LazyOverrideAwareMemberCollector(type, false, true).getResult();
    }

    private List<TMember> createResultInstance() {
        return Lists.newLinkedList();
    }

    private LazyOverrideAwareMemberCollector(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean onlyInheritedMembers) {
        super(type);
        this.onlyInheritedMembers = onlyInheritedMembers;
        this.includeImplicitSuperTypes = includeImplicitSuperTypes;
        this.result = this.createResultInstance();
        RuleEnvironment _xifexpression = null;
        _xifexpression = includeImplicitSuperTypes ? RuleEnvironmentExtensions.newRuleEnvironment(type) : null;
        this.G = _xifexpression;
    }

    protected List<TMember> doGetResult() {
        return this.result;
    }

    protected void doProcess(ContainerType<?> type) {
        if (type instanceof TClassifier) {
            EList ownedMembers = ((TClassifier)type).getOwnedMembers();
            this.result.addAll((Collection<TMember>)ownedMembers);
        }
    }

    protected boolean processAndReplace(TClassifier type) {
        boolean _xblockexpression = false;
        EList ownedMembers = type.getOwnedMembers();
        Iterator<TMember> iterInherited = this.result.iterator();
        while (iterInherited.hasNext()) {
            TMember inherited = iterInherited.next();
            Functions.Function1 _function = it -> Objects.equal((Object)it.getName(), (Object)inherited.getName()) && it.getMemberType() == inherited.getMemberType() && Boolean.valueOf(it.isStatic()) == Boolean.valueOf(inherited.isStatic());
            boolean _exists = IterableExtensions.exists((Iterable)ownedMembers, (Functions.Function1)_function);
            if (!_exists) continue;
            iterInherited.remove();
        }
        _xblockexpression = this.result.addAll((Collection<TMember>)ownedMembers);
        return _xblockexpression;
    }

    public Boolean caseTClass(TClass object) {
        boolean _tryNext = this.guard.tryNext((Object)object);
        if (_tryNext) {
            List<TMember> parentResult = this.result;
            if (object != this.bottomType) {
                this.result = this.createResultInstance();
            }
            this.doProcess(this.getSuperTypes((Type)object));
            this.doProcess((List)object.getImplementedInterfaceRefs());
            if (!this.onlyInheritedMembers || !Objects.equal((Object)object, (Object)this.bottomType)) {
                this.processAndReplace((TClassifier)object);
            }
            if (parentResult != this.result) {
                parentResult.addAll(this.result);
                this.result = parentResult;
            }
        }
        return Boolean.FALSE;
    }

    public Boolean caseTInterface(TInterface object) {
        boolean _tryNext = this.guard.tryNext((Object)object);
        if (_tryNext) {
            List<TMember> parentResult = this.result;
            if (object != this.bottomType) {
                this.result = this.createResultInstance();
            }
            this.doProcess((List)object.getSuperInterfaceRefs());
            this.doProcess((List)object.getSuperInterfaceRefs());
            if (!this.onlyInheritedMembers || !Objects.equal((Object)object, (Object)this.bottomType)) {
                this.processAndReplace((TClassifier)object);
            }
            if (parentResult != this.result) {
                parentResult.addAll(this.result);
                this.result = parentResult;
            }
        }
        return Boolean.FALSE;
    }

    protected List<ParameterizedTypeRef> getImplicitSuperTypes(Type t) {
        if (this.includeImplicitSuperTypes) {
            ArrayList<ParameterizedTypeRef> implSuperTypeRefs = new ArrayList<ParameterizedTypeRef>();
            List<ParameterizedTypeRef> _collectAllImplicitSuperTypes = RuleEnvironmentExtensions.collectAllImplicitSuperTypes(this.G, (TypeRef)TypeUtils.createTypeRef((Type)t, (TypeArgument[])new TypeArgument[0]));
            for (TypeRef typeRef : _collectAllImplicitSuperTypes) {
                implSuperTypeRefs.add((ParameterizedTypeRef)typeRef);
            }
            return implSuperTypeRefs;
        }
        return Collections.emptyList();
    }
}

