/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.flowgraphs;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.MissingReturnOrThrowAnalyser;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.validators.N4JSFlowgraphValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.FlowValidator;

public class MissingReturnOrThrowValidator
implements FlowValidator {
    private final MissingReturnOrThrowAnalyser mrta;

    public MissingReturnOrThrowValidator(TypeSystemHelper typeSystemHelper, JavaScriptVariantHelper jsVariantHelper) {
        this.mrta = new MissingReturnOrThrowAnalyser(typeSystemHelper, jsVariantHelper);
    }

    @Override
    public FlowAnalyser getFlowAnalyser() {
        return this.mrta;
    }

    @Override
    public void checkResults(N4JSFlowgraphValidator fVali) {
        this.internalCheckMissingReturnDisallowed(fVali);
    }

    private void internalCheckMissingReturnDisallowed(N4JSFlowgraphValidator fVali) {
        Collection<FunctionOrFieldAccessor> mrtFunctions = this.mrta.getMRTFunctions();
        for (FunctionOrFieldAccessor fofa : mrtFunctions) {
            EStructuralFeature highlightFeature = this.getMarkedElement(fofa);
            String msg = IssueCodes.getMessageForFUN_MISSING_RETURN_OR_THROW_STATEMENT();
            fVali.addIssue(msg, (EObject)fofa, highlightFeature, "FUN_MISSING_RETURN_OR_THROW_STATEMENT", new String[0]);
        }
    }

    private EStructuralFeature getMarkedElement(FunctionOrFieldAccessor fofa) {
        if (fofa instanceof FunctionDeclaration) {
            return N4JSPackage.Literals.FUNCTION_DECLARATION__NAME;
        }
        if (fofa instanceof N4MethodDeclaration) {
            return N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME;
        }
        if (fofa instanceof FunctionExpression) {
            return N4JSPackage.Literals.FUNCTION_EXPRESSION__NAME;
        }
        if (fofa instanceof GetterDeclaration) {
            return N4JSPackage.Literals.GETTER_DECLARATION__DEFINED_GETTER;
        }
        return null;
    }
}

