/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.tasks.ITaskFinder;
import org.eclipse.xtext.tasks.ITaskParser;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DefaultTaskFinder
implements ITaskFinder {
    @Inject
    private ITaskParser parser;
    @Inject
    private ITaskTagProvider taskTagProvider;
    @Inject
    private IHiddenTokenHelper hiddenTokenHelper;
    private Pattern endTagPattern = Pattern.compile("\\*/\\z");

    @Inject(optional=true)
    protected Pattern setEndTag(@Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.endTag") String endTag) {
        this.endTagPattern = Pattern.compile(endTag + "\\z");
        return this.endTagPattern;
    }

    @Override
    public List<Task> findTasks(Resource resource) {
        List<Task> _xblockexpression = null;
        TaskTags taskTags = this.taskTagProvider.getTaskTags(resource);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)taskTags);
        if (_isEmpty) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        List<Task> _xifexpression = null;
        if (resource instanceof XtextResource) {
            List<Task> _elvis = null;
            IParseResult _parseResult = ((XtextResource)resource).getParseResult();
            ICompositeNode _rootNode = null;
            if (_parseResult != null) {
                _rootNode = _parseResult.getRootNode();
            }
            List<Task> _findTasks = null;
            if (_rootNode != null) {
                _findTasks = this.findTasks(_rootNode, taskTags);
            }
            _elvis = _findTasks != null ? _findTasks : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            _xifexpression = _elvis;
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected List<Task> findTasks(ICompositeNode it, TaskTags taskTags) {
        Functions.Function1 _function = it_1 -> this.findTasks((ILeafNode)it_1, taskTags);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map(it.getLeafNodes(), (Functions.Function1)_function)));
    }

    protected List<Task> findTasks(ILeafNode node, TaskTags taskTags) {
        boolean _canContainTaskTags = this.canContainTaskTags(node);
        if (_canContainTaskTags) {
            List<Task> tasks = this.parser.parseTasks(this.stripText(node, node.getText()), taskTags);
            Consumer<Task> _function = it -> {
                int _offset = it.getOffset();
                int _offset_1 = node.getOffset();
                int _plus = _offset + _offset_1;
                it.setOffset(_plus);
                int _lineNumber = it.getLineNumber();
                int _startLine = node.getStartLine();
                int _plus_1 = _lineNumber + _startLine;
                int _minus = _plus_1 - 1;
                it.setLineNumber(_minus);
            };
            tasks.forEach(_function);
            return tasks;
        }
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected String stripText(ILeafNode node, String text) {
        return this.endTagPattern.matcher(text).replaceAll("");
    }

    protected boolean canContainTaskTags(ILeafNode node) {
        EObject rule = node.getGrammarElement();
        if (rule instanceof AbstractRule) {
            return this.hiddenTokenHelper.isComment((AbstractRule)rule);
        }
        return false;
    }
}

