/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.n4js.utils.io.IDirectoryDiffAcceptor;

public abstract class FileUtils {
    private FileUtils() {
    }

    private static final String getTempDirValue() {
        return (String)Preconditions.checkNotNull((Object)StandardSystemProperty.JAVA_IO_TMPDIR.value(), (Object)"Null for java.io.tmpdir system property.");
    }

    public static Path getTempFolder() {
        File file = new File(FileUtils.getTempDirValue());
        if (!file.exists() || !file.canWrite()) {
            throw new RuntimeException("Cannot access temporary directory under: " + FileUtils.getTempDirValue());
        }
        return file.toPath();
    }

    public static Path createDirectory(Path parent, String folderName) {
        File file = new File(parent.toFile(), folderName);
        if (!file.exists() && !file.mkdir()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + " with " + folderName + ".");
        }
        file.deleteOnExit();
        return file.toPath();
    }

    public static Path createNestedDirectory(Path parent, String nestedPath) {
        if (!parent.toFile().isDirectory()) {
            throw new RuntimeException("Invalid parent at " + parent + ".");
        }
        Path desiredPath = parent.resolve(nestedPath);
        File file = new File(desiredPath.toUri());
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + " with " + nestedPath + ".");
        }
        file.deleteOnExit();
        return file.toPath();
    }

    public static Path createDirectory(Path parent) {
        File file;
        try {
            file = Files.createTempDirectory(parent, null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!file.exists()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + ".");
        }
        file.deleteOnExit();
        return file.toPath();
    }

    public static Path createTempDirectory() {
        return FileUtils.createTempDirectory(null);
    }

    public static Path createTempDirectory(String prefix) {
        File child;
        File parent = new File(FileUtils.getTempDirValue());
        if (!parent.exists() || !parent.canWrite()) {
            throw new RuntimeException("Cannot access temporary directory under: " + FileUtils.getTempDirValue());
        }
        try {
            child = Files.createTempDirectory(parent.toPath(), prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!child.exists()) {
            throw new RuntimeException("Error while trying to create folder at " + parent + ".");
        }
        child.deleteOnExit();
        return child.toPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long compareFiles(File expectedFile, File actualFile) {
        if (!expectedFile.exists()) throw new IllegalArgumentException("expectedFile does not exist or is a directory");
        if (expectedFile.isDirectory()) {
            throw new IllegalArgumentException("expectedFile does not exist or is a directory");
        }
        if (!actualFile.exists()) throw new IllegalArgumentException("actualFile does not exist or is a directory");
        if (actualFile.isDirectory()) {
            throw new IllegalArgumentException("actualFile does not exist or is a directory");
        }
        if (actualFile.length() != expectedFile.length()) {
            return -1L;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedInputStream inActual = new BufferedInputStream(new FileInputStream(actualFile));
                try {
                    block21: {
                        long l;
                        block22: {
                            int b;
                            BufferedInputStream inExpected = new BufferedInputStream(new FileInputStream(expectedFile));
                            long pos = 0L;
                            while ((b = ((InputStream)inActual).read()) >= 0) {
                                if (b != ((InputStream)inExpected).read()) {
                                    l = pos;
                                    return l;
                                }
                                ++pos;
                            }
                            break block21;
                            {
                                continue;
                                break;
                            }
                            finally {
                                if (inExpected == null) break block22;
                                ((InputStream)inExpected).close();
                            }
                        }
                        if (inActual != null) {
                            ((InputStream)inActual).close();
                        }
                        return l;
                    }
                    if (inActual == null) return -2L;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inActual == null) throw throwable;
                    ((InputStream)inActual).close();
                    throw throwable;
                }
                ((InputStream)inActual).close();
                return -2L;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void compareDirectories(File expectedRoot, File actualRoot, IDirectoryDiffAcceptor acceptor) throws IOException {
        if (!expectedRoot.exists() || !expectedRoot.isDirectory()) {
            throw new IllegalArgumentException("expectedRoot does not exist or is not a directory");
        }
        if (!actualRoot.exists() || !actualRoot.isDirectory()) {
            throw new IllegalArgumentException("actualRoot does not exist or is not a directory");
        }
        Path expectedRootPath = expectedRoot.toPath();
        Path actualRootPath = actualRoot.toPath();
        Set expectedContents = Files.walk(expectedRootPath, new FileVisitOption[0]).collect(Collectors.toSet());
        Files.walk(actualRootPath, new FileVisitOption[0]).forEach(actualPath -> {
            Path relativePath = actualRootPath.relativize((Path)actualPath);
            Path expectedPath = expectedRootPath.resolve(relativePath);
            if (expectedContents.remove(expectedPath)) {
                File expectedFile = expectedPath.toFile();
                File actualFile = actualPath.toFile();
                if (expectedFile.isDirectory()) {
                    if (!actualFile.isDirectory()) {
                        acceptor.fileInsteadOfDirectory(relativePath);
                    }
                } else if (actualFile.isDirectory()) {
                    acceptor.directoryInsteadOfFile(relativePath);
                } else {
                    long diffPos = FileUtils.compareFiles(expectedFile, actualFile);
                    if (diffPos == -1L) {
                        acceptor.differentLength(relativePath);
                    } else if (diffPos >= 0L) {
                        acceptor.differentContent(relativePath, diffPos);
                    }
                }
            } else {
                acceptor.unexpected(relativePath);
            }
        });
        expectedContents.stream().forEach(expectedPath -> {
            Path relativePath = expectedRootPath.relativize((Path)expectedPath);
            acceptor.missing(relativePath);
        });
    }

    public static void deleteFileOrFolder(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else {
            File[] childFildes = file.listFiles();
            int i = 0;
            while (i < childFildes.length) {
                FileUtils.deleteFileOrFolder(childFildes[i]);
                ++i;
            }
        }
        file.delete();
    }

    public static void onExitDeleteFileOrFolder(File file) {
        file.deleteOnExit();
        if (file.isDirectory()) {
            File[] childFildes = file.listFiles();
            int i = 0;
            while (i < childFildes.length) {
                FileUtils.onExitDeleteFileOrFolder(childFildes[i]);
                ++i;
            }
        }
    }

    public static void cleanFolder(File folder) {
        if (folder.isDirectory()) {
            File[] childFiles = folder.listFiles();
            int i = 0;
            while (i < childFiles.length) {
                FileUtils.deleteFileOrFolder(childFiles[i]);
                ++i;
            }
        }
    }

    public static String normalize(String path) {
        String normalized = null;
        if (path != null) {
            normalized = Paths.get(path, new String[0]).normalize().toString();
        }
        return normalized;
    }

    public static String normalizeToDotWhenEmpty(String path) {
        String normalized = FileUtils.normalize(path);
        if (normalized != null && normalized.isEmpty()) {
            normalized = ".";
        }
        return normalized;
    }
}

