/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import com.google.inject.Inject;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.ui.RunConfigurationConverter;
import org.eclipse.n4js.runner.ui.RunnerFrontEndUI;
import org.eclipse.n4js.utils.StatusHelper;

public abstract class IDERunnerDelegate
implements ILaunchConfigurationDelegate {
    private static final String N4JS_PROCESS_TYPE = "n4js";
    private static final Logger LOGGER = Logger.getLogger(IDERunnerDelegate.class);
    @Inject
    private RunnerFrontEndUI runnerFrontEndUI;
    @Inject
    private RunConfigurationConverter runConfigurationConverter;
    @Inject
    private StatusHelper statusHelper;

    public abstract String getRunnerId();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RunConfiguration runConfig = this.runConfigurationConverter.toRunConfiguration(configuration);
        if (runConfig == null) {
            throw new CoreException(this.statusHelper.createError("Couldn't obtain run configuration."));
        }
        try {
            HashMap<String, String> attributes = new HashMap<String, String>(1);
            attributes.put(IProcess.ATTR_PROCESS_TYPE, N4JS_PROCESS_TYPE);
            DebugPlugin.newProcess((ILaunch)launch, (Process)this.runnerFrontEndUI.runInUI(runConfig), (String)launch.getLaunchConfiguration().getName(), attributes);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred while trying to execute module.", (Throwable)e);
            if (e instanceof CoreException) {
                throw e;
            }
            throw new CoreException(this.statusHelper.createError((Throwable)e));
        }
    }
}

