/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.n4JS.AnnotableScriptElement;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.DelegationAssistant;
import org.eclipse.n4js.transpiler.es.transform.MemberPatchingTransformation;
import org.eclipse.n4js.transpiler.im.DelegatingMember;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryIMOnly;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.ConcreteMembersOrderedForTranspiler;
import org.eclipse.n4js.transpiler.utils.MissingApiMembersForTranspiler;
import org.eclipse.n4js.transpiler.utils.ScriptApiTracker;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.AccessorTuple;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.typesystem.TypeSystemHelper;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@TransformationDependency.RequiresBefore(value={MemberPatchingTransformation.class})
public class ApiImplStubGenerationTransformation
extends Transformation {
    @Inject
    private DelegationAssistant delegationAssistant;
    @Inject
    private TypeAssistant typeAssistant;
    @Inject
    private ScriptApiTracker scriptApiTracker;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private N4JSElementKeywordProvider n4jsElementKeywordProvider;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
        this.scriptApiTracker.initApiCompare(this.getState().resource.getScript());
    }

    public void transform() {
        Consumer<N4ClassifierDeclaration> _function = it -> this.addMissingMembers((N4ClassifierDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4ClassifierDeclaration.class, false).forEach(_function);
        this.addMissingTopLevelElements();
    }

    private void addMissingMembers(N4ClassifierDeclaration classifierDecl) {
        EList _ownedMembersRaw;
        TClassifier type = this.getState().info.getOriginalDefinedType(classifierDecl);
        MissingApiMembersForTranspiler mamft = this.createMAMFT(type);
        for (TMethod m : mamft.missingApiMethods) {
            N4MemberDeclaration member = this.createApiImplStub(classifierDecl, (TMember)m);
            _ownedMembersRaw = classifierDecl.getOwnedMembersRaw();
            _ownedMembersRaw.add((Object)member);
        }
        for (AccessorTuple accTuple : mamft.missingApiAccessorTuples) {
            TSetter _setter;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            TGetter _getter = accTuple.getGetter();
            boolean bl = _tripleNotEquals = _getter != null;
            if (_tripleNotEquals) {
                TGetter g = accTuple.getGetter();
                N4MemberDeclaration member = this.createApiImplStub(classifierDecl, (TMember)g);
                EList _ownedMembersRaw2 = classifierDecl.getOwnedMembersRaw();
                _ownedMembersRaw2.add((Object)member);
            }
            boolean bl2 = _tripleNotEquals_1 = (_setter = accTuple.getSetter()) != null;
            if (!_tripleNotEquals_1) continue;
            TSetter s = accTuple.getSetter();
            N4MemberDeclaration member_1 = this.createApiImplStub(classifierDecl, (TMember)s);
            EList _ownedMembersRaw_1 = classifierDecl.getOwnedMembersRaw();
            _ownedMembersRaw_1.add((Object)member_1);
        }
        for (AccessorTuple accTuple_1 : mamft.missingApiAccessorTuples) {
            if (accTuple_1.getInheritedGetter() != null && accTuple_1.getGetter() == null && accTuple_1.getSetter() != null) {
                DelegatingMember delegator = this.delegationAssistant.createDelegatingMember(type, (TMember)accTuple_1.getInheritedGetter());
                _ownedMembersRaw = classifierDecl.getOwnedMembersRaw();
                _ownedMembersRaw.add((Object)delegator);
            }
            if (accTuple_1.getInheritedSetter() == null || accTuple_1.getGetter() == null || accTuple_1.getSetter() != null) continue;
            DelegatingMember delegator_1 = this.delegationAssistant.createDelegatingMember(type, (TMember)accTuple_1.getInheritedSetter());
            EList _ownedMembersRaw_1 = classifierDecl.getOwnedMembersRaw();
            _ownedMembersRaw_1.add((Object)delegator_1);
        }
    }

    private void addMissingTopLevelElements() {
        Script script = this.getState().resource.getScript();
        this.scriptApiTracker.initApiCompare(script);
        ScriptApiTracker.ProjectComparisonAdapter comparison = ScriptApiTracker.firstProjectComparisonAdapter((Resource)script.eResource()).orElse(null);
        if (comparison == null) {
            return;
        }
        Functions.Function1 _function = it -> {
            EObject _elementImpl = it.getElementImpl(0);
            return _elementImpl == null;
        };
        Consumer<ProjectComparisonEntry> _function_1 = it -> {
            EObject _elementAPI;
            EObject x = _elementAPI = it.getElementAPI();
            boolean _matched = false;
            if (x instanceof TMethod) {
                _matched = true;
            }
            if (!_matched && x instanceof TFunction) {
                _matched = true;
                this.missing(x);
            }
            if (!_matched && x instanceof TClass) {
                _matched = true;
                this.missing(x);
            }
            if (!_matched && x instanceof TInterface) {
                _matched = true;
                this.missing(x);
            }
            if (!_matched && x instanceof TEnum) {
                _matched = true;
                this.missing(x);
            }
            if (!_matched && x instanceof TVariable) {
                _matched = true;
                this.missing(x);
            }
        };
        IterableExtensions.filter(this.toIterable(comparison.getEntryFor(script.getModule()).allChildren()), (Functions.Function1)_function).forEach(_function_1);
    }

    private SymbolTableEntryIMOnly _missing(TInterface tinter) {
        SymbolTableEntryIMOnly _xblockexpression = null;
        N4InterfaceDeclaration stub0 = TranspilerBuilderBlocks._N4InterfaceDeclaration((String)tinter.getName());
        Functions.Function1 _function = it -> AnnotationDefinition.find((String)it.getName());
        stub0.setAnnotationList(TranspilerBuilderBlocks._AnnotationList((List)ListExtensions.map((List)tinter.getAnnotations(), (Functions.Function1)_function)));
        EObject _wrapExported = this.wrapExported(tinter.isExported(), (ExportableElement)stub0);
        ScriptElement stub = (ScriptElement)_wrapExported;
        MemberList members = this.getState().memberCollector.members((ContainerType)tinter, false, false);
        for (TMember m : members) {
            if (m instanceof TField) continue;
            EList _ownedMembersRaw = stub0.getOwnedMembersRaw();
            N4MemberDeclaration _createApiImplStub = this.createApiImplStub((N4ClassifierDeclaration)stub0, m);
            _ownedMembersRaw.add((Object)_createApiImplStub);
        }
        this.appendToScript(stub);
        this.getState().info.setOriginalDefinedType((N4TypeDeclaration)stub0, (Type)tinter);
        _xblockexpression = this.createSymbolTableEntryIMOnly((NamedElement)stub0);
        return _xblockexpression;
    }

    private SymbolTableEntryIMOnly _missing(TClass tclass) {
        SymbolTableEntryIMOnly _xblockexpression = null;
        N4ClassDeclaration __N4ClassDeclaration = TranspilerBuilderBlocks._N4ClassDeclaration((String)tclass.getName());
        Procedures.Procedure1 _function = it -> {
            EList _ownedMembersRaw = it.getOwnedMembersRaw();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Class ");
            String _name = tclass.getName();
            _builder.append(_name);
            _builder.append(" is not implemented yet.");
            N4MethodDeclaration __N4MethodDecl = TranspilerBuilderBlocks._N4MethodDecl((String)"constructor", (Statement[])new Statement[]{TranspilerBuilderBlocks._ThrowStmnt((Expression)TranspilerBuilderBlocks._NewExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.N4ApiNotImplementedErrorSTE()), (Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteral((String)_builder.toString())}))});
            _ownedMembersRaw.add((Object)__N4MethodDecl);
        };
        N4ClassDeclaration stub0 = (N4ClassDeclaration)ObjectExtensions.operator_doubleArrow((Object)__N4ClassDeclaration, (Procedures.Procedure1)_function);
        Functions.Function1 _function_1 = it -> AnnotationDefinition.find((String)it.getName());
        stub0.setAnnotationList(TranspilerBuilderBlocks._AnnotationList((List)ListExtensions.map((List)tclass.getAnnotations(), (Functions.Function1)_function_1)));
        EObject _wrapExported = this.wrapExported(tclass.isExported(), (ExportableElement)stub0);
        ScriptElement stub = (ScriptElement)_wrapExported;
        MemberList members = this.getState().memberCollector.members((ContainerType)tclass, false, false);
        for (TMember m : members) {
            if (m instanceof TField || !m.isStatic()) continue;
            EList _ownedMembersRaw = stub0.getOwnedMembersRaw();
            N4MemberDeclaration _createApiImplStub = this.createApiImplStub((N4ClassifierDeclaration)stub0, m);
            _ownedMembersRaw.add((Object)_createApiImplStub);
        }
        this.appendToScript(stub);
        this.getState().info.setOriginalDefinedType((N4TypeDeclaration)stub0, (Type)tclass);
        _xblockexpression = this.createSymbolTableEntryIMOnly((NamedElement)stub0);
        return _xblockexpression;
    }

    private SymbolTableEntryIMOnly _missing(TEnum tenum) {
        SymbolTableEntryIMOnly _xblockexpression = null;
        boolean stringBased = TypeSystemHelper.isStringBasedEnumeration((TEnum)tenum);
        Functions.Function1 _function = it -> TranspilerBuilderBlocks._EnumLiteral((String)it.getName(), (String)it.getName());
        N4EnumDeclaration stub0 = TranspilerBuilderBlocks._EnumDeclaration((String)tenum.getName(), (List)ListExtensions.map((List)tenum.getLiterals(), (Functions.Function1)_function));
        EObject _wrapExported = this.wrapExported(tenum.isExported(), (ExportableElement)stub0);
        ScriptElement stub = (ScriptElement)_wrapExported;
        if (stringBased) {
            ((AnnotableScriptElement)stub).setAnnotationList(TranspilerBuilderBlocks._AnnotationList(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AnnotationDefinition[]{AnnotationDefinition.STRING_BASED}))));
        }
        this.appendToScript(stub);
        this.getState().info.setOriginalDefinedType((N4TypeDeclaration)stub0, (Type)tenum);
        _xblockexpression = this.createSymbolTableEntryIMOnly((NamedElement)stub0);
        return _xblockexpression;
    }

    private Boolean appendToScript(ScriptElement stub) {
        boolean _xblockexpression = false;
        Script_IM script = this.getState().im;
        boolean _xifexpression = false;
        boolean _isEmpty = script.getScriptElements().isEmpty();
        if (_isEmpty) {
            EList _scriptElements = script.getScriptElements();
            _xifexpression = _scriptElements.add((Object)stub);
        } else {
            this.insertAfter((EObject)IterableExtensions.last((Iterable)script.getScriptElements()), new EObject[]{stub});
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private SymbolTableEntryIMOnly _missing(TVariable tvar) {
        this.missingFuncOrVar((IdentifiableElement)tvar, tvar.isExported(), "variable");
        return null;
    }

    private SymbolTableEntryIMOnly _missing(TFunction func) {
        this.missingFuncOrVar((IdentifiableElement)func, func.isExported(), "function");
        return null;
    }

    private SymbolTableEntryInternal N4ApiNotImplementedErrorSTE() {
        return this.steFor_N4ApiNotImplementedError();
    }

    private void missingFuncOrVar(IdentifiableElement func, boolean exported, String description) {
        SymbolTableEntryOriginal funcSTE = this.getSymbolTableEntryOriginal(func, true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(description);
        _builder.append(" ");
        String _name = funcSTE.getName();
        _builder.append(_name);
        _builder.append(" is not implemented yet.");
        FunctionDeclaration __FunDecl = TranspilerBuilderBlocks._FunDecl((String)funcSTE.getName(), (Statement[])new Statement[]{TranspilerBuilderBlocks._ThrowStmnt((Expression)TranspilerBuilderBlocks._NewExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.N4ApiNotImplementedErrorSTE()), (Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteral((String)_builder.toString())}))});
        Procedures.Procedure1 _function = it -> {};
        FunctionDeclaration funcDecl = (FunctionDeclaration)ObjectExtensions.operator_doubleArrow((Object)__FunDecl, (Procedures.Procedure1)_function);
        EObject stub = this.wrapExported(exported, (ExportableElement)funcDecl);
        this.insertAfter((EObject)IterableExtensions.last((Iterable)this.getState().im.getScriptElements()), new EObject[]{stub});
    }

    private EObject wrapExported(boolean exported, ExportableElement toExportOrNotToExport) {
        Object _xifexpression = null;
        _xifexpression = exported ? TranspilerBuilderBlocks._ExportDeclaration((ExportableElement)toExportOrNotToExport) : toExportOrNotToExport;
        return _xifexpression;
    }

    private N4MemberDeclaration createApiImplStub(N4ClassifierDeclaration classifierDecl, TMember apiMember) {
        SymbolTableEntryInternal N4ApiNotImplementedErrorSTE = this.steFor_N4ApiNotImplementedError();
        String typeName = classifierDecl.getName();
        String memberKeyword = this.n4jsElementKeywordProvider.keyword((Object)apiMember);
        String memberName = apiMember.getName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("API for ");
        _builder.append(memberKeyword);
        _builder.append(" ");
        _builder.append(typeName);
        _builder.append(".");
        _builder.append(memberName);
        _builder.append(" not implemented yet.");
        return TranspilerBuilderBlocks._N4MemberDecl((TMember)apiMember, (Statement[])new Statement[]{TranspilerBuilderBlocks._ThrowStmnt((Expression)TranspilerBuilderBlocks._NewExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)N4ApiNotImplementedErrorSTE), (Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteral((String)_builder.toString())}))});
    }

    private <T> Iterable<T> toIterable(Stream<T> stream) {
        Iterable _function = () -> stream.iterator();
        return _function;
    }

    private MissingApiMembersForTranspiler createMAMFT(TClassifier classifier) {
        ConcreteMembersOrderedForTranspiler cmoft = this.typeAssistant.getOrCreateCMOFT(classifier);
        return MissingApiMembersForTranspiler.create((ContainerTypesHelper)this.containerTypesHelper, (ScriptApiTracker)this.scriptApiTracker, (TClassifier)classifier, (ConcreteMembersOrderedForTranspiler)cmoft, (Script)this.getState().resource.getScript());
    }

    private SymbolTableEntryIMOnly missing(EObject tclass) {
        if (tclass instanceof TClass) {
            return this._missing((TClass)tclass);
        }
        if (tclass instanceof TInterface) {
            return this._missing((TInterface)tclass);
        }
        if (tclass instanceof TEnum) {
            return this._missing((TEnum)tclass);
        }
        if (tclass instanceof TFunction) {
            return this._missing((TFunction)tclass);
        }
        if (tclass instanceof TVariable) {
            return this._missing((TVariable)tclass);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tclass).toString());
    }
}

