/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.internal.util.WrapperTypeLookup;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentMerger;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

@Singleton
public class RawTypeConformanceComputer {
    public static final int RAW_TYPE = 1;
    public static final int AS_TYPE_ARGUMENT = 2;
    public static final int ALLOW_RAW_TYPE_CONVERSION = 4;
    public static final int ALLOW_BOXING = 8;
    public static final int ALLOW_UNBOXING = 16;
    public static final int ALLOW_BOXING_UNBOXING = 24;
    public static final int ALLOW_PRIMITIVE_WIDENING = 32;
    public static final int UNBOUND_COMPUTATION_ADDS_HINTS = 64;
    public static final int ALLOW_SYNONYMS = 128;
    public static final int ALLOW_FUNCTION_CONVERSION = 256;
    public static final int SUCCESS = 512;
    public static final int DEMAND_CONVERSION = 1024;
    public static final int SUBTYPE = 2048;
    public static final int PRIMITIVE_WIDENING = 4096;
    public static final int UNBOXING = 8192;
    public static final int BOXING = 16384;
    public static final int RAW_TYPE_CONVERSION = 32768;
    public static final int SYNONYM = 65536;
    public static final int UNKNOWN_TYPE_PARTICIPATED = 131072;
    public static final int INCOMPATIBLE = 262144;
    public static final int AS_NESTED_TYPE_ARGUMENT = 524288;
    private SynonymTypesProvider synonymTypesProvider;
    private boolean useCustomSynonymTypes = false;
    private static final int PRIMITIVE_NONE = -1;
    private static final int PRIMITIVE_BOOLEAN = 0;
    private static final int PRIMITIVE_INT = 1;
    private static final int PRIMITIVE_LONG = 2;
    private static final int PRIMITIVE_DOUBLE = 3;
    private static final int PRIMITIVE_CHAR = 4;
    private static final int PRIMITIVE_BYTE = 5;
    private static final int PRIMITIVE_SHORT = 6;
    private static final int PRIMITIVE_FLOAT = 7;
    private static final int PRIMITIVE_VOID = 8;

    @Inject
    public void setSynonymTypesProvider(SynonymTypesProvider synonymTypesProvider) {
        this.synonymTypesProvider = synonymTypesProvider;
        this.useCustomSynonymTypes = !synonymTypesProvider.getClass().equals(SynonymTypesProvider.class);
    }

    public int isConformant(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        if (left == right && left != null) {
            return flags | 0x200;
        }
        int result = this.doIsConformant(left, right, flags);
        if (((result = this.isSynonymConformant(result, left, right, flags)) & 0x200) == 0) {
            result |= 0x40000;
        }
        return result & 0xFFF7FFFF;
    }

    protected int isSynonymConformant(int originalConformance, final LightweightTypeReference left, LightweightTypeReference right, final int flags) {
        if (this.useCustomSynonymTypes && (originalConformance & 0x200) == 0 && (flags & 0x80) != 0) {
            final int[] resultFromSynonyms = new int[]{originalConformance};
            this.synonymTypesProvider.collectSynonymTypes(right, new SynonymTypesProvider.Acceptor(){

                @Override
                protected boolean accept(LightweightTypeReference synonym, int synonymFlags) {
                    int synonymResult;
                    if ((synonymFlags & 0x6000) == 0 && ((synonymResult = RawTypeConformanceComputer.this.isConformant(left, synonym, flags & 0xFFFFFF7F)) & 0x200) != 0) {
                        resultFromSynonyms[0] = synonymResult | synonymFlags | 0x10000;
                        return false;
                    }
                    return true;
                }
            });
            return resultFromSynonyms[0];
        }
        return originalConformance;
    }

    protected int doIsConformant(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        int rightKind = right.getKind();
        switch (rightKind) {
            case 7: {
                return flags | 0x200 | 0x20000;
            }
            case 6: {
                UnboundTypeReference castedRight = (UnboundTypeReference)right;
                LightweightTypeReference resolved = castedRight.internalGetResolvedTo();
                if (resolved != null) {
                    return this.doIsConformant(left, resolved, flags);
                }
                if (left.getKind() == 6) {
                    UnboundTypeReference castedLeft = (UnboundTypeReference)left;
                    LightweightTypeReference resolvedLeft = castedLeft.internalGetResolvedTo();
                    if (resolvedLeft != null) {
                        return this.doIsConformant(resolvedLeft, castedRight, flags);
                    }
                    return this.doIsConformant((UnboundTypeReference)left, castedRight, flags);
                }
                return this.doIsConformant(left, castedRight, flags);
            }
            case 4: {
                int leftKind = left.getKind();
                if (leftKind == 6 || leftKind == 4 || leftKind == 8) break;
                for (LightweightTypeReference component : right.getMultiTypeComponents()) {
                    int result = this.doIsConformant(left, component, flags);
                    if ((result & 0x200) == 0) continue;
                    return result;
                }
                return flags;
            }
        }
        switch (left.getKind()) {
            case 7: {
                return flags | 0x200 | 0x20000;
            }
            case 11: {
                switch (rightKind) {
                    case 10: {
                        return this.doIsConformant((InnerFunctionTypeReference)left, (InnerTypeReference)right, flags);
                    }
                    case 11: {
                        return this.doIsConformant((InnerFunctionTypeReference)left, (InnerFunctionTypeReference)right, flags);
                    }
                }
            }
            case 9: {
                switch (rightKind) {
                    case 9: {
                        return this.doIsConformant((FunctionTypeReference)left, (FunctionTypeReference)right, flags);
                    }
                    case 5: 
                    case 10: {
                        return this.doIsConformant((FunctionTypeReference)left, (ParameterizedTypeReference)right, flags);
                    }
                    case 3: {
                        return this.doIsConformant((ParameterizedTypeReference)left, (ArrayTypeReference)right, flags);
                    }
                    case 2: {
                        return this.doIsConformantToAnyType((ParameterizedTypeReference)left, flags);
                    }
                    case 8: {
                        return this.doIsConformant(left, (WildcardTypeReference)right, flags);
                    }
                }
                return flags;
            }
            case 10: {
                switch (rightKind) {
                    case 10: {
                        return this.doIsConformant((InnerTypeReference)left, (InnerTypeReference)right, flags);
                    }
                    case 11: {
                        return this.doIsConformant((InnerTypeReference)left, (InnerFunctionTypeReference)right, flags);
                    }
                }
            }
            case 5: {
                switch (rightKind) {
                    case 3: {
                        return this.doIsConformant((ParameterizedTypeReference)left, (ArrayTypeReference)right, flags);
                    }
                    case 9: 
                    case 11: {
                        return this.doIsConformant((ParameterizedTypeReference)left, (FunctionTypeReference)right, flags);
                    }
                    case 5: 
                    case 10: {
                        return this.doIsConformant((ParameterizedTypeReference)left, (ParameterizedTypeReference)right, flags);
                    }
                    case 2: {
                        return this.doIsConformantToAnyType((ParameterizedTypeReference)left, flags);
                    }
                    case 8: {
                        return this.doIsConformant(left, (WildcardTypeReference)right, flags);
                    }
                }
                return flags;
            }
            case 3: {
                switch (rightKind) {
                    case 3: {
                        return this.doIsConformant((ArrayTypeReference)left, (ArrayTypeReference)right, flags);
                    }
                    case 5: 
                    case 9: {
                        return this.doIsConformant((ArrayTypeReference)left, (ParameterizedTypeReference)right, flags);
                    }
                    case 2: {
                        return flags | 0x200;
                    }
                    case 8: {
                        return this.doIsConformant(left, (WildcardTypeReference)right, flags);
                    }
                }
                return flags;
            }
            case 4: {
                List<LightweightTypeReference> leftReferences = left.getMultiTypeComponents();
                if (leftReferences.isEmpty()) {
                    if (left.isSynonym()) {
                        return flags;
                    }
                    return flags | 0x200;
                }
                int result = flags;
                for (LightweightTypeReference reference : leftReferences) {
                    int componentResult = this.doIsConformant(reference, right, flags);
                    if ((componentResult & 0x200) != 0) {
                        if (left.isSynonym()) {
                            return componentResult;
                        }
                        result |= componentResult;
                        continue;
                    }
                    if (left.isSynonym()) continue;
                    return flags;
                }
                return result;
            }
            case 2: {
                switch (rightKind) {
                    case 2: {
                        return flags | 0x200;
                    }
                    case 8: {
                        return this.doIsConformant(left, (WildcardTypeReference)right, flags);
                    }
                }
                return flags;
            }
            case 6: {
                UnboundTypeReference castedLeft = (UnboundTypeReference)left;
                LightweightTypeReference resolvedLeft = castedLeft.internalGetResolvedTo();
                if (resolvedLeft != null) {
                    return this.doIsConformant(resolvedLeft, right, flags);
                }
                switch (rightKind) {
                    case 2: {
                        return flags | 0x200;
                    }
                }
                return this.tryResolveAndCheckConformance(castedLeft, right, flags);
            }
            case 8: {
                switch (rightKind) {
                    case 8: {
                        return this.doIsConformant((WildcardTypeReference)left, (WildcardTypeReference)right, flags);
                    }
                }
                return this.doIsConformant((WildcardTypeReference)left, right, flags);
            }
        }
        return flags;
    }

    protected int doIsConformant(ParameterizedTypeReference left, ArrayTypeReference right, int flags) {
        if (left.isType(Object.class) || left.isType(Serializable.class) || left.isType(Cloneable.class)) {
            return flags | 0x200 | 0x800;
        }
        if ((flags & 0x80) != 0 && (left.isType(List.class) || left.isType(Collection.class) || left.isType(Iterable.class))) {
            List<LightweightTypeReference> arguments = left.getTypeArguments();
            if (arguments.isEmpty()) {
                return flags | 0x200 | 0x400;
            }
            LightweightTypeReference componentType = right.getComponentType().getWrapperTypeIfPrimitive();
            int result = this.doIsConformant(arguments.get(0).getInvariantBoundSubstitute(), componentType, flags);
            if ((result & 0x200) != 0) {
                return result | 0x400;
            }
        }
        return flags;
    }

    protected int doIsConformant(ArrayTypeReference left, ArrayTypeReference right, int flags) {
        LightweightTypeReference leftComponent = left.getComponentType();
        LightweightTypeReference rightComponent = right.getComponentType();
        return this.doIsConformant(leftComponent, rightComponent, flags & 0xFFFFFE47);
    }

    protected int doIsConformant(ArrayTypeReference left, ParameterizedTypeReference right, int flags) {
        LightweightTypeReference rightComponent;
        LightweightTypeReference leftComponent;
        int result;
        ArrayTypeReference rightAsArray;
        if ((flags & 2) == 0 && (flags & 0x80) != 0 && (rightAsArray = right.tryConvertToArray()) != null && ((result = this.doIsConformant(leftComponent = left.getComponentType().getWrapperTypeIfPrimitive(), rightComponent = rightAsArray.getComponentType(), flags & 0xFFFFFE47)) & 0x200) != 0) {
            return result | 0x400 | 0x10000;
        }
        return flags;
    }

    protected int doIsConformant(LightweightTypeReference left, WildcardTypeReference right, int flags) {
        if ((flags & 2) == 0 || (flags & 0x80000) != 0) {
            for (LightweightTypeReference upperBound : right.getUpperBounds()) {
                int result = this.doIsConformant(left, upperBound, flags);
                if ((result & 0x200) == 0) continue;
                return result;
            }
        }
        return flags;
    }

    protected int doIsConformant(WildcardTypeReference left, LightweightTypeReference right, int flags) {
        if ((flags & 2) != 0 || (flags & 0x80000) != 0) {
            LightweightTypeReference lowerBound = left.getLowerBound();
            if (lowerBound != null) {
                int result;
                int newFlags = flags & 0xFFFFFE41;
                if ((newFlags & 0x80000) != 0) {
                    newFlags |= 2;
                }
                if (right.isRawType()) {
                    newFlags |= 4;
                }
                if (((result = this.doIsConformant(right, lowerBound, newFlags)) & 0x200) == 0) {
                    return result;
                }
            }
            for (LightweightTypeReference leftUpperBound : left.getUpperBounds()) {
                int result;
                int newFlags = flags & 0xFFFFFE41;
                if ((newFlags & 0x80000) != 0) {
                    newFlags |= 2;
                }
                if (leftUpperBound.isRawType()) {
                    newFlags |= 4;
                }
                if (((result = this.doIsConformant(leftUpperBound, right, newFlags)) & 0x200) != 0) continue;
                return result;
            }
            return flags | 0x200 | 0x800;
        }
        return flags;
    }

    protected int doIsConformant(WildcardTypeReference left, WildcardTypeReference right, int flags) {
        if ((flags & 2) != 0) {
            LightweightTypeReference leftLowerBound = left.getLowerBound();
            if (leftLowerBound != null) {
                LightweightTypeReference rightLowerBound = right.getLowerBound();
                if (rightLowerBound != null) {
                    int newFlags = flags & 0xFFFFFE41;
                    if ((newFlags & 0x80000) != 0) {
                        newFlags |= 2;
                    }
                    if (rightLowerBound.isRawType()) {
                        newFlags |= 4;
                    }
                    int result = this.doIsConformant(rightLowerBound, leftLowerBound, newFlags);
                    return result;
                }
                return flags;
            }
            int subtypeOrRawConversion = 0;
            for (LightweightTypeReference leftUpperBound : left.getUpperBounds()) {
                int result;
                int newFlags = flags & 0xFFFFFE41;
                if ((newFlags & 0x80000) != 0) {
                    newFlags |= 2;
                }
                if (leftUpperBound.isRawType()) {
                    newFlags |= 4;
                }
                if (((result = this.doIsConformant(leftUpperBound, (LightweightTypeReference)right, newFlags)) & 0x200) == 0) {
                    return result;
                }
                subtypeOrRawConversion |= result & 0x8800;
            }
            return flags | 0x200 | subtypeOrRawConversion;
        }
        return flags;
    }

    protected int doIsConformantToAnyType(ParameterizedTypeReference left, int flags) {
        if (left.isPrimitive() || left.isPrimitiveVoid()) {
            return flags;
        }
        return flags | 0x200;
    }

    protected int doIsConformant(LightweightTypeReference left, UnboundTypeReference right, int flags) {
        if (left.getType() == right.getType() || left.isType(Object.class)) {
            return flags | 0x200;
        }
        if ((flags & 0x10) == 0 && left.isPrimitive()) {
            return flags;
        }
        boolean doesNotHaveSignificantHints = false;
        if ((flags & 1) == 0 && (right.canResolveTo(left) || (flags & 2) != 0 && (doesNotHaveSignificantHints = !right.hasSignificantHints()))) {
            if ((flags & 0x40) != 0 && doesNotHaveSignificantHints) {
                right.acceptHint(left, BoundTypeArgumentSource.INFERRED_LATER, left, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            }
            return flags | 0x200;
        }
        right.tryResolve(false);
        LightweightTypeReference resolvedTo = right.getResolvedTo();
        if (resolvedTo != null) {
            return this.doIsConformant(left, resolvedTo, flags);
        }
        return flags;
    }

    protected int doIsConformant(UnboundTypeReference left, UnboundTypeReference right, int flags) {
        if (left.getHandle().equals(right.getHandle())) {
            return flags | 0x200;
        }
        List<LightweightBoundTypeArgument> leftHints = left.getAllHints();
        List<LightweightBoundTypeArgument> rightHints = right.getAllHints();
        if ((flags & 0x40) != 0 && (leftHints.isEmpty() || rightHints.isEmpty() || !left.hasSignificantHints(leftHints) || !right.hasSignificantHints())) {
            left.acceptHint(right, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.OUT, VarianceInfo.OUT);
            return flags | 0x200;
        }
        if (leftHints.equals(rightHints)) {
            return flags | 0x200;
        }
        return this.tryResolveAndCheckConformance(left, right, flags);
    }

    protected int tryResolveAndCheckConformance(UnboundTypeReference left, LightweightTypeReference right, int flags) {
        return this.tryResolveAndCheckConformance(left, left.getAllHints(), right, flags);
    }

    protected int tryResolveAndCheckConformance(UnboundTypeReference left, List<LightweightBoundTypeArgument> leftHints, LightweightTypeReference right, int flags) {
        if (leftHints.isEmpty() && (flags & 0x40) == 0) {
            return flags;
        }
        int result = this.isConformantToConstraints(left, right, leftHints, flags & 0xFFFFFE5D);
        if ((result & 0x200) == 0) {
            return flags;
        }
        class Helper {
            final List<LightweightBoundTypeArgument> hintsToProcess;
            final List<LightweightBoundTypeArgument> inferredHintsToProcess;
            int laterCount = 0;
            boolean inferredAsWildcard = false;

            Helper(List<LightweightBoundTypeArgument> hints) {
                this.hintsToProcess = Lists.newArrayListWithCapacity((int)hints.size());
                this.inferredHintsToProcess = Lists.newArrayListWithCapacity((int)hints.size());
                for (LightweightBoundTypeArgument hint : hints) {
                    if (hint.getDeclaredVariance() == null) continue;
                    this.hintsToProcess.add(hint);
                    if (hint.getSource() == BoundTypeArgumentSource.INFERRED) {
                        if (hint.getTypeReference() instanceof WildcardTypeReference) {
                            this.inferredAsWildcard = true;
                        }
                        this.inferredHintsToProcess.add(hint);
                        continue;
                    }
                    if (hint.getSource() != BoundTypeArgumentSource.INFERRED_LATER) continue;
                    ++this.laterCount;
                }
            }

            private List<LightweightBoundTypeArgument> getHintsToMerge() {
                return this.inferredHintsToProcess.isEmpty() || this.laterCount > 1 && this.inferredAsWildcard ? this.hintsToProcess : this.inferredHintsToProcess;
            }

            LightweightMergedBoundTypeArgument getMergeResult(UnboundTypeReference left) {
                LightweightBoundTypeArgument singleBoundArgument;
                VarianceInfo varianceInfo;
                BoundTypeArgumentMerger merger = left.getOwner().getServices().getBoundTypeArgumentMerger();
                if (this.inferredHintsToProcess.size() == 1 && (varianceInfo = (singleBoundArgument = this.inferredHintsToProcess.get(0)).getDeclaredVariance().mergeDeclaredWithActual(singleBoundArgument.getActualVariance())) != null) {
                    return new LightweightMergedBoundTypeArgument(singleBoundArgument.getTypeReference(), varianceInfo);
                }
                return merger.merge(this.getHintsToMerge(), left.getOwner());
            }
        }
        Helper state = new Helper(leftHints);
        if (state.hintsToProcess.isEmpty() && (flags & 0x40) != 0) {
            return this.addHintAndAnnounceSuccess(left, right, flags);
        }
        LightweightMergedBoundTypeArgument mergeResult = state.getMergeResult(left);
        if (mergeResult != null && mergeResult.getVariance() != null) {
            return this.isConformantMergeResult(mergeResult, right, flags);
        }
        return flags;
    }

    protected int isConformantToConstraints(final UnboundTypeReference left, final LightweightTypeReference right, List<LightweightBoundTypeArgument> leftHints, int flags) {
        int result = flags;
        for (LightweightBoundTypeArgument leftHint : leftHints) {
            LightweightTypeReference leftHintReference;
            if (leftHint.getSource() != BoundTypeArgumentSource.CONSTRAINT || (leftHintReference = leftHint.getTypeReference()).getUniqueIdentifier().equals(right.getUniqueIdentifier())) continue;
            final LightweightMergedBoundTypeArgument rightTypeArgument = new LightweightMergedBoundTypeArgument(right.getWrapperTypeIfPrimitive(), VarianceInfo.INVARIANT);
            UnboundTypeParameterPreservingSubstitutor unboundSubstitutor = new UnboundTypeParameterPreservingSubstitutor(Collections.singletonMap(left.getTypeParameter(), rightTypeArgument), right.getOwner()){

                @Override
                public LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference, Set<JvmTypeParameter> visiting) {
                    if (reference.getHandle() == left.getHandle()) {
                        if (right.getKind() == 6) {
                            UnboundTypeReference rightUnbound = (UnboundTypeReference)right;
                            List<LightweightBoundTypeArgument> rightHints = rightUnbound.getAllHints();
                            for (LightweightBoundTypeArgument rightHint : rightHints) {
                                LightweightTypeReference rightHintReference = rightHint.getTypeReference();
                                if (rightHintReference == null || !leftHintReference.getUniqueIdentifier().equals(rightHintReference.getUniqueIdentifier())) continue;
                                return super.doVisitUnboundTypeReference(reference, visiting);
                            }
                        }
                        return rightTypeArgument.getTypeReference();
                    }
                    return super.doVisitUnboundTypeReference(reference, visiting);
                }
            };
            LightweightTypeReference constraintReference = unboundSubstitutor.substitute(leftHintReference);
            int constraintResult = this.doIsConformant(constraintReference, right, flags);
            if ((constraintResult & 0x200) == 0) {
                return flags;
            }
            result |= constraintResult;
        }
        return result | 0x200;
    }

    protected int addHintAndAnnounceSuccess(UnboundTypeReference left, LightweightTypeReference hint, int flags) {
        if (hint instanceof WildcardTypeReference) {
            List<LightweightTypeReference> bounds = ((WildcardTypeReference)hint).getUpperBounds();
            for (LightweightTypeReference upperBound : bounds) {
                left.acceptHint(upperBound, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.OUT, VarianceInfo.OUT);
            }
        } else {
            left.acceptHint(hint, BoundTypeArgumentSource.INFERRED, this, VarianceInfo.OUT, VarianceInfo.OUT);
        }
        return flags | 0x200;
    }

    protected int isConformantMergeResult(LightweightMergedBoundTypeArgument mergeResult, LightweightTypeReference right, int flags) {
        LightweightTypeReference mergeResultReference = mergeResult.getTypeReference();
        if (right.isWildcard() && mergeResultReference.isWildcard()) {
            if (right.getLowerBoundSubstitute().isAny()) {
                LightweightTypeReference lowerBoundMergeResult = mergeResultReference.getLowerBoundSubstitute();
                if (!lowerBoundMergeResult.isAny()) {
                    mergeResultReference = lowerBoundMergeResult;
                }
            } else {
                flags |= 2;
            }
        } else if (mergeResultReference.isWildcard()) {
            flags |= 2;
        }
        return this.isConformant(mergeResultReference, right, flags);
    }

    protected int doIsConformant(ParameterizedTypeReference left, FunctionTypeReference right, int flags) {
        int result;
        if ((flags & 0x100) == 0) {
            return this.doIsConformant(left, (ParameterizedTypeReference)right, flags);
        }
        FunctionTypeReference convertedLeft = left.getAsFunctionTypeReference();
        if (convertedLeft != null) {
            return this.doIsConformant(convertedLeft, right, flags);
        }
        if (right.isFunctionType() && (convertedLeft = left.tryConvertToFunctionTypeReference(false)) != null && ((result = this.doIsConformant(convertedLeft, right, flags)) & 0x200) != 0) {
            return result | 0x400;
        }
        return this.doIsConformant(left, (ParameterizedTypeReference)right, flags);
    }

    protected int doIsConformant(FunctionTypeReference left, FunctionTypeReference right, int flags) {
        if (left.getType() == right.getType()) {
            return flags | 0x200;
        }
        if ((flags & 0x100) == 0) {
            return flags;
        }
        if (left.getParameterTypes().size() == right.getParameterTypes().size()) {
            LightweightTypeReference rightReturnType;
            LightweightTypeReference leftReturnType = left.getReturnType();
            if (leftReturnType == (rightReturnType = right.getReturnType())) {
                return flags | 0x200;
            }
            if (leftReturnType != null && rightReturnType != null && leftReturnType.isPrimitiveVoid() == rightReturnType.isPrimitiveVoid()) {
                return flags | 0x200;
            }
        }
        return flags;
    }

    protected int doIsConformant(FunctionTypeReference left, ParameterizedTypeReference right, int flags) {
        int result;
        if ((flags & 0x100) == 0) {
            return this.doIsConformant((ParameterizedTypeReference)left, right, flags);
        }
        FunctionTypeReference convertedRight = right.getAsFunctionTypeReference();
        if (convertedRight != null) {
            return this.doIsConformant(left, convertedRight, flags);
        }
        if (left.isFunctionType() && (convertedRight = right.tryConvertToFunctionTypeReference(false)) != null && ((result = this.doIsConformant(left, convertedRight, flags)) & 0x200) != 0) {
            return result | 0x400;
        }
        return this.doIsConformant((ParameterizedTypeReference)left, right, flags);
    }

    protected int doIsConformant(InnerFunctionTypeReference left, InnerFunctionTypeReference right, int flags) {
        int result = this.doIsConformant((FunctionTypeReference)left, (FunctionTypeReference)right, flags);
        return this.doIsConformantOuter(left, right, result, flags);
    }

    protected int doIsConformant(InnerFunctionTypeReference left, InnerTypeReference right, int flags) {
        int result = this.doIsConformant((FunctionTypeReference)left, (ParameterizedTypeReference)right, flags);
        return this.doIsConformantOuter(left, right, result, flags);
    }

    protected int doIsConformant(InnerTypeReference left, InnerFunctionTypeReference right, int flags) {
        int result = this.doIsConformant((ParameterizedTypeReference)left, (FunctionTypeReference)right, flags);
        return this.doIsConformantOuter(left, right, result, flags);
    }

    protected int doIsConformant(InnerTypeReference left, InnerTypeReference right, int flags) {
        int result = this.doIsConformant((ParameterizedTypeReference)left, (ParameterizedTypeReference)right, flags);
        return this.doIsConformantOuter(left, right, result, flags);
    }

    protected int doIsConformantOuter(LightweightTypeReference left, LightweightTypeReference right, int nestedResult, int flags) {
        JvmType leftType;
        EObject leftDeclarator;
        if ((nestedResult & 0x200) != 0 && (leftDeclarator = (leftType = left.getType()).eContainer()) instanceof JvmDeclaredType) {
            int outerResult;
            LightweightTypeReference rightOuter;
            JvmDeclaredType castedLeftDeclarator = (JvmDeclaredType)leftDeclarator;
            LightweightTypeReference leftOuter = left.getOuter().getSuperType((JvmType)castedLeftDeclarator);
            if (leftOuter != null && (rightOuter = right.getOuter().getSuperType((JvmType)castedLeftDeclarator)) != null && ((outerResult = this.doIsConformant(leftOuter, rightOuter, flags)) & 0x200) == 0) {
                return outerResult;
            }
        }
        return nestedResult;
    }

    protected int doIsConformant(ParameterizedTypeReference left, ParameterizedTypeReference right, int flags) {
        ParameterizedTypeReference rightSuperType;
        if (left.getType() == right.getType()) {
            if ((flags & 2) != 0) {
                flags |= 0x80000;
            }
            return this.doIsConformantTypeArguments(left, right, flags);
        }
        if (left.isPrimitiveVoid() || right.isPrimitiveVoid()) {
            return flags;
        }
        if ((flags & 0x38) != 0) {
            Primitives.Primitive rightPrimitiveKind;
            int leftPrimitiveKind = this.internalGetPrimitiveKind(left);
            if (leftPrimitiveKind != -1) {
                int rightPrimitiveKind2 = this.internalGetPrimitiveKind(right);
                if (rightPrimitiveKind2 != -1) {
                    if ((flags & 0x20) != 0 && this.isWideningConversion(leftPrimitiveKind, rightPrimitiveKind2)) {
                        return flags | 0x200 | 0x1000;
                    }
                } else if ((flags & 0x10) != 0 && (rightPrimitiveKind2 = this.internalGetPrimitiveKindFromWrapper(right)) != -1 && (rightPrimitiveKind2 == leftPrimitiveKind || this.isWideningConversion(leftPrimitiveKind, rightPrimitiveKind2))) {
                    return flags | 0x200 | 0x2000;
                }
                if (right.getType().eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) {
                    return flags;
                }
            } else if ((flags & 8) != 0 && (rightPrimitiveKind = right.getPrimitiveKind()) != null) {
                if (left.isType(Object.class)) {
                    return flags | 0x200 | 0x4000;
                }
                if (left.isType(String.class)) {
                    return flags;
                }
                LightweightTypeReference wrapper = WrapperTypeLookup.getWrapperType(right, rightPrimitiveKind);
                int result = this.doIsConformant(left, (ParameterizedTypeReference)wrapper, flags);
                if ((result & 0x200) != 0) {
                    return result | 0x4000;
                }
                return flags;
            }
        } else if (left.isPrimitive() || right.isPrimitive()) {
            return flags;
        }
        if ((flags & 2) != 0) {
            return flags;
        }
        if (left.isType(Object.class)) {
            return flags | 0x200 | 0x800;
        }
        JvmType leftType = left.getType();
        JvmType rightType = right.getType();
        EClass leftEClass = leftType.eClass();
        if (leftEClass == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            JvmGenericType castedLeftType = (JvmGenericType)leftType;
            EClass rightEClass = rightType.eClass();
            if (castedLeftType.isFinal()) {
                if (rightEClass == TypesPackage.Literals.JVM_TYPE_PARAMETER && this.getSuperType(right, (JvmType)castedLeftType) != null) {
                    return flags | 0x200 | 0x800;
                }
                return flags;
            }
            if (!castedLeftType.isInterface() && rightEClass == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)rightType).isInterface()) {
                return flags;
            }
        } else if (leftEClass == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            if (rightType.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER && this.getSuperType(right, leftType) != null) {
                return flags | 0x200 | 0x800;
            }
            return flags;
        }
        if ((rightSuperType = (ParameterizedTypeReference)this.getSuperType(right, leftType)) != null) {
            int result = this.doIsConformantTypeArguments(left, rightSuperType, flags);
            if ((result & 0x200) != 0) {
                return result | 0x800;
            }
            return result;
        }
        return this.isAssignableAsFunctionType(left, right, flags);
    }

    protected int isAssignableAsFunctionType(ParameterizedTypeReference left, ParameterizedTypeReference right, int flags) {
        if ((flags & 0x100) == 0) {
            return flags;
        }
        FunctionTypeReference leftFunctionType = left.getAsFunctionTypeReference();
        if (leftFunctionType != null) {
            int result;
            FunctionTypeReference rightFunctionType = right.getAsFunctionTypeReference();
            if (rightFunctionType != null) {
                return flags;
            }
            rightFunctionType = right.tryConvertToFunctionTypeReference((flags & 1) != 0);
            if (rightFunctionType != null && ((result = this.doIsConformant(leftFunctionType, rightFunctionType, flags)) & 0x200) != 0) {
                return result | 0x400;
            }
        } else {
            int result;
            FunctionTypeReference rightFunctionType = right.getAsFunctionTypeReference();
            if (rightFunctionType != null && (leftFunctionType = left.tryConvertToFunctionTypeReference((flags & 1) != 0)) != null && ((result = this.doIsConformant(leftFunctionType, rightFunctionType, flags)) & 0x200) != 0) {
                return result | 0x400;
            }
        }
        return flags;
    }

    private int internalGetPrimitiveKind(ParameterizedTypeReference typeReference) {
        JvmType type = typeReference.getType();
        EClass eClass = type.eClass();
        if (eClass == TypesPackage.Literals.JVM_PRIMITIVE_TYPE) {
            if (type.eIsProxy()) {
                return -1;
            }
            String name = type.getSimpleName();
            switch (name.length()) {
                case 3: {
                    if (!"int".equals(name)) break;
                    return 1;
                }
                case 4: {
                    if ("long".equals(name)) {
                        return 2;
                    }
                    if ("char".equals(name)) {
                        return 4;
                    }
                    if (!"byte".equals(name)) break;
                    return 5;
                }
                case 5: {
                    if ("short".equals(name)) {
                        return 6;
                    }
                    if (!"float".equals(name)) break;
                    return 7;
                }
                case 6: {
                    if (!"double".equals(name)) break;
                    return 3;
                }
                case 7: {
                    if (!"boolean".equals(name)) break;
                    return 0;
                }
            }
        } else if (eClass == TypesPackage.Literals.JVM_VOID) {
            if (type.eIsProxy()) {
                return -1;
            }
            return 8;
        }
        return -1;
    }

    private int internalGetPrimitiveKindFromWrapper(ParameterizedTypeReference typeReference) {
        JvmType type = typeReference.getType();
        if (type == null || type.eIsProxy()) {
            return -1;
        }
        EClass eClass = type.eClass();
        if (eClass != TypesPackage.Literals.JVM_GENERIC_TYPE) {
            if (eClass == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
                return this.internalGetPrimitiveKindFromWrapper((JvmTypeParameter)type, null);
            }
            return -1;
        }
        return this.internalGetPrimitiveKindFromWrapper((JvmGenericType)type);
    }

    protected int internalGetPrimitiveKindFromWrapper(JvmGenericType type) {
        String name = type.getIdentifier();
        switch (name.length()) {
            case 17: {
                if ("java.lang.Integer".equals(name)) {
                    return 1;
                }
                if (!"java.lang.Boolean".equals(name)) break;
                return 0;
            }
            case 14: {
                if ("java.lang.Long".equals(name)) {
                    return 2;
                }
                if ("java.lang.Byte".equals(name)) {
                    return 5;
                }
                if (!"java.lang.Void".equals(name)) break;
                return 8;
            }
            case 15: {
                if ("java.lang.Short".equals(name)) {
                    return 6;
                }
                if (!"java.lang.Float".equals(name)) break;
                return 7;
            }
            case 16: {
                if (!"java.lang.Double".equals(name)) break;
                return 3;
            }
            case 19: {
                if (!"java.lang.Character".equals(name)) break;
                return 4;
            }
        }
        return -1;
    }

    private int internalGetPrimitiveKindFromWrapper(JvmTypeParameter type, RecursionGuard<JvmTypeParameter> guard) {
        if (type.eIsProxy()) {
            return -1;
        }
        for (JvmTypeConstraint constraint : type.getConstraints()) {
            JvmTypeReference upperBound;
            if (constraint.eClass() != TypesPackage.Literals.JVM_UPPER_BOUND || (upperBound = constraint.getTypeReference()) == null) continue;
            JvmType upperBoundType = upperBound.getType();
            if (upperBoundType == null) {
                return -1;
            }
            EClass eClass = upperBoundType.eClass();
            if (eClass == TypesPackage.Literals.JVM_GENERIC_TYPE) {
                return this.internalGetPrimitiveKindFromWrapper((JvmGenericType)upperBoundType);
            }
            if (type == upperBoundType) {
                return -1;
            }
            if (eClass != TypesPackage.Literals.JVM_TYPE_PARAMETER) continue;
            JvmTypeParameter upperBoundTypeParameter = (JvmTypeParameter)upperBoundType;
            if (guard == null) {
                guard = new RecursionGuard();
                guard.tryNext(type);
            }
            if (guard.tryNext(upperBoundTypeParameter)) {
                return this.internalGetPrimitiveKindFromWrapper(upperBoundTypeParameter, guard);
            }
            return -1;
        }
        return -1;
    }

    private boolean isWideningConversion(int leftPrimitiveKind, int rightPrimitiveKind) {
        switch (rightPrimitiveKind) {
            case 5: {
                switch (leftPrimitiveKind) {
                    case 0: 
                    case 5: 
                    case 8: {
                        return false;
                    }
                }
                return true;
            }
            case 4: 
            case 6: {
                switch (leftPrimitiveKind) {
                    case 0: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        return false;
                    }
                }
                return true;
            }
            case 1: {
                switch (leftPrimitiveKind) {
                    case 2: 
                    case 3: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (leftPrimitiveKind) {
                    case 3: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                return leftPrimitiveKind == 3;
            }
        }
        return false;
    }

    protected int doIsConformantTypeArguments(LightweightTypeReference left, LightweightTypeReference right, int flags) {
        if (left.isRawType() != right.isRawType()) {
            return flags | 0x200 | 0x8000;
        }
        return flags | 0x200;
    }

    protected LightweightTypeReference getSuperType(ParameterizedTypeReference current, JvmType type) {
        return current.getRawSuperType(type);
    }
}

